#ifndef __inttypes_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __inttypes_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <inttypes.h> Header File                                        */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/


   /*********************** Basic integer types *****************************
   **
   ** The following defines the basic fixed-size integer types.
   **
   ** intmax_t and uintmax_t are the largest signed and unsigned integer
   ** types supported by the implementation.
   **
   ** intptr_t and uintptr_t are signed and unsigned integer types large enough
   ** to hold a pointer; that is, pointers can be assigned into or from
   ** these integer types without losing precision.
   **
   ** intfast_t and uintfast_t are the most efficient signed and unsigned
   ** integer types of the implementation.
   **
   */

   typedef signed char int8_t;         /* 8-bit signed integer */
   typedef signed short int16_t;       /* 16-bit signed integer */
   typedef signed int int32_t;         /* 32-bit signed integer */
   typedef unsigned char uint8_t;      /* 8-bit unsigned integer */
   typedef unsigned short uint16_t;    /* 16-bit unsigned integer */
   typedef unsigned int uint32_t;      /* 32-bit unsigned integer */
//   #if _LONG_LONG
   typedef long long int64_t;            /* 64-bit signed integer */
   typedef unsigned long long uint64_t;  /* 64-bit unsigned integer */
   typedef signed long long intmax_t;       /* largest signed integer supported */
   typedef unsigned long long uintmax_t;    /* largest unsigned integer supported */
//   #else
//   typedef signed long intmax_t;       /* largest signed integer supported */
//   typedef unsigned long uintmax_t;    /* largest unsigned integer supported */
//   #endif
   typedef signed int intptr_t;        /* signed integer type capable of holding a void * */
   typedef unsigned int uintptr_t;     /* unsigned integer type capable of holding a void * */
   typedef signed int intfast_t;       /* most efficient signed integer type */
   typedef unsigned int uintfast_t;    /* most efficient unsigned integer type */


   /*********************** Extended integer types *************************
   **
   ** The following defines smallest integer types that can hold n bits.
   **
   */

   typedef signed char int_least8_t;   /* smallest signed integer of at least 8 bits */
   typedef int int_fast8_t;            /* the most efficient integer of at least 8 bits */
   typedef signed short int_least16_t; /* smallest signed integer of at least 16 bits */
   typedef int int_fast16_t;           /* the most efficient integer of at least 16 bits */
   typedef signed int int_least32_t;   /* smallest signed integer of at least 32 bits */
   typedef int int_fast32_t;           /* the most efficient integer of at least 32 bits */
   #ifdef _LONG_LONG
   typedef __int64 int_least64_t;      /* smallest signed integer of at least 64 bits */
   typedef __int64 int_fast64_t;       /* the most efficient integer of at least 64 bits */
   #endif
   typedef unsigned char uint_least8_t;   /* smallest unsigned integer of at least 8 bits */
   typedef unsigned int uint_fast8_t;     /* the most efficient unsigned integer of at least 8 bits */
   typedef unsigned short uint_least16_t; /* smallest unsigned integer of at least 16 bits */
   typedef unsigned int uint_fast16_t;    /* the most efficient unsigned integer of at least 16 bits */
   typedef unsigned int uint_least32_t;   /* smallest unsigned integer of at least 32 bits */
   typedef unsigned int uint_fast32_t;    /* the most efficient unsigned integer of at least 32 bits */
   #ifdef _LONG_LONG
   typedef unsigned __int64 uint_least64_t; /* smallest unsigned integer of at least 64 bits */
   typedef unsigned __int64 uint_fast64_t;  /* the most efficient unsigned integer of at least 64 bits */
   #endif


   /* ************************** limits ***********************************
   **
   ** The following defines the limits for the above types.
   **
   ** NOTE : A programmer can test to see whether an implementation supports
   ** a particular size of integer by testing if the macro that gives the
   ** maximum for that datatype is defined. For example, if #ifdef UINT64_MAX
   ** tests false, the implementation does not support unsigned 64 bit integers.
   **
   */

   #define INT8_MIN                    (-128)
   #define INT16_MIN                   (-32767-1)
   #define INT32_MIN                   (-2147483647-1)
   #if _LONG_LONG
   #define INT64_MIN                   (-9223372036854775807LL-1LL)
   #endif
   #define INT_LEAST8_MIN              (-128)
   #define INT_LEAST16_MIN             (-32767-1)
   #define INT_LEAST32_MIN             (-2147483647-1)
   #if _LONG_LONG
   #define INT_LEAST64_MIN             (-9223372036854775807LL-1LL)
   #endif
   #define INT_FAST8_MIN               (-128)
   #define INT_FAST16_MIN              (-32767-1)
   #define INT_FAST32_MIN              (-2147483647-1)
   #if _LONG_LONG
   #define INT_FAST64_MIN              (-9223372036854775807LL-1LL)
   #endif
   #define INT8_MAX                    (127)
   #define INT16_MAX                   (32767)
   #define INT32_MAX                   (2147483647)
   #if _LONG_LONG
   #define INT64_MAX                   (9223372036854775807LL)
   #endif
   #define UINT8_MAX                   (255U)
   #define UINT16_MAX                  (65535U)
   #define UINT32_MAX                  (4294967295U)
   #if _LONG_LONG
   #define UINT64_MAX                  (18446744073709551615ULL)
   #endif

   #if _LONG_LONG
   #define INTMAX_MIN                  (-9223372036854775807LL-1LL)
   #define INTMAX_MAX                  (9223372036854775807LL)
   #define UINTMAX_MAX                 (18446744073709551615ULL)
   #else
   #define INTMAX_MIN                  (-2147483647L-1)
   #define INTMAX_MAX                  (2147483647L)
   #define UINTMAX_MAX                 (4294967295UL)
   #endif
   #define INTFAST_MIN                 (-2147483647L-1)
   #define INTFAST_MAX                 (2147483647L)
   #define UINTFAST_MAX                (4294967295U)
   #define INT_LEAST8_MAX              (127)
   #define INT_LEAST16_MAX             (32767)
   #define INT_LEAST32_MAX             (2147483647)
   #if _LONG_LONG
   #define INT_LEAST64_MAX             (9223372036854775807LL)
   #endif
   #define INT_FAST8_MAX               (2147483647)
   #define INT_FAST16_MAX              (2147483647)
   #define INT_FAST32_MAX              (2147483647)
   #if _LONG_LONG
   #define INT_FAST64_MAX              (9223372036854775807LL)
   #endif
   #define UINT_LEAST8_MAX             (255U)
   #define UINT_LEAST16_MAX            (65535U)
   #define UINT_LEAST32_MAX            (4294967295U)
   #if _LONG_LONG
   #define UINT_LEAST64_MAX            (18446744073709551615ULL)
   #endif
   #define UINT_FAST8_MAX              (4294967295U)
   #define UINT_FAST16_MAX             (4294967295U)
   #define UINT_FAST32_MAX             (4294967295U)
   #if _LONG_LONG
   #define UINT_FAST64_MAX             (18446744073709551615ULL)
   #endif

   /* The following 2 macros are provided for testing whether the types
   ** intptr_t and uintptr_t (integers large enough to hold a void *) are
   ** defined in this header. They are needed in case the architecture can't
   ** represent a pointer in any standard integral type.
   */

   #define INTPTR_MAX                  (2147483647)
   #define UINTPTR_MAX                 (4294967295U)


   /* ************************ CONSTANTS ********************************
   **
   ** The following macros create constants of the above types. The intent is
   ** that:
   **   Constants defined using these macros have a specific length and
   **     signedness.
   */

   #define __CONCAT__(A,B)             A ## B
   #define INT8_C(c)                   (c)
   #define UINT8_C(c)                  __CONCAT__(c,u)
   #define INT16_C(c)                  (c)
   #define UINT16_C(c)                 __CONCAT__(c,u)
   #define INT32_C(c)                  (c)
   #define UINT32_C(c)                 __CONCAT__(c,u)
   #define INT64_C(c)                  __CONCAT__(c,ll)
   #define UINT64_C(c)                 __CONCAT__(c,ull)
   #define INTMAX_C(c)                 __CONCAT__(c,ll)
   #define UINTMAX_C(c)                __CONCAT__(c,ull)


   /************************* FORMATTED I/O ********************************
   **
   ** The following macros can be used even when an implementation has not
   ** extended the printf/scanf family of functions.
   **
   ** The form of the names of the macros is either "PRI" for printf specifiers
   ** or "SCN" for scanf specifiers followed by the conversion specifier letter
   ** followed by the datatype size. For example, PRId32 is the macro for
   ** the printf d conversion specifier with the flags for 32 bit datatype.
   **
   ** Separate printf versus scanf macros are given because typically different
   ** size flags must prefix the conversion specifier letter.
   **
   *** An example using one of these macros:
   **
   **    uint64_t u;
   **    printf("u = %016" PRIx64 "\n", u);
   **
   */

   /* For signed integers */
   #define PRId8                       "d"
   #define PRId16                      "d"
   #define PRId32                      "d"
   #if _LONG_LONG
   #define PRId64                    "lld"
   #endif
   #define PRIdFAST8                   "d"
   #define PRIdFAST16                  "d"
   #define PRIdFAST32                  "d"
   #if _LONG_LONG
   #define PRIdFAST64                "lld"
   #endif
   #define PRIdLEAST8                  "d"
   #define PRIdLEAST16                 "d"
   #define PRIdLEAST32                 "d"
   #if _LONG_LONG
   #define PRIdLEAST64               "lld"
   #endif
   #define PRIi8                       "i"
   #define PRIi16                      "i"
   #define PRIi32                      "i"
   #if _LONG_LONG
   #define PRIi64                    "lli"
   #endif
   #define PRIiFAST8                   "i"
   #define PRIiFAST16                  "i"
   #define PRIiFAST32                  "i"
   #if _LONG_LONG
   #define PRIiFAST64                "lli"
   #endif
   #define PRIiLEAST8                  "i"
   #define PRIiLEAST16                 "i"
   #define PRIiLEAST32                 "i"
   #if _LONG_LONG
   #define PRIiLEAST64               "lli"
   #endif
   #define PRIo8                       "o"
   #define PRIo16                      "o"
   #define PRIo32                      "o"
   #if _LONG_LONG
   #define PRIo64                    "llo"
   #endif
   #define PRIoFAST8                   "o"
   #define PRIoFAST16                  "o"
   #define PRIoFAST32                  "o"
   #if _LONG_LONG
   #define PRIoFAST64                "llo"
   #endif
   #define PRIoLEAST8                  "o"
   #define PRIoLEAST16                 "o"
   #define PRIoLEAST32                 "o"
   #if _LONG_LONG
   #define PRIoLEAST64               "llo"
   #endif
   #define PRIx8                       "x"
   #define PRIx16                      "x"
   #define PRIx32                      "x"
   #if _LONG_LONG
   #define PRIx64                    "llx"
   #endif
   #define PRIxFAST8                   "x"
   #define PRIxFAST16                  "x"
   #define PRIxFAST32                  "x"
   #if _LONG_LONG
   #define PRIxFAST64                "llx"
   #endif
   #define PRIxLEAST8                  "x"
   #define PRIxLEAST16                 "x"
   #define PRIxLEAST32                 "x"
   #if _LONG_LONG
   #define PRIxLEAST64               "llx"
   #endif
   #define PRIX8                       "X"
   #define PRIX16                      "X"
   #define PRIX32                      "X"
   #if _LONG_LONG
   #define PRIX64                    "llX"
   #endif
   #define PRIXFAST8                   "X"
   #define PRIXFAST16                  "X"
   #define PRIXFAST32                  "X"
   #if _LONG_LONG
   #define PRIXFAST64                "llX"
   #endif
   #define PRIXLEAST8                  "X"
   #define PRIXLEAST16                 "X"
   #define PRIXLEAST32                 "X"
   #if _LONG_LONG
   #define PRIXLEAST64               "llX"
   #endif

   /* For unsigned integers */
   #define PRIu8                       "u"
   #define PRIu16                      "u"
   #define PRIu32                      "u"
   #if _LONG_LONG
   #define PRIu64                    "llu"
   #endif
   #define PRIuFAST8                   "u"
   #define PRIuFAST16                  "u"
   #define PRIuFAST32                  "u"
   #if _LONG_LONG
   #define PRIuFAST64                "llu"
   #endif
   #define PRIuLEAST8                  "u"
   #define PRIuLEAST16                 "u"
   #define PRIuLEAST32                 "u"
   #if _LONG_LONG
   #define PRIuLEAST64               "llu"
   #endif

   /* scanf macros */
   #define SCNd16                     "hd"
   #define SCNd32                      "d"
   #if _LONG_LONG
   #define SCNd64                    "lld"
   #endif
   #define SCNi16                     "hi"
   #define SCNi32                      "i"
   #if _LONG_LONG
   #define SCNi64                    "lli"
   #endif
   #define SCNo16                     "ho"
   #define SCNo32                      "o"
   #if _LONG_LONG
   #define SCNo64                    "llo"
   #endif
   #define SCNu16                     "hu"
   #define SCNu32                      "u"
   #if _LONG_LONG
   #define SCNu64                    "llu"
   #endif
   #define SCNx16                     "hx"
   #define SCNx32                      "x"
   #if _LONG_LONG
   #define SCNx64                    "llx"
   #endif
   #define SCNdFAST16                  "d"
   #define SCNdFAST32                  "d"
   #if _LONG_LONG
   #define SCNdFAST64                "lld"
   #endif
   #define SCNdLEAST16                 "d"
   #define SCNdLEAST32                 "d"
   #if _LONG_LONG
   #define SCNdLEAST64               "lld"
   #endif
   #define SCNiFAST16                  "i"
   #define SCNiFAST32                  "i"
   #if _LONG_LONG
   #define SCNiFAST64                "lli"
   #endif
   #define SCNiLEAST16                 "i"
   #define SCNiLEAST32                 "i"
   #if _LONG_LONG
   #define SCNiLEAST64               "lli"
   #endif
   #define SCNoFAST16                  "o"
   #define SCNoFAST32                  "o"
   #if _LONG_LONG
   #define SCNoFAST64                "llo"
   #endif
   #define SCNoLEAST16                 "o"
   #define SCNoLEAST32                 "o"
   #if _LONG_LONG
   #define SCNoLEAST64               "llo"
   #endif
   #define SCNuFAST16                  "u"
   #define SCNuFAST32                  "u"
   #if _LONG_LONG
   #define SCNuFAST64                "llu"
   #endif
   #define SCNuLEAST16                 "u"
   #define SCNuLEAST32                 "u"
   #if _LONG_LONG
   #define SCNuLEAST64               "llu"
   #endif
   #define SCNxFAST16                  "x"
   #define SCNxFAST32                  "x"
   #if _LONG_LONG
   #define SCNxFAST64                "llx"
   #endif
   #define SCNxLEAST16                 "x"
   #define SCNxLEAST32                 "x"
   #if _LONG_LONG
   #define SCNxLEAST64               "llx"
   #endif
   #define SCNXFAST16                  "X"
   #define SCNXFAST32                  "X"
   #if _LONG_LONG
   #define SCNXFAST64                "llX"
   #endif
   #define SCNXLEAST16                 "X"
   #define SCNXLEAST32                 "X"
   #if _LONG_LONG
   #define SCNXLEAST64               "llX"
   #endif


   /* The following macros define I/O formats for intmax_t and uintmax_t.
   */

   #define PRIdMAX                   "lld"
   #define PRIiMAX                   "lli"
   #define PRIoMAX                   "llo"
   #define PRIxMAX                   "llx"
   #define PRIXMAX                   "llX"
   #define PRIuMAX                   "llu"
   #define SCNiMAX                   "lli"
   #define SCNdMAX                   "lld"
   #define SCNoMAX                   "llo"
   #define SCNxMAX                   "llx"
   #define SCNuMAX                   "llu"

   /* The following macros define I/O formats for intfast_t and uintfast_t.
   */

   #define PRIdFAST                    "d"
   #define PRIiFAST                    "i"
   #define PRIoFAST                    "o"
   #define PRIxFAST                    "x"
   #define PRIXFAST                    "X"
   #define PRIuFAST                    "u"
   #define SCNiFAST                    "i"
   #define SCNdFAST                    "d"
   #define SCNoFAST                    "o"
   #define SCNxFAST                    "x"
   #define SCNuFAST                    "u"


   /*************** conversion functions ********************************
   **
   ** The following routines are proposed to do conversions from strings to the
   ** largest supported integer types. They parallel the ISO C strto* functions.
   */

   extern intmax_t _LNK_CONV _IMPORT strtoimax(const char*, char**, int);
   extern uintmax_t _LNK_CONV _IMPORT strtoumax(const char*, char**, int);

   #ifdef _LONG_LONG
      #if __WINDOWS__ && __THW_INTEL__
         #pragma map(strtoimax, "?strtoll")
         #pragma map(strtoumax, "?strtoull")
      #else
         #pragma map(strtoimax, "strtoll")
         #pragma map(strtoumax, "strtoull")
      #endif
   #else
      #if __WINDOWS__ && __THW_INTEL__
         #pragma map(strtoimax, "?strtol")
         #pragma map(strtoumax, "?strtoul")
      #else
         #pragma map(strtoimax, "strtol")
         #pragma map(strtoumax, "strtoul")
      #endif
   #endif

   #ifdef __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif

#endif

