/*
 * WarpVision GUI. Settings dialog
 *
 * CopyRight Dmitry Zakharov, Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#define		INCL_PM
#define		INCL_DOS

#include	<os2.h>		// OS/2 defines

#include	<stdio.h>	// C library
#include	<malloc.h>
#include	<stdlib.h>
#include	<string.h>
#include <stdarg.h>
#include <assert.h>
#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>
#include <sys\types.h>
#include <math.h>
#include <ctype.h>
#include <os2me.h>

#include "..\inttypes.h"

#include "..\wvision.h"
extern "C" {
#include "..\libavcodec\avcodec.h"
#include "..\yuv\yuv2rgb.h"
#include "..\libmpdemux\stream.h"
#include "..\libmpdemux\demuxer.h"
#include "..\libmpdemux\stheader.h"
#include "..\codecs.h"
#include "..\audio\dart.h"
#include "..\audio\adecode.h"
#include "..\video\vdecode.h"

}  // extern C

//#include	"video2.hpp"	// dialog res
#include	"wvguidlg.h"	// dialog res
#include "config.h"
#define ASPECT_FORCE_169     1
#define ASPECT_FORCE_43      2
#define ASPECT_USER_DEFINED  3

extern HWND hwndMainDlg,hWndShow;
extern Config conf;
HWND hwndAudio,hwndVideo,hwndInterface,hwndSystem, hwndAspect;
void save_ini(void);
void yuv2rgb_set_gamma(int);
void set_ontop(HWND, BOOL);

INT	queryTextBox1 (HPS hps, PSZ pszText, PSIZEL pszl)
{
   POINTL txtPointl[TXTBOX_COUNT];

   GpiQueryTextBox (hps, strlen(pszText), pszText, TXTBOX_COUNT,
                   (PPOINTL)&txtPointl[0]);

   pszl->cx = txtPointl[TXTBOX_TOPRIGHT].x - txtPointl[TXTBOX_TOPLEFT].x + 2;
   pszl->cy = txtPointl[TXTBOX_TOPLEFT].y - txtPointl[TXTBOX_BOTTOMLEFT].y + 2;

return pszl->cx;
}

HWND addNotebookPage (HWND hwndNb, PFNWP pfnwp, HMODULE hmod, ULONG resid, PVOID parm, PSZ pszTabText, PSZ pszStatusText, ULONG tab)
{
   MPARAM mp = MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE | tab), BKA_LAST);
   HWND hwndPage = WinLoadDlg (hwndNb, hwndNb, pfnwp, hmod, resid, parm);

   if (hwndPage)
   {
      ULONG pageid = (ULONG)WinSendMsg(hwndNb, BKM_INSERTPAGE, (MPARAM)0L, mp);
      WinSendMsg(hwndNb, BKM_SETTABTEXT, MPFROMLONG(pageid), MPFROMP(pszTabText));
      WinSendMsg(hwndNb, BKM_SETSTATUSLINETEXT, MPFROMLONG(pageid), MPFROMP(pszStatusText));
      WinSendMsg(hwndNb, BKM_SETPAGEWINDOWHWND, MPFROMLONG(pageid), MPFROMHWND(hwndPage));
   }

return hwndPage;
}

MRESULT EXPENTRY AudioPageProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   switch (msg)
   {
   case WM_INITDLG:
       WinSendDlgItemMsg (hwnd, IDD_DISABLE_AUDIO, BM_SETCHECK, MPFROMLONG(conf.AudioDisable), NULL);
       WinSendDlgItemMsg (hwnd, IDD_SHARED_ACCESS, BM_SETCHECK, MPFROMLONG(conf.DartShare), NULL);
       WinSendDlgItemMsg (hwnd, IDD_AUDIO_DEVICE_SPIN, SPBM_SETLIMITS, MPFROMLONG(10L), MPFROMLONG(1L));
       WinSendDlgItemMsg (hwnd, IDD_AUDIO_DEVICE_SPIN, SPBM_SETCURRENTVALUE, MPFROMLONG(conf.AudioDeviceIndex), NULL);

       switch (conf.AudioResampleFlag)
       {
       case RESAMPLE_TO_44100:
           {
           WinSendDlgItemMsg (hwnd, IDD_RESAMPLE_48_TO_44, BM_SETCHECK, MPFROMLONG(1L), NULL);
//           printf("set to BGR");fflush(stdout);
           break;
       }
       case RESAMPLE_TO_48000:
           {
           WinSendDlgItemMsg (hwnd, IDD_RESAMPLE_ANYTHING_TO_48, BM_SETCHECK, MPFROMLONG(1L), NULL);
//           printf("set to YUV");fflush(stdout);
           break;
           }
       case RESAMPLE_NONE:
           {
           WinSendDlgItemMsg (hwnd, IDD_RESAMPLE_NONE, BM_SETCHECK, MPFROMLONG(1L), NULL);
//           printf("set to YUV");fflush(stdout);
           break;
           }

       }

      break;

   case WM_COMMAND:
      return (MRESULT)0L;

      case WM_DESTROY:
      break;
   }

return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY VideoPageProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   switch (msg)
   {
   case WM_INITDLG:
       {
       WinSendDlgItemMsg (hwnd, IDD_USE_HWVIDEO, BM_SETCHECK, MPFROMLONG(conf.UseHWVIDEO), NULL);
       WinSendDlgItemMsg (hwnd, IDD_BRIGHTNESS_SLIDER,
                          SLM_SETSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_RANGEVALUE), MPFROMLONG(conf.Bright+128));

       switch (conf.VideoFormat)
       {
       case FMT_BGR24:
           {
//           WinSendDlgItemMsg (hwnd, IDD_DECODE_AS_YUV422, BM_SETCHECK, MPFROMLONG(0L), NULL);
           WinSendDlgItemMsg (hwnd, IDD_DECODE_AS_BGR24, BM_SETCHECK, MPFROMLONG(1L), NULL);
//           printf("set to BGR");fflush(stdout);
           break;
       }
       case FMT_YUV422:
           {
//           WinSendDlgItemMsg (hwnd, IDD_DECODE_AS_BGR24, BM_SETCHECK, MPFROMLONG(0L), NULL);
           WinSendDlgItemMsg (hwnd, IDD_DECODE_AS_YUV422, BM_SETCHECK, MPFROMLONG(1L), NULL);
//           printf("set to YUV");fflush(stdout);
           break;
       }
       case FMT_RGB16:
           {
           WinSendDlgItemMsg (hwnd, IDD_DECODE_AS_RGB24, BM_SETCHECK, MPFROMLONG(1L), NULL);
//           WinSendDlgItemMsg (hwnd, IDD_DECODE_AS_YUV422, BM_SETCHECK, MPFROMLONG(1L), NULL);
//           printf("set to YUV");fflush(stdout);
           break;
       }
       case -1:
           {
//           WinSendDlgItemMsg (hwnd, IDD_DECODE_AS_BGR24, BM_SETCHECK, MPFROMLONG(0L), NULL);
           WinSendDlgItemMsg (hwnd, IDD_AUTO_DECODE, BM_SETCHECK, MPFROMLONG(1L), NULL);
//           printf("set to YUV");fflush(stdout);
           break;
       }

       } // switch video format
       } // wminitdlg
      break;

      case WM_COMMAND:
      return (MRESULT)0L;

      case WM_DESTROY:
      break;
   }

return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY AspectPageProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   switch (msg)
   {
   case WM_INITDLG:
       {
           WinSendDlgItemMsg (hwnd, IDD_KEEP_ASPECT_RATIO, BM_SETCHECK, MPFROMLONG(conf.KeepAspect), NULL);

       switch (conf.ForceAspect)
       {
       case ASPECT_FORCE_169:
           {
           WinSendDlgItemMsg (hwnd, IDD_FORCE_169, BM_SETCHECK, MPFROMLONG(1L), NULL);
           break;
       }
       case ASPECT_FORCE_43:
           {
           WinSendDlgItemMsg (hwnd, IDD_FORCE_43, BM_SETCHECK, MPFROMLONG(1L), NULL);
           break;
       }
       case ASPECT_USER_DEFINED:
           {
           WinSendDlgItemMsg (hwnd, IDD_USER_DEFINED, BM_SETCHECK, MPFROMLONG(1L), NULL);
           break;
       }
       } // switch force aspect
            break;
       } // wminitdlg

      case WM_COMMAND:
      return (MRESULT)0L;

      case WM_DESTROY:
      break;
   }

return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY InterfacePageProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   switch (msg)
   {
   case WM_INITDLG:
       WinSendDlgItemMsg (hwnd, IDD_SHOW_VIDEO_WINDOW, BM_SETCHECK, MPFROMLONG(conf.isShowWindow), NULL);
       WinSendDlgItemMsg (hwnd, IDD_SWITCH_TO_FULLSCREEN_ON_PLAY, BM_SETCHECK, MPFROMLONG(conf.FullScreen), NULL);
       WinSendDlgItemMsg (hwnd, IDD_GO_TO_LAST_POS, BM_SETCHECK, MPFROMLONG(conf.ToLastPos), NULL);
       WinSendDlgItemMsg (hwnd, IDD_FLOAT_ON_TOP, BM_SETCHECK, MPFROMLONG(conf.IsOnTop), NULL);
       WinSendDlgItemMsg (hwnd, IDD_LOAD_LAST_PLAYLIST, BM_SETCHECK, MPFROMLONG(conf.LoadLastPlaylist), NULL);
       WinSendDlgItemMsg (hwnd, IDD_MEDIA_FILE_MASK, EM_SETTEXTLIMIT, MPFROMSHORT(255), NULL);
       WinSetWindowText(WinWindowFromID(hwnd,IDD_MEDIA_FILE_MASK),conf.exts);
      break;

      case WM_COMMAND:
      return (MRESULT)0L;

      case WM_DESTROY:
      break;
   }

return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY SystemPageProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   switch (msg)
   {
      case WM_INITDLG:
          WinSendDlgItemMsg (hwnd, IDD_PRIORITY_CLASS, SPBM_SETLIMITS, MPFROMLONG(4L), MPFROMLONG(1L));
          WinSendDlgItemMsg (hwnd, IDD_PRIORITY_DELTA, SPBM_SETLIMITS, MPFROMLONG(PRTYD_MAXIMUM), MPFROMLONG(PRTYD_MINIMUM));
          WinSendDlgItemMsg (hwnd, IDD_PRIORITY_CLASS, SPBM_SETCURRENTVALUE, MPFROMLONG(conf.priClass), NULL);
          WinSendDlgItemMsg (hwnd, IDD_PRIORITY_DELTA, SPBM_SETCURRENTVALUE, MPFROMLONG(conf.priDelta), NULL);
//          printf("pri cl: %i\n",conf.priClass);
//          printf("pri del: %i\n",conf.priDelta);
//          fflush(stdout);
      break;

      case WM_COMMAND:
      return (MRESULT)0L;

      case WM_DESTROY:
      break;
   }
  return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY AboutPageProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   switch (msg)
   {
      case WM_INITDLG:
      break;

      case WM_COMMAND:
      return (MRESULT)0L;

      case WM_DESTROY:
      break;
   }

return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY SettingsDlgProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   HWND hwndNb;

   switch (msg)
   {
      case WM_INITDLG:
      hwndNb = WinWindowFromID (hwnd, IDD_NOTEBOOK);
      hwndAudio=addNotebookPage (hwndNb, AudioPageProc, 0L, IDR_AUDIO_TAB, NULL, "Audio", "Audio tab", BKA_MAJOR);
      hwndVideo=addNotebookPage (hwndNb, VideoPageProc, 0L, IDR_VIDEO_TAB, NULL, "Video", "Video tab", BKA_MAJOR);
      hwndInterface=addNotebookPage (hwndNb, InterfacePageProc, 0L, IDR_INTERFACE_TAB, NULL, "Interface", "Interface tab 1 of 2", BKA_MAJOR);
      hwndAspect=addNotebookPage (hwndNb, AspectPageProc, 0L, IDR_ASPECT_TAB, NULL, "Aspect ratio", "Interface tab 2 of 2", BKA_MINOR);
      hwndSystem=addNotebookPage (hwndNb, SystemPageProc, 0L, IDR_SYSTEM_TAB, NULL, "System", "System tab", BKA_MAJOR);
      addNotebookPage (hwndNb, AboutPageProc, 0L, IDR_ABOUT_TAB, NULL, "About", "About WarpVision GUI", BKA_MAJOR);

      if (((WinQueryVersion(WinQueryAnchorBlock(hwnd)) >> 8) & 255) < 40) // WARP 3 NOTEBOOK
      {
          WinSetWindowULong(hwndNb, QWL_STYLE, WS_GROUP      | WS_VISIBLE     |
                            BKS_SPIRALBIND | BKS_MAJORTABTOP | BKS_BACKPAGESTR);

          WinShowWindow(hwndNb, TRUE);

          WinSendMsg(hwndNb, BKM_SETDIMENSIONS,
                     MPFROM2SHORT(100, 28), (MPARAM)BKA_MAJORTAB);

          WinSendMsg(hwndNb, BKM_SETNOTEBOOKCOLORS,
                     MPFROMLONG(SYSCLR_ENTRYFIELD/*DIALOGBACKGROUND*/),
                     MPFROMLONG(BKA_BACKGROUNDMAJORCOLORINDEX));

          WinSendMsg(hwndNb, BKM_SETNOTEBOOKCOLORS,
                     MPFROMLONG(SYSCLR_DIALOGBACKGROUND),
                     MPFROMLONG(BKA_BACKGROUNDPAGECOLORINDEX));

      } else // WARP 4+
      {
          WinSetWindowULong(hwndNb, QWL_STYLE, BKS_BACKPAGESBR | BKS_MAJORTABRIGHT | WS_GROUP | 0x800L);

          WinShowWindow(hwndNb, TRUE);
      }
      break;

   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1))
      {
      case DID_OK:
          BOOL buf;
          USHORT aa;
          conf.AudioDisable=(WinQueryButtonCheckstate(hwndAudio,IDD_DISABLE_AUDIO));
          conf.DartShare=(WinQueryButtonCheckstate(hwndAudio,IDD_SHARED_ACCESS));
          conf.KeepAspect=(WinQueryButtonCheckstate(hwndAspect,IDD_KEEP_ASPECT_RATIO));
          conf.isShowWindow=(WinQueryButtonCheckstate(hwndInterface,IDD_SHOW_VIDEO_WINDOW));
          conf.FullScreen=(WinQueryButtonCheckstate(hwndInterface,IDD_SWITCH_TO_FULLSCREEN_ON_PLAY));
          conf.ToLastPos=(WinQueryButtonCheckstate(hwndInterface,IDD_GO_TO_LAST_POS));
          conf.IsOnTop=(WinQueryButtonCheckstate(hwndInterface,IDD_FLOAT_ON_TOP));
          conf.LoadLastPlaylist=(WinQueryButtonCheckstate(hwndInterface,IDD_LOAD_LAST_PLAYLIST));
          set_ontop(hWndShow,conf.IsOnTop);
          if ((WinQueryButtonCheckstate(hwndVideo,IDD_DECODE_AS_BGR24)))
              conf.VideoFormat = FMT_BGR24;
          if ((WinQueryButtonCheckstate(hwndVideo,IDD_DECODE_AS_YUV422)))
              conf.VideoFormat = FMT_YUV422;
          if ((WinQueryButtonCheckstate(hwndVideo,IDD_DECODE_AS_RGB24)))
              conf.VideoFormat = FMT_RGB16;
          if ((WinQueryButtonCheckstate(hwndVideo,IDD_AUTO_DECODE)))
              conf.VideoFormat = -1;
          if ((WinQueryButtonCheckstate(hwndAudio,IDD_RESAMPLE_48_TO_44)))
              conf.AudioResampleFlag = RESAMPLE_TO_44100;
          if ((WinQueryButtonCheckstate(hwndAudio,IDD_RESAMPLE_ANYTHING_TO_48)))
              conf.AudioResampleFlag = RESAMPLE_TO_48000;
          if ((WinQueryButtonCheckstate(hwndAudio,IDD_RESAMPLE_NONE)))
              conf.AudioResampleFlag = RESAMPLE_NONE;
          WinSendDlgItemMsg (hwndSystem, IDD_PRIORITY_CLASS, SPBM_QUERYVALUE, MPFROMLONG(&conf.priClass), MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
          WinSendDlgItemMsg (hwndSystem, IDD_PRIORITY_DELTA, SPBM_QUERYVALUE, MPFROMLONG(&conf.priDelta), MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
          WinSendDlgItemMsg (hwndAudio, IDD_AUDIO_DEVICE_SPIN, SPBM_QUERYVALUE, MPFROMLONG(&conf.AudioDeviceIndex), MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
          conf.Bright=SHORT1FROMMP(WinSendDlgItemMsg (hwndVideo, IDD_BRIGHTNESS_SLIDER,
                                                      SLM_QUERYSLIDERINFO, MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_RANGEVALUE),
                                                      MPFROMLONG(0L)))-128;
          WinQueryWindowText(WinWindowFromID(hwndInterface,IDD_MEDIA_FILE_MASK),sizeof(conf.exts),conf.exts);
          conf.UseHWVIDEO=(WinQueryButtonCheckstate(hwndVideo,IDD_USE_HWVIDEO));
          if ((WinQueryButtonCheckstate(hwndAspect,IDD_FORCE_169)))
              conf.ForceAspect = ASPECT_FORCE_169;
          if ((WinQueryButtonCheckstate(hwndAspect,IDD_FORCE_43)))
              conf.ForceAspect = ASPECT_FORCE_43;
          if ((WinQueryButtonCheckstate(hwndAspect,IDD_USER_DEFINED)))
              conf.ForceAspect = ASPECT_USER_DEFINED;

//          printf("%i\n",conf.VideoFormat);
//                    fflush(stdout);
          yuv2rgb_set_gamma(conf.Bright);

          save_ini();
          WinDestroyWindow(hwndMainDlg);
          hwndMainDlg = NULLHANDLE;
         break;
      case DID_CANCEL:
          WinDestroyWindow(hwndMainDlg);
          hwndMainDlg = NULLHANDLE;

         break;
      }

      return (MRESULT)0L;

      case WM_CLOSE:
          WinDestroyWindow(hwndMainDlg);
          hwndMainDlg = NULLHANDLE;
      return (MRESULT)0L;

      case WM_DESTROY:
      break;
   }

return WinDefDlgProc (hwnd, msg, mp1, mp2);
}

void add_settings()
{
    if (hwndMainDlg!=NULLHANDLE)
    {
        WinDestroyWindow(hwndMainDlg);
        hwndMainDlg = NULLHANDLE;
        return;
     }
   hwndMainDlg = WinLoadDlg (HWND_DESKTOP, NULLHANDLE, SettingsDlgProc, NULLHANDLE, IDR_SETTINGS, NULL);

   if (hwndMainDlg == NULLHANDLE)
   {
      DosBeep(100,100);
      return;
   } else WinShowWindow(hwndMainDlg, TRUE);

}

