/*
 * WarpVision GUI. Reads movie properties
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

int media_props(char *mediaFname, pplayItem ppl) // reads properties of given media file
{
    stream_t* streamL = NULL;
    demuxer_t* demuxerL = NULL;
    demux_stream_t *d_audioL = NULL;
    demux_stream_t *d_videoL = NULL;
    extern int asf_packetsize;
//    sh_audio_t *sh_audioL = NULL;
    sh_video_t *sh_videoL = NULL;

    int file_format = DEMUXER_TYPE_UNKNOWN;
    int rcL,rc1 = 0;
    ULONG a_bps;

    if (ppl == NULL ||
        mediaFname == NULL ||
        mediaFname[0] == '\0' ||
        strchr(mediaFname,'*') != NULL ||
        strchr(mediaFname,';') != NULL) return -3;

    streamL = open_stream(mediaFname, 0, &file_format);
//    printf("stream opened.\n");fflush(stdout);
    if(!streamL)
    {
	return -1;
    }
    demuxerL = demux_open(streamL, file_format, conf.AudioID, conf.VideoID, -1);
//    printf("demuxe opened.\n");fflush(stdout);
    if(demuxerL == NULL)
    {
        return -2;
    }
    d_audioL = demuxerL->audio;
    d_videoL = demuxerL->video;
/*
    if (conf.AudioDisable == TRUE)
        sh_audio = NULL;
        else
    */
    sh_audio=(sh_audio_t *)d_audioL->sh;
    sh_videoL=(sh_video_t *)d_videoL->sh;

    // Find & init audio codec
    rcL=0;
    rc1=0;
    if (sh_audio != NULL)
    {
//        printf("searching audio codec\n");fflush(stdout);
        sh_audio->codec=find_audio_codec(sh_audio->format);
    } else rcL = 1; // no audion
    if (rcL == 0 && sh_audio != NULL)
    {
        if (sh_audio->codec->codec_supported == TRUE)
       {
           a_bps=get_audio_bps(sh_audio);
           printf("audio bps=%u\n",a_bps);fflush(stdout);
       }
        else rcL = 2;
    }
    if (sh_videoL != NULL)
    {
        video_read_properties(sh_videoL);
//        printf("reading video props\n");fflush(stdout);
    }
    sh_videoL->codec=find_video_codec(sh_videoL->format);
//     printf("finding video codec\n");fflush(stdout);
    switch (rcL)
    {
    case 0: {strcpy(ppl->aCodec, sh_audio->codec->codec_name);break;}
    case 1: {strcpy(ppl->aCodec, "No audio");break;}
    case 2: {strcpy(ppl->aCodec, "Not supported");break;}
    } // switch
            switch(sh_videoL->ds->demuxer->file_format)
            {
            case DEMUXER_TYPE_ASF:
                sh_videoL->aspect = 1.0;
                strcpy(ppl->vFormat, (char *)&sh_videoL->format);
                ppl->cx = sh_videoL->disp_w;
                ppl->cy = sh_videoL->disp_h;

//                printf("Video: fourcc:[%.4s] size:%dx%d\n",
//                       (char *)&sh_video->format,
//                       sh_video->disp_w,sh_video->disp_h);
            break;

            case DEMUXER_TYPE_AVI:
            case DEMUXER_TYPE_AVI_NI:
            case DEMUXER_TYPE_AVI_NINI:
                sh_videoL->aspect = 1.0;
                strcpy(ppl->vFormat, (char *)&sh_videoL->format);
                ppl->cx = sh_videoL->disp_w;
                ppl->cy = sh_videoL->disp_h;
                ppl->nfps = sh_videoL->fps;
//                printf("Video: fourcc:[%.4s] size:%dx%d fps:%5.2f\n",
//                       (char *)&sh_video->format, sh_video->disp_w,sh_video->disp_h,
//                        sh_video->fps);
            break;
            case DEMUXER_TYPE_MPEG_ES:
            case DEMUXER_TYPE_MPEG_PS:
                strcpy(ppl->vFormat, sh_videoL->format?"MPEG1":"MPEG2");
                ppl->cx = sh_videoL->disp_w;
                ppl->cy = sh_videoL->disp_h;
                ppl->nfps = sh_videoL->fps;

//                printf("Video: %s size:%dx%d aspect:%s fps:%5.2f\n",
//                       sh_video->format?"MPEG1":"MPEG2",
//                       sh_video->disp_w,sh_video->disp_h,
//                       aspect, sh_video->fps);
                 break;
        }
            //        printf("Found video codec: %s\n", sh_video->codec->codec_name);
         strcpy(ppl->vCodec, sh_videoL->codec->codec_name);
         strcpy(ppl->fName, mediaFname);
         sprintf(ppl->res,"%dx%d",ppl->cx,ppl->cy);
         sprintf(ppl->fps,"%5.2f",ppl->nfps);
         ppl->ntime = sh_videoL->video.dwLength/sh_videoL->fps;
         if (ppl->ntime < 1) // mpeg?
         {
          if (sh_audio != NULL)
              ppl->ntime =(float)(demuxerL->movi_end-demuxerL->movi_start)/((float)sh_videoL->i_bps/10.0f*8.0f+(float)a_bps);
         }
         // calc total time for ASF stream
         if (sh_videoL->ds->demuxer->file_format == DEMUXER_TYPE_ASF)
            ppl->ntime = (float)(demuxerL->movi_end-demuxerL->movi_start)/(asf_packetsize*10);
         printf("play time=%f\n",ppl->ntime);fflush(stdout);
            ULONG new_time;
            new_time = (ULONG)ppl->ntime;
            sprintf(ppl->time,"%02d:%02d:%02d",new_time/3600,new_time/60%60,new_time%60);
            ppl->next=NULL;

//         free_demuxer(demuxerL);
     close_stream(streamL); // ᢮ ⮪

  return rcL;
}
pplayItem load_media(HWND hwnd, char *mname) // choose, check, and add media to playlist
{
   FILEDLG pfdFiledlg;
   HWND hwndDlg;
   char *pszFullFile;
   static PSZ ppszDefaultEATypeList[] = { "*", NULL};
   char s[128];
   pplayItem ppl = NULL;
   int mrc;
   if (mname == NULL || mname == "")
   {
       memset(&pfdFiledlg, 0, sizeof(FILEDLG));
       pfdFiledlg.cbSize = sizeof(FILEDLG);
       pfdFiledlg.fl = FDS_CENTER | FDS_OPEN_DIALOG;
       pfdFiledlg.pszTitle= "Choose media file:";
       strcat(pfdFiledlg.szFullFile,conf.mediapath); // last saved path if any
       strcat(pfdFiledlg.szFullFile,conf.exts);
//       pfdFiledlg.papszITypeList=(PAPSZ)ppszDefaultEATypeList;
       hwndDlg = WinFileDlg(HWND_DESKTOP, hwnd, &pfdFiledlg);

       pszFullFile=pfdFiledlg.szFullFile;
//       strcpy(conf.mediafile,pszFullFile);
       splitdir(pszFullFile,conf.mediapath,s);
   } else
       pszFullFile=mname;

//   save_ini();
   ppl = (pplayItem)malloc(sizeof(playItem));
   memset(ppl,0,sizeof(playItem));
   //   printf("alloc mem for item done. reading media props..\n");fflush(stdout);
   if (conf.Check) { // check media?
   mrc=media_props(pszFullFile,ppl);
//   printf("media props reading finished with code %i \n",mrc);fflush(stdout);
   if (mrc < 0) {
       if (ppl!=NULL) free(ppl);
       ppl = NULL; } // not media or unknown
   } else
   {
       strcpy(ppl->fName,pszFullFile);
   }
       return ppl;
}
