/*
 * WarpVision GUI. Main header
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include "cfgfile.h"
#include "bitbutt.h"
#include "wvguidlg.h"
// #include "statproc.h"
// define control signals
#define VIDCTL_PLAY   10000 // play (from beginning or from pause)
#define VIDCTL_STOP   10001 // stop and returns to beginning
#define VIDCTL_PAUSE  10002 // pause
#define VIDCTL_BEGIN  10003 // returns to begginning and play(?)
#define VIDCTL_END    10004 // forward to end or to begin of next video
#define VIDCTL_FBACK  10005 // fast back
#define VIDCTL_FFORW  10006 // fast forward
#define VIDCTL_AUDOFF 10007 // turn audio off
#define VIDCTL_AUDON  10008 // turn audio on
#define VIDCTL_VOL    10009 // set new audio volume
#define VIDCTL_POS    10010 // set new video position

// define status change signals
#define VIDSTA_MIN   11001 // window minmized
#define VIDSTA_MAX   11002 // window maximized
#define VIDSTA_RES   11003 // window resize
#define VIDSTA_TFS   11004 // toggle FS

// interprocess exchange data structure

// #define ID_APP_FRAMEWND 1
#include "icon.h"
#define ID_APP_SHOWWND 2
#define BHID 1017 // id 㡫-奫
#define DIZ_REPAINT 99
#define ID_TIMER 1

//    c os2ezine :)
// Undocumented messages generated by Warp 4 and superior versions
// These messages are posted to a window when the mouse pointer enters
// or leaves the window rectangle.
// The default window procedure returns FALSE in both cases

// mouse getting inside the window area
// mp1 : handle of the window the mouse is moving to
// mp2 : handle of the window previously under the mouse
#define WM_MOUSEENTER      0x041e

// mouse getting outside the window area
// mp1 : handle of the window the mouse is moving away from
// mp2 : handle of the window the mouse is moving to
#define WM_MOUSEEXIT       0x041f    // mouse leaving the window area

#define WS_TOPMOST  0x00200000
// buttons states defines
#define MBS_PRESSED 1
#define MBS_RELEASED 2
#define MBS_DISABLED 3
#define MBS_MOUSEOVER 0x8000
// ।塞 ᮮ饭

#define WC_DCLOCK "DIGITAL_CLOCK"
// ।塞 ᮮ饭
#define MSL_POSCHANGED      WM_USER+1 //  ᫠ 
#define MSL_SETPOS          WM_USER+2 // ⠭ ᫠   
#define MSL_CACHE           WM_USER+3
#define MSL_MOTIONBEGIN     WM_USER+4 // ⠭ ᫠   
#define MSL_MOTIONEND       WM_USER+5 // ⠭ ᫠   
#define MST_INIT            WM_USER+6
#define MST_NEWTEXT         WM_USER+7
#define CNTRL_FINISH        WM_USER+8
#define CNTRL_CLKUPD        WM_USER+9
#define NBM_BSCHANGED       WM_USER+10
#define MCL_SETCLOCKALONE   WM_USER+11
#define MCL_SETTIME         WM_USER+12
#define MCL_RESETCLOCK      WM_USER+13
#define MCL_BUTTONCLICK     WM_USER+14
#define MCL_BUTTONDBLCLK    WM_USER+15

#define MID_TIMER 1
#define ST_TIMER 2
#define BH_TIMER 3

#define BPLAY 1001
#define BSTOP 1002
#define BBEGIN 1003
#define BFBACK 1004
#define BFFORW 1005
#define BEND 1006
#define BSOUND 1007
#define BPLAYLIST 1008
#define BCONFIG 1009
#define BMIN 1010
#define BMAX 1011
#define BCLOSE 1012
#define SLVIDPOS 1013
#define SLSOUND 1014
#define VIDNAME 1015
#define DCLOCK 1016
#define BEJECT 1017

#define TRANSPERENT 0x000000ff

#define ASPECT_FORCE_169     1
#define ASPECT_FORCE_43      2
#define ASPECT_USER_DEFINED  3

// ===================================================
//  ६
// ===================================================

// configuration structure
#include "config.h"

Config conf;

HAB  hab;  // main Anchor block
HMQ   hmq; // main message queue
static BOOL mbp; // mouse button pressed (indicates, that mouse buttons is pressed)
HWND hWndFrame; // main window frame ID
HWND hWndClient; // Client Window ID
HWND hWndMenu; // main control popup menu
HWND hWndPLMenu; // playlist popup menu
HWND hwndMainDlg; // seetings window

POINTL apts[3];
ULONG chkst = 0;

BOOL windrag; // ᪠ 誮
SWP curpos; //  
POINTL mptl;
SWP winpos;
CHAR     PipeName[256] = "\\PIPE\\WVGUIPOS" ;     /* Pipe name */
HPIPE    PipeHandle    = NULLHANDLE;             /* Pipe handle */

char cl_media[255]; // command line media file
char rs_save[255]; // running string save
char st_path[255]; // program start path
char full_ini[255]; // full INI path
char DVDDrive[3]; // drive to work with DVD
int Shutdown = 0; // shutdown flag (set, when need shutdown playing)
int Pause = TRUE; // pause flag..it is set, when paused
int Playing = FALSE; // set, when playing
int Seeking = FALSE; // set, when seeking
BOOL IsDVDVCD; // true if dvd or vcd playing
BOOL ClockReverse;
int ScreenGamma = 0; // screen gamma (bright) REMOVE IT later!!!
int no_audio; // no audio flag. REMOVE IT later!!!
int SeekFlag = SEEK_NONE; // seek flag
int dem_flag;
float new_dem_pos;
float SyncCorrection = 0.0; // ????
float OldSyncCorrection = 0.0; // ????
demuxer_t* demuxerM = NULL; //main demuxer
stream_t* streamM = NULL; // main media stream
sh_audio_t *sh_audio = NULL; // audio stream
sh_video_t *sh_video = NULL; // video stream
demux_stream_t *d_audioM = NULL;
demux_stream_t *d_videoM = NULL;
//int colnum = 9;
long colsizes[9];
BOOL HWVIDEOPresent; // is HWVIDEO present?
HWVIDEOCAPS VideoCaps;
HWATTRIBUTE VideoAttr;
HWVIDEOSETUP VideoSetup;
ULONG     FourCC[10];
ULONG     ScreenFOURCC;
int WindowWidth, WindowHeight; // play window width & heigth
// audio & video playing threads
TID AudioThread, VideoThread;

extern DartStruct DART; // DART structure
int ArgNum; // number of args in cmd.line

HWND  WinHandle; // output window handle

//  ਫ
CHAR szAppTitle[] = "Video for OS/2";

MRESULT APIENTRY ShowWndProc(HWND, ULONG, MPARAM, MPARAM);
MRESULT APIENTRY TBWndProc(HWND, ULONG, MPARAM, MPARAM);
MRESULT APIENTRY FRWndProc(HWND, ULONG, MPARAM, MPARAM);

HWND hWndShow; // window to show movie
HWND hWndShowClient;
HWND tb; //title bar
HWND bhhwnd; //  㡫-奫

CHAR szShowAppTitle[] = "Movie";
ULONG flShowWinFlags =  FCF_TITLEBAR | FCF_BORDER | FCF_SIZEBORDER |FCF_NOBYTEALIGN | FCF_SHELLPOSITION | FCF_TASKLIST;
ULONG stShowWin = FS_NOBYTEALIGN;
ULONG stShowWinOnTop = FS_NOBYTEALIGN | WS_TOPMOST;

CHAR  szShowWndClass[] = "SHOWVIDEO2";
PFNWP oldTBProc;
PFNWP oldFRProc;
SWP tbswp;

PFNWP pfnWcStatic;
ULONG cbWcStatic;
BOOL ctrlInFocus; // is control window in focus?
BOOL showInFocus; // is control window in focus?


// bitmap
typedef struct {
   char fhbm[128];
   HBITMAP hbm;
   int x;
   int y;
   int width;
   int heigth;
} HBMPOS; // bitmap with position

typedef HBMPOS *PHBMPOS;

// bitmap
typedef struct {
      ULONG TitleBColor;
      ULONG TitleFColor;
      ULONG ListBColor;
      ULONG ListFColor;
      char ListFont[60];
      char TitleFont[60];
} PLAYLIST; // bitmap with position

typedef PLAYLIST *PPLAYLIST;

// clock/time indicator
typedef struct {
   ULONG id;
   HWND hWnd;
   char fbackgr[128];
   HBITMAP backgr;
   char fdigits[128];
   HBITMAP digits; //  ⬠  쪠
   BOOL isClock; // ⨯  ...⨪    ண
   DATETIME datetime; // ६窮
   CHAR help[128];
   BOOL isHelp;
   int x;
   int y;
   int width;
   int heigth;
   int dig_y;
   int dig_w;
   int dig_h;
   int dig_xh1;
   int dig_xh2;
   int dig_xm1;
   int dig_xm2;
   int dig_xs1;
   int dig_xs2;

    } SKN_CLK; // digital clocks
typedef SKN_CLK *PSKN_CLK;

// running text
typedef struct {
    ULONG id;
    HWND hWnd;
   char fbackgr[128];
   HBITMAP backgr;  //background for text
   HBITMAP hbm;  //temp
   HBITMAP hbmtext;  //temp for text
   CHAR vidname[254];  // video name
   CHAR help[128];
   BOOL isHelp;
   FATTRS fat;
   int x;
   int y;
   int pos; // position of text while its running
   int step; // run steps
   RECTL txt; // text rectangle within static window
   int width; // width
   int heigth; // heigth
   ULONG textwidth; // width of all text in pixels
   ULONG textheigth; // width of all text in pixels
   PFNWP oldStaticProc;
   HPS hps; //   
   HPS textps; // 
   ULONG tColor; //text color
  // 㥬  ,  ⮬   ࠭
   HDC hdc; // device context
   HDC hdct; // device context
   HAB hab;
} SKN_STAT; // name with position

typedef SKN_STAT *PSKN_STAT;

// button
typedef struct { // button structure
  HWND hWnd;
  ULONG id;
  CHAR help[128];
  BOOL isHelp;
  BOOL latch; // is it latched?
  BOOL dblpos; // is it latched?
   char fbutt_off[128];
   HBITMAP butt_off; // button off
   char fbutt_on[128];
   HBITMAP butt_on;  // button on
   char fbutt_off1[128];
   HBITMAP butt_off1; // button off
   char fbutt_on1[128];
   HBITMAP butt_on1;  // button on
   char fbutt_dis[128];
   HBITMAP butt_dis; // button disabled
   char fbutt_mouover[128];
   HBITMAP butt_mouover;
   char fbutt_mouover1[128];
  HBITMAP butt_mouover1;
  USHORT  bstate;
  int x;
  int y;
  int width;
  int heigth;
  PFNWP oldButtonProc;

    } SKN_BUTT;
typedef SKN_BUTT *PSKN_BUTT;

// slider
typedef struct { // slider structure
  HWND hWnd;
  ULONG id;
  CHAR help[128];
  BOOL isHelp;
  SLDCDATA sldcdata; // slider control data
  ULONG slstyle;  // slider style
   char fsld_arm[128];
   HBITMAP sld_arm; // slider arm bitmap
   char fsldarm_dis[128];
   HBITMAP sldarm_dis;  // disabled slider arm bitmap
   char fsldarm_sel[128];
   HBITMAP sldarm_sel;  // selected slider arm bitmap
   char fsld_shaft[128];
   HBITMAP sld_shaft; // slider shaft bitmap
   char fsld_backgr[128];
   HBITMAP sld_backgr; // slider background bitmap
  HBITMAP hbm; // temp slider bitmap
  USHORT  slorient; //orintation of slider (vertical or horisontal)
  int x;
  int y;
  int width;
  int heigth;
  int arm_width;
  int arm_heigth;
  int arm_pos;
  int shaft_x;
  int shaft_y;
  int shaft_width;
  int shaft_heigth;
  float min; // minimum volume in right (high) position
  float max; // maximum volume in right (high) position
  float step; // increase step on one pixel step in shaft
  BOOL drag;
  int beg_move_x;
  int beg_pos;
  PFNWP oldSliderProc;
  HPS hps; // ,  뢮 ᫠
  // 㥬  ,  ⮬   ࠭
  HDC hdc; // device context
  HAB hab;

  } SKN_SLD;  // slider skin
typedef SKN_SLD *PSKN_SLD;

// whole skin
typedef struct {            // skin structure
 int h;                     // window heigth
 int w;                     // window width
 HPS memdc;                 // for control background cache
 HDC hdc;                   // for control background cache
 HPS memdc_on;              // for focus control background cache
 HDC hdc_on;                // for focus control background cache

 POINTL apts[3];            // for control background cache

 HBMPOS def_backgr;         // default background for movie window; can be null;
 HBMPOS ctrl_backgr;        // control background.
 HBMPOS ctrl_backgr_on;     // control background.
 HBMPOS ctrl_backgr_off;    // control background.
 HBMPOS title_left;         // title. usually "WarpVision" :-)
 HBMPOS title_left_on;      // focused title. usually "WarpVision" :-)
 HBMPOS title_backgr;       // title bar background.
 PLAYLIST playlist;         // playlist
 SKN_BUTT min_butt;         // minimize button
 SKN_BUTT max_butt;         // maximize button
 SKN_BUTT close_butt;       // close button
 SKN_BUTT play_butt;        // >
 SKN_BUTT stop_butt;        //
 SKN_BUTT beg_butt;         // |<
 SKN_BUTT fb_butt;          // <<
 SKN_BUTT ff_butt;          // >>
 SKN_BUTT end_butt;         // >|
 SKN_BUTT sound_butt;
 SKN_BUTT conf_butt;        // configure
 SKN_BUTT playlist_butt;
 SKN_BUTT eject_butt;
 SKN_SLD  video_sld;        // video position slider
 SKN_SLD  audio_sld;        // audion volume slider
 SKN_STAT vidname;
 SKN_CLK  dclock;
    } SKIN;
typedef SKIN *PSKIN;

PSKIN skn; // main skin

// play item (for play list)
typedef struct playItem {
    char fName[128]; //media file name
    char aCodec[60]; // audio codec
    char vCodec[60]; // video codec
    char vFormat[60]; // video format
    char time[10]; // show time
    char abitrate[20]; // audio bit rate
    char freq[20]; //audio frequency
    char res[20]; // video resolution
    char fps[10]; // video fps
    float nfps;   // numeric fps
    int cx; // x res
    int cy; //y res
    float ntime; // time in seconds
    float currpos; // current position in seconds
    BOOL no_audio;
    struct playItem *prev;
    struct playItem *next;
    int row;
} playItem;

typedef playItem *pplayItem;

pplayItem playLst = NULL; // pointer to first entry in playlist
pplayItem playonce = NULL; // pointer to playitem, played once

char tColStr[10];
char *tcslast;

typedef unsigned char bool;// need for divelib
#define DIVE_MAXBUFFERS 16 // Maximal number of backbuffers
#define DIVE_NEXTBUFFER -1 // Choose next backbuffer

// dive interface
typedef struct {
    int DesktopH;
    int DesktopW;
    HDIVE hDive;                          // DIVE handle
    ULONG hBuffer[DIVE_MAXBUFFERS];       // Image buffers
    unsigned char *bufs[DIVE_MAXBUFFERS]; // array of pointers
  FOURCC BufferF;                       // Image buffer format
  long BufferW, BufferH;                // Image buffers parameters
  long nBuffers;                        // Count of image buffers
  long ActiveBuffer;                    // ID of active image buffer
  long VisibleBuffer;                   // ID of visible image buffer
  long ScreenW, ScreenH;                // Screen size
  ULONG *CLUT;                          // The palette for 256-color images
  HEV sRedrawComplete;                  // Redraw complete event semaphore
  bool fAspect;                         // Maintain aspect ratio?
  bool fPause;                          // Set to true will freeze drawing
  bool fMouseVisible;                   // If false mouse pointer will be hidden
  ULONG MouseCursorID;          // Mouse cursor shape ID (SPTR_ARROW ...)
  bool fMinimized;                      // This is true when window is minimized
  bool fFullScreen;                     // true if we`re in full-screen
  bool fPhysCLUT;                       // true if we changed physical palette
  bool fActive;                         // Window is active
  long FailedCount;                     // Count failed attempts to redraw between
  // WM_VRNDIS/ENABLED
  ULONG FrameCount;
  SWP swpFullScreen;                    // Window position before full-screen
  long WindowW;                         // Client window width
  long WindowH;                         // Client window height
  RECTL DirtyRect;                      // Rectangle that should be updated
  SWP rect;                           // rect to image out
  RECTL oldDirtyRect;                   // Dirty rectangle that is already set up
  ULONG MouseButtonMask;        // Current mouse button states
  bool MouseCaptured;           // Mouse captured flag
  RECTL RealRect;
  long FrameW;
  long FrameH;
  float AspectRatio;
  bool fDataInProgress;
  bool fVrnDisabled;
  int recalcX;                 // recalculate frame flag
  int recalcY;                 // recalculate frame flag
  BOOL recalc;                 // recalculate frame flag
} diveInfo;

diveInfo di; // dive info

// functions prototypes

void add_clock(HWND, PSKN_CLK );         // create clock window
void add_static(HWND, PSKN_STAT);        // create moving text window
void add_button(HWND, PSKN_BUTT);        // create button
void add_slider(HWND, PSKN_SLD);         // create slider
BOOL add_show(void);                     // create show window

void measure_slider(PSKN_SLD);           // set slider pos and size
void measure_button(PSKN_BUTT);          // set button pos and size
void measure_clock(PSKN_CLK);            // set clock pos and size
void measure_static(PSKN_STAT);          // set moving text pos and size
void measure_show(HWND, PHBMPOS);        // set show window pos and size

void save_ini(void);                     // save all conf to ini-file
void load_ini(void);                     // load from ini-file to conf

// dive init with size, color format and number of buffers
bool diveInit(long Width, long Height, FOURCC Format, float aspect, long nBuff,BOOL doopen);
bool SetupBlitter (HPS);                 // setup blitter for current window pos and size
// begin access to dive buffer befor fill it
unsigned char *diveBeginPaint (ULONG * BytesPerLine, long BufferNo);
void diveEndPaint (void);                // buffer filled, stop access
inline void bufSwitch (long );           // switch to next dive buffer
inline void WaitSwitch (void);           // wait until switched
int GetBestDIVEMode(void);               // auto select dive mode
void ReportDIVECaps(int);                // print dive caps
// set dive buffer size
bool ResizeBuffer (long Width, long Height, FOURCC Format);
void MouseVisible (bool);                // set mouse on/off
USHORT get_volume(void);                 // get current volume
void   set_volume(ULONG);                // set current volume
void   set_sound_state(BOOL);            // turn audio on/off
extern "C" {
ULONG  get_audio_bps(sh_audio_t *sh_audio); // get audio stream bps for movie
}
void set_new_text(PSKN_STAT st, char *newstr, char *oldstr);

void  set_slider_range(PSKN_SLD,float,float);// set range for slider
int   calc_slider_pos(PSKN_SLD, float);      // calculates position on slider shaft
void  set_slider_volume(PSKN_SLD, float);    // sets pos on shaft
int   get_slider_pos(PSKN_SLD);              // get pos on shaft
float get_slider_volume(PSKN_SLD);           // get float volume represanting float range
void  set_button_state(PSKN_BUTT, USHORT, BOOL);
void      setPause(BOOL);                    // pause playing
BOOL      begin_play(pplayItem);             // begin play given item
int       media_props(char*, pplayItem);     // reads properties of given media file
pplayItem load_media(HWND,char*);            // choose, check, and add media to playlist
void      pause_play(void);                  // pause playing
void      resume_play(void);                 // continue playing after pause
void      stop_play(void);                   // stop all playing

void addNewItem(pplayItem ppl);              // add new item to playlist

void fullScreen(BOOL);                       // set fullscreen on (TRUE) or off (FALSE)
void release_all(void);                      // release all resorces after play finished
void play_finished(void);                    // inform control

void set_clock(PSKN_CLK ,int );               // set counter seconds
void reset_clock(PSKN_CLK,BOOL);                  // set counter to clock state
RECTL r,r1;
void add_settings(void);
int pipe_create(void);
void pipe_close(void);
void get_coords(HWND hw, int *x,int *y,int *cx, int *cy);
void set_ontop(HWND hw, BOOL ontop);
pplayItem search_item(int item);
void remove_row(int item);
int read_playlist(char *cName, pplayItem ppi);
int sl_playlist(HWND hwnd,BOOL load_fl); // save/load playlist
void check_playlist(); // check if playlist autoload
ULONG mem_avail(void); // return memory
