/*
 * WarpVision GUI. Main file
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

// ===================================================
// ।
// ===================================================

// ।  䠩 os2.h
#define INCL_DOS
#define INCL_DOSPROFILE
#define INCL_WIN
#define INCL_GPI
#define INCL_WINWINDOWMGR
#define INCL_WINSYS
#define INCL_WINSHELLDATA
//  ᮤন ।, 室
//   ਫ OS/2
#include <os2.h>
// ⨯ ᫠஧⥫
MRESULT EXPENTRY newSliderProc(HWND , ULONG, MPARAM, MPARAM);
// ⨯ ⥫
MRESULT EXPENTRY newButtonProc(HWND , ULONG, MPARAM, MPARAM);
// ᤥ
MRESULT EXPENTRY ClockProc(HWND ,ULONG ,MPARAM ,MPARAM );
MRESULT EXPENTRY newStaticProc(HWND , ULONG, MPARAM, MPARAM);

//  䠩 㦥  । 㭪樨 sprintf
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <os2me.h>
#include <direct.h>
#include <stdarg.h>
#include <assert.h>

#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>

#include <sys\types.h>

#include "inttypes.h"

#include "wvision.h"

extern "C" {
#include "libavcodec\avcodec.h"
#include "yuv2rgb.h"
#include "libmpdemux\avifmt.h"
#include "libmpdemux\stream.h"
#include "libmpdemux\demuxer.h"
#include "libmpdemux\rcache.h"
#include "libmpdemux\stheader.h"
#include "codecs.h"
#include "audio\dart.h"
#include "audio\adecode.h"
#include "video\vdecode.h"
#include <mp3.h>
#include <a52.h>

HMTX demux_mtx;
HMTX dart_cb_mtx;

extern int index_mode;

extern audio_header_t audio_header;
extern video_header_t video_header;
float audio_delay = 0;

#define singlecadr (TimerFreq/sh_video->fps)
#define Q2LL(a) ((ULONG)a.ulHi<<32)|((ULONG)a.ulLo)

int snprintf (char *a, size_t b, const char *format, ...)
{
    va_list arg_ptr;

    va_start(arg_ptr, format);
    vsprintf(a, format, arg_ptr);
    va_end(arg_ptr);

    return 0;
}

 void dprintf(char fmt[],...)
 {
    return;
 }

}  // extern C

#include "hwvideo.h"

#include "video2.hpp"

//#include "advctl\actl.c" // advanced controls by MadInt

#include "skin.h"
#include "bubhelp.h"
#include "sldproc.h"
#include "btnproc.h"
#include "clkproc.h"
#include "statproc.h"
#include "showwin.hpp"
#include "saveload.hpp"
#include "playlist.h"
#include "vidprop.hpp"
#include "play.hpp"
#include "divelib.hpp"
#include "audio.hpp"
#include "npipes.h"

MRESULT EXPENTRY WndProc(HWND, ULONG, MPARAM, MPARAM);




// ===================================================
//  㭪 ਫ main
// 砥 ࠢ  ᪥ ਫ
// ===================================================

int main (int argc, char *argv[])
{
  // 䨪 । ᮮ饭
    // ,   뢠 ᮮ饭,
  // 祭  ।
  QMSG   qmsg;

  // ६  ࠭  
  BOOL  fRc;

  //   ᮧ  Frame Window
//  ULONG flFrameFlags =  FCF_SHELLPOSITION | FCF_TASKLIST ;
  ULONG flFrameFlags = FCF_TASKLIST | FCF_SHELLPOSITION;
  //   ᮧ  Frame Window
  ULONG flShowWinFlags =  FCF_TITLEBAR | FCF_NOBYTEALIGN | FCF_SIZEBORDER |  FCF_SHELLPOSITION | FCF_TASKLIST;
// FCF_NOBYTEALIGN |
  //    
  CHAR  szWndClass[] = "VIDEO2";
  CHAR  szShowWndClass[] = "SHOWVIDEO2";


  // 樠 ਫ, 室 
  // ᯮ짮 㭪権 Presentation Manager
   PPIB pib;
   PTIB tib;
   // get command line

   DosGetInfoBlocks(&tib, &pib);
   DosQueryModuleName(pib->pib_hmte, 255, st_path);
   char tmpfile[_MAX_PATH];
   splitdir(st_path,full_ini,tmpfile);
   strcat(full_ini,"VIDEO2.INI");

   // Try morphing into a PM application.
#ifndef PMAPI
   if (pib->pib_ultype == 2)          // VIO
   {
      pib->pib_ultype = 3;
   }
#endif
  hab = WinInitialize (0);
  if (!ClockRegister(hab)) DosBeep(2000,100);
  //   樠樨 뢮
  // ᮮ饭  訡
  if(hab == NULLHANDLE)
  {
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "訡 樠樨",
      "訡", 0, MB_ICONHAND | MB_OK);
    return(-1);
  }

  //  । ᮮ饭
  hmq = WinCreateMsgQueue (hab, 0);

  if(hmq == NULLHANDLE)
  {
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "訡  ᮧ । ᮮ饭",
      "訡", 0, MB_ICONHAND | MB_OK);

    // । ਩ 襭 ਫ
    // 室 맢 㭪 WinTerminate
    WinTerminate (hab);
    return(-1);
  }

  load_ini(); //load old or default settings
  // get command line
  conf.Check = TRUE;

//  strcpy(st_path,argv[-1]); // copy program start path to global var
    for(ArgNum = 0; ArgNum < argc; ArgNum++)
    {

        if (strcmp(argv[ArgNum], "-44100") == 0)
            conf.AudioResampleFlag = RESAMPLE_TO_44100;

        if (strcmp(argv[ArgNum], "-48000") == 0)
            conf.AudioResampleFlag = RESAMPLE_TO_48000;

        if (strncmp(argv[ArgNum], "-adev", 5) == 0)
            conf.AudioDeviceIndex = atoi(argv[ArgNum] + 5);

        if (strncmp(argv[ArgNum], "-bri", 4) == 0)
            conf.Bright = atoi(argv[ArgNum] + 4);

        if (strcmp(argv[ArgNum], "-idx") == 0)
            index_mode = 2; // generate index

        if (strcmp(argv[ArgNum], "-noaudio") == 0)
            conf.AudioDisable = TRUE;

        if (strcmp(argv[ArgNum], "-vaspect") == 0)
            conf.KeepAspect = TRUE;

        if (strncmp(argv[ArgNum], "-aid", 4) == 0)
            conf.AudioID = atoi(argv[ArgNum] + 4);

        if (strncmp(argv[ArgNum], "-vid", 4) == 0)
            conf.VideoID = atoi(argv[ArgNum] + 4);

        if (strncmp(argv[ArgNum], "-pricls", 7) == 0)
            conf.priClass = atoi(argv[ArgNum] + 7);

        if (strncmp(argv[ArgNum], "-pridta", 7) == 0)
            conf.priDelta = atoi(argv[ArgNum] + 7);

        if (strcmp(argv[ArgNum], "-vrgb") == 0)
            conf.VideoFormat = FMT_BGR24;

        if (strcmp(argv[ArgNum], "-vyuv") == 0)
            conf.VideoFormat = FMT_YUV422;

        if (strcmp(argv[ArgNum], "-nochk") == 0)
            conf.Check = FALSE;

        if (strcmp(argv[ArgNum], "-nowin") == 0)
            conf.isShowWindow = FALSE;

        if (strcmp(argv[ArgNum], "-win") == 0)
            conf.isShowWindow = TRUE;

        if (strncmp(argv[ArgNum], "-f", 2) == 0)
            strcpy(cl_media, argv[ArgNum] + 2);

    }

    if ((cl_media == "" || cl_media[0] == '\0') && (strcmpi(st_path,argv[argc-1]) != 0))
    {
     strcpy(cl_media, argv[argc-1]); // save command line media
//     printf("got cmd line file 2-nd way: %s\n",argv[argc]);fflush(stdout);
     }

//  
// strcpy(cl_media, argv[argc-1]); // save command line media
 save_ini(); // save new settings

  //    ਫ
    fRc = WinRegisterClass (hab, szWndClass,(PFNWP)WndProc, CS_SIZEREDRAW|CS_SYNCPAINT,  0);
                            //CS_SIZEREDRAW|CS_SYNCPAINT,  0);

  if(fRc == FALSE)
  {
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "訡  ॣ樨   ",
      "訡", 0, MB_ICONHAND | MB_OK);

    // । ਩ 襭 ਫ
    // 㭨⮦ ᮧ ࠭ । ᮮ饭 
    // 뢠 㭪 WinTerminate
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);

    return(-1);
  }


  //    ਫ

  hWndFrame = WinCreateStdWindow (HWND_DESKTOP,
    WS_VISIBLE,
    &flFrameFlags, szWndClass, szAppTitle,
    0, 0, ID_APP_FRAMEWND, &hWndClient);

  if(hWndFrame == NULLHANDLE)
  {
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "訡  ᮧ  ",
      "訡", 0, MB_ICONHAND | MB_OK);

    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);

    return(-1);
  }
//  load_ini(); //loading ini
  if (conf.ctlx == 9999 || conf.ctly == 9999) {
     WinQueryTaskSizePos(hab,0,&winpos);
     WinSetWindowPos(hWndFrame,HWND_TOP,winpos.x,winpos.y,skn->w,skn->h, SWP_ACTIVATE | SWP_MOVE | SWP_SHOW | SWP_SIZE);
  } else
  {
      WinSetWindowPos(hWndFrame,HWND_TOP,conf.ctlx,conf.ctly,skn->w,skn->h, SWP_ACTIVATE | SWP_MOVE | SWP_SHOW | SWP_SIZE);
   }


  mbp = FALSE; //    ?
  // ᪠ 横 ࠡ⪨ ᮮ饭
  while(WinGetMsg (hab, &qmsg, 0, 0, 0))
    WinDispatchMsg (hab, &qmsg);

  // ⮦   ਫ
  WinDestroyWindow(hWndFrame);

  // 塞 । ᮮ饭  뢠
  // 㭪 WinTerminate
  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);

  // 頥 ࠢ 樮 ⥬
  DosExit(0,0);
  return(0);
}


MRESULT EXPENTRY WndProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  // ६   ⮢ ᮮ饭
  CHAR szMsg[100];
  HPS hps,hpsb;
  RECTL rcl, rclb;
  USHORT kbs,kbs1,kbch;
  POINTL ptl;
  ULONG ulXY;
  SWP swp;
  LONG wID;
  int now_x,now_y;
  CHAR     szTickText[5];             // Text strings variable
  USHORT   idx;                       // Counter for setting text


   switch (msg)
   {
     case WM_BUTTON1DOWN:
//     case WM_BUTTON2DOWN:
         {   mbp = TRUE;
           if (hWnd!=WinQueryFocus(HWND_DESKTOP)) { WinSetFocus(HWND_DESKTOP, hWnd); }
           break;
       }
   case WM_BUTTON1UP:
//   case WM_BUTTON2UP:
       {   mbp = FALSE;
           break;
       }
   case WM_BUTTON2CLICK:
       {
           WinQueryPointerPos(HWND_DESKTOP, &ptl);
           WinMapWindowPoints(HWND_DESKTOP, hWnd, &ptl, 1L);
               WinPopupMenu(hWnd, hWnd, hWndMenu, ptl.x,ptl.y,0,
               PU_MOUSEBUTTON1 | PU_KEYBOARD | PU_HCONSTRAIN | PU_VCONSTRAIN);
               return 0;
       }
     case WM_BUTTON1MOTIONSTART:
//     case WM_BUTTON2MOTIONSTART:
         {
         mbp = TRUE;
//         strcpy(skn->vidname.vidname, "  , !");
//         WinSendMsg(skn->vidname.hWnd,MST_NEWTEXT,0L,0L);
         return WinSendMsg(WinQueryWindow(hWnd,QW_PARENT), WM_TRACKFRAME, MPFROMSHORT(TF_MOVE), MPVOID);
         }

     case WM_BUTTON1MOTIONEND:
//     case WM_BUTTON2MOTIONEND:
         {
          mbp = FALSE;
//         strcpy(skn->vidname.vidname, " ⠪, 㬭...");
//         WinSendMsg(skn->vidname.hWnd,MST_NEWTEXT,0L,0L);
         break;
         }

   case WM_CREATE:
       {
           // check for HWVIDEO
           //            HWVIDEOClose();
        WinDefWindowProc(hWnd, msg, mp1, mp2);
        hWndMenu = WinLoadMenu(hWnd, NULLHANDLE, ID_MENU);
        WinSetAccelTable (hab, NULLHANDLE, NULLHANDLE);
        if (!WinSetAccelTable (hab, WinLoadAccelTable(hab,NULL,ID_ACCEL), NULLHANDLE))
            DosBeep(2000,200);;

//        load_ini();
        load_skin(hWnd,conf.skinpath,conf.skinfile);
        init_skin(hWnd,skn);
        if (cl_media != "" && cl_media[0] != '\0')
        {
          strcpy(conf.mediafile,cl_media); // save cmd line media to last played
          save_ini();
          WinPostMsg(hWnd,WM_COMMAND,MPFROM2SHORT(IDM_PLAYLAST,0),NULL);
          printf("got cmd line file\n");fflush(stdout);
        }
        ClockReverse = FALSE;
        WinPostMsg(hWnd,WM_COMMAND,MPFROM2SHORT(IDM_CHKPLAYLST,0),NULL);
        return (MRESULT)FALSE;
       }

//   case WM_ERASEBACKGROUND:
//       {
//           WinInvalidateRect(hWnd,NULLHANDLE,FALSE);
      return (MRESULT)FALSE;
//       }
//   case WM_WINDOWPOSCHANGED:
//       {
//           WinInvalidateRect(skn->video_sld.hWnd,NULLHANDLE,TRUE);
//      return (MRESULT)TRUE;
//       }

   case WM_SIZE:
   {
       measure_all();
       break;
//    return 0;
    }
   case WM_CHAR:
   {
   kbch = CHARMSG(&msg)->vkey & VK_F4;
   kbs  = CHARMSG(&msg)->fs;
   kbs1 = kbs & KC_ALT;
   if ((kbs & KC_VIRTUALKEY) && !(kbs & KC_CTRL) && !(kbs & KC_SHIFT) && (kbch == VK_F4) && (kbs1 == KC_ALT))
   {
         WinPostMsg(hWnd, WM_QUIT, 0L, 0L);
         return ((MRESULT) NULL);
   }

   if (((CHARMSG(&msg)->fs) & KC_SCANCODE) && ((CHARMSG(&msg)->fs) & KC_KEYUP))
   {
       kbch=CHARMSG(&msg)->scancode;
//      printf("key code=%i\n",kbch);fflush(stdout);
   }
       if ((CHARMSG(&msg)->fs) & KC_CTRL)
       {
//       printf("ctrl pressed\n");fflush(stdout);

       switch(kbch)
       {
       case 38: // play last played
           {
          WinPostMsg(hWnd,WM_COMMAND,MPFROM2SHORT(IDM_PLAYLAST,0),NULL);
              break;
           } // case O
       case 25: // show playlist
           {
               WinPostMsg(hWnd,WM_COMMAND,MPFROM2SHORT(IDM_PLAYLIST,0),NULL);
              break;
           } // case O
       case 24: // load media
           {
               WinPostMsg(hWnd,WM_COMMAND,MPFROM2SHORT(IDM_LOADMEDIA,0),NULL);
               break;
           } // case O

         } // switch
       } // if key up
//    } // if ctrl
   return (FALSE);
   }

   case WM_SETFOCUS:
       {
           POINTL p;

           if (SHORT1FROMMP(mp2))
           {
               if (!WinIsChild((HWND)LONGFROMMP(mp1),hWnd) && ((HWND)LONGFROMMP(mp1) != hWndMenu))
               {
                   ctrlInFocus = TRUE;
                   hps = WinGetPS(hWnd);
                   p.x = skn->ctrl_backgr_on.x;
                   p.y = skn->ctrl_backgr_on.y;
                   if (skn->ctrl_backgr_on.hbm)
                    WinDrawBitmap(hps,skn->ctrl_backgr_on.hbm,
                      NULL,&p,0L,0L,DBM_NORMAL);
//                   WinDrawBitmap();
                   WinReleasePS(hps);
//                   WinInvalidateRect(hWnd,NULLHANDLE,TRUE);
               }
               //               printf("I have focus! \n");
           }
           else
           {
               if (!WinIsChild((HWND)LONGFROMMP(mp1),hWnd) && ((HWND)LONGFROMMP(mp1) != hWndMenu))
               {
                   ctrlInFocus = FALSE;
                   hps = WinGetPS(hWnd);
                   p.x = skn->ctrl_backgr_on.x;
                   p.y = skn->ctrl_backgr_on.y;
                   if (skn->ctrl_backgr_off.hbm)
                     WinDrawBitmap(hps,skn->ctrl_backgr_off.hbm,
                       NULL,&p,0L,0L,DBM_NORMAL);
                   WinReleasePS(hps);
               }
//               printf("I loose focus! \n");
           }
           //           fflush(stdout);
           return(WinDefWindowProc(hWnd, msg, mp1, mp2));
           }
   case WM_PAINT:
       {
        POINTL p;
        hps = WinBeginPaint(hWnd, NULLHANDLE, NULL);
         GpiBitBlt( hps,
                    skn->memdc,
                    3L,
                    (PPOINTL)skn->apts,ROP_SRCCOPY,BBO_IGNORE);
         p.x = skn->ctrl_backgr_on.x;
         p.y = skn->ctrl_backgr_on.y;
         if (ctrlInFocus)
         {
           if (skn->ctrl_backgr_on.hbm)
                WinDrawBitmap(hps,skn->ctrl_backgr_on.hbm,
                      NULL,&p,0L,0L,DBM_NORMAL);
         } else
         {
           if (skn->ctrl_backgr_off.hbm)
                WinDrawBitmap(hps,skn->ctrl_backgr_off.hbm,
                      NULL,&p,0L,0L,DBM_NORMAL);
         }
        WinEndPaint(hps);
        return (MRESULT)FALSE;
       }
   case WM_COMMAND:
       {
          switch (COMMANDMSG(&msg)->cmd)
          {
          case MCL_BUTTONDBLCLK: // update clock
              {
                  ClockReverse = !ClockReverse;
                  break;
              }
          case CNTRL_CLKUPD: // update clock
              {
               char plbuf[60];
               ULONG npRet,new_time;
               float cur_time;
               if (ClockReverse)
                   cur_time = playonce->ntime - audio_time;
               else cur_time = audio_time;
               new_time = (ULONG)cur_time;
               sprintf(plbuf,"%02d:%02d:%02d",new_time/3600,new_time/60%60,new_time%60);
               if (PipeHandle) DosWrite(PipeHandle,plbuf,strlen(plbuf),&npRet);
               set_slider_volume(&skn->video_sld,audio_time);
               set_clock(&skn->dclock,cur_time);
               return (MRESULT)TRUE;
               }
          case CNTRL_FINISH:
              {
           get_coords(hWndFrame,&conf.ctlx,&conf.ctly,NULL,NULL);
           get_coords(hWndShow,&conf.movx,&conf.movy,&conf.movcx, &conf.movcy);
           save_ini();
           if (conf.isShowWindow)
           {
               //               WinSetWindowULong(hWndShow, QWL_STYLE,stShowWin);
               WinShowWindow(hWndShow, FALSE);
               WinInvalidateRect(hWndShow,NULLHANDLE,TRUE);
               set_ontop(hWndShow,FALSE);
               WinShowWindow(hWndShow, TRUE);
           }
             else
             {
               WinShowWindow(hWndShow, FALSE);
                 if (!WinDestroyWindow(hWndShow)) DosBeep(2000,200);
                 }
                break;
              }
          case IDM_LOADPLLST:
              {
                  sl_playlist(hWnd,TRUE); // save/load playlist
                  break;
              }
          case IDM_SAVEPLLST:
              {
                  sl_playlist(hWnd,FALSE); // save/load playlist
                  break;
              }
          case IDM_CHKPLAYLST:
              {
                  char temp[128];
                  strcpy(temp,"Loading last saved playlist...");
                  set_new_text(&skn->vidname, temp,rs_save);
                  check_playlist();
                  set_new_text(&skn->vidname, rs_save, NULL);
                  break;
              }

          case IDM_PLAYLIST:
              {
                  add_playlist();
                  measure_playlist();
                  break;
              }
          case IDM_ADDLAST2LST:
              {
                if (!Playing)
                  {
                  addNewItem(playonce);
                  if (playLst != NULL) set_button_state(&skn->play_butt, MBS_RELEASED,FALSE);
                  }
                  break;
              }

          case IDM_ADDTOLIST:
              {
                if (!Playing)
                  {
                  addNewItem(load_media(hWnd,""));
                  if (playLst != NULL) set_button_state(&skn->play_butt, MBS_RELEASED,FALSE);
                  }
                  break;
              }
          case IDM_LOADMEDIA:
              {
                 if (Playing)
                     {
                         Shutdown=TRUE;
                         while (Playing) DosSleep(1); // wait for playing is down
                       }

                 playonce=load_media(hWnd,"");
                 if (playonce != NULL) { // if loading sucessfull
                     if (begin_play(playonce))
                     {
                         strcpy(conf.mediafile,playonce->fName);
                         save_ini();
                      }
                    }
                  break;
              }
          case IDM_PLAYONE:
              {
                if (Playing)
                   {
                       Shutdown=TRUE;
                       while (Playing) DosSleep(10); // wait for playing is down
                   }
                 if (begin_play(playonce)) // if all ok and we can play
                     {
                         strcpy(conf.mediafile,playonce->fName);
                         save_ini();
                      }
                 break;
              }
          case IDM_OPENDVDVCD:
              {
                if (Playing)
                   {
                       Shutdown=TRUE;
                       while (Playing) DosSleep(10); // wait for playing is down
                   }
                strcpy(DVDDrive,"G:\\");
                dvd_title = 1;
//                playonce=load_media(hWnd,DVDDrive);
                playonce = (pplayItem)malloc(sizeof(playItem));
                memset(playonce,0,sizeof(playItem));
                strcpy(playonce->fName,DVDDrive);
                dvd_title = 1;
                begin_play(playonce); // if all ok and we can play
                 break;
              }
          case IDM_PLAYLAST:
              {
             if (!Playing) { // only if not currently playing
                 playonce=load_media(hWnd,conf.mediafile);
                 if (playonce != NULL) { // if loading sucessfull
                     if (!begin_play(playonce)) { // if all ok and we can play
//                         printf("Life is suxx..\n");
                     }
                     else
                     {
                         strcpy(conf.mediafile,playonce->fName);
                         save_ini();
                      }
                    }
             } else // we playing now!
                 DosBeep(2000,300);
                  break;
              }

          case IDM_LOADSKIN:
              {
                  reload_skin(hWnd);
                  break;
              }
           case IDM_EXIT:
                WinPostMsg (hWnd, WM_QUIT, 0, 0) ;
                break;
           } //switch
         return 0;
        }  // case wm command
   case WM_CONTROL:
       {
           if (SHORT2FROMMP(mp1) == WM_CONTEXTMENU)
               {
               WinQueryPointerPos(HWND_DESKTOP, &ptl);
               WinMapWindowPoints(HWND_DESKTOP, hWnd, &ptl, 1L);
               WinPopupMenu(hWnd, hWnd, hWndMenu, ptl.x,ptl.y,0,
               PU_MOUSEBUTTON1 | PU_KEYBOARD | PU_HCONSTRAIN | PU_VCONSTRAIN);
               }

           switch(SHORT1FROMMP(mp1))
           {
           case BPLAY: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               { if (!Playing) { // not playing
                    if (playLst != NULL) { // playlist has something
                        if (!begin_play(playLst)) { // if all ok and we can play
                            printf("Life is suxx..\n");
                        }
                    }
               }
               else {
                   if (!Pause) pause_play();
                   else resume_play();
                   }
               } // if
               break;
           } // case bplay
           case BSTOP: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
//                   ReportDIVECaps( DIVE_BUFFER_SCREEN );
                   if (Playing)
                   {
//                       stop_play();
                       Shutdown=TRUE;
                       while (Playing) DosSleep(10); // wait for playing is down
                   }
                   else
                   {
                       WinPostMsg(hWnd,WM_COMMAND,MPFROM2SHORT(IDM_LOADMEDIA,0),NULL);
                       set_button_state(&skn->stop_butt, MBS_RELEASED,TRUE); // show eject
                    }
               } // if
              break;
           } // case bstop
           case BMAX: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
               if (Playing) {
                   if (!di.fFullScreen) fullScreen(TRUE);
                   set_button_state(&skn->max_butt, MBS_DISABLED,TRUE); //
                       }
               } // if
              break;
           } // case bmax

           case BCLOSE: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
                   if (Playing) Shutdown = TRUE; // down playing
                 while (Playing) DosSleep(1); // wait for playing is down
                  WinPostMsg(hWnd, WM_QUIT, 0L, 0L);
               } // if
              break;
           } // case bclose
           case BBEGIN: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
                   if (!Seeking)
                   {
                    Seeking=TRUE;
                    dem_flag = 3; // absolute seek
                    new_dem_pos=0;
                   }
               } // if
              break;
           } // case beg
           case BEND: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
                   if (!Seeking)
                   {
                       Seeking=TRUE;
                    dem_flag = 2; // absolute seek
                    new_dem_pos=99;
                   }
               } // if
              break;
           } // case end

           case BFFORW: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
                   if (!Seeking)
                   {
                       Seeking=TRUE;
                       dem_flag = 0; // absolute seek
                       new_dem_pos=10;
                   }
               } // if
              break;
           } // case fforw
           case BFBACK: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
                   if (!Seeking)
                   {
                    Seeking=TRUE;
                    dem_flag = 0; // absolute seek
                    new_dem_pos=-10;
                   } // if
                   }
              break;
           } // case fback

           case BPLAYLIST: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
                WinPostMsg(hWnd,WM_COMMAND,MPFROM2SHORT(IDM_PLAYLIST,0),NULL);
//                add_playlist();
               } // if
               break;
           } // case bplaylist
           case BCONFIG: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
                   add_settings();
               } // if
               break;
           } // case bconfig

           case BSOUND: {
               USHORT nst;
                   nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == NBM_BSCHANGED && nst == MBS_RELEASED)
               {
                   if (conf.IsSound)
                       conf.IsSound = FALSE;
                   else conf.IsSound = TRUE;
                   set_sound_state(conf.IsSound);

               } // if
               break;
           } // case bconfig

           case SLSOUND: {
               USHORT nst = SHORT1FROMMP(mp2);
               if (SHORT2FROMMP(mp1) == MSL_POSCHANGED)
               {
                   conf.volume=get_slider_volume(&skn->audio_sld);
                   set_volume(conf.volume);
               } // if
               break;
           } // case bplaylist

           case SLVIDPOS: {

              USHORT nst = SHORT1FROMMP(mp2);
              switch (SHORT2FROMMP(mp1))
              {
              case MSL_MOTIONBEGIN:
                  {
                   if (!Seeking && Playing)
                    {
//                        pause_play();
                    }
                break;
                }
              case MSL_MOTIONEND:
               {
                   //                 printf("slider motion end at: %f\n",new_pos);fflush(stdout);
                   if (Playing)
                   {
                   if (!Seeking)
                    {
                    Seeking=TRUE;
                    dem_flag = 1; // absolute seek
                    new_dem_pos=get_slider_volume(&skn->video_sld);
                   printf("slider motion end at: %f\n",new_dem_pos);fflush(stdout);
                    } // if !seeking
//                   resume_play();
                   } // if playing
                 break;
                }

             case MSL_POSCHANGED:
               {
//                float new_pos2;
//                 new_pos2=get_slider_volume(&skn->video_sld);
//                 printf("slider at: %f\n",new_pos2);fflush(stdout);

/*
                   float new_pos;
                   new_pos=get_slider_volume(&skn->video_sld);
                   if (!Seeking && Playing)
                    {
                    Seeking=TRUE;
                    DosRequestMutexSem(dart_cb_mtx, (ULONG)SEM_INDEFINITE_WAIT);
                    demux_seek(demuxerM, new_pos, 1);
                    DosReleaseMutexSem(dart_cb_mtx);
                    Seeking=FALSE;
                    }
                    */
                 break;
               } // case
              } // switch MSL_
               break;
           } // case SLIDER
              break;
             } //
      return 0;
       }
   case WM_DESTROY:
       {
           //           WinShowWindow(hWnd,FALSE);
           HWVIDEOClose();
           if (Playing) Shutdown = TRUE; // down playing
           while (Playing) DosSleep(1); // wait for playing is down
           WinShowWindow(hWnd,FALSE);
           GpiDestroyPS(skn->memdc);
           DevCloseDC(skn->hdc);
           SWP winpos;
           WinQueryWindowPos(hWndFrame,&winpos);
           conf.ctlx=winpos.x;
           conf.ctly=winpos.y;
           get_coords(hWndFrame,&conf.ctlx,&conf.ctly,NULL,NULL);
           if (hWndShow) get_coords(hWndShow,&conf.movx,&conf.movy,&conf.movcx, &conf.movcy);
           if (hWndPlayList) get_coords(hWndPlayList,&conf.playlx,&conf.playly,&conf.playlcx, &conf.playlcy);
           save_ini();
           unload_skin(skn);
           return 0;
        }
    default:
      return(WinDefWindowProc(hWnd, msg, mp1, mp2));
   }
   return(WinDefWindowProc(hWnd, msg, mp1, mp2));
//   return 0;
   }
