/*
 * WarpVision GUI. Running text proc
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

void set_new_text(PSKN_STAT st, char *newstr, char *oldstr)
{
    if (oldstr != NULL) strcpy(oldstr,st->vidname);

  if (newstr != NULL)
  {
      strcpy(st->vidname, newstr);
      // double post for compatibility with other threads
      WinSendMsg(st->hWnd,MST_NEWTEXT,0L,0L);
      WinPostMsg(st->hWnd,MST_NEWTEXT,0L,0L);
  }
}

void measure_static(PSKN_STAT b)
{
  WinSetWindowPos (b->hWnd, HWND_TOP,b->x, b->y, b->width, b->heigth, SWP_SIZE | SWP_MOVE);
 return;
    }

void add_static(HWND parent, PSKN_STAT pstat)
 {
       pstat->hWnd = WinCreateWindow (parent, WC_STATIC,
        "", WS_VISIBLE | SS_TEXT ,0, 0, 0, 0, parent, HWND_TOP , pstat->id, NULL, NULL);
        WinSetWindowPtr(pstat->hWnd,QWL_USER, pstat);
        pstat->oldStaticProc = WinSubclassWindow(pstat->hWnd, (PFNWP)newStaticProc);
        WinSendMsg(pstat->hWnd,MST_INIT,0L,0L);
       return;
    }

void redraw_stat(HPS hps, PSKN_STAT pstat)
{
    POINTL ptl = {0,0};
    POINTL pts1[4],pts2[4];
    int cx;

    WinDrawBitmap (pstat->hps, pstat->backgr, NULL, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL) ;

    cx = pstat->txt.xRight-pstat->txt.xLeft;
        pts1[0].x = pstat->txt.xLeft;
        pts1[0].y = pstat->txt.yBottom;
        pts1[1].x = pstat->txt.xRight;
        pts1[1].y = pstat->txt.yTop;
        if (cx > pstat->textwidth) // ⥪  ...뢮  
        {
            pts1[2].x = 0;
            pts1[2].y = 0;
            GpiBitBlt( pstat->hps, pstat->textps,3L, pts1, ROP_SRCPAINT, BBO_IGNORE );
        } else
          {
            pts1[2].x = pstat->pos;
            pts1[2].y = pstat->txt.yBottom;
            pts1[3].x = pts1[2].x + cx;
            pts1[3].y = pstat->txt.yTop;
            GpiBitBlt( pstat->hps, pstat->textps,4L, pts1, ROP_SRCPAINT, BBO_IGNORE );
            if ((pstat->textwidth-pstat->pos) < cx) { // 墮 
            pts2[0].x = pts1[0].x + (pstat->textwidth-pstat->pos);
            pts2[0].y = pts1[0].y;
            pts2[1].x = pts1[1].x;
            pts2[1].y = pts1[1].y;

            pts2[2].x = 0;
            pts2[2].y = pstat->txt.yBottom;
            pts2[3].x = pts2[1].x - pts2[0].x;
            pts2[3].y = pstat->txt.yTop;
            GpiBitBlt(pstat->hps, pstat->textps,4L, pts2, ROP_SRCPAINT, BBO_IGNORE );
            }
          } // else
        //  ⥯ 㥬 
    pts1[0].x = pts1[0].y = pts1[2].x = pts1[2].y = 0;
    pts1[1].x = pstat->width;
    pts1[1].y = pstat->heigth;
    GpiBitBlt(hps, pstat->hps, 3L, pts1, ROP_SRCCOPY, BBO_IGNORE );
 return;
}

void createtextbmp(PSKN_STAT p)
{
 SHORT cx,cy,cxv,cyv;
 POINTL aptl[TXTBOX_COUNT];
 BITMAPINFOHEADER2 bmp;
 DEVOPENSTRUC dop = {NULL, "DISPLAY", NULL, NULL, NULL, NULL,
                    NULL, NULL, NULL};
 SIZEL sizl = { 0,0};
 LONG cPlanes;
 LONG cBitCount;
 RECTL rclb,rcl;
 POINTL ptl;
 LONG alTable[16];
 FONTMETRICS fm;
 SIZEF sizf;

     p->hab = WinQueryAnchorBlock(p->hWnd);
     p->hdc = DevOpenDC(p->hab,OD_MEMORY,"*",2L,(PDEVOPENDATA)&dop,NULLHANDLE);
     p->hps = GpiCreatePS(p->hab,p->hdc,&sizl,PU_PELS | GPIA_ASSOC);
     p->hdct = DevOpenDC(p->hab,OD_MEMORY,"*",2L,(PDEVOPENDATA)&dop,NULLHANDLE);
     DevQueryCaps(p->hdc, CAPS_COLOR_PLANES  , 1L, &cPlanes);
     DevQueryCaps(p->hdc, CAPS_COLOR_BITCOUNT, 1L, &cBitCount);

     bmp.cbFix     = sizeof(BITMAPINFOHEADER2);
     bmp.cx        = (SHORT)p->width;
     bmp.cy        = (SHORT)p->heigth;
     bmp.cPlanes   = (SHORT)cPlanes;
     bmp.cBitCount = (SHORT)cBitCount;

     p->hbm = GpiCreateBitmap(p->hps,
                      (PBITMAPINFOHEADER2)&bmp,
                      0x0000,
                      (PBYTE)NULL,
                      (PBITMAPINFO2)NULL);
     GpiSetBitmap(p->hps , p->hbm);

  p->textps = GpiCreatePS( p->hab, p->hdct, &sizl, PU_PELS | GPIA_ASSOC );

  GpiCreateLogFont(p->textps, NULL, 1L, &p->fat);
  GpiSetCharSet (p->textps, 1L);
  GpiQueryTextBox (p->textps, strlen(p->vidname), p->vidname, 4L, aptl) ;
                 cx = (SHORT) (aptl [TXTBOX_TOPRIGHT].x -
                                     aptl [TXTBOX_TOPLEFT].x) ;
                 cy = (SHORT) (aptl [TXTBOX_TOPLEFT].y -
                               aptl [TXTBOX_BOTTOMLEFT].y) ;
  GpiQueryFontMetrics(p->textps, sizeof(FONTMETRICS), &fm);
  memset( &bmp, 0, sizeof(BITMAPINFOHEADER2));

  bmp.cbFix     = sizeof(BITMAPINFOHEADER2);
  bmp.cx        = cx;
  bmp.cy        = cy;
  bmp.cPlanes   = cPlanes;
  bmp.cBitCount = cBitCount;
  p->hbmtext = GpiCreateBitmap( p->textps, &bmp, 0L, NULL, NULL );
  p->textwidth = cx;
  p->textheigth = cy;
  GpiSetBitmap( p->textps, p->hbmtext );
//  GpiSetColor (psknstat->textps,psknstat->tColor ) ;
  ptl.x= ptl.y = 0;
  rcl.xLeft= rcl.yBottom = 0;
  rcl.xRight=cx;
  rcl.yTop=cy;
    GpiQueryLogColorTable(p->textps, 0L, 0L, 16, alTable);
    GpiCreateLogColorTable(p->textps, 0L, LCOLF_RGB, 0L, 16, alTable);
//    WinSetPresParam(p->hWnd, PP_FONTNAMESIZE, 11,(PVOID)"18.Courier");
    //    sizf.cx = MAKEFIXED(fm.lEmInc,0);
    sizf.cx = MAKEFIXED(p->fat.lMaxBaselineExt,0);
    sizf.cy = MAKEFIXED(p->fat.lMaxBaselineExt,0);
    GpiSetCharBox(p->textps, &sizf );

  WinDrawText(p->textps, -1, p->vidname, &rcl, p->tColor, 0L,DT_LEFT | DT_VCENTER);
//  GpiCharStringAt ( psknstat->textps, &ptl, strlen(psknstat->vidname), psknstat->vidname);
  p->pos=0;
  if ((p->txt.xRight-p->txt.xLeft) <= p->textwidth)
       WinStartTimer(p->hab,p->hWnd,ST_TIMER,30);

 }
void destroytextbmp(PSKN_STAT p)
{
           p->hbm = GpiSetBitmap (p->hps, NULLHANDLE);
           p->hbmtext = GpiSetBitmap (p->textps, NULLHANDLE);

        if (p->hbm != NULLHANDLE) GpiDeleteBitmap (p->hbm);

        if (p->hbmtext != NULLHANDLE) GpiDeleteBitmap (p->hbmtext);

           GpiDestroyPS(p->hps);
           GpiDestroyPS(p->textps);
           DevCloseDC(p->hdc);
           DevCloseDC(p->hdct);
       if ((p->txt.xRight-p->txt.xLeft) <= p->textwidth) WinStopTimer(p->hab,p->hWnd,ST_TIMER);

 }


MRESULT EXPENTRY newStaticProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
 {
 PSKN_STAT psknstat;
 HPS hpsb;
 int now_x,newpos;


// WinSetAccelTable (WinQueryAnchorBlock (hwnd), NULLHANDLE, NULLHANDLE);

psknstat = (PSKN_STAT)WinQueryWindowPtr(hwnd,QWL_USER);

// st =
switch (msg) {

   case WM_TIMER:
       {
           psknstat->pos = psknstat->pos + psknstat->step;
           if (psknstat->step >0) {
               if (psknstat->pos>=psknstat->textwidth) { psknstat->pos=0; }
           } else {
               if (psknstat->pos < 0) { psknstat->pos=psknstat->textwidth; }
           }
           WinInvalidateRect(psknstat->hWnd,NULLHANDLE,FALSE);
           break;
       }
case MST_NEWTEXT:
    {
       destroytextbmp(psknstat);
       createtextbmp(psknstat);
       WinInvalidateRect(psknstat->hWnd,NULLHANDLE,FALSE);
        return (MRESULT)TRUE;
    }
    case MST_INIT:
        {
   createtextbmp(psknstat);
  if ((psknstat->txt.xRight-psknstat->txt.xLeft) <= psknstat->textwidth)
      WinStartTimer(psknstat->hab,psknstat->hWnd,ST_TIMER,30);
     return (MRESULT)TRUE;
        }
       case WM_CONTEXTMENU:
           {
            WinSendMsg (WinQueryWindow (hwnd, QW_OWNER), WM_CONTROL,
                        MPFROM2SHORT (WinQueryWindowUShort(hwnd, QWS_ID),
                       WM_CONTEXTMENU), (MPARAM)0L);
         break;
           }
     case WM_BUTTON1DOWN:
         {
             WinSetFocus(HWND_DESKTOP,WinQueryWindow(hwnd,QW_OWNER)); // set focuse to owner
             break;
         }
case WM_BUTTON1DBLCLK:
    {
        if (psknstat->step > 0) {
            psknstat->step = 0-psknstat->step;
        } else {
            psknstat->step = abs(psknstat->step);
          }
        break;
      }
     case WM_PAINT:
         {
        hpsb = WinBeginPaint(hwnd, NULLHANDLE, NULL);
        redraw_stat(hpsb,psknstat);
        WinEndPaint(hpsb);
         return (MRESULT)FALSE;
         }
        case WM_DESTROY:
            {
                GpiDeleteBitmap(psknstat->backgr);
                destroytextbmp(psknstat);
                break;
            }
     } // switch
           return (MRESULT)psknstat->oldStaticProc(hwnd,msg,mp1,mp2);
    }
