/*
 * WarpVision GUI. Slider procedure
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

void set_slider_range(PSKN_SLD s, float min, float max)
{
    s->min = min;
    s->max = max;
    s->step = (max-min)/(float)s->shaft_width; // calculate step
}
int calc_slider_pos(PSKN_SLD s, float pos) // calculates position on slider shaft
{
    int sh_pos; // pos on shaft
    sh_pos = pos/s->step;
    return sh_pos;
}
void set_slider_volume(PSKN_SLD s, float pos) // sets pos on shaft
{
    WinPostMsg(s->hWnd, MSL_SETPOS,0L,MPFROMSHORT(calc_slider_pos(s,pos)));
}
int get_slider_pos(PSKN_SLD s) // get pos on shaft
{
    return s->arm_pos;
 }
float get_slider_volume(PSKN_SLD s) //  get float volume represanting float range
{
    return s->step*get_slider_pos(s);
 }

void measure_slider(PSKN_SLD s)
{
  WinSetWindowPos (s->hWnd, HWND_TOP,s->x, s->y, s->width, s->heigth, SWP_SIZE  | SWP_MOVE );
 return;
    }

void add_slider(HWND parent, PSKN_SLD psld)
 {
    ULONG armpos;
    ULONG ulInfo;
    LONG rc;

    psld->sldcdata.cbSize = sizeof(SLDCDATA);
    psld->sldcdata.usScale1Spacing = 1;
  switch (psld->slorient) {
    case SLS_HORIZONTAL: { psld->slstyle = WS_VISIBLE |
                                           SLS_HORIZONTAL | SLS_RIGHT |SLS_BOTTOM|
                                           SLS_PRIMARYSCALE1 |
                                           SLS_HOMELEFT;
//                                           SLS_OWNERDRAW;
      psld->sldcdata.usScale1Increments = psld->shaft_width - 6;
     break;
                                            }

    case SLS_VERTICAL: {psld->slstyle = WS_VISIBLE |
                                           SLS_VERTICAL |
                                           SLS_PRIMARYSCALE1 |
                                           SLS_HOMEBOTTOM | SLS_CENTER |
                                           SLS_OWNERDRAW;
             psld->sldcdata.usScale1Increments = psld->shaft_heigth;
             break;
                                            }
    } // switch
       psld->hWnd = WinCreateWindow (parent, WC_SLIDER,
        "", psld->slstyle,
        psld->x, psld->y, psld->width, psld->heigth, parent, HWND_TOP , psld->id, &psld->sldcdata, NULL);
        WinSetWindowPtr(psld->hWnd,QWL_USER, psld);
        psld->oldSliderProc = WinSubclassWindow(psld->hWnd, (PFNWP)newSliderProc);
        WinPostMsg(psld->hWnd, MSL_CACHE,0L,0L);
        psld->arm_pos=0;
        psld->drag=FALSE;
        psld->beg_move_x = 0;
        psld->beg_pos = psld->arm_pos;
       return;
    }

void redraw_slider(HPS hps, PSKN_SLD psld) {
    POINTL              pts[3];
    HPS                 memdc1;
    HDC hdc1;
    HAB hab1;
    SIZEL sizl = { 0,0};
    DEVOPENSTRUC dop = {NULL, "DISPLAY", NULL, NULL, NULL, NULL,
                    NULL, NULL, NULL};
    POINTL ptl;

//    hab1 = WinQueryAnchorBlock(psld->hWnd); //㥬   
//    hdc1 = DevOpenDC( hab1, OD_MEMORY, "*", 1L,(PDEVOPENDATA)&dop, NULLHANDLE );
//    memdc1 = GpiCreatePS( hab1, hdc1, &sizl, PU_PELS | GPIA_ASSOC );

//    GpiSetBitmap(psld->hps , psld->sld_backgr);
    // ᥣ 㥬  ⬠
//    GpiSetBitmap( memdc1, psld->sld_backgr );

    pts[2].x = 0;
    pts[2].y = 0;
// 㥬 䮭
//    pts[0].x = 0;
//    pts[0].y = 0;
//    pts[1].x = psld->width;
//    pts[1].y = psld->heigth;
//    GpiBitBlt( psld->hps,memdc1, 3L, pts, ROP_SRCCOPY, BBO_IGNORE );
//    GpiSetBitmap( memdc1, NULLHANDLE );
    // 㥬 

//    GpiSetBitmap( memdc1, psld->sld_shaft );
//    pts[0].x = psld->shaft_x;
//    pts[0].y = psld->shaft_y;
//    pts[1].x = psld->shaft_width+pts[0].x;
//    pts[1].y = psld->shaft_heigth+pts[0].y;
//    GpiBitBlt( psld->hps,memdc1, 3L, pts, ROP_SRCCOPY, BBO_IGNORE );
//    GpiSetBitmap( memdc1, NULLHANDLE );
    // 㥬 
//    GpiSetBitmap( memdc1, psld->sld_arm );
//    pts[0].x = psld->shaft_x+armp-psld->arm_width/2;
//    pts[0].y = psld->shaft_y+psld->shaft_heigth/2-psld->arm_heigth/2;
//    pts[1].x = psld->arm_width+pts[0].x;
//    pts[1].y = psld->arm_heigth+pts[0].y;
//    GpiBitBlt( psld->hps,memdc1, 3L, pts, ROP_SRCCOPY, BBO_IGNORE );
//    GpiSetBitmap( memdc1, NULLHANDLE );
// 㥬 
//    pts[0].x = 0;
//    pts[0].y = 0;
//    pts[1].x = psld->width;
//    pts[1].y = psld->heigth;
//    GpiBitBlt(hps, psld->hps, 3L, pts, ROP_SRCCOPY, BBO_IGNORE );
    // ᢮稢 
//       GpiDestroyPS(memdc1);
//       DevCloseDC(hdc1);


    ptl.x=0;
    ptl.y=0;
    WinDrawBitmap (psld->hps, psld->sld_backgr, NULL, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL) ;
    ptl.x=psld->shaft_x;
    ptl.y=psld->shaft_y;
    WinDrawBitmap (psld->hps, psld->sld_shaft, NULL, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL) ;
    ptl.x=psld->shaft_x+psld->arm_pos-psld->arm_width/2;
    ptl.y=psld->shaft_y+psld->shaft_heigth/2-psld->arm_heigth/2;
    if (psld->drag)
        WinDrawBitmap (psld->hps, psld->sldarm_sel, NULL, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);
            else WinDrawBitmap (psld->hps, psld->sld_arm, NULL, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);
    pts[0].x = 0;
    pts[0].y = 0;
    pts[1].x = psld->width;
    pts[1].y = psld->heigth;
    GpiBitBlt(hps, psld->hps, 3L, pts, ROP_SRCCOPY, BBO_IGNORE );
//    printf("armpos=%i\n",psld->arm_pos);
//    fflush(stdout);
    return;
 }

MRESULT EXPENTRY newSliderProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
 {
 PSKN_SLD psld = NULL;
 HPS hpsb;
 RECTL rclb,rcl;
 POINTL ptl,ptl1;
 USHORT new_ap,slarmpos;
 SIZEL               sizl = { 0, 0 };
 DEVOPENSTRUC dop = {NULL, "DISPLAY", NULL, NULL, NULL, NULL,
 NULL, NULL, NULL};
 LONG cPlanes;
 LONG cBitCount;
 HBITMAP hbm;
 BITMAPINFOHEADER bmp;


// WinSetAccelTable (WinQueryAnchorBlock (hwnd), NULLHANDLE, NULLHANDLE);

 psld = (PSKN_SLD)WinQueryWindowPtr(hwnd,QWL_USER);

if (psld == NULL) return NULL;

switch (msg) {
  case WM_TIMER:
      {
          if (psld->isHelp) {
              WinDestroyWindow(bhhwnd);
//              psknbtn->isHelp = FALSE;
          } else {
              startbubblehelp(psld->hWnd,psld->help);
              psld->isHelp = TRUE;
          }
          WinStartTimer(hab,psld->hWnd,BH_TIMER,1500L);
       return (MRESULT)TRUE;
       }

    case MSL_CACHE:
        {
//            ulFlags = GpiQueryPS(hps, &sizl);
//            WinReleasePS(hps);
     psld->hab = WinQueryAnchorBlock(psld->hWnd);
     psld->hdc = DevOpenDC(psld->hab,OD_MEMORY,"*",1L,(PDEVOPENDATA)&dop,NULLHANDLE);
     psld->hps = GpiCreatePS(psld->hab,psld->hdc,&sizl,PU_PELS | GPIA_ASSOC);
     DevQueryCaps(psld->hdc, CAPS_COLOR_PLANES  , 1L, &cPlanes);
     DevQueryCaps(psld->hdc, CAPS_COLOR_BITCOUNT, 1L, &cBitCount);

     bmp.cbFix     = sizeof(BITMAPINFOHEADER);
     bmp.cx        = (SHORT)psld->width;
     bmp.cy        = (SHORT)psld->heigth;
     bmp.cPlanes   = (SHORT)cPlanes;
     bmp.cBitCount = (SHORT)cBitCount;

    psld->hbm = GpiCreateBitmap(psld->hps,
                      (PBITMAPINFOHEADER2)&bmp,
                      0x0000,
                      (PBYTE)NULL,
                      (PBITMAPINFO2)NULL);
     GpiSetBitmap(psld->hps , psld->hbm);

     break;
        }
     case WM_DESTROY:
         {
            psld->hbm = GpiSetBitmap (psld->hps, NULLHANDLE);

        if (psld->hbm != NULLHANDLE)
              GpiDeleteBitmap (psld->hbm);

           GpiDestroyPS(psld->hps);
           DevCloseDC(psld->hdc);
         GpiDeleteBitmap(psld->sld_arm);
         GpiDeleteBitmap(psld->sldarm_dis);
         GpiDeleteBitmap(psld->sld_shaft);
         GpiDeleteBitmap(psld->sld_backgr);
         GpiDeleteBitmap(psld->sldarm_sel);

         break;
        }
     case MSL_SETPOS:
         {
           if (!psld->drag) // dont change pos while draging
             {
             psld->arm_pos=SHORT1FROMMP(mp2);
             return ((MRESULT)WinInvalidateRect(hwnd,0,FALSE));
             }
             return (MRESULT)FALSE;
         }

     case WM_PAINT:
    {
//        WinQueryWindowRect(hwnd,&rclb);
        hpsb = WinBeginPaint(psld->hWnd, NULLHANDLE, NULL);
        redraw_slider(hpsb,psld);
        WinEndPaint(hpsb);
//         WinValidateRect(hwnd,&rclb,FALSE);
         return (MRESULT)FALSE;
         //         return(oldSliderProc(hwnd, msg, mp1, mp2));
    }
       case WM_CONTEXTMENU:
           {
            WinSendMsg (WinQueryWindow (hwnd, QW_OWNER), WM_CONTROL,
                        MPFROM2SHORT (WinQueryWindowUShort(hwnd, QWS_ID),
                       WM_CONTEXTMENU), (MPARAM)0L);
         break;
           }
     case WM_BUTTON1DOWN: // த 㦥 䮪!!!
     case WM_BUTTON2DOWN:
         {
           mbp = TRUE;
         WinSetFocus(HWND_DESKTOP,WinQueryWindow(psld->hWnd,QW_OWNER)); // set focuse to owner
//         WinQueryWindowRect(psld->hWnd, &rcl);
         // 뢠 न 窨
         rcl.xLeft=psld->arm_pos-psld->arm_width/2+psld->shaft_x;
         rcl.yBottom=psld->shaft_y+psld->shaft_heigth/2-psld->arm_heigth/2;
         rcl.xRight=psld->arm_pos+psld->arm_width/2+psld->shaft_x;
         rcl.yTop=psld->shaft_y+psld->shaft_heigth/2+psld->arm_heigth/2;

         //  誨?
         ptl.x = MOUSEMSG(&msg)->x;
         ptl.y = MOUSEMSG(&msg)->y;
         if(WinPtInRect(WinQueryAnchorBlock(psld->hWnd), &rcl, &ptl)) {
             //  䮪!
             if (psld->hWnd!=WinQueryFocus(HWND_DESKTOP)) {
                 WinSetFocus(HWND_DESKTOP, psld->hWnd);
//                 WinSetFocus(HWND_DESKTOP,WinQueryWindow(hwnd,QW_OWNER)); // set focuse to owner
             }
         // ८ࠧ㥬 न   ⮯
         WinMapWindowPoints(psld->hWnd,HWND_DESKTOP,&ptl,1L);
          psld->beg_move_x = ptl.x;
          psld->beg_pos = psld->arm_pos;
          WinInvalidateRect(hwnd,0,FALSE); // ᮢ뢠  ᫠
//          printf("armpos2=%i\n",psld->arm_pos);
         //          fflush(stdout);
            WinSetCapture(HWND_DESKTOP,psld->hWnd); //   ⤠   ⮯!!.., 
            psld->drag=TRUE; // ﭥ
        WinPostMsg(WinQueryWindow(psld->hWnd,QW_OWNER), WM_CONTROL,
           MPFROM2SHORT(psld->id,MSL_MOTIONBEGIN),MPFROMSHORT(psld->arm_pos));

            }
         break;
      }
     case WM_MOUSEMOVE:
         {  if (psld->drag) { //  ?
         ptl1.x = MOUSEMSG(&msg)->x;
         ptl1.y = MOUSEMSG(&msg)->y;
         WinMapWindowPoints(psld->hWnd,HWND_DESKTOP,&ptl1,1L);
//         now_x = ptl.x;
        if (ptl1.x > psld->beg_move_x) { // ࠢ
             psld->arm_pos = psld->beg_pos+(ptl1.x-psld->beg_move_x);
            if (psld->arm_pos > psld->shaft_width) psld->arm_pos = psld->shaft_width;
            }
        if (ptl1.x < psld->beg_move_x) { // 
             psld->arm_pos = psld->beg_pos-(psld->beg_move_x-ptl1.x);
            if (psld->arm_pos <= 0) psld->arm_pos = 1;
             }
//          psld->arm_pos=newpos;
        //    ⮬ ᪠
      WinInvalidateRect(psld->hWnd,0,FALSE);
     WinPostMsg(WinQueryWindow(psld->hWnd,QW_OWNER), WM_CONTROL,
      MPFROM2SHORT(psld->id,MSL_POSCHANGED),MPFROMSHORT(psld->arm_pos));
            }
         return (MRESULT)TRUE;
        }
    case WM_BUTTON1UP:
    case WM_BUTTON2UP:
//     case WM_BUTTON1MOTIONEND:
//     case WM_BUTTON2MOTIONEND: // ⠢   

        {
           mbp = FALSE;
           WinSetCapture(HWND_DESKTOP,NULLHANDLE);
           psld->drag=FALSE;
        WinPostMsg(WinQueryWindow(psld->hWnd,QW_OWNER), WM_CONTROL,
           MPFROM2SHORT(psld->id,MSL_MOTIONEND),MPFROMSHORT(psld->arm_pos));
           WinInvalidateRect(psld->hWnd,0,FALSE);
           return (MRESULT)TRUE;
            }
     case WM_CHAR: //  ⥫   
         {
            switch(CHARMSG(&msg)->vkey) {
              case VK_LEFT:
              case VK_UP:
                  {
                  if (psld->arm_pos == 1) return (MRESULT)TRUE; // ⨯  ⮢ 祭
                  psld->arm_pos--;
//        WinQueryWindowRect(hwnd,&rclb);
                  WinInvalidateRect(psld->hWnd,0,FALSE);
                  break;
//                  return (MRESULT)TRUE;
                  }
              case VK_RIGHT:
              case VK_DOWN:
                {
                 if (psld->arm_pos>psld->shaft_width) return (MRESULT)TRUE;
                 psld->arm_pos++;
//        WinQueryWindowRect(hwnd,&rclb);
                 WinInvalidateRect(psld->hWnd,0,FALSE);
                 break;
//                  return (MRESULT)TRUE;
                 }
              case VK_HOME: {
                  psld->arm_pos=1;
//        WinQueryWindowRect(hwnd,&rclb);
                  WinInvalidateRect(psld->hWnd,0,FALSE);
                  break;
                  //                  return (MRESULT)TRUE;
              }
              case VK_END: {
                 psld->arm_pos=psld->shaft_width;
//            WinQueryWindowRect(hwnd,&rclb);
                 WinInvalidateRect(psld->hWnd,0,FALSE);
                 break;
                 //                     return (MRESULT)TRUE;
              }
//            default: psld->oldSliderProc(hwnd, msg, mp1, mp2);
            } // switch vkey
       WinPostMsg(WinQueryWindow(psld->hWnd,QW_OWNER), WM_CONTROL,
          MPFROM2SHORT(psld->id,MSL_POSCHANGED),MPFROMSHORT(psld->arm_pos));
            break;
            } // case wm_char
//  case WM_ERASEBACKGROUND:
//      return (MRESULT) TRUE;
 case WM_TRANSLATEACCEL: // .. 祬,   ⮣ 뭠
      {
          return (MRESULT)WinDefWindowProc(hwnd, msg, mp1, mp2);
              // oldSliderProc(hwnd, msg, mp1, mp2);
       }
      //     default: psld->oldSliderProc(hwnd, msg, mp1, mp2);
  case WM_MOUSEENTER:
      {
            WinStartTimer(hab,psld->hWnd,BH_TIMER,1500L);
            break;
      }
  case WM_MOUSEEXIT:
      {
          if (psld->isHelp) {
              WinDestroyWindow(bhhwnd);
              psld->isHelp = FALSE;
          }
        WinStopTimer(hab,psld->hWnd,BH_TIMER);
            break;
      }
     } // switch
           return (MRESULT)TRUE;
    }

