/*
 * WarpVision GUI. Skin Load/Unload/Reload
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

void measure_all(void)
{
        measure_button(&skn->min_butt);
        measure_button(&skn->max_butt);
        measure_button(&skn->close_butt);
        measure_slider(&skn->video_sld);
        measure_slider(&skn->audio_sld);
        measure_button(&skn->play_butt);
        measure_button(&skn->stop_butt);
        measure_button(&skn->beg_butt);
        measure_button(&skn->fb_butt);
        measure_button(&skn->ff_butt);
        measure_button(&skn->end_butt);
        measure_button(&skn->sound_butt);
        measure_button(&skn->playlist_butt);
        measure_button(&skn->conf_butt);
        measure_button(&skn->eject_butt);
        measure_clock(&skn->dclock);
        reset_clock(&skn->dclock,TRUE); // set to clock
        measure_static(&skn->vidname);
        if (conf.isShowWindow) measure_show(hWndShow, &skn->def_backgr);
}

char *SkinFileDlg(HWND hwnd)
{

   FILEDLG pfdFiledlg;
   HWND hwndDlg;
   char *pszFullFile;

       memset(&pfdFiledlg, 0, sizeof(FILEDLG));

       pfdFiledlg.cbSize = sizeof(FILEDLG);
       pfdFiledlg.fl = FDS_CENTER | FDS_OPEN_DIALOG;
       pfdFiledlg.pszTitle= "Choose new skin file:";
       strcpy(pfdFiledlg.szFullFile,"*.skn");

       hwndDlg = WinFileDlg(HWND_DESKTOP, hwnd, &pfdFiledlg);

       pszFullFile=pfdFiledlg.szFullFile;
     return pszFullFile;
}


char *adddir(char *dir, char *file )
{
    char s[128];
    char *sl = "\\";
    strcpy(s,dir);
    if (strrchr(s, '\\') == 0) strcat(s,sl);
    strcat(s,file);
    return s;
 }

void splitdir(char *fpath, char *dir, char *file )
{
 char drive[_MAX_DRIVE];
 char sdir[_MAX_DIR];
 char fname[_MAX_FNAME];
 char ext[_MAX_EXT];

 strcpy(dir,""); // ⨬
  strcpy(file,""); // ⨬
 _splitpath(fpath, drive, sdir, fname, ext); // ࠧࠥ
 strcat(dir,drive); // ᮡࠥ
 strcat(dir,sdir);  //
 strcat(file,fname); // ᮡࠥ
 strcat(file,ext);  //

 }

void load_button(HPS hps,char *dir, PSKN_BUTT p, ULONG id)
{
    char bfile[128];

 p->id = id;
 strcpy(bfile, adddir(dir,p->fbutt_off));
 VidLoadBitmap(hps, bfile, &p->butt_off);
 strcpy(bfile, adddir(dir,p->fbutt_on));
 VidLoadBitmap(hps, bfile, &p->butt_on);
 strcpy(bfile, adddir(dir,p->fbutt_off1));
 VidLoadBitmap(hps, bfile, &p->butt_off1);
 strcpy(bfile, adddir(dir,p->fbutt_on1));
 VidLoadBitmap(hps, bfile, &p->butt_on1);
 strcpy(bfile, adddir(dir,p->fbutt_mouover));
 VidLoadBitmap(hps, bfile, &p->butt_mouover);
 strcpy(bfile, adddir(dir,p->fbutt_mouover1));
 VidLoadBitmap(hps, bfile, &p->butt_mouover1);
 strcpy(bfile, adddir(dir,p->fbutt_dis));
 VidLoadBitmap(hps, bfile, &p->butt_dis);
 if (p->help == "") p->isHelp=FALSE;
 bitmap_size(p->butt_off, &p->width, &p->heigth);
 p->bstate = MBS_DISABLED;
 p->dblpos = FALSE;
}

void unload_button(PSKN_BUTT p)
{
 GpiDeleteBitmap(p->butt_off);
 GpiDeleteBitmap(p->butt_on);
 GpiDeleteBitmap(p->butt_off1);
 GpiDeleteBitmap(p->butt_on1);
 GpiDeleteBitmap(p->butt_mouover);
 GpiDeleteBitmap(p->butt_mouover1);
 GpiDeleteBitmap(p->butt_dis);
}

void load_skin(HWND hwnd, char *dir1, char *fskin)
{
 HBITMAP bmp;
 char bfile[128];
 char skpath[CCHMAXPATH];
 char dir[CCHMAXPATH];
 HPS hps;
 PSKIN pskn;
 long sksize;
 ULONG rc;
 char titlebcolor[10];
 char titlefcolor[10];
 char listbcolor[10];
 char listfcolor[10];

 sksize = sizeof(SKIN);
 rc = DosAllocMem((PPVOID)&skn, sksize,PAG_COMMIT | PAG_READ | PAG_WRITE);
 pskn=skn;
#include "vars.inc" //  塞 ᨢ ६
 strcpy(skpath,adddir(dir1,fskin));
 strcpy(dir,dir1);
 if (LoadConfig(skpath,Vars) > 0)
 {   WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "Error loading skin. Choose new skin...",
      "Error", 0, MB_ICONHAND | MB_OK);

 strcpy(skpath,SkinFileDlg(hwnd));

 if (skpath == "" ) {
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab); }

 if (LoadConfig(skpath,Vars) > 0) // second try
 {   WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "Error loading skin. Bye.",
      "Error", 0, MB_ICONHAND | MB_OK);
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab); }
 splitdir(skpath,conf.skinpath,conf.skinfile);
 strcpy(dir,conf.skinpath);
 }
 hps=WinGetPS(hwnd);
// load background for control
 strcpy(bfile, adddir(dir,pskn->ctrl_backgr.fhbm));
 VidLoadBitmap(hps, bfile, &pskn->ctrl_backgr.hbm);
 bitmap_size(pskn->ctrl_backgr.hbm, &pskn->w, &pskn->h);

// load on focus background for control
 strcpy(bfile, adddir(dir,pskn->ctrl_backgr_on.fhbm));
 VidLoadBitmap(hps, bfile, &pskn->ctrl_backgr_on.hbm);
 bitmap_size(pskn->ctrl_backgr_on.hbm, &pskn->ctrl_backgr_on.width, &pskn->ctrl_backgr_on.heigth);

// load off focus background for control
 strcpy(bfile, adddir(dir,pskn->ctrl_backgr_off.fhbm));
 VidLoadBitmap(hps, bfile, &pskn->ctrl_backgr_off.hbm);

// load background for show window
 strcpy(bfile, adddir(dir,pskn->def_backgr.fhbm));
 VidLoadBitmap(hps, bfile, &pskn->def_backgr.hbm);
 bitmap_size(pskn->def_backgr.hbm, &pskn->def_backgr.width, &pskn->def_backgr.heigth);

// load title
 strcpy(bfile, adddir(dir,pskn->title_left.fhbm));
 VidLoadBitmap(hps, bfile, &pskn->title_left.hbm);
 bitmap_size(pskn->title_left.hbm, &pskn->title_left.width, &pskn->title_left.heigth);
// load focuse title
 strcpy(bfile, adddir(dir,pskn->title_left_on.fhbm));
 VidLoadBitmap(hps, bfile, &pskn->title_left_on.hbm);
 bitmap_size(pskn->title_left_on.hbm, &pskn->title_left_on.width, &pskn->title_left_on.heigth);

// load title background
 strcpy(bfile, adddir(dir,pskn->title_backgr.fhbm));
 VidLoadBitmap(hps, bfile, &pskn->title_backgr.hbm);
 bitmap_size(pskn->title_backgr.hbm, &pskn->title_backgr.width, &pskn->title_backgr.heigth);

 // load minimize button
load_button(hps,dir,&pskn->min_butt,BMIN);

// load maximize button
load_button(hps,dir,&pskn->max_butt,BMAX);

 // load close button
load_button(hps,dir,&pskn->close_butt,BCLOSE);
 pskn->close_butt.bstate = MBS_RELEASED;
 // load play button
 load_button(hps,dir,&pskn->play_butt,BPLAY);

 // load stop button
 load_button(hps,dir,&pskn->stop_butt,BSTOP);
  pskn->stop_butt.bstate = MBS_RELEASED;

 // load begin button
load_button(hps,dir,&pskn->beg_butt,BBEGIN);

// load fast back button
load_button(hps,dir,&pskn->fb_butt,BFBACK);

// load fast forward button
load_button(hps,dir,&pskn->ff_butt,BFFORW);

// load end button
load_button(hps,dir,&pskn->end_butt,BEND);

// load sound button
load_button(hps,dir,&pskn->sound_butt,BSOUND);

// load playlist button
load_button(hps,dir,&pskn->playlist_butt,BPLAYLIST);
 pskn->playlist_butt.bstate = MBS_RELEASED;
// load config button
load_button(hps,dir,&pskn->conf_butt,BCONFIG);
pskn->conf_butt.bstate = MBS_RELEASED;

// load eject button
load_button(hps,dir,&pskn->eject_butt,BEJECT);
 pskn->eject_butt.bstate = MBS_RELEASED;

 // load video position slider
 pskn->video_sld.id = SLVIDPOS;
 strcpy(bfile, adddir(dir,pskn->video_sld.fsld_arm));
 VidLoadBitmap(hps, bfile, &pskn->video_sld.sld_arm);
 strcpy(bfile, adddir(dir,pskn->video_sld.fsldarm_dis));
 VidLoadBitmap(hps, bfile, &pskn->video_sld.sldarm_dis);
 strcpy(bfile, adddir(dir,pskn->video_sld.fsldarm_sel));
 VidLoadBitmap(hps, bfile, &pskn->video_sld.sldarm_sel);
 strcpy(bfile, adddir(dir,pskn->video_sld.fsld_shaft));
 VidLoadBitmap(hps, bfile, &pskn->video_sld.sld_shaft);
 strcpy(bfile, adddir(dir,pskn->video_sld.fsld_backgr));
 VidLoadBitmap(hps, bfile, &pskn->video_sld.sld_backgr);
if (pskn->video_sld.help == "") pskn->video_sld.isHelp=FALSE;
 bitmap_size(pskn->video_sld.sld_backgr, &pskn->video_sld.width, &pskn->video_sld.heigth);
 bitmap_size(pskn->video_sld.sld_arm, &pskn->video_sld.arm_width, &pskn->video_sld.arm_heigth);
 bitmap_size(pskn->video_sld.sld_shaft, &pskn->video_sld.shaft_width, &pskn->video_sld.shaft_heigth);
// pskn->video_sld.drag=FALSE;

 // load audio volume slider
 pskn->audio_sld.id = SLSOUND;
 strcpy(bfile, adddir(dir,pskn->audio_sld.fsld_arm));
 VidLoadBitmap(hps, bfile, &pskn->audio_sld.sld_arm);
 strcpy(bfile, adddir(dir,pskn->audio_sld.fsldarm_dis));
 VidLoadBitmap(hps, bfile, &pskn->audio_sld.sldarm_dis);
 strcpy(bfile, adddir(dir,pskn->audio_sld.fsldarm_sel));
 VidLoadBitmap(hps, bfile, &pskn->audio_sld.sldarm_sel);
 strcpy(bfile, adddir(dir,pskn->audio_sld.fsld_shaft));
 VidLoadBitmap(hps, bfile, &pskn->audio_sld.sld_shaft);
 strcpy(bfile, adddir(dir,pskn->audio_sld.fsld_backgr));
 VidLoadBitmap(hps, bfile, &pskn->audio_sld.sld_backgr);
 if (pskn->audio_sld.help == "") pskn->audio_sld.isHelp=FALSE;
 bitmap_size(pskn->audio_sld.sld_backgr, &pskn->audio_sld.width, &pskn->audio_sld.heigth);
 bitmap_size(pskn->audio_sld.sld_arm, &pskn->audio_sld.arm_width, &pskn->audio_sld.arm_heigth);
 bitmap_size(pskn->audio_sld.sld_shaft, &pskn->audio_sld.shaft_width, &pskn->audio_sld.shaft_heigth);

 // load name skin
 pskn->vidname.id = VIDNAME;
 strcpy(bfile, adddir(dir,pskn->vidname.fbackgr));
 VidLoadBitmap(hps, bfile, &pskn->vidname.backgr);
 bitmap_size(pskn->vidname.backgr, &pskn->vidname.width, &pskn->vidname.heigth);
 pskn->vidname.pos = 0;
 pskn->vidname.fat.usRecordLength = sizeof(FATTRS);
 pskn->vidname.fat.fsSelection = 0;
 pskn->vidname.fat.lMatch = 0L;
 pskn->vidname.fat.idRegistry = 0;
 pskn->vidname.fat.usCodePage = 866;
// pskn->vidname.fat.lMaxBaselineExt = 9L;
 pskn->vidname.fat.lAveCharWidth = pskn->vidname.fat.lMaxBaselineExt;
 pskn->vidname.fat.fsType = 0;
 pskn->vidname.fat.fsFontUse = FATTR_FONTUSE_NOMIX | FATTR_FONTUSE_OUTLINE;

// pskn->vidname.step = 2;
 pskn->vidname.tColor = strtoul(tColStr, &tcslast,16);

 pskn->playlist.TitleBColor = strtoul(titlebcolor, &tcslast,16);
 pskn->playlist.TitleFColor = strtoul(titlefcolor, &tcslast,16);
 pskn->playlist.ListBColor = strtoul(listbcolor, &tcslast,16);
 pskn->playlist.ListFColor = strtoul(listfcolor, &tcslast,16);

// strcpy(pskn->vidname.vidname,"ணࠬ Video/2. 樮 ०.砭   뫠  vlad@usib.com.ua...Click me :-) Samm!!!   ᪨ ??? ");
 //WinSetPresParam(hwnd, PP_FONTNAMESIZE,(ULONG)strlen(pskn->vidname.fontname) + 1, (PVOID)pskn->vidname.fontname);

 // load clock skin
 pskn->vidname.id = DCLOCK;
 strcpy(bfile, adddir(dir,pskn->dclock.fbackgr));
 VidLoadBitmap(hps, bfile, &pskn->dclock.backgr);
 strcpy(bfile, adddir(dir,pskn->dclock.fdigits));
 VidLoadBitmap(hps, bfile, &pskn->dclock.digits);
 bitmap_size(pskn->dclock.backgr, &pskn->dclock.width, &pskn->dclock.heigth);
 WinReleasePS(hps);

 return ;

} //load_skin


void unload_skin(PSKIN pskn) {
 GpiDeleteBitmap(pskn->ctrl_backgr.hbm);
 GpiDeleteBitmap(pskn->ctrl_backgr_on.hbm);
 GpiDeleteBitmap(pskn->def_backgr.hbm);
 GpiDeleteBitmap(pskn->title_left.hbm);
 GpiDeleteBitmap(pskn->title_left_on.hbm);
 GpiDeleteBitmap(pskn->title_backgr.hbm);
 WinDestroyWindow(pskn->min_butt.hWnd);
 WinDestroyWindow(pskn->max_butt.hWnd);
 WinDestroyWindow(pskn->close_butt.hWnd);
 WinDestroyWindow(pskn->play_butt.hWnd);
 WinDestroyWindow(pskn->stop_butt.hWnd);
 WinDestroyWindow(pskn->beg_butt.hWnd);
 WinDestroyWindow(pskn->fb_butt.hWnd);
 WinDestroyWindow(pskn->ff_butt.hWnd);
 WinDestroyWindow(pskn->end_butt.hWnd);
 WinDestroyWindow(pskn->sound_butt.hWnd);
 WinDestroyWindow(pskn->playlist_butt.hWnd);
 WinDestroyWindow(pskn->conf_butt.hWnd);
 WinDestroyWindow(pskn->eject_butt.hWnd);
 WinDestroyWindow(skn->video_sld.hWnd);
 WinDestroyWindow(skn->audio_sld.hWnd);
 WinDestroyWindow(skn->vidname.hWnd);
 WinDestroyWindow(skn->dclock.hWnd);
 WinDestroyWindow(hWndShow);
 DosFreeMem(pskn);
 return;
}
void init_skin(HWND hWnd, PSKIN p)
{
    SIZEL               sizl = { 0, 0 };

     add_slider(hWnd,&p->video_sld);
     add_slider(hWnd,&p->audio_sld);
     add_button(hWnd,&p->min_butt);
     add_button(hWnd,&p->max_butt);
     add_button(hWnd,&p->close_butt);
     add_button(hWnd,&p->play_butt);
     add_button(hWnd,&p->stop_butt);
     add_button(hWnd,&p->beg_butt);
     add_button(hWnd,&p->fb_butt);
     add_button(hWnd,&p->ff_butt);
     add_button(hWnd,&p->end_butt);
     add_button(hWnd,&p->sound_butt);
     add_button(hWnd,&p->playlist_butt);
     add_button(hWnd,&p->conf_butt);
//     add_button(hWnd,&p->eject_butt);
     add_clock(hWnd,&p->dclock);
     add_static(hWnd,&p->vidname);
     if (conf.isShowWindow) add_show(); // add show if it allowed
     if (p->dclock.hWnd && p->dclock.isClock) WinSendMsg(p->dclock.hWnd, WM_COMMAND, MPFROMSHORT(MCL_SETCLOCKALONE), 0);
     // set loose focus bmp
        p->hdc = DevOpenDC(hab,OD_MEMORY,"*",0L,NULL,NULLHANDLE);
        p->memdc = GpiCreatePS(hab,p->hdc,&sizl,
                            PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC );
        GpiSetBitmap(p->memdc,p->ctrl_backgr.hbm);
        // set get focus bmp
        p->hdc_on = DevOpenDC(hab,OD_MEMORY,"*",0L,NULL,NULLHANDLE);
        p->memdc_on = GpiCreatePS(hab,p->hdc_on,&sizl,
                            PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC );
        GpiSetBitmap(p->memdc_on,p->ctrl_backgr_on.hbm);

        p->apts[2].x = p->apts[2].y = 0;
        p->apts[0].x = p->apts[0].y = 0;
        p->apts[1].x = p->w;
        p->apts[1].y = p->h;;
        set_slider_range(&skn->audio_sld,0,100); // set the audio range in %%
        set_volume(conf.volume); // sets audio volume
        set_button_state(&skn->stop_butt, MBS_RELEASED,TRUE); // disabling stop
//        set_slider_volume(&skn->audio_sld, conf.volume); // set volume from the driver
}

void draw_bitmap(HWND hwnd, HPS hps, HBITMAP bmp, USHORT x, USHORT y)
{
    HBITMAP hBm;
    HBITMAP oldbmp;
    DEVOPENSTRUC dop = { 0L, "DISPLAY", NULL, 0L,0L, 0L, 0L, 0L, 0L };
    POINTL              pts[3] = {0,0,0,0,0,0};
    HPS                 memdc;
    HDC                 hdc;
    HAB                 hab;
    SIZEL               sizl = { 0, 0 };

    hab = WinQueryAnchorBlock(hwnd );
    hdc = DevOpenDC( hab, OD_MEMORY, "*", 5L,(PDEVOPENDATA)&dop, NULLHANDLE );
    memdc = GpiCreatePS( hab, hdc, &sizl, PU_PELS | GPIA_ASSOC );
    pts[1].x = x;
    pts[1].y = y;
    GpiSetBitmap( memdc, bmp );
    GpiBitBlt( hps, memdc, 3L, pts, ROP_SRCCOPY, BBO_IGNORE );
    GpiSetBitmap( memdc, NULLHANDLE );
    GpiDestroyPS( memdc );
    DevCloseDC( hdc );
   return;
}

void reload_skin(HWND hwnd)
{
    char newskinpath[255];
    strcpy(newskinpath,"");
    strcpy(newskinpath, SkinFileDlg(hwnd));
    if (newskinpath == "") return;
    splitdir(newskinpath,conf.skinpath,conf.skinfile);
    save_ini();
    WinShowWindow(hWndFrame,FALSE);
    if (conf.isShowWindow) WinShowWindow(hWndShow,FALSE);
    GpiSetBitmap(skn->memdc,NULLHANDLE);
    GpiDestroyPS(skn->memdc);
    DevCloseDC(skn->hdc);
    unload_skin(skn);
    load_skin(hwnd,conf.skinpath,conf.skinfile);
    load_ini();
    init_skin(hwnd,skn);
    measure_all();
      if (conf.ctlx == 9999 || conf.ctly == 9999) {
     WinQueryTaskSizePos(hab,0,&winpos);
     WinSetWindowPos(hWndFrame,HWND_TOP,winpos.x,winpos.y,skn->w,skn->h, SWP_ACTIVATE | SWP_MOVE | SWP_SHOW | SWP_SIZE);
  } else
  {
      WinSetWindowPos(hWndFrame,HWND_TOP,conf.ctlx,conf.ctly,skn->w,skn->h, SWP_ACTIVATE | SWP_MOVE | SWP_SHOW | SWP_SIZE);
   }
//    measure_all();
    WinShowWindow(hWndFrame,TRUE);
    if (conf.isShowWindow) WinShowWindow(hWndShow,TRUE);
    WinInvalidateRect(hWndFrame,NULLHANDLE,TRUE);
    if (conf.isShowWindow) WinInvalidateRect(hWndShow,NULLHANDLE,TRUE);
 }
