/*
 * WarpVision GUI. Movie window workers
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

RECTL oldrect = {9999,9999,9999,9999}; // old rectangle
SWP oldswp = {9999,9999,9999,9999};
SWP swpFrame;

BOOL add_show()
{
    BOOL fRc;
  fRc = WinRegisterClass (hab, szShowWndClass,(PFNWP)ShowWndProc, CS_SIZEREDRAW | CS_MOVENOTIFY,  sizeof (void *));

  if(fRc == FALSE)
  {
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "訡  ॣ樨   뢮",
      "訡", 0, MB_ICONHAND | MB_OK);

    // । ਩ 襭 ਫ
    // 㭨⮦ ᮧ ࠭ । ᮮ饭 
    // 뢠 㭪 WinTerminate
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);

    return FALSE;

  }
  hWndShow = WinCreateStdWindow (HWND_DESKTOP,stShowWin,
    &flShowWinFlags, szShowWndClass, szShowAppTitle,
                                 0, 0, ID_APP_SHOWWND, &hWndShowClient);

  if(hWndShow == NULLHANDLE)
  {
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "訡  ᮧ  ",
      "訡", 0, MB_ICONHAND | MB_OK);

    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);

    return FALSE;
  }
  WinPostMsg(hWndShow,WM_SETBORDERSIZE,MPFROMSHORT(2),MPFROMSHORT(2));
  tb=WinWindowFromID(hWndShow,(USHORT) FID_TITLEBAR);
  oldTBProc = WinSubclassWindow(tb, (PFNWP)TBWndProc);
  oldFRProc = WinSubclassWindow(hWndShow, (PFNWP)FRWndProc);
  if (!hWndShow) return FALSE;
//  WinQueryWindowPos(tb, &tbswp);
//  WinSetWindowPos(tb, HWND_TOP,tbswp.x,tbswp.y,tbswp.cx,5,SWP_SIZE);
  return TRUE;
}

void set_ontop(HWND hw, BOOL ontop)
{
  ULONG showst;
   showst = WinQueryWindowULong(hw, QWL_STYLE);
   if (ontop) showst = showst | WS_TOPMOST;
   else
      showst = showst & ~WS_TOPMOST;
   WinSetWindowULong(hWndShow, QWL_STYLE,showst);
 }

void measure_show(HWND hwnd,PHBMPOS b)
{
    if (conf.movx == 9999 || conf.movx == 9999 ||
        conf.movcx ==0 || conf.movcy == 0)
        WinSetWindowPos (hwnd, HWND_TOP,b->x, b->y, b->width, b->heigth, SWP_SIZE | SWP_MOVE | SWP_ACTIVATE |SWP_SHOW);
    else
        WinSetWindowPos (hwnd, HWND_TOP,conf.movx, conf.movy, conf.movcx, conf.movcy, SWP_SIZE | SWP_MOVE | SWP_ACTIVATE |SWP_SHOW);
 return;
    }

MRESULT APIENTRY TBWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CHAR szMsg[100];
   switch(msg)
   {

   case WM_PAINT:
       {
           HPS hps;
           RECTL rcl;
           rcl.xLeft=0;
           rcl.yBottom=0;
           rcl.yTop=tbswp.cy;
           rcl.xRight=tbswp.cx;
           hps=WinBeginPaint(hwnd,NULLHANDLE,NULL);
           WinDrawBitmap (hps, skn->title_backgr.hbm, NULL, (PPOINTL)&rcl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_STRETCH) ;
           rcl.yTop=tbswp.cy;
               // skn->title_left.heigth;
           rcl.xRight=skn->title_left.width;
           if (showInFocus)
             WinDrawBitmap (hps, skn->title_left_on.hbm, NULL, (PPOINTL)&rcl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_STRETCH) ;
           else
             WinDrawBitmap (hps, skn->title_left.hbm, NULL, (PPOINTL)&rcl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_STRETCH) ;
           WinEndPaint(hps);
           return (MRESULT)FALSE;
          // break;
       }
   case TBM_SETHILITE:
       {
//           WinInvalidateRect(hwnd,NULLHANDLE,TRUE);
           return (MRESULT)FALSE;
       }
//       oldTBProc(hwnd, msg, mp1, mp2);
   }
  return (MRESULT)oldTBProc(hwnd, msg, mp1, mp2);
}

MRESULT APIENTRY FRWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CHAR szMsg[100];
   switch(msg)
   {
       /*
      case WM_QUERYTRACKINFO:
      {
         PTRACKINFO ptInfo;
         ULONG itemCount;
         BOOL trc = TRUE;
         RECTL newrcl;
         USHORT fs;
              oldFRProc(hwnd, msg, mp1,mp2);
              //         WinQueryWindowPos( hwnd, &swpFrame );
              fs = SHORT1FROMMP(mp1);
//              printf("flag %u",fs);
//              fflush(stdout);
              if (Playing && !di.fFullScreen) // has no aspect while not playing
                  if (fs < TF_MOVE) di.recalc = TRUE;
              return (MRESULT)TRUE;

              ptInfo = (PTRACKINFO)(mp2);
              newrcl = ptInfo->rclTrack;
         if (oldrect.xLeft == 9999) {
             oldrect = newrcl;
//             printf("first time \n");
         }
//         ptInfo->ptlMinTrackSize.y = 100;
         //         ptInfo->ptlMinTrackSize.x = 200;
         if (Playing && !di.fFullScreen) // has no aspect while not playing
         {
             LONG ch_x = newrcl.xRight - newrcl.xLeft;
             LONG ch_y = newrcl.yTop - newrcl.yBottom;
             LONG old_ch_x = oldrect.xRight - oldrect.xLeft;
             LONG old_ch_y = oldrect.yTop - oldrect.yBottom;
             oldrect = newrcl;
//             printf("new: %i x %i, old: %i x %i\n",ch_x,ch_y,old_ch_x,old_ch_y);
//             fflush(stdout);
             float koef;
             LONG y_inc,x_inc;
           if ((ch_x != old_ch_x) || (ch_y != old_ch_y)) // size changed
           {
               if (labs(ch_x - old_ch_x) > labs(ch_y - old_ch_y)) // X more increased
               {
               koef = (float)ch_x/(float)di.BufferW;
               y_inc = di.BufferH*koef;
               newrcl.yTop = newrcl.yBottom + y_inc;
//               di.recalcY=TRUE;
               } else // Y more increased
               {
               koef = (float)ch_y/(float)di.BufferH;
               x_inc = di.BufferW*koef;
               newrcl.xRight = newrcl.xLeft + x_inc;
//               di.recalcX=TRUE;
               }
               di.recalc=TRUE; // need to recalculate frame size
//               oldrect = newrcl;
               } // size changed
         } // if playing
//         oldrect = newrcl;
return (MRESULT)trc;

} // case

*/
   case WM_FORMATFRAME :
               {
               USHORT usClient = 0,
                      usTitle   = 0;
         USHORT itemCount = SHORT1FROMMR( oldFRProc( hwnd, msg,mp1,mp2));
               PSWP pSWP = (PSWP)PVOIDFROMMP(mp1);
               while (pSWP[usClient].hwnd != WinWindowFromID(hWndShow,FID_CLIENT))
                    ++usClient;
               while (pSWP[usTitle].hwnd != WinWindowFromID(hWndShow,FID_TITLEBAR))
                    ++usTitle;

               pSWP[itemCount].fl = SWP_SIZE | SWP_MOVE;      // SWP_SIZE style flag
               //               pSWP[itemCount].hwndInsertBehind = HWND_TOP ;  // On which window (ONTOP)
               // adjust client window size and title bar
               int tb_diff = pSWP[usTitle].cy - skn->title_left.heigth;
               pSWP[usClient].cy = pSWP[usClient].cy + tb_diff;
               pSWP[usTitle].cy = skn->title_left.heigth;
               pSWP[usTitle].y = pSWP[usTitle].y + tb_diff;
               tbswp.x = pSWP[usTitle].x;
               tbswp.y = pSWP[usTitle].y;
               tbswp.cx = pSWP[usTitle].cx;
               tbswp.cy = pSWP[usTitle].cy;
               // calculate new dive window
               // return total count of frame controls
               return( MRFROMSHORT(itemCount ));
               }
   case WM_WINDOWPOSCHANGED:
       {
           PSWP pswp;
           SWP swp;
           RECTL clr;
           ULONG h,w;
           ULONG koef;
           POINTL pointl;
           MRESULT mr;
           RECTL  rcl;

           mr = oldFRProc(hwnd, msg, mp1, mp2);
//           pswp = (PSWP)PVOIDFROMMP(mp1);
           // calculate client coordinates
           WinQueryWindowPos(hWndShowClient, &swp);
           rcl.xLeft = swp.x;
           rcl.yBottom = swp.y;
           rcl.xRight = swp.x+swp.cx;
           rcl.yTop = swp.y+swp.cy;

           if (di.BufferW <=0) di.BufferW = 1;
           if (di.BufferH <=0) di.BufferH = 1;
           if (WindowWidth <=0) WindowWidth = 1;
           if (WindowHeight <=0) WindowHeight = 1;

           if (conf.KeepAspect)
           {
             switch (conf.ForceAspect)
              {
              case ASPECT_FORCE_169:
              w = swp.cx;
              h = w / (16.0f/9.0f);
              break;
              case ASPECT_FORCE_43:
              w = swp.cx;
              h = w / (4.0f/3.0f);
              break;
              case ASPECT_USER_DEFINED:
               koef = (swp.cx << 16)/di.BufferW;
               h = (di.BufferH*koef) >>16;
               w = swp.cx;
              break;
              }
               pointl.y = swp.y+ (swp.cy/2 - h/2);
               pointl.x = swp.x+ (swp.cx/2 - w/2);
               r.xLeft=swp.x-2;
               r.yBottom=swp.y-2;
               r.xRight=swp.cx;
               r.yTop=pointl.y-1;
               r1.xLeft=swp.x-2;
               r1.yBottom=pointl.y+h-2;
               r1.xRight=swp.cx;
               r1.yTop=swp.cy;
                if (h>swp.cy)
                {
                  switch (conf.ForceAspect)
                   {
                    case ASPECT_FORCE_169:
                    h = swp.cy;
                    w = h * (16.0f/9.0f);
                    break;
                    case ASPECT_FORCE_43:
                    h = swp.cy;
                    w = h * (4.0f/3.0f);
                    break;
                   case ASPECT_USER_DEFINED:
                    koef = (swp.cy << 16)/di.BufferH;
                    h = swp.cy;
                    w = (di.BufferW*koef) >> 16;
                    break;
                   }
                  pointl.y = swp.y+ (swp.cy/2 - h/2);
                  pointl.x = swp.x+ (swp.cx/2 - w/2);
                  r.xRight=pointl.x-1;
                  r.yTop=swp.cy;
                  r1.xLeft=pointl.x+w-2;
                  r1.yBottom=swp.y-2;
                  r1.xRight=swp.cx;
                  r1.yTop=swp.cy;
                 }
           } // if KeepAspect
           else
           {
                h = swp.cy;
                w = swp.cx;
                pointl.y = swp.y;
                pointl.x = swp.x;
            }
                WinMapWindowPoints (hWndShow, HWND_DESKTOP, &pointl, 1);
                // fill structure for blitter setup
                di.rect.x = pointl.x;
                di.rect.y = pointl.y;
                di.rect.cx = w;
                di.rect.cy = h;
//                printf("x-y: %i-%i,cx-cy: %i-%i\n",pswp->x,pswp->y,pswp->cx,pswp->cy);
//                printf("x-y: %i-%i,cx-cy: %i-%i\n",di.rect.x,di.rect.y,di.rect.cx,di.rect.cy);
                //                fflush(stdout);
        if (!conf.UseHWVIDEO)
        {
            SetupBlitter(NULL);
        }
        else
        {
           VideoSetup.ulLength=sizeof(HWVIDEOSETUP);
           VideoSetup.rctlDstRect.xLeft=di.rect.x;
           VideoSetup.rctlDstRect.yBottom=di.rect.y;
           VideoSetup.rctlDstRect.yTop=di.rect.y + di.rect.cy;
           VideoSetup.rctlDstRect.xRight=di.rect.x + di.rect.cx;
           VideoSetup.szlSrcSize.cx=WindowWidth;
           VideoSetup.szlSrcSize.cy=WindowHeight;
           VideoSetup.ulSrcPitch=(VideoSetup.szlSrcSize.cx*2+VideoCaps.ulScanAlign)&~VideoCaps.ulScanAlign;
           VideoSetup.fccColor=FOURCC_Y422;
           VideoSetup.ulKeyColor=TRANSPERENT;
           HWVIDEOSetup(&VideoSetup);
          if (Playing && HWVIDEOPresent)
           {
           LONG  alTable[16];
           HPS hps = WinGetPS(hWndShowClient);
           GpiQueryLogColorTable(hps,0,0,16,alTable);
           alTable[10]=TRANSPERENT;
           GpiCreateLogColorTable(hps,0,LCOLF_CONSECRGB,0,16,alTable);
           WinFillRect( hps, &rcl, 10);
           WinFillRect(hps, &r, CLR_BLACK);
           WinFillRect(hps, &r1, CLR_BLACK);
           WinReleasePS(hps);
           }
        } //  if (conf.UseHWVIDEO)
           return mr;
       }
      } // switch
  return (MRESULT)oldFRProc(hwnd, msg, mp1, mp2);
}

MRESULT APIENTRY ShowWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    CHAR szMsg[100];
    SWP swp;
    HPS hps;

   switch(msg)
   {
   case WM_VRNDISABLED:
       {
         di.FailedCount = 0;
         DiveSetupBlitter ( di.hDive, 0 );
         di.oldDirtyRect.xLeft = -9999;
         return 0;
       }
   case WM_VRNENABLED:
       {

/*
      if (WinQueryWindowPos (hWndShowClient, &swp)
       && ((di.WindowW != swp.cx) || (di.WindowH != swp.cy)))
      {
        WinQueryWindowPos (hWndShowClient, &swp);
        di.DirtyRect.xRight = di.WindowW = swp.cx;
        di.DirtyRect.yTop = di.WindowH = swp.cy;
        di.DirtyRect.xLeft = 0;
        di.DirtyRect.yBottom = 0;
        di.FailedCount = 1;
        } // endif
*/
      hps = WinGetPS (hWndShowClient);

//         SetupBlitter ();
      if (di.FailedCount > 0)
          bufSwitch (di.VisibleBuffer);
         SetupBlitter (hps);
//      if (DiveBlitImage (di.hDive, di.hBuffer[di.VisibleBuffer], DIVE_BUFFER_GRAPHICS_PLANE) != DIVE_SUCCESS)
//          di.FailedCount++;
      WinReleasePS(hps);

      return 0;
       }
   case WM_ERASEBACKGROUND:
       {
//           printf("kva\n");
//           fflush(stdout);
           return (MRESULT)FALSE;
       }
   case WM_SETFOCUS:
       {
           if (SHORT1FROMMP(mp2))
               showInFocus = TRUE;
//               printf("I have focus! \n");
           else
           {
               if (Playing && conf.IsOnTop)
               {
//           WinSetWindowPos (HWND_DESKTOP, hwnd,
//                            0, 0, 0, 0, SWP_ZORDER | SWP_ACTIVATE);

//                   WinSetFocus(HWND_DESKTOP,hWndShow);
//                   WinSetWindowPos(hWndShow, HWND_TOP,-1, -1, -1, -1, SWP_ACTIVATE |SWP_SHOW);
                }
               else
               if (!WinIsChild((HWND)LONGFROMMP(mp1),hwnd))
                           showInFocus = FALSE;
//               printf("I loose focus! \n");
           }
           //           fflush(stdout);
           WinInvalidateRect(tb,NULLHANDLE,TRUE);
           return(WinDefWindowProc(hwnd, msg, mp1, mp2));
           }

   case WM_CHAR:
       {
         int kbch;
           if (!Playing) break; // do nothing
         if ((CHARMSG(&msg)->fs) & KC_SCANCODE)
          {
          kbch=CHARMSG(&msg)->scancode;
//       printf("key code=%i\n",kbch);fflush(stdout);
          switch(kbch)
             {
             case 99: // Left
                 {
                   if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                   if (!Seeking) {
                       Seeking=TRUE;
                       dem_flag = 0; // absolute seek
                       new_dem_pos=-10; }
                      return MRESULT(TRUE);
                 } // case left
             case 100: // Right
                 {
                   if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                   if (!Seeking) {
                       Seeking=TRUE;
                       dem_flag = 0; // absolute seek
                       new_dem_pos=10; }
                      return MRESULT(TRUE);
                  } // case Right
             case 97: // Up
                 {
                   if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                   if (!Seeking) {
                       Seeking=TRUE;
                       dem_flag = 0; // absolute seek
                       new_dem_pos=60; }
                      return MRESULT(TRUE);
                 } // case UP
             case 102: // Down
                 {
                   if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                   if (!Seeking) {
                       Seeking=TRUE;
                       dem_flag = 0; // absolute seek
                       new_dem_pos=-60; }
                      return MRESULT(TRUE);
                  } // casedown
             case 98: // PgUp
                 {
                   if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                   if (!Seeking) {
                       Seeking=TRUE;
                       dem_flag = 0; // absolute seek
                       new_dem_pos=600; }
                      return MRESULT(TRUE);
                 } // case left
             case 103: //  PgDown
                 {
                   if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                   if (!Seeking) {
                       Seeking=TRUE;
                       dem_flag = 0; // absolute seek
                       new_dem_pos=-600; }
                      return MRESULT(TRUE);
                 } // case PgDown
             case 25: // 'P'
             case 57: // Space
                 {
            if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                  if (!Pause)
                   {
                       pause_play();
                     }
                   else resume_play();
                   return MRESULT(TRUE);
                 }
             case 51: // '<' key
                 {
                      if (conf.Bright > -128)
                      {
                          conf.Bright--;
                          yuv2rgb_set_gamma(conf.Bright);
                      }
                     return MRESULT(TRUE);
                 }
             case 52: // '>' key
                 {
                      if (conf.Bright < 128)
                      {
                          conf.Bright++;
                          yuv2rgb_set_gamma(conf.Bright);
                      }
                     return MRESULT(TRUE);
                 }
               case 33: // 'F' key
               case 28: // Enter key
                   {
                if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                    if (di.fFullScreen)
                      fullScreen(FALSE);
                     else fullScreen(TRUE);
                     return MRESULT(TRUE);
                 }
             case 1: // Esc key
                 {
                     if (!((CHARMSG(&msg)->fs) & KC_KEYUP)) return MRESULT(TRUE);
                    if (di.fFullScreen)
                      fullScreen(FALSE);
//                     Shutdown = TRUE;
                     return MRESULT(TRUE);
                   }
             case 12: // '-' key
                   {
                     SyncCorrection -= 0.1f;
                     return MRESULT(TRUE);
                   }
             case 13: // '+' key
                   {
                     SyncCorrection += 0.1f;
                     return MRESULT(TRUE);
                   }
             case 78: // Gray '+' key
                 {
                      if (conf.volume < 100)
                      {
                         conf.volume++;
                         set_volume(conf.volume);
                      }
                     return MRESULT(TRUE);
                   }
             case 74: // Gray '-' key
                 {
                    if (conf.volume > 1)
                      {
                        conf.volume--;
                        set_volume(conf.volume);
                      }
                     return MRESULT(TRUE);
                   }
               } // switch kbch
              } // if
         break;
      } // case wm_char

   case WM_BUTTON1MOTIONSTART: // drag window
         {
             mbp = TRUE;
             if (di.fFullScreen) break; // dont track when fullscreen
         return WinSendMsg(WinQueryWindow(hwnd,QW_PARENT), WM_TRACKFRAME, MPFROMSHORT(TF_MOVE), MPVOID);
         }
   case WM_BUTTON1MOTIONEND:
         {
             mbp = FALSE;
             break;
         }
   case WM_BUTTON1UP:
   case WM_BUTTON2UP:
         {
             mbp = FALSE;
             break;
         }

   case WM_BUTTON1DOWN:
   case WM_BUTTON2DOWN:
         {
             mbp = TRUE;
             break;
         }
//   case WM_MOUSEMOVE:
//       {
//           if (di.fFullScreen)
//           {
//            WinSetPointer (HWND_DESKTOP, di.fMouseVisible ? WinQuerySysPointer (HWND_DESKTOP,
//               di.MouseCursorID, FALSE) : NULL);
//            WinSetPointer (HWND_DESKTOP, NULL);
//           }
//        break;
//       }
   case WM_BUTTON2DBLCLK:
       {
           if (Playing) {
               if (di.fFullScreen)
                   fullScreen(FALSE);
               else fullScreen(TRUE);
           }
           return (MRESULT)TRUE;
       }

   case WM_PAINT:
       {

       RECTL ptl;
       LONG  alTable[16];

       if (!Playing) {
       ptl.xLeft=0;
       ptl.yBottom=0;
       SWP swp;
       
       WinQueryWindowPos(hwnd, &swp);
       ptl.xRight=swp.cx;
       ptl.yTop=swp.cy;

        hps=WinBeginPaint(hwnd, NULLHANDLE,NULL);
           WinDrawBitmap (hps, skn->def_backgr.hbm, NULL, (PPOINTL)&ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_STRETCH) ;
           WinEndPaint(hps);
       } else {
           hps = WinBeginPaint (hWndShowClient, NULLHANDLE, NULL);
     //塞  梥⮬,  ᫥⢨ 㤥 ஧祭  ૥.
//           GpiQueryLogColorTable(hps,0,0,16,alTable);
//           alTable[10]=TRANSPERENT;
//           GpiCreateLogColorTable(hps,0,LCOLF_CONSECRGB,0,16,alTable);
//           WinFillRect( hps, &ptl, 10);
           //           SetupBlitter(hps);
           if (conf.KeepAspect)
           {
           WinFillRect(hps, &r, CLR_BLACK);
           WinFillRect(hps, &r1, CLR_BLACK);
           }
          WinEndPaint (hps);
//      di.FrameCount++;
      return (MRESULT)FALSE;
//            break;
      }

        return (MRESULT)FALSE;
       }
   default:
    return WinDefWindowProc(hwnd, msg, mp1, mp2);
   }
   
   return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

void fullScreen(BOOL st)
{
   if (di.fFullScreen) // already in full screen
   {
       if (st) return; // nothing to do
       di.fFullScreen=FALSE;
       WinShowPointer(HWND_DESKTOP,TRUE);
//       MouseVisible(TRUE);
      WinSetWindowPos (hWndShow, HWND_TOP, di.swpFullScreen.x, di.swpFullScreen.y,
                     di.swpFullScreen.cx, di.swpFullScreen.cy, SWP_SHOW | SWP_SIZE | SWP_ACTIVATE | SWP_MOVE);
      set_button_state(&skn->max_butt, MBS_RELEASED,TRUE); //
//      di.fFullScreen=FALSE;
      if (!conf.UseHWVIDEO && !HWVIDEOPresent) SetupBlitter (NULL);
    }
    else // in windowed state
    {
        if (!st) return; // we already in window
        WinShowPointer(HWND_DESKTOP,FALSE);
//         MouseVisible(FALSE);
         set_button_state(&skn->max_butt, MBS_DISABLED,TRUE); //
         WinQueryWindowPos (hWndShow, &di.swpFullScreen);
          // calculate new frame size
          RECTL frr;
          frr.xLeft=0;
          frr.yBottom=0;
          frr.xRight=di.ScreenW;
          frr.yTop=di.ScreenH;
          WinCalcFrameRect(hWndShow,&frr,FALSE);
          di.fFullScreen=TRUE;
          WinSetWindowPos (hWndShow, HWND_TOP, frr.xLeft, frr.yBottom,
                           frr.xRight-frr.xLeft, frr.yTop-frr.yBottom, SWP_SHOW | SWP_SIZE | SWP_ACTIVATE | SWP_MOVE);

          //          di.fFullScreen=TRUE;
          if (!conf.UseHWVIDEO && !HWVIDEOPresent) SetupBlitter (NULL);
    }
 }

HBITMAP text2bmp(char *text,HWND hWnd, ULONG Col, PFATTRS fat)
{
 SHORT cx,cy,cxv,cyv;
 POINTL aptl[TXTBOX_COUNT];
 BITMAPINFOHEADER2 bmp;
 DEVOPENSTRUC dop = {NULL, "DISPLAY", NULL, NULL, NULL, NULL,
                    NULL, NULL, NULL};
 SIZEL sizl = { 0,0};
 LONG cPlanes;
 LONG cBitCount;
 RECTL rclb,rcl;
 POINTL ptl;
 LONG alTable[16];
 FONTMETRICS fm;
 SIZEF sizf;
 HAB hab1;
 HDC hdc1,hdct;
 HPS hps1,textps;
 HBITMAP hbm,hbmtext;

     hab1 = WinQueryAnchorBlock(hWnd);
//     hdc1 = DevOpenDC(hab1,OD_MEMORY,"*",2L,(PDEVOPENDATA)&dop,NULLHANDLE);
     hps1 = GpiCreatePS(hab1,hdc1,&sizl,PU_PELS | GPIA_ASSOC);
     hdct = DevOpenDC(hab1,OD_MEMORY,"*",2L,(PDEVOPENDATA)&dop,NULLHANDLE);
     DevQueryCaps(hdct, CAPS_COLOR_PLANES  , 1L, &cPlanes);
     DevQueryCaps(hdct, CAPS_COLOR_BITCOUNT, 1L, &cBitCount);


  textps = GpiCreatePS( hab1, hdct, &sizl, PU_PELS | GPIA_ASSOC );

  GpiCreateLogFont(textps, NULL, 1L, fat);
  GpiSetCharSet (textps, 1L);
  GpiQueryTextBox (textps, strlen(text), text, 4L, aptl) ;
                 cx = (SHORT) (aptl [TXTBOX_TOPRIGHT].x -
                                     aptl [TXTBOX_TOPLEFT].x) ;
                 cy = (SHORT) (aptl [TXTBOX_TOPLEFT].y -
                               aptl [TXTBOX_BOTTOMLEFT].y) ;
  GpiQueryFontMetrics(textps, sizeof(FONTMETRICS), &fm);
  memset( &bmp, 0, sizeof(BITMAPINFOHEADER2));

  bmp.cbFix     = sizeof(BITMAPINFOHEADER2);
  bmp.cx        = cx;
  bmp.cy        = cy;
  bmp.cPlanes   = cPlanes;
  bmp.cBitCount = cBitCount;
  hbmtext = GpiCreateBitmap( textps, &bmp, 0L, NULL, NULL );
  GpiSetBitmap( textps, hbmtext );
//  GpiSetColor (psknstat->textps,psknstat->tColor ) ;
  ptl.x= ptl.y = 0;
  rcl.xLeft= rcl.yBottom = 0;
  rcl.xRight=cx;
  rcl.yTop=cy;
    GpiQueryLogColorTable(textps, 0L, 0L, 16, alTable);
    GpiCreateLogColorTable(textps, 0L, LCOLF_RGB, 0L, 16, alTable);
//    WinSetPresParam(p->hWnd, PP_FONTNAMESIZE, 11,(PVOID)"18.Courier");
    //    sizf.cx = MAKEFIXED(fm.lEmInc,0);
    sizf.cx = MAKEFIXED(fat->lMaxBaselineExt,0);
    sizf.cy = MAKEFIXED(fat->lMaxBaselineExt,0);
    GpiSetCharBox(textps, &sizf );
    WinDrawText(textps, -1, text, &rcl, Col, 0L,DT_LEFT | DT_VCENTER);
    return hbmtext;
//  GpiCharStringAt ( psknstat->textps, &ptl, strlen(psknstat->vidname), psknstat->vidname);
}

void get_coords(HWND hw, int *x,int *y,int *cx, int *cy)
{
 SWP wp;
 WinQueryWindowPos(hw,&wp);
 if (x != NULL) *x=wp.x;
 if (y != NULL) *y=wp.y;
 if (cx != NULL) *cx=wp.cx;
 if (cy != NULL) *cy=wp.cy;
 }
