/*
 * WarpVision GUI. Save/Load INI
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

void save_ini()
{
    HINI hini;
    char buf[60];

    hini=PrfOpenProfile(hab,full_ini);
    itoa(conf.ctlx,buf,10);
    PrfWriteProfileString(hini, "video2", "ctlx", buf);
    itoa(conf.ctly,buf,10);
    PrfWriteProfileString(hini, "video2", "ctly", buf);
    itoa(conf.movx,buf,10);
    PrfWriteProfileString(hini, "video2", "movx", buf);
    itoa(conf.movy,buf,10);
    PrfWriteProfileString(hini, "video2", "movy", buf);
    itoa(conf.movcx,buf,10);
    PrfWriteProfileString(hini, "video2", "movcx", buf);
    itoa(conf.movcy,buf,10);
    PrfWriteProfileString(hini, "video2", "movcy", buf);
    itoa(conf.playlx,buf,10);
    PrfWriteProfileString(hini, "video2", "playlx", buf);
    itoa(conf.playly,buf,10);
    PrfWriteProfileString(hini, "video2", "playly", buf);
    itoa(conf.playlcx,buf,10);
    PrfWriteProfileString(hini, "video2", "playlcx", buf);
    itoa(conf.playlcy,buf,10);
    PrfWriteProfileString(hini, "video2", "playlcy", buf);
    itoa(conf.volume,buf,10);
    PrfWriteProfileString(hini, "video2", "volume", buf);
    itoa(conf.isShowWindow,buf,10);
    PrfWriteProfileString(hini, "video2", "isshw", buf);
    itoa(conf.Bright,buf,10);
    PrfWriteProfileString(hini, "video2", "bright", buf);
     itoa(conf.AudioDeviceIndex,buf,10);
    PrfWriteProfileString(hini, "video2", "adi", buf);
    itoa(conf.AudioResampleFlag,buf,10);
    PrfWriteProfileString(hini, "video2", "vrf", buf);
    itoa(conf.AudioID,buf,10);
    PrfWriteProfileString(hini, "video2", "aid", buf);
    itoa(conf.VideoID,buf,10);
    PrfWriteProfileString(hini, "video2", "vid", buf);
    itoa(conf.priClass,buf,10);
    PrfWriteProfileString(hini, "video2", "priclass", buf);
    itoa(conf.priDelta,buf,10);
    PrfWriteProfileString(hini, "video2", "pridelta", buf);
    itoa(conf.VideoFormat,buf,10);
    PrfWriteProfileString(hini, "video2", "vidf", buf);
    itoa(conf.AudioDisable,buf,10);
    PrfWriteProfileString(hini, "video2", "auddis", buf);
    itoa(conf.KeepAspect,buf,10);
    PrfWriteProfileString(hini, "video2", "keepasp", buf);
    itoa(conf.FullScreen,buf,10);
    PrfWriteProfileString(hini, "video2", "fullscreen", buf);
    itoa(conf.IsSound,buf,10);
    PrfWriteProfileString(hini, "video2", "issound", buf);
    itoa(conf.IsOnTop,buf,10);
    PrfWriteProfileString(hini, "video2", "isontop", buf);
    itoa(conf.DartShare,buf,10);
    PrfWriteProfileString(hini, "video2", "dartshare", buf);
    itoa(conf.ToLastPos,buf,10);
    PrfWriteProfileString(hini, "video2", "tolastpos", buf);
    itoa(conf.UseHWVIDEO,buf,10);
    PrfWriteProfileString(hini, "video2", "hwvideo", buf);
    itoa(conf.LoadLastPlaylist,buf,10);
    PrfWriteProfileString(hini, "video2", "loadlpl", buf);
    itoa(conf.w_fps,buf,10);
    PrfWriteProfileString(hini, "video2", "w_fps", buf);
    itoa(conf.w_abr,buf,10);
    PrfWriteProfileString(hini, "video2", "w_abr", buf);
    itoa(conf.w_freq,buf,10);
    PrfWriteProfileString(hini, "video2", "w_freq", buf);
    itoa(conf.w_acod,buf,10);
    PrfWriteProfileString(hini, "video2", "w_acod", buf);
    itoa(conf.w_vcod,buf,10);
    PrfWriteProfileString(hini, "video2", "w_vcod", buf);
    itoa(conf.w_res,buf,10);
    PrfWriteProfileString(hini, "video2", "w_res", buf);
    itoa(conf.w_time,buf,10);
    PrfWriteProfileString(hini, "video2", "w_time", buf);
    itoa(conf.w_file,buf,10);
    PrfWriteProfileString(hini, "video2", "w_file", buf);
    itoa(conf.w_status,buf,10);
    PrfWriteProfileString(hini, "video2", "w_status", buf);
    itoa(conf.ForceAspect,buf,10);
    PrfWriteProfileString(hini, "video2", "faspect", buf);

    int x1,x2;
    sprintf(buf,"%g",conf.LastPos);
    PrfWriteProfileString(hini, "video2", "lastpos", buf);

    PrfWriteProfileString(hini, "video2", "skinpath", conf.skinpath);
    PrfWriteProfileString(hini, "video2", "skinfile", conf.skinfile);
    PrfWriteProfileString(hini, "video2", "mediafile", conf.mediafile);
    PrfWriteProfileString(hini, "video2", "mediapath", conf.mediapath);
    PrfWriteProfileString(hini, "video2", "exts", conf.exts);
    PrfWriteProfileString(hini, "video2", "lastpl", conf.playlstfile);

    PrfCloseProfile(hini);


 }
void load_ini()
{
    HINI hini;
    char buf[60];

    hini=PrfOpenProfile(hab,full_ini);
    conf.ctlx=PrfQueryProfileInt(hini, "video2", "ctlx", 9999);
    conf.ctly=PrfQueryProfileInt(hini, "video2", "ctly", 9999);
    conf.movx=PrfQueryProfileInt(hini, "video2", "movx", 100);
    conf.movy=PrfQueryProfileInt(hini, "video2", "movy", 100);
    conf.movcx=PrfQueryProfileInt(hini, "video2", "movcx", 200);
    conf.movcy=PrfQueryProfileInt(hini, "video2", "movcy", 200);
    conf.playlx=PrfQueryProfileInt(hini, "video2", "playlx", 10);
    conf.playly=PrfQueryProfileInt(hini, "video2", "playly", 10);
    conf.playlcx=PrfQueryProfileInt(hini, "video2", "playlcx", 200);
    conf.playlcy=PrfQueryProfileInt(hini, "video2", "playlcy", 200);
    conf.volume=PrfQueryProfileInt(hini, "video2", "volume", 100);
    conf.isShowWindow=PrfQueryProfileInt(hini, "video2", "isshw", 1);
    conf.AudioDeviceIndex=PrfQueryProfileInt(hini, "video2", "adi", 0);
    conf.AudioResampleFlag=PrfQueryProfileInt(hini, "video2", "vrf", RESAMPLE_NONE);
    conf.AudioID=PrfQueryProfileInt(hini, "video2", "aid", -1);
    conf.VideoID=PrfQueryProfileInt(hini, "video2", "vid", -1);
    conf.priClass=PrfQueryProfileInt(hini, "video2", "priclass", 3); //time critical
    conf.priDelta=PrfQueryProfileInt(hini, "video2", "pridelta", PRTYD_MINIMUM); // minimal
    conf.Bright=PrfQueryProfileInt(hini, "video2", "bright", 0);
    conf.VideoFormat=PrfQueryProfileInt(hini, "video2", "vidf", FMT_RGB16);
    conf.AudioDisable=PrfQueryProfileInt(hini, "video2", "auddis", 0);
    conf.KeepAspect=PrfQueryProfileInt(hini, "video2", "keepasp", 0);
    conf.FullScreen=PrfQueryProfileInt(hini, "video2", "fullscreen", 0);
    conf.DartShare=PrfQueryProfileInt(hini, "video2", "dartshare", 0);
    conf.ToLastPos=PrfQueryProfileInt(hini, "video2", "tolastpos", 0);
    conf.UseHWVIDEO=PrfQueryProfileInt(hini, "video2", "hwvideo", 0);
    conf.w_fps=PrfQueryProfileInt(hini, "video2", "w_fps", 50);
    conf.w_abr=PrfQueryProfileInt(hini, "video2", "w_abr", 100);
    conf.w_freq=PrfQueryProfileInt(hini, "video2", "w_freq", 100);
    conf.w_acod=PrfQueryProfileInt(hini, "video2", "w_acod", 200);
    conf.w_vcod=PrfQueryProfileInt(hini, "video2", "w_vcod", 200);
    conf.w_res=PrfQueryProfileInt(hini, "video2", "w_res", 100);
    conf.w_time=PrfQueryProfileInt(hini, "video2", "w_time", 100);
    conf.w_file=PrfQueryProfileInt(hini, "video2", "w_file", 300);
    conf.w_status=PrfQueryProfileInt(hini, "video2", "w_status", 100);
    conf.IsSound=PrfQueryProfileInt(hini, "video2", "issound", 1);
    conf.IsOnTop=PrfQueryProfileInt(hini, "video2", "isontop", 1);
    conf.LoadLastPlaylist=PrfQueryProfileInt(hini, "video2", "loadlpl", 1);
    conf.ForceAspect=PrfQueryProfileInt(hini, "video2", "faspect",ASPECT_USER_DEFINED);

    PrfQueryProfileString(hini, "video2", "skinpath",
                          "", conf.skinpath, sizeof(conf.skinpath));
    PrfQueryProfileString(hini, "video2", "exts",
                          "*.avi;*.mpeg;*.mpg;*.asf;*.wma;*.wmv;*.vob",
                          conf.exts, sizeof(conf.exts));

//    printf("skin path1: %s\n",conf.skinpath);
    if ((conf.skinpath == "") || (conf.skinpath[0] == '\0'))
    {
//        getcwd(st_path, _MAX_PATH);
//        printf("PRG START path: %s\n",st_path);
        splitdir(st_path,conf.skinpath,conf.skinfile);
        strcat(conf.skinpath,"skin\\");
//        printf("skin path1: %s\n",conf.skinpath);
    }
//    fflush(stdout);
    PrfQueryProfileString(hini, "video2", "lastpos",
                          "0", buf, sizeof(buf));
    conf.LastPos=atof(buf);
         PrfQueryProfileString(hini, "video2", "skinfile",
               "def.skn", conf.skinfile, sizeof(conf.skinfile));
    PrfQueryProfileString(hini, "video2", "mediapath",
                          "", conf.mediapath, sizeof(conf.mediapath));
    PrfQueryProfileString(hini, "video2", "mediafile",
                          "", conf.mediafile, sizeof(conf.mediafile));

    PrfQueryProfileString(hini, "video2", "lastpl",
               "", conf.playlstfile, sizeof(conf.playlstfile));

    PrfCloseProfile(hini);
}
