/*
 * WarpVision GUI. Playlist
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include "mclb\mclb.h"
#define szPlayListClass "PlayListClass"
#define ID_APP_PLAYLIST 1018
#define ID_PLAYLIST 1019
#define szPlayListTitle "Playlist"
int plrows = 0;

void fillPlayList(pplayItem); // adds item to playlist
MRESULT APIENTRY PlayListWndProc(HWND, ULONG, MPARAM, MPARAM);

HWND hWndPlayList,hWndPlayListClient,hwndList;

ULONG flPlayListWinFlags =  FCF_TITLEBAR | FCF_MINMAX | FCF_SYSMENU | FCF_BORDER | FCF_SIZEBORDER |FCF_NOBYTEALIGN | FCF_SHELLPOSITION | FCF_TASKLIST;
char delim = '!';

void get_colsizes()
{
    int i;
    WinSendMsg(hwndList,MCLB_QUERYCOLSIZES,MPFROMLONG(&colsizes),NULL);
    conf.w_fps=colsizes[0];
    conf.w_abr=colsizes[1];
    conf.w_freq=colsizes[2];
    conf.w_acod=colsizes[3];
    conf.w_vcod=colsizes[4];
    conf.w_res=colsizes[5];
    conf.w_time=colsizes[6];
    conf.w_file=colsizes[7];
    conf.w_status=colsizes[8];
//    for (i=0; i < 9;i++) printf("%u\n",colsizes[i]);
 }
void set_colsizes()
{
    colsizes[0]=conf.w_fps;
    colsizes[1]=conf.w_abr;
    colsizes[2]=conf.w_freq;
    colsizes[3]=conf.w_acod;
    colsizes[4]=conf.w_vcod;
    colsizes[5]=conf.w_res;
    colsizes[6]=conf.w_time;
    colsizes[7]=conf.w_file;
    colsizes[8]=conf.w_status;
    WinSendMsg(hwndList,MCLB_SETCOLSIZES,MPFROMLONG(&colsizes),NULL);
}

void add_playlist()
{

    BOOL fRc;
    if (hWndPlayList) {
       get_coords(hWndPlayList,&conf.playlx,&conf.playly,&conf.playlcx, &conf.playlcy);
       get_colsizes();
       save_ini();
       WinDestroyWindow(hWndPlayList);
       hWndPlayList = NULL;
       return;
     }
  fRc = WinRegisterClass (hab, szPlayListClass,(PFNWP)PlayListWndProc, CS_SYNCPAINT,  0);
  if(fRc == FALSE)
  {
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "訡  ॣ樨   ᯨ᪠",
      "訡", 0, MB_ICONHAND | MB_OK);

    // । ਩ 襭 ਫ
    // 㭨⮦ ᮧ ࠭ । ᮮ饭 
    // 뢠 㭪 WinTerminate
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);
    return;
  }

  hWndPlayList = WinCreateStdWindow (HWND_DESKTOP,
    0,
    &flPlayListWinFlags, szPlayListClass, szPlayListTitle,
                                 0, 0, ID_APP_PLAYLIST, &hWndPlayListClient);
  if(hWndPlayList == NULLHANDLE)
  {
    WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
      "訡  ᮧ  ",
      "訡", 0, MB_ICONHAND | MB_OK);
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);
    return;  }

  //  WinSetWindowPos (hWndPlayList, HWND_TOP,10, 10, 200, 200, SWP_SIZE | SWP_MOVE | SWP_ACTIVATE |SWP_SHOW);
// set_colsizes();
 WinSetFocus(HWND_DESKTOP,hWndPlayList);

//  tb=WinWindowFromID(hWndShow,(USHORT) FID_TITLEBAR);
//  oldTBProc = WinSubclassWindow(tb, (PFNWP)TBWndProc);
}


void measure_playlist()
{
    WinSetWindowPos (hWndPlayList, HWND_TOP,conf.playlx, conf.playly, conf.playlcx, conf.playlcy, SWP_SIZE | SWP_MOVE | SWP_ACTIVATE |SWP_SHOW);
    set_colsizes();
 return;
}

/*
MRESULT APIENTRY TBWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CHAR szMsg[100];
   switch(msg)
   {
   case WM_WINDOWPOSCHANGED:
   case WM_SIZE:
   case WM_MOVE:
       {
           WinQueryWindowPos(hwnd, &tbswp);
           break;
        }
   case WM_PAINT:
       {
           HPS hps;
           RECTL rcl;
           rcl.xLeft=0;
           rcl.yBottom=0;
           rcl.yTop=tbswp.cy;
           rcl.xRight=tbswp.cx;
           hps=WinBeginPaint(hwnd,NULLHANDLE,NULL);

           WinDrawBitmap (hps, skn->title_backgr.hbm, NULL, (PPOINTL)&rcl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_STRETCH) ;
           //           oldTBProc(hwnd, msg, mp1, mp2);
           rcl.yTop=skn->title_left.heigth;
           rcl.xRight=skn->title_left.width;

           WinDrawBitmap (hps, skn->title_left.hbm, NULL, (PPOINTL)&rcl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_STRETCH) ;
//             WinFillRect(hps, &rcl, CLR_GREEN);
           WinEndPaint(hps);
           return (MRESULT)FALSE;
          // break;
       }
   case TBM_SETHILITE:
       {
//           WinInvalidateRect(hwnd,NULLHANDLE,TRUE);
           return (MRESULT)FALSE;
        }
//       oldTBProc(hwnd, msg, mp1, mp2);
   }
  return (MRESULT)oldTBProc(hwnd, msg, mp1, mp2);
}
*/

MRESULT APIENTRY PlayListWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CHAR szMsg[100];
   switch(msg)
   {
   case WM_PAINT:
       {
           break;
       }
      case WM_CREATE:
          {
      MCLBINFO InitData;
      LONG InitSizeList[9]= {1L,4L,1L,1L,1L,1L,1L,1L,1L};  // Make col 1 twice as big as 2 and 3

      /* Initialize MCLB create data structure */

      memset(&InitData, 0x00, sizeof(MCLBINFO));
      // These are the only required initialization values:
      InitData.Size = sizeof(MCLBINFO);
      InitData.Cols = 9;
      InitData.TabChar = delim;
      InitData.Titles = "Status!Media file!Time!Resolution!Video codec!Audio codec!Freq!Audio bit rate!FPS";
      InitData.InitSizes= InitSizeList;  // Initial sizes (proportions)

      // Play with these for colors and fonts:
       InitData.TitleBColor = skn->playlist.TitleBColor;
       InitData.TitleFColor = skn->playlist.TitleFColor;
       InitData.ListBColor = skn->playlist.ListBColor;
       InitData.ListFColor = skn->playlist.ListFColor;
       strcpy(InitData.ListFont, skn->playlist.ListFont);
       strcpy(InitData.TitleFont, skn->playlist.TitleFont);

      hwndList = MCLBCreateWindow(
                 hwnd,            // Parent window
                 hwnd,                    // Owner to recv messages
                 WS_VISIBLE|              // Styles: Make it visible
                 WS_TABSTOP|              // Let user TAB to it
                 MCLBS_SIZEMETHOD_PROP|   // Proportional sizing when window is sized
                 LS_HORZSCROLL,           // Give each column a horizontal scroll bar
                 0,0,100,100,             // Will set size later, but must have large horz size now
                 HWND_TOP,                // Put on top of any sibling windows
                 ID_PLAYLIST,             // Window ID
                 &InitData);              // MCLB create structure

       hWndPLMenu = WinLoadMenu(hwndList, NULLHANDLE, ID_PLSTMENU);
      fillPlayList(playLst);
      return FALSE;                                                             
          }

   case WM_CLOSE:
       {
           //                      DosBeep(2000,100);
           WinDestroyWindow(hWndPlayList);
           return MRESULT(TRUE);
                     //           break;
       }
   case WM_BUTTON2UP:
       {
           POINTL ptl;
           WinQueryPointerPos(HWND_DESKTOP, &ptl);
           WinMapWindowPoints(HWND_DESKTOP, hwnd, &ptl, 1L);
               WinPopupMenu(hwnd, hwnd, hWndPLMenu, ptl.x,ptl.y,0,
               PU_MOUSEBUTTON1 | PU_KEYBOARD | PU_HCONSTRAIN | PU_VCONSTRAIN);
               return 0;
           break;
       }
   case WM_CONTROL:
       {
           SHORT Item;   // Item index
           char buf[255];
           char name1[255];
           char *name;
           pplayItem p;

           if (SHORT1FROMMP(mp1) == ID_PLAYLIST)
           {
             switch SHORT2FROMMP(mp1) {
             case LN_ENTER: // User double-clicked or pressed ENTER in the MCLB.
                 {
                     Item = SHORT1FROMMR(WinSendMsg(hwndList, LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), MPVOID));
                     p = search_item(Item);
                     if (p != NULL)
                     {
                      if (playonce != NULL) // we played only one media not from list
                      { free(playonce);
                        playonce = NULL;
                        }
//                         printf("will play: %s\n",p->fName);
                         playonce = p;
                         WinPostMsg(hWndClient,WM_COMMAND,MPFROM2SHORT(IDM_PLAYONE,0),NULL);
                      }
                 } // case lm_enter
             }
           } // if playlist
           break;
        } // case wm_control
     case WM_CONTEXTMENU:
          {
           POINTL ptl;
           WinQueryPointerPos(HWND_DESKTOP, &ptl);
           WinMapWindowPoints(HWND_DESKTOP, hwnd, &ptl, 1L);
               WinPopupMenu(hwnd, hwnd, hWndPLMenu, ptl.x,ptl.y,0,
               PU_MOUSEBUTTON1 | PU_KEYBOARD | PU_HCONSTRAIN | PU_VCONSTRAIN);
               return 0;
          } // case ALN_

   case WM_COMMAND:
       {
          switch (COMMANDMSG(&msg)->cmd)
          {
          case IDM_LOADPLLST:
              {
//                  DosBeep(2000,200);
                  sl_playlist(hwnd,TRUE); // save/load playlist
                  break;
              }
          case IDM_SAVEPLLST:
              {
//                  DosBeep(2000,200);
                  sl_playlist(hwnd,FALSE); // save/load playlist
                  break;
              }

          case IDM_PLAY:
              {
                  //                  add_playlist();
                  int item;
                  item = (int)WinSendMsg(hwndList,LM_QUERYSELECTION,MPFROMSHORT(LIT_FIRST),NULL);
                  playonce = search_item(item);
                  WinPostMsg(hWndClient,WM_COMMAND,MPFROM2SHORT(IDM_PLAYONE,0),NULL);
                  break;
              }
          case IDM_ADDTOLIST:
              {
                  WinPostMsg(hWndClient,WM_COMMAND,MPFROM2SHORT(IDM_ADDTOLIST,0),NULL);
                  break;
              }
          case IDM_REMOVE:
              {
                  int item;
                  item = (int)WinSendMsg(hwndList,LM_QUERYSELECTION,MPFROMSHORT(LIT_FIRST),NULL);
                  remove_row(item);
                    fillPlayList(playLst);
//                  if (playLst != NULL) set_button_state(&skn->play_butt, MBS_RELEASED,FALSE);
                  break;
              }

          case IDM_LOADMEDIA:
              {
                WinPostMsg(hWndClient,WM_COMMAND,MPFROM2SHORT(IDM_LOADMEDIA,0),NULL);
                  break;
              }

          case IDM_EXIT:
              {
             WinDestroyWindow(hWndPlayList);
             hWndPlayList=NULL;
             break;
              }
           } //switch
         return 0;
        }  // case wm command
   case WM_SIZE:
       {
         WinSetWindowPos (WinWindowFromID (hwnd, ID_PLAYLIST), HWND_TOP,
                       0, 0, SHORT1FROMMP (mp2), SHORT2FROMMP (mp2),
                       SWP_MOVE | SWP_SIZE | SWP_SHOW | SWP_ACTIVATE);
       break;
       }

   case WM_DESTROY:
       {
       get_coords(hWndPlayList,&conf.playlx,&conf.playly,&conf.playlcx, &conf.playlcy);
       get_colsizes();
       save_ini();
//           WinDestroyWindow(hWndPlayList);
            hWndPlayList=NULL;
//           DosBeep(2000,100);
           plrows=0;
           break;
       }
   }
   
   return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

void insert_row(pplayItem ppl, int row)
{
    char itemRow[255];
    strcpy(itemRow," !");
    strcat(itemRow,ppl->fName);
    strcat(itemRow,"!");
    strcat(itemRow,ppl->time);
    strcat(itemRow,"!");
    strcat(itemRow,ppl->res);
    strcat(itemRow,"!");
    strcat(itemRow,ppl->vCodec);
    strcat(itemRow,"!");
    strcat(itemRow,ppl->aCodec);
    strcat(itemRow,"!");
    strcat(itemRow,ppl->freq);
    strcat(itemRow,"!");
    strcat(itemRow,ppl->abitrate);
    strcat(itemRow,"!");
    strcat(itemRow,ppl->fps);
//    printf("Inserting row:\n%s\n",itemRow);
    ppl->row=(int)WinSendMsg(hwndList, LM_INSERTITEM, MPFROM2SHORT(LIT_END, 0), MPFROMP(itemRow));

}

void remove_item(pplayItem ppl)
{
    if (ppl == NULL || playLst == NULL) return;
    if (ppl == playLst) // first item
    {
        if (playLst->next != NULL) // more than 2 elements
        {
            playLst = playLst->next; // next stays first
            playLst->prev = NULL; // have not previous
            free(ppl);  // free current
            ppl = NULL;
            return;
        }
        else
        {
         free(ppl);
         ppl = playLst = NULL;
         return;
        }
     }
    if (ppl->prev != NULL) ppl->prev->next = ppl->next; // removing row from chain
    if (ppl->next != NULL) ppl->next->prev = ppl->prev;
    free(ppl);
    ppl = NULL;
}

void remove_row(int item)
{
    pplayItem p;
    p = search_item(item);
    remove_item(p);
    WinSendMsg(hwndList, LM_DELETEITEM, MPFROMSHORT(item), NULL);
}


pplayItem search_item(int item)
{
    pplayItem pp;
    if (playLst == NULL) return NULL;
    pp = playLst;
    while(pp->row != item)
    {
        if (pp->next != NULL) // not last
            pp = pp->next;
        else return NULL; // not found
    }     //while
  return pp;
}


void fillPlayList(pplayItem ppl) //
{
    pplayItem pp;
    int i; // row in playlist
    if (ppl == NULL) return;
    WinEnableWindowUpdate(hwndList, FALSE);
    WinSendMsg(hwndList,LM_DELETEALL,NULL,NULL);
     if (plrows > 0 ) { // not empty
         // clear all playlist
    }
    pp = ppl;
    i = plrows = 0;
    do {
           insert_row(pp,i+1);
            i++;
            pp = pp->next;
    } while(pp != NULL);    //while

    plrows=i;
    //    printf("rows=%i\n",plrows);
    WinShowWindow(hwndList, TRUE);
   if (hwndList != NULL) WinInvalidateRect(hwndList,NULLHANDLE,TRUE);
}
// moving elements in item up (step < 0) or down (step >0)
void move_item(pplayItem ppl,pplayItem ppi, int step)
{
    if (ppl == NULL || ppi == NULL || step == 0) return; // dont try to fuck me!
    pplayItem pp,next;

}

void addNewItem(pplayItem ppl)
{
    pplayItem pp,p_prev;

    if (ppl == NULL) return; // nothing to add
    if (playLst == NULL) // playlist is empty
    {
        playLst = ppl;
        ppl->prev = ppl->next = NULL;
        fillPlayList(playLst);
        return;
     }
    pp = playLst;

    do {
        p_prev = pp;
        pp=pp->next;
    } while (pp != NULL); //skip to end of playlist

    pp = ppl; // set current;
    p_prev->next = ppl;
    pp->prev = p_prev; // previous point to the last
    pp->next=NULL;
    fillPlayList(playLst);
    pp = playLst;
    do {
        pp=pp->next;
    } while (pp != NULL); //skip to end of playlist

    return;
}

int read_playlist(char *cName, pplayItem ppi)
{
    FILE *fin;
    char *pline;
    char fname[_MAX_PATH];
    char *ptr;
    static char line[2048];
    int errors = 0;
    BOOL ispl;
    line[0] = 0;
    int cnt;
    int i;

    fin = fopen(cName, "r");

    if (!fin)
    {
        //syslog(LOG_WARNING, "Unable to load file %s\n", cName);
        return 1;
    }
    ispl = FALSE;
    i = 0;
    do 
    {
        i++;
        pline = fgets(line, sizeof(line), fin);
        if (pline == NULL) break;
        if(!*pline         ||
            *pline == '\r' ||
            *pline == '\n' ||
            *pline == '#'  ||
            *pline == ';')
            continue;
        if (!ispl) // still no playlist label
        {
          if(strnicmp(line,"[playlist]",10) == 0)
           {
            ispl = TRUE; // no playlists
            continue;
           }
        }
        if (ispl) // has playlist label
        {
         if(strnicmp(line,"file",4) == 0)    // seek for file
             {
                 do { *pline++; } while(*pline != '=');  // skip after '='
                 *pline++;
               // count file name length
                cnt = 0;
                ptr = strchr(pline, '\n');
                *ptr = '\0';
                strcpy(fname,pline);
               // add filename to playlist
               if ((fname != NULL) && (fname[0] != '\0'))
               {
                   printf("%s\n",fname); fflush(stdout);
                   addNewItem(load_media(NULL, fname));
               }
            } // get file name
        } // if ispl
    } while (!feof(fin)); // feof
    fclose(fin);
    return 0;
}

int save_playlist(char *cName, pplayItem ppi)
{
    FILE *fin;
    char *pline;
    char fname[_MAX_PATH];
    char *ptr;
    static char line[2048];
    char buf[60];
    int errors = 0;
    BOOL ispl;
    line[0] = 0;
    int cnt;
    int i;
    pplayItem pp;


    if (ppi == NULL) return -2;
    pp = ppi;
    fin = fopen(cName, "w");
    if (!fin)
    {
        //syslog(LOG_WARNING, "Unable to load file %s\n", cName);
        return 1;
    }
    strcpy(line,"[playlist]");
    if (fputs(line,fin) == EOF)
    {
        fclose(fin);
        return -1;
    }
    fputc('\n',fin);
    i = 0;
    do {
       i++;
       strcpy(line,"File");
       _itoa(i, buf, 10);
       strcat(line,buf);
       strcat(line,"=");
       strcat(line,pp->fName);
      if (fputs(line,fin) == EOF)
      {
         fclose(fin);
        return -1;
      }
      fputc('\n',fin);
            pp = pp->next;
    } while(pp != NULL);    //while

    fclose(fin);
    return 0;
}

int sl_playlist(HWND fd_hwnd,BOOL load_fl) // save/load playlist
{
   FILEDLG pfdFiledlg;
   HWND hwndD;
   char *pszFullFile;
   int plrc;

   memset(&pfdFiledlg, 0, sizeof(FILEDLG));
   if (load_fl)
       pfdFiledlg.fl = FDS_CENTER | FDS_OPEN_DIALOG;
    else pfdFiledlg.fl = FDS_CENTER | FDS_SAVEAS_DIALOG | FDS_ENABLEFILELB;
       pfdFiledlg.cbSize = sizeof(FILEDLG);
       pfdFiledlg.pszTitle= "Choose playlist file:";
//       strcat(pfdFiledlg.szFullFile,conf.mediapath); // last saved path if any
       strcpy(pfdFiledlg.szFullFile,"*");
       hwndD = WinFileDlg(HWND_DESKTOP, fd_hwnd, &pfdFiledlg);
      if (hwndD && (pfdFiledlg.lReturn == DID_OK))
      {
       pszFullFile=pfdFiledlg.szFullFile;
       if (load_fl) plrc=read_playlist(pszFullFile, NULL);
       else plrc=save_playlist(pszFullFile, playLst);
       if (plrc == 0) // playlist save/load successfully
            {
             strcpy(conf.playlstfile,pszFullFile);
             save_ini();
            }
       }
       else
       {
           printf("Error creating file dialog\n");fflush(stdout);
//           pszFullFile=SkinFileDlg(fd_hwnd);
           return -1;
       }
    return 0;
}

void check_playlist()
{
    if (conf.LoadLastPlaylist) // if load last playlist?
    {
        if (conf.playlstfile != NULL &&
            conf.playlstfile != "" &&
            conf.playlstfile[0] != '\0')
        {
          read_playlist(conf.playlstfile, NULL);
         }
     }
 }
