/*
 * WarpVision GUI. Start/stop play threads
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

float audio_time, video_time;

extern "C" void CalcAVtime(void)
{
    unsigned int samples;

    if (no_audio != TRUE)
    {
        if (sh_audio->audio.dwSampleSize == 0)
        {
            audio_time = d_audioM->pts;
        }
        else
        {
            samples = ((ds_tell(d_audioM)-sh_audio->a_in_buffer_len) /
                       sh_audio->audio.dwSampleSize);
            samples += sh_audio->audio.dwStart;

            audio_time = samples * (float)sh_audio->audio.dwScale /
                         (float)sh_audio->audio.dwRate;
        }
        audio_time -= (float)audio_header.audio_buffer_used/sh_audio->i_bps;
        audio_time -= (float)audio_header.dart_buffer_size/sh_audio->o_bps;
        video_time = d_videoM->pts;

        audio_time += SyncCorrection;
    }
    else
    {
        video_time = d_videoM->pts;
        audio_time = video_time;
    }
}

void APIENTRY PlayAudio(ULONG Parm)
{
    dart_play();

    while(DART.Stopped != TRUE)
    {
        DosSleep(100);
    }

    dart_stop();

    no_audio = TRUE;

    return;
}


void APIENTRY PlayVideo(ULONG Parm)
{
    int rc;
    ULONG TimerFreq;
    int FrameTimer;
    QWORD Qres;
    unsigned long long StartDec, EndDec;
    float frame_delay;
    ULONG numwait;
    int numcadr;
    int SkipFrame = 0;
    int SkippedFrames = 0;
    unsigned char *DiveMemory;

    int show_info = -1;
    ULONG bpl;

    DosTmrQueryFreq(&TimerFreq);
    DosTmrQueryTime(&Qres);
    StartDec = Q2LL(Qres);
    FrameTimer = 0;

    show_info = -1;
    SyncCorrection = 0.0f;
    CalcAVtime();
    while(Shutdown == 0)
    {

        DosTmrQueryTime(&Qres);
        EndDec = Q2LL(Qres);
        if (no_audio == TRUE) CalcAVtime();
        frame_delay = (audio_time - video_time) / sh_video->fps;
        FrameTimer += (EndDec - StartDec);
/*
                 printf("A: %5.1f V: %5.1f A-V: %3.2f C: %3.2f \r",
                   audio_time, video_time, audio_time - video_time,
                   SyncCorrection);

            fflush(stdout);
            */



        if (frame_delay)
        {
            FrameTimer += (TimerFreq/sh_video->fps) * frame_delay;
            frame_delay = 0;
        }

        StartDec = EndDec;
        numcadr = ((float)FrameTimer)/TimerFreq;
        if (numcadr > 2 + max(0, SkippedFrames) / 2)
        {
            SkipFrame = TRUE;
            SkippedFrames++; // A
        }
        else
        if (SkippedFrames > 0)
            SkippedFrames = 0; // B


        if (numcadr > 0)
        {
            FrameTimer -= TimerFreq/sh_video->fps;
  NextMem:

            if (Pause) {
                DosSleep(2);
                DiveBlitImage (di.hDive, di.hBuffer[di.VisibleBuffer], DIVE_BUFFER_GRAPHICS_PLANE);
                continue;
            }

            if (Seeking)
            {
                DosRequestMutexSem(dart_cb_mtx, (ULONG)SEM_INDEFINITE_WAIT);
                demux_seek(demuxerM, new_dem_pos, dem_flag);
                DosReleaseMutexSem(dart_cb_mtx);
                FrameTimer = 0;
                frame_delay = 0;
                SkipFrame = FALSE;
                CalcAVtime();
                Seeking=FALSE;
            }
            switch(video_header.codec)
            {
                ULONG     BufPhys;

                case CODEC_FFMPEG:
                {
                    if ((rc = video_decode(sh_video, NULL, 0)) == -1)
                    {
                        Shutdown = TRUE;
                        break;
                    }

                    if (rc == 0 && SkipFrame == FALSE)
                    {
                       if (HWVIDEOPresent && conf.UseHWVIDEO)
                       {
                           if (HWVIDEOBeginUpdate((PPVOID)(&DiveMemory),&BufPhys) != HWVIDEO_ERROR_BACKGROUND)
                             video_blit(sh_video, DiveMemory, VideoSetup.ulSrcPitch);
                           HWVIDEOEndUpdate();
                         }
                        else // via DIVE
                        {
                      DiveMemory = (unsigned char *)diveBeginPaint (&bpl, DIVE_NEXTBUFFER);
                        if (DiveMemory == NULL)
                            continue;
                       video_blit(sh_video, DiveMemory, bpl);
                       diveEndPaint ();
                       bufSwitch (DIVE_NEXTBUFFER);
                       if (DiveBlitImage (di.hDive, di.hBuffer[di.VisibleBuffer], DIVE_BUFFER_GRAPHICS_PLANE) != DIVE_SUCCESS)
                          di.FailedCount++;
                       di.FrameCount++;
                        }
                       // inform main control to update slider, clock etc
                   WinPostMsg(hWndClient,WM_COMMAND,MPFROM2SHORT(CNTRL_CLKUPD,0L),MPFROMLONG(1L));
                    }
                    else
                        SkipFrame = FALSE;
                } // case CODEC_FFMPEG:
                break;

                case CODEC_LIBMPEG2:
                {
                    if (SkipFrame == FALSE)
                    {
                     if (HWVIDEOPresent && conf.UseHWVIDEO)
                     {
//                         HWVIDEOBeginUpdate((PPVOID)(&DiveMemory),&BufPhys);
                     if (HWVIDEOBeginUpdate((PPVOID)(&DiveMemory),&BufPhys) != HWVIDEO_ERROR_BACKGROUND)
                     {
                         rc = video_decode(sh_video, DiveMemory, VideoSetup.ulSrcPitch);
                         video_blit(sh_video, DiveMemory, VideoSetup.ulSrcPitch);
                     }
                      HWVIDEOEndUpdate();
//                         printf("hwv\n");fflush(stdout);
                         }
                        else // via DIVE
                        {
                      DiveMemory = (unsigned char *)diveBeginPaint (&bpl, DIVE_NEXTBUFFER);
                      if (DiveMemory == NULL)
                          continue;

                        rc = video_decode(sh_video, DiveMemory, bpl);
//                         video_blit(sh_video, DiveMemory, bpl);
                         diveEndPaint ();
                         bufSwitch (DIVE_NEXTBUFFER);
                       if (DiveBlitImage (di.hDive, di.hBuffer[di.VisibleBuffer], DIVE_BUFFER_GRAPHICS_PLANE) != DIVE_SUCCESS)
                          di.FailedCount++;
                       di.FrameCount++;
//                       printf("dive\n");fflush(stdout);
                        }
                       // inform main control to update slider, clock etc
                       WinPostMsg(hWndClient,WM_COMMAND,MPFROM2SHORT(CNTRL_CLKUPD,0L),MPFROMLONG(1L));
                        if (rc == -1)
                        {
                            Shutdown = TRUE;
                            break;
                        }
                    }
                    else
                        SkipFrame = FALSE;
                } // case CODEC_LIBMPEG2:
                break;
            } // switch
        } // if numcadr
        else
        {
            DosSleep(1);
        }
    } // while shutdown
    stop_play();
    return;
}


BOOL begin_play(pplayItem ppl)
{
    PPIB  pib;
    PTIB  tib;
    ULONG OldProcessType;
    FOURCC fccColorFormat;
    char  pszTitleText[64];
    int   WindowX, WindowY, rc, outbytes;
    int file_format = DEMUXER_TYPE_UNKNOWN;
    int show_info;
    //    int rc;
    if (ppl != NULL) ppl->no_audio = FALSE;
    no_audio = FALSE;
    DosSetPriority(PRTYS_THREAD, conf.priClass, conf.priDelta, PRTYS_PROCESSTREE);
    DosCreateMutexSem(NULL, &demux_mtx, 0, FALSE);
    DosCreateMutexSem(NULL, &dart_cb_mtx, 0, FALSE);
    // Init streams
//    printf("Mem: %u\n",mem_avail());
    streamM = open_stream(ppl->fName, 0, &file_format);
    if(!streamM)
    {
	return FALSE;
    }
    if (conf.AudioDisable == TRUE) conf.AudioID = -2; // don't read audio packets
    else conf.AudioID = -1;

    demuxerM = demux_open(streamM, file_format, conf.AudioID,conf.VideoID, -1);

    if(demuxerM == NULL)
    {
        printf("Cannot open demuxer\n");
        return FALSE;
    }
  
    d_audioM = demuxerM->audio;
    d_videoM = demuxerM->video;

    if (conf.AudioDisable == TRUE)
    {
        sh_audio = NULL;
    }
    else
    sh_audio=(sh_audio_t *)d_audioM->sh;

    sh_video=(sh_video_t *)d_videoM->sh;

    // Find & init audio codec

    if (sh_audio != NULL)
    {
        sh_audio->codec=find_audio_codec(sh_audio->format);

        if ((sh_audio->codec != NULL) && (sh_audio->codec->codec_supported == TRUE))
        {
            printf("Found audio codec1: %s\n", sh_audio->codec->codec_name);
            DART.Shareable = conf.DartShare;
            rc = audio_init(sh_audio, conf.AudioDeviceIndex, conf.AudioResampleFlag);
            printf("DART device: %u\n",DART.DeviceID);
            printf("num of buffers: %u\n",DART.BufferParms.ulNumBuffers);
            printf("buffer size: %u\n",DART.BufferParms.ulBufferSize);
            printf("Audio: sample rate: %d, bit rate: %d kbps, scannels: %d\n",
                   audio_header.sample_rate, audio_header.bit_rate,
                   audio_header.channels);

            fflush(stdout);
            if (rc != TRUE)
            {
                no_audio = TRUE;
                if (ppl != NULL) ppl->no_audio = TRUE;
                if (DART.DeviceID > 0) dart_close(); // we MUST close DART !!
            }
            else
            {
                no_audio = FALSE;
                    if (ppl != NULL) ppl->no_audio = FALSE;
            }
        }
        else
        {
            printf("Found audio codec2: %s\n", sh_audio->codec->codec_name);

            ds_free_packs(d_audioM);
            d_audioM->id = -2;
            no_audio = TRUE;
            if (ppl != NULL) ppl->no_audio = TRUE;
            sh_audio = NULL;
            if (DART.DeviceID > 0) dart_close(); // we MUST close DART !!
         }
    }
    else
    {
        ds_free_packs(d_audioM);
        d_audioM->id = -2;
        no_audio = TRUE;
        if (ppl != NULL) ppl->no_audio = TRUE;
        sh_audio = NULL;
    }
    if (ppl != NULL) no_audio = ppl->no_audio;
    if (sh_video != NULL)
    {
        video_read_properties(sh_video);

        switch(sh_video->ds->demuxer->file_format)
        {
            case DEMUXER_TYPE_ASF:
                sh_video->aspect = 1.0;
/*
                printf("Video: fourcc:[%.4s] size:%dx%d\n",
                       (char *)&sh_video->format,
                       sh_video->disp_w,sh_video->disp_h);
*/
            break;

            case DEMUXER_TYPE_AVI:
            case DEMUXER_TYPE_AVI_NI:
            case DEMUXER_TYPE_AVI_NINI:
                sh_video->aspect = 1.0;

/*                printf("Video: fourcc:[%.4s] size:%dx%d fps:%5.2f\n",
                       (char *)&sh_video->format, sh_video->disp_w,sh_video->disp_h,
                       sh_video->fps);
*/
            break;
            case DEMUXER_TYPE_MPEG_ES:
            case DEMUXER_TYPE_MPEG_PS:
                char aspect[8];

                switch(sh_video->aspect_info)
                {
                    case 2:
                    case 4:
                    case 8:
                    case 12:
                        strcpy(aspect, "4:3");
                    break;

                    case 3:
                    case 6:
                        strcpy(aspect, "16:9");
                    break;

                    default:
                        strcpy(aspect, "1:1");
                    break;
                }
/*
                printf("Video: %s size:%dx%d aspect:%s fps:%5.2f\n",
                       sh_video->format?"MPEG1":"MPEG2",
                       sh_video->disp_w,sh_video->disp_h,
                       aspect,
                       sh_video->fps);
*/
            break;
        }

        // Find & init video codec
        sh_video->codec=find_video_codec(sh_video->format);

//        printf("Found video codec: %s\n", sh_video->codec->codec_name);
    }
    if (conf.VideoFormat < 0) // auto select
    {
     conf.VideoFormat = GetBestDIVEMode();
    }

    if (conf.VideoFormat <= 0) // auto select
    {

     conf.VideoFormat = FMT_RGB16;
    }

//    ReportDIVECaps(DIVE_BUFFER_SCREEN);
    video_header.format = conf.VideoFormat;

    switch(video_header.format)
    {
        case FMT_RGB16:
            fccColorFormat = FOURCC_R565;
            video_header.format_bpp = 2;
            break;

        case FMT_BGR24:
            fccColorFormat = FOURCC_BGR3;
            video_header.format_bpp = 3;
        break;

        case FMT_YUV422:
            fccColorFormat = FOURCC_Y422;
            video_header.format_bpp = 2;
        break;
    }

//    printf(" video format %u\n",conf.VideoFormat);fflush(stdout);
    if (video_init(sh_video, sh_video->codec->codec_type) != 0)
    {
        if (DART.DeviceID > 0) dart_close(); // we MUST close DART !!
        return FALSE;
    }
//    printf("Init video ok\n");fflush(stdout);
    // DIVE Output video frame format
    // FIXME !!! 
    WindowWidth = (sh_video->disp_w + 15) &~ 15;
    WindowHeight = sh_video->disp_h;
   if (conf.UseHWVIDEO)
      {
    if (HWVIDEOInit() == 0)
          HWVIDEOPresent = TRUE;
    else
    {
        HWVIDEOPresent = FALSE;
        printf("error initing hwvideo\n");fflush(stdout);
    }
    if (HWVIDEOPresent)
    {
       VideoCaps.ulLength=sizeof(HWVIDEOCAPS);
       VideoCaps.ulNumColors=0;
       VideoCaps.fccColorType=NULL;
       HWVIDEOCaps(&VideoCaps);
       VideoCaps.fccColorType=(PULONG)malloc(VideoCaps.ulNumColors*4);
        if (HWVIDEOCaps(&VideoCaps) != 0)
        {
            printf("error querying hwvideo caps\n");fflush(stdout);
            HWVIDEOPresent = FALSE;
            HWVIDEOClose();
        }
       }
      diveInit(WindowWidth,WindowHeight,fccColorFormat,sh_video->aspect,2,FALSE);
      } // if (conf.UseHWVIDEO)
   else
    // try to initialize dive
    if (!diveInit(WindowWidth,WindowHeight,fccColorFormat,sh_video->aspect,2,TRUE))
    {
       if (DART.DeviceID > 0) dart_close(); // we MUST close DART !!
        printf("Error initing dive");fflush(stdout);
        return FALSE;
    }
//    printf("Init dive ok\n");fflush(stdout);
    // open show window
    if (!conf.isShowWindow)
        if (!add_show()) return FALSE;
        else measure_show(hWndShow, &skn->def_backgr);

    // set show window pos
    RECTL clr,frr;
    // calculate client from frame
    if (conf.IsOnTop) set_ontop(hWndShow,TRUE);
    get_coords(hWndShow,&conf.movx,&conf.movy,&conf.movcx, &conf.movcy);
    clr.xLeft=conf.movx;
    clr.yBottom=conf.movy;
    clr.xRight=clr.xLeft+conf.movcx;
    clr.yTop=clr.yBottom+conf.movcy;

//    printf("Calculate frame..\n");
//    printf("frame: %i,%i,%i,%i\n",clr.xLeft,clr.yBottom,clr.xRight,clr.yTop);
    //    fflush(stdout);
    // TEMP hack!!!!!
    Playing = TRUE;  Pause = FALSE;
    WinCalcFrameRect(hWndShow,&clr,TRUE);
    // calculate new frame size
    frr.xLeft=clr.xLeft;
    frr.yBottom=clr.yBottom;
    frr.xRight=clr.xLeft+WindowWidth;
    frr.yTop=clr.yBottom+WindowHeight;
//    printf("Calculate client..\n");
//    printf("client: %i,%i,%i,%i\n",frr.xLeft,frr.yBottom,frr.xRight,frr.yTop);
//    fflush(stdout);
    WinCalcFrameRect(hWndShow,&frr,FALSE);
//    printf("Set new window pos..\n");fflush(stdout);
    WinSetWindowPos (hWndShow, HWND_TOP,frr.xLeft, frr.yBottom, frr.xRight-frr.xLeft,frr.yTop-frr.yBottom, SWP_SIZE | SWP_MOVE | SWP_ACTIVATE |SWP_SHOW);
    //    printf("Refresh..\n");fflush(stdout);

    WinInvalidateRect(hWndShow,NULLHANDLE,TRUE);
    //    printf("Resizing dive buffer..\n");fflush(stdout);
    if (!conf.UseHWVIDEO)
    {
     if (!ResizeBuffer (di.BufferW, di.BufferH, di.BufferF))
     {
         printf("Error resizing dive buffer\n");
         fflush(stdout);
         if (DART.DeviceID > 0) dart_close(); // we MUST close DART !!
         play_finished(); // inform main window
        return FALSE;
     }
     SetupBlitter (NULL);
    }
  di.DirtyRect.xLeft = 0;
  di.DirtyRect.xRight = di.WindowW;
  di.DirtyRect.yBottom = 0;
  di.DirtyRect.yTop = di.WindowH;

//  printf("Setuping blitter..\n");fflush(stdout);
//  SetupBlitter (NULL);
//  printf("Blitter setup ok..\n");fflush(stdout);
  WinSetVisibleRegionNotify (hWndShowClient, TRUE);
//  printf("Set gamma..\n");fflush(stdout);
  yuv2rgb_set_gamma(conf.Bright);

  Shutdown = 0; // we will not shutdown now!!! we wonna play!
//  printf("Set pause..\n");fflush(stdout);
  setPause(FALSE); // full speed ahead!!
//  printf("Creating video thread..\n");fflush(stdout);
  set_volume(conf.volume);
  reset_clock(&skn->dclock,FALSE); // set to ticker
  if (conf.FullScreen) fullScreen(TRUE);

  // save old running string and put file name
  set_new_text(&skn->vidname, ppl->fName, rs_save);
  //, moving to last saved pos

  if (conf.ToLastPos && (conf.LastPos < ppl->ntime) && (strcmpi(conf.mediafile,ppl->fName) == 0))
      {
     Seeking=TRUE;
     dem_flag = 1; // absolute seek
     new_dem_pos=conf.LastPos;
  }
//  pause_play();
  // create audio thread
    pipe_create();
    rc=DosCreateThread(&AudioThread,
                   (PFNTHREAD) PlayAudio,
                       0, 0L, 32767L);
// printf("Creating audio thread..\n");fflush(stdout);
// create video thread
    rc=DosCreateThread(&VideoThread,
                   (PFNTHREAD) PlayVideo,
                       0, 0L, 32767L);
//    printf("Exiting..\n");fflush(stdout);
    Playing = TRUE;  Pause = FALSE;
//    WinPostMsg(hWndShow,WM_WINDOWPOSCHANGED,0L,0L);
       set_button_state(&skn->play_butt, MBS_RELEASED,TRUE); // show pause
       set_button_state(&skn->stop_butt, MBS_RELEASED,FALSE); // show stop
       set_button_state(&skn->fb_butt, MBS_RELEASED,TRUE); // show stop
       set_button_state(&skn->ff_butt, MBS_RELEASED,TRUE); // show stop
       set_button_state(&skn->beg_butt, MBS_RELEASED,TRUE); // show stop
       set_button_state(&skn->end_butt, MBS_RELEASED,TRUE); // show stop
       set_button_state(&skn->max_butt, MBS_RELEASED,TRUE); // show stop
       set_slider_range(&skn->video_sld,0,ppl->ntime); // set range for movie
       set_button_state(&skn->sound_butt, MBS_RELEASED,TRUE); // disable sound button
//       printf("cache handler=%i\n",cache_h);
//       fflush(stdout);

    return TRUE;
}

void release_all()
{
    pipe_close();
    fullScreen(FALSE);
    if (DART.DeviceID > 0)
    {
        dart_close(); // THEN stop sound
        DART.DeviceID = 0;
        DART.MixBuffers = NULL;
        DART.InputCallback = NULL;
        DART.BufferCount = 0;
    }
    if (conf.UseHWVIDEO && HWVIDEOPresent) HWVIDEOClose();
    WinSetVisibleRegionNotify( hWndShowClient, FALSE);
    if (di.hDive) { // dive opened and allocated
     DiveSetupBlitter(di.hDive,NULL);
      for (int i = 0; i <= di.nBuffers; i++)
         {
           DiveFreeImageBuffer (di.hDive, di.hBuffer[i]);
          }
       DiveClose(di.hDive);
       di.hDive=NULL;
    }
    memset(&di,0, sizeof(diveInfo));
//    cache_close(cache->handle);
//    close_av();
//    audio_close();
//    if (demuxerM) free_demuxer(demuxerM);
    if (streamM) close_stream(streamM); // ᢮ ⮪
    DosCloseMutexSem(demux_mtx);
    DosCloseMutexSem(dart_cb_mtx);
    Pause = FALSE;
    set_button_state(&skn->stop_butt, MBS_RELEASED,TRUE); // show eject
    set_button_state(&skn->fb_butt, MBS_DISABLED,TRUE); // show stop
    set_button_state(&skn->ff_butt, MBS_DISABLED,TRUE); // show stop
    set_button_state(&skn->beg_butt, MBS_DISABLED,TRUE); // show stop
    set_button_state(&skn->end_butt, MBS_DISABLED,TRUE); // show stop
    set_button_state(&skn->max_butt, MBS_DISABLED,TRUE); // show stop
    set_button_state(&skn->sound_butt, MBS_DISABLED,TRUE); // disable sound button
    reset_clock(&skn->dclock,TRUE); // set to clock
    // restore running string
    set_new_text(&skn->vidname, rs_save, NULL);
    // check if play list is not empty
    if (playLst == NULL) set_button_state(&skn->play_butt, MBS_DISABLED,FALSE);
    else set_button_state(&skn->play_butt, MBS_RELEASED,FALSE);
    conf.LastPos = video_time;
    save_ini();
    play_finished(); // inform main window
    DosSetPriority(PRTYS_PROCESS, 2, 0, PRTYS_PROCESSTREE);
}

void stop_play()
{
    Shutdown = TRUE;
    release_all(); // release all catched stuff
    Playing = FALSE; // set flag that all free
}

void pause_play(void)
{
    DosRequestMutexSem(dart_cb_mtx, (ULONG)SEM_INDEFINITE_WAIT);
    Pause = TRUE;
    set_button_state(&skn->play_butt, MBS_RELEASED,FALSE); // show play
    dart_pause();
    setPause(Pause);
    DosReleaseMutexSem(dart_cb_mtx);
}

void resume_play(void)
{
    Pause = FALSE;
    set_button_state(&skn->play_butt, MBS_RELEASED,TRUE); // show pause
    dart_resume();
    setPause(Pause);
}
void play_finished(void) //notify control window that we are finished play
{
    WinPostMsg(hWndClient,WM_COMMAND,MPFROM2SHORT(CNTRL_FINISH,0L),MPFROMLONG(1L));
 }

ULONG mem_avail()
{
 ULONG   aulSysInfo[QSV_MAX] = {0};       /* System Information Data Buffer */
 APIRET  rc                  = NO_ERROR;  /* Return code                    */

  rc = DosQuerySysInfo(1L,                 /* Request all available system   */
                       QSV_MAX,            /* information                    */
                       (PVOID)aulSysInfo,
                       sizeof(ULONG)*QSV_MAX);

  return aulSysInfo[QSV_MAXPRMEM-1];
 }
