/*
 * WarpVision GUI dive library
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

static long MAX_PHYS_COLORS = -1;
static bool DEVICE_HAS_PALETTE = FALSE;
//RECTL r,r1;


BOOL ifDive() { // is DIVE exist?
  if (DiveOpen (&di.hDive, FALSE, NULL) != DIVE_SUCCESS) return FALSE;
    return TRUE;
}


void ReportDIVECaps( int which )
{
  DIVE_CAPS cap;
  char buffer[512];
  int i, j;
  typedef unsigned char uchar;

  typedef uchar *puchar;

  char *str;

  cap.ulStructLen = sizeof( DIVE_CAPS );
  cap.ulFormatLength = 512;
  cap.pFormatData = buffer;
  cap.ulPlaneCount = 0;
  DiveQueryCaps( &cap, which );

    printf( "\nDive capabilities-\n=> Number of planes: %ld\n=> Screen direct access: %d\n=> Bank switched operations required: %d\n=> Bits per pixel: %ld\n=> Screen width: %ld\n=> Screen height: %ld\n=> Screen scan line length: %ld\n=> Color encoding: %c%c%c%c\n=> VRAM aperture size: %ld\n",
     cap.ulPlaneCount, cap.fScreenDirect, cap.fBankSwitched, cap.ulDepth,
     cap.ulHorizontalResolution, cap.ulVerticalResolution, cap.ulScanLineBytes,
     cap.fccColorEncoding&0xff, (cap.fccColorEncoding>>8)&0xff,
     (cap.fccColorEncoding>>16)&0xff, (cap.fccColorEncoding>>24)&0xff,
     cap.ulApertureSize, cap.ulInputFormats );

//  mglclient.desktopdepth = cap.ulDepth;
//  mglclient.desktopscan = cap.ulScanLineBytes / (cap.ulDepth>>3);
//  mglclient.desktopheight = cap.ulVerticalResolution;

    printf( "=> Input formats: " );
    for (i = 0; i < cap.ulInputFormats; i++)
    {
     FOURCC fcc = ((FOURCC *) cap.pFormatData)[i];
     str = (char*)&fcc;
     printf( "%c%c%c%c ", str[0], str[1], str[2], str[3] );


    }

    printf(  "\n=> Output formats: " );

    for ( i=0; i<cap.ulOutputFormats; ++i )
    {
      str = (char*)cap.pFormatData + (i*4);
      printf( "%c%c%c%c ", str[0], str[1], str[2], str[3] );
    }

    printf( "\n\n" );

  if ( cap.fScreenDirect && !cap.fBankSwitched )
  {
//    mglclient.allowcustomblitter = 1;
  }
}

// shit or somthg
void myCalcFrame(long PicW, long PicH, long WinW, long WinH, long *OutW, long *OutH)
{
    ULONG Koeff;

    Koeff = (PicW * 1000) / (PicH);

    *OutW = WinW;
    *OutH = (WinW * 1000) / Koeff;

    if (*OutH > WinH)
    {
        *OutW = (WinH * Koeff) / 1000;
        *OutH = WinH;
    }

    return;
}

unsigned char *diveBeginPaint (ULONG * BytesPerLine, long BufferNo)
{
  unsigned char *buff;
  ULONG TotalLines;
  if (di.fPause)
  {
      DosSleep (1);
      WinInvalidateRect (hWndShowClient, NULL, TRUE);
    return NULL;
  }

  if (BufferNo == DIVE_NEXTBUFFER)
  {
    di.ActiveBuffer++;
    if (di.ActiveBuffer >= di.nBuffers)
      di.ActiveBuffer = 0;
  } else
    di.ActiveBuffer = BufferNo;
  if (DiveBeginImageBufferAccess (di.hDive, di.hBuffer[di.ActiveBuffer],
      (PBYTE *)&buff, BytesPerLine, &TotalLines) != DIVE_SUCCESS)
    return (NULL);
  return (buff);
}

void diveEndPaint ()
{
  DiveEndImageBufferAccess (di.hDive, di.hBuffer[di.ActiveBuffer]);
}

bool SetupBlitter (HPS hps)
{
  HPS shps; // hps for setup blitter
  POINTL pointl;
  SWP swp;
//  RECTL r,r1;
  ULONG h,w;
  ULONG koef;

   shps = hps;
   if (!hWndShowClient) return TRUE;
   // Don`t setup blitter when minimized
 if ((di.oldDirtyRect.xLeft == di.DirtyRect.xLeft)
    && (di.oldDirtyRect.xRight == di.DirtyRect.xRight)
    && (di.oldDirtyRect.yTop == di.DirtyRect.yTop)
    && (di.oldDirtyRect.yBottom == di.DirtyRect.yBottom))
    return TRUE;                        // Blitter already set up

  di.oldDirtyRect.xLeft = di.DirtyRect.xLeft;
  di.oldDirtyRect.xRight = di.DirtyRect.xRight;
  di.oldDirtyRect.yBottom = di.DirtyRect.yBottom;
  di.oldDirtyRect.yTop = di.DirtyRect.yTop;

  //
 if (hps == NULL)   shps = WinGetPS (hWndShowClient); // has no input hps, get own

 HRGN hrgn = GpiCreateRegion (shps, 0, NULL);


  WinQueryVisibleRegion (hWndShowClient, hrgn);

  // First, get the rectangles and window coordinates:
  RECTL rctls[50];                     // Rectangles for visible rgn
  RGNRECT rgnCtl;                       // Region control struct
  SETUP_BLITTER SetupBlitter;           // DiveSetupBlitter struct

  // Get rectangles for the visible region
  rgnCtl.ircStart = 0;                  // Enumerate rectangles
  rgnCtl.crc = sizeof (rctls) / sizeof (RECTL); // Max number of rectangles
  rgnCtl.ulDirection = 1L;
  if (GpiQueryRegionRects (shps, hrgn, NULL, &rgnCtl, rctls))
  {
    // Now goes the tricky part: scan all rectangles returned by
    // GpiQueryRegionRects and intersect them with DirtyRect. This way,
    // we'll get updated only the part of screen that has been changed.
/*    for (int i = rgnCtl.crcReturned - 1; i >= 0; i--)
    {
      if (di.DirtyRect.xLeft > rctls[i].xLeft)
        rctls[i].xLeft = di.DirtyRect.xLeft;
      if (di.DirtyRect.xRight < rctls[i].xRight)
        rctls[i].xRight = di.DirtyRect.xRight;
      if (di.DirtyRect.yBottom > rctls[i].yBottom)
        rctls[i].yBottom = di.DirtyRect.yBottom;
      if (di.DirtyRect.yTop < rctls[i].yTop)
        rctls[i].yTop = di.DirtyRect.yTop;

      if ((rctls[i].xLeft >= rctls[i].xRight)
        || (rctls[i].yBottom >= rctls[i].yTop))
      {
        // the rectangle became empty: we should remove it from the list
        rgnCtl.crcReturned--;
        memmove (&rctls[i], &rctls[i + 1], (rgnCtl.crcReturned - i) * sizeof (RECTL));
      }                                 // endif
      }                                   // endfor
*/
      if (di.fFullScreen)
      {
        WinFillRect(shps, &r, CLR_BLACK);
        WinFillRect(shps, &r1, CLR_BLACK);
      }

    // Find the window position relative to its parent.

      // Tell DIVE about the new settings.
//      printf("w: %ix%i,f %ix%i, cl %ix%i\n",di.WindowW,di.WindowH,di.FrameW,
//            di.FrameH,swp.cx,swp.cy);
//      fflush(stdout);
    SetupBlitter.ulStructLen = sizeof (SETUP_BLITTER);
    SetupBlitter.fInvert = 0;
    SetupBlitter.fccSrcColorFormat = di.BufferF;
    SetupBlitter.ulSrcPosX = 0;
    SetupBlitter.ulSrcPosY = 0;
    SetupBlitter.ulSrcWidth = di.BufferW;
    SetupBlitter.ulSrcHeight = di.BufferH;
    SetupBlitter.ulDitherType = 1; // dithering on
    SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
//    SetupBlitter.ulDstWidth = w;
//    SetupBlitter.ulDstHeight = h;
        // swp.cy;
    SetupBlitter.ulDstWidth = di.rect.cx;
    SetupBlitter.ulDstHeight = di.rect.cy;
    SetupBlitter.lDstPosX = 0;
    SetupBlitter.lDstPosY = 0;
    SetupBlitter.lScreenPosX = di.rect.x;
    SetupBlitter.lScreenPosY = di.rect.y;
    SetupBlitter.ulNumDstRects = rgnCtl.crcReturned;
//    printf("rgns: %i \n",rgnCtl.crcReturned);
//    fflush(stdout);
    SetupBlitter.pVisDstRects = rctls;
    DiveSetupBlitter (di.hDive, &SetupBlitter);
  } else
  {
      DiveSetupBlitter (di.hDive, NULL);
  }
    GpiDestroyRegion (shps, hrgn);
  if (hps == NULL) WinReleasePS (shps); // release own hps
//  GpiDestroyRegion (shps, hrgn);
  return TRUE;
}

bool diveInit(long Width, long Height, FOURCC Format, float aspect, long nBuff, BOOL doopen)
{
  di.CLUT = NULL;
  di.hDive = NULLHANDLE;
  di.fFullScreen = FALSE;
  di.fMinimized = FALSE;
  di.fPhysCLUT = FALSE;
  di.fAspect = TRUE;
  di.fPause = TRUE;
  di.fMouseVisible = TRUE;
  di.MouseCursorID = SPTR_ARROW;
  di.FailedCount = 0;
  di.ActiveBuffer = 0;
  di.VisibleBuffer = 0;
  di.MouseButtonMask = 0;
  di.MouseCaptured = FALSE;
  di.nBuffers = nBuff;
  di.BufferW = Width;
  di.BufferH = Height;
  di.BufferF = Format;
  di.AspectRatio = (float)Width/(float)Height;
      // aspect;
  di.ScreenW = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
  di.ScreenH = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);
  for (int i = 0; i < DIVE_MAXBUFFERS; i++)
    di.hBuffer[i] = NULLHANDLE;
  di.DirtyRect.xLeft = 1;
  di.DirtyRect.xRight = -1;
  di.recalcX=di.recalcY=FALSE; //
  if (doopen) // open dive exept just init variables
  {
         if (nBuff > DIVE_MAXBUFFERS || nBuff < 1)
            {
            return FALSE;
           }
           if (MAX_PHYS_COLORS == -1)            // Query physical screen parameters
            {
             HPS hps = WinGetScreenPS (HWND_DESKTOP);
             HDC hdc = GpiQueryDevice (hps);
             DevQueryCaps (hdc, CAPS_PHYS_COLORS, 1L, &MAX_PHYS_COLORS);
             DevQueryCaps (hdc, CAPS_ADDITIONAL_GRAPHICS, 1L, (LONG *) & DEVICE_HAS_PALETTE);
             DEVICE_HAS_PALETTE =  DEVICE_HAS_PALETTE && CAPS_PALETTE_MANAGER;
             WinReleasePS (hps);
             }
             if (DiveOpen (&di.hDive, FALSE, NULL) != DIVE_SUCCESS)
             {
              return FALSE;
              }
  } // if doopen
  return TRUE;
}

  /// Repaint DIVE buffer
 inline void bufSwitch (long BufferNo)
  {
    ULONG Count;
//    DosResetEventSem (sRedrawComplete, &Count);
    di.VisibleBuffer = (BufferNo == DIVE_NEXTBUFFER) ? di.ActiveBuffer : BufferNo;
    WinInvalidateRect (hWndShowClient, NULL, TRUE);
//    WinInvalidateRect (tb, NULL, FALSE);
  }

  /// Wait until buffer redraw is complete. Recommended before calling Switch()
  inline void WaitSwitch ()
  {
  //  DosWaitEventSem (sRedrawComplete, 1000);
  }

bool ResizeBuffer (long Width, long Height, FOURCC Format)
{
  SWP swp;
  int i;
  ULONG diverc;
  ULONG tl,bpl;
  // Free image buffers
  for (i = 0; i < DIVE_MAXBUFFERS; i++)
      DiveFreeImageBuffer(di.hDive, di.hBuffer[i]);

//  myCalcFrame(Width, Height, di.WindowW, di.WindowH, &di.FrameW, &di.FrameH);

  // Allocate image buffers
  di.BufferW = Width;
  di.BufferH = Height;
  di.BufferF = Format;
  for (i = 0; i < di.nBuffers; i++)
  {
    diverc=DiveAllocImageBuffer (di.hDive, &di.hBuffer[i], di.BufferF,
                                 di.BufferW, di.BufferH, 0, NULL);
//    printf("alloc buf no: %i\n",di.hBuffer[i]);
  }
       if (diverc!= DIVE_SUCCESS)
    {
      for (i--; i >= 0; i--)
          DiveFreeImageBuffer (di.hDive, di.hBuffer[i]);
      printf("dive allocate buffer error: %u\n",diverc);

      return FALSE;
    }

       //  WinQueryWindowPos (hWndShowClient, &swp);
       // query buffers adresses
/*       tl = 100;
       bpl = 1;
  for (i = 0; i < di.nBuffers; i++)
  {
    if (DiveBeginImageBufferAccess (di.hDive, di.hBuffer[i],
      (PBYTE *)&di.bufs[i], bpl, &tl) == DIVE_SUCCESS)
     DiveEndImageBufferAccess (di.hDive, di.hBuffer[i]);
     } */
  SetupBlitter (NULL);

  di.DirtyRect.xLeft = 0;
  di.DirtyRect.xRight = di.WindowW;
  di.DirtyRect.yBottom = 0;
  di.DirtyRect.yTop = di.WindowH;
  di.oldDirtyRect.xLeft = -9999;

//  SetupBlitter (NULL);
  return TRUE;
}
void setPause(BOOL state)
{
    di.fPause = state;
 }

int GetBestDIVEMode(void)
{
    DIVE_CAPS caps;
    FOURCC fourcc;
    char *caps_buffer;
    int i, best_format;

    caps_buffer = (char *)malloc(512);
    caps.ulStructLen = sizeof(DIVE_CAPS);
    caps.ulFormatLength = 512;
    caps.pFormatData = caps_buffer;
    caps.ulPlaneCount = 0;

    DiveQueryCaps(&caps, DIVE_BUFFER_SCREEN);

    best_format = -1;

#if 0
    for (i = 0; i < caps.ulInputFormats; i++)
    {
        fourcc = ((FOURCC *) caps.pFormatData)[i];
        printf("%.4s ", (char*)&fourcc);
    }

    printf("\n");
    fflush(stdout);
#endif

    for (i = 0; i < caps.ulInputFormats; i++)
    {
        fourcc = ((FOURCC *) caps.pFormatData)[i];

        if (strnicmp((char*)&fourcc, "Y422", 4) == 0)
        {
            best_format = FMT_YUV422;

            break;
        }

        if (strnicmp((char*)&fourcc, "R565", 4) == 0)
        {
            best_format = FMT_RGB16;

            break;
        }

        if (strnicmp((char*)&fourcc, "BGR3", 4) == 0)
        {
            best_format = FMT_BGR24;

            break;
        }
    }

    free(caps_buffer);

    return best_format;
}

void MouseVisible (bool State)
{
  di.fMouseVisible = State;
  /* Send a pseudo mouse-move message to get mouse pointer updated */
  POINTL mouse;
  WinQueryPointerPos (HWND_DESKTOP, &mouse);
  WinMapWindowPoints (HWND_DESKTOP, hWndShowClient, &mouse, 1);
  RECTL winpos;
  WinQueryWindowRect (hWndShowClient, &winpos);
  if ((mouse.x >= winpos.xLeft) && (mouse.x < winpos.xRight)
   && (mouse.y >= winpos.yBottom) && (mouse.y < winpos.yTop))
    WinPostMsg (hWndShowClient, WM_MOUSEMOVE, MPFROM2SHORT (mouse.x, mouse.y),
      MPFROM2SHORT (HT_NORMAL, KC_NONE));
}
