/*
 * WarpVision GUI config structure
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

typedef struct {
char skinpath[_MAX_PATH]; // last opened skin path
char skinfile[_MAX_PATH]; // last opened skin file
char mediafile[_MAX_PATH]; // last opened media file
char mediapath[_MAX_PATH]; // last opened media path
char playlstfile[_MAX_PATH]; // last playlist file
char exts[128]; // user defined extentions
int ctlx,ctly; // control window position
int movx,movy; // movie window position
int movcx,movcy; // movie window size
int playlx,playly; // movie window position
int playlcx,playlcy; // movie window size
ULONG volume; // last sound volume
BOOL DartShare; // share dart?
BOOL isShowWindow; // show output window at startup and leave it after stop play
int AudioDeviceIndex;
int AudioResampleFlag;
int AudioID;
int VideoID;
int VideoFormat;
int AudioDisable;
int KeepAspect;
int Bright;
int Check; // check media before playing
int priClass; // priority class time critical
int priDelta; // priority delta minimal
BOOL FullScreen;
BOOL IsSound;
BOOL IsOnTop;
float LastPos;
BOOL ToLastPos; // should I go to last pos?
BOOL UseHWVIDEO;
BOOL LoadLastPlaylist;
int ForceAspect;
// playlist items widths
int w_fps,w_abr,w_freq,w_acod,w_vcod,w_res,w_time,w_file,w_status;
} Config; // config parameters, saved in ini-file
