/*
 * WarpVision GUI clock
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

BOOL ClockRegister(HAB hab) {
    CLASSINFO ci;
   if (WinQueryClassInfo(hab, WC_STATIC, &ci)) {
      // store the default class procedure in the global variables
      pfnWcStatic = ci.pfnWindowProc;
      cbWcStatic = ci.cbWindowData;

   return (BOOL)WinRegisterClass(hab, WC_DCLOCK, ClockProc,
                              ci.flClassStyle & ~CS_PUBLIC,
                           ci.cbWindowData + sizeof(PVOID));
   }
   return FALSE;
}

void measure_clock(PSKN_CLK c)
{
  WinSetWindowPos (c->hWnd, HWND_TOP,c->x, c->y, c->width, c->heigth, SWP_SIZE  | SWP_MOVE );
 return;
    }


void add_clock(HWND parent, PSKN_CLK pclk)
 {
       pclk->hWnd = WinCreateWindow (parent, WC_DCLOCK,
        "", WS_VISIBLE , pclk->x, pclk->y, pclk->width, pclk->heigth, parent, HWND_TOP , pclk->id, NULL, NULL);
        WinSetWindowPtr(pclk->hWnd,QWL_USER, pclk);
       return;
    }

void redraw_clock(HPS hps, PSKN_CLK pclk)
{
    POINTL ptl;
    RECTL rcl;
    ptl.x=0;
    ptl.y=0;;

    PDATETIME pdt=&pclk->datetime;
    // 㥬 䮭
    WinDrawBitmap(hps,pclk->backgr, NULL, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);

//    㥬 ⪨ ᮢ
    rcl.xLeft=pdt->hours/10*pclk->dig_w;
    rcl.xRight=(pdt->hours/10+1)*pclk->dig_w;
     rcl.yTop=pclk->dig_h;
     rcl.yBottom=0;
     ptl.x=pclk->dig_xh1;
     ptl.y=pclk->dig_y;
     WinDrawBitmap(hps,pclk->digits, &rcl, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);
//    㥬   ᮢ
    rcl.xLeft=pdt->hours%10*pclk->dig_w;
    rcl.xRight=(pdt->hours%10+1)*pclk->dig_w;
     rcl.yTop=pclk->dig_h;
     rcl.yBottom=0;
     ptl.x=pclk->dig_xh2;
     ptl.y=pclk->dig_y;
    WinDrawBitmap(hps,pclk->digits, &rcl, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);
//    㥬 ⪨ 
    rcl.xLeft=pdt->minutes/10*pclk->dig_w;
    rcl.xRight=(pdt->minutes/10+1)*pclk->dig_w;
     rcl.yTop=pclk->dig_h;
     rcl.yBottom=0;
     ptl.x=pclk->dig_xm1;
     ptl.y=pclk->dig_y;
    WinDrawBitmap(hps,pclk->digits, &rcl, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);
//    㥬  
    rcl.xLeft=pdt->minutes%10*pclk->dig_w;
    rcl.xRight=(pdt->minutes%10+1)*pclk->dig_w;
     rcl.yTop=pclk->dig_h;
     rcl.yBottom=0;
     ptl.x=pclk->dig_xm2;
     ptl.y=pclk->dig_y;
    WinDrawBitmap(hps,pclk->digits, &rcl, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);
//    㥬 ⪨ ᥪ㭤
    rcl.xLeft=pdt->seconds/10*pclk->dig_w;
    rcl.xRight=(pdt->seconds/10+1)*pclk->dig_w;
     rcl.yTop=pclk->dig_h;
     rcl.yBottom=0;
     ptl.x=pclk->dig_xs1;
     ptl.y=pclk->dig_y;
    WinDrawBitmap(hps,pclk->digits, &rcl, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);
//    㥬  ᥪ㭤
    rcl.xLeft=pdt->seconds%10*pclk->dig_w;
    rcl.xRight=(pdt->seconds%10+1)*pclk->dig_w;
     rcl.yTop=pclk->dig_h;
     rcl.yBottom=0;
     ptl.x=pclk->dig_xs2;
     ptl.y=pclk->dig_y;
    WinDrawBitmap(hps,pclk->digits, &rcl, &ptl,CLR_BACKGROUND, CLR_NEUTRAL, DBM_NORMAL);
  }

MRESULT EXPENTRY ClockProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
 {
 PSKN_CLK psknclk;
 HPS hpsb;
 RECTL rclb,rcl;
 POINTL ptl;
 DATETIME dt;
 PDATETIME pdt;

psknclk = (PSKN_CLK)WinQueryWindowPtr(hwnd,QWL_USER);


  switch (msg) {
  case WM_CREATE:
      {//   if (psknclk->isClock) {

          MRESULT r = WinDefWindowProc(hwnd,msg,mp1,mp2);
          WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, MID_TIMER, 1000);
          return r;

      }

  case WM_TIMER:
      {
          WinInvalidateRect(psknclk->hWnd, NULL, TRUE);
          return 0;
      }
       case WM_CONTEXTMENU:
           {
            WinSendMsg (WinQueryWindow (hwnd, QW_OWNER), WM_CONTROL,
                        MPFROM2SHORT (WinQueryWindowUShort(hwnd, QWS_ID),
                       WM_CONTEXTMENU), (MPARAM)0L);
         break;
           }

     case WM_PAINT:
         {
             hpsb = WinBeginPaint(hwnd, NULLHANDLE, NULL);
             if (psknclk->isClock) DosGetDateTime(&psknclk->datetime);
             redraw_clock(hpsb,psknclk);
        WinEndPaint(hpsb);
         return (MRESULT)FALSE;
         }
     case WM_BUTTON1DOWN:
         {
             WinSetFocus(HWND_DESKTOP,WinQueryWindow(hwnd,QW_OWNER)); // set focuse to owner
             break;
         }
     case WM_BUTTON1CLICK:
         {
             WinPostMsg(WinQueryWindow(hwnd,QW_OWNER),WM_COMMAND,MPFROMLONG(MCL_BUTTONCLICK),0L); // set focus to owner
             break;
         }
     case WM_BUTTON1DBLCLK:
         {
             WinPostMsg(WinQueryWindow(hwnd,QW_OWNER),WM_COMMAND,MPFROMLONG(MCL_BUTTONDBLCLK),0L); // set focus to owner
             break;
         }

  case WM_COMMAND: {
      switch(SHORT1FROMMP(mp1)) {
      case MCL_SETCLOCKALONE:
          {
              psknclk->isClock=TRUE;
//              WinStartTimer(WinQueryAnchorBlock(psknclk->hWnd), psknclk->hWnd, MID_TIMER, 1000);
              break;
           }
      case MCL_RESETCLOCK:
          {
          if ((BOOL)MPFROMLONG(mp2)) { // set to clock mode
              if (!psknclk->isClock)
              {
              psknclk->isClock=TRUE;
//              WinStartTimer(WinQueryAnchorBlock(psknclk->hWnd), psknclk->hWnd, MID_TIMER, 1000);
              }
          }
          else {
              if (psknclk->isClock)
              {
               psknclk->isClock=FALSE;
//               WinStopTimer(WinQueryAnchorBlock(psknclk->hWnd), psknclk->hWnd, MID_TIMER);
              }
           }
//             WinInvalidateRect(hwnd,0,FALSE);

          break;
          }
      case MCL_SETTIME:
          {
//              psknclk->isClock=FALSE;
//              WinStopTimer(WinQueryAnchorBlock(psknclk->hWnd), psknclk->hWnd, MID_TIMER);
//              pdt=(PDATETIME)MPFROMLONG(mp2);
//              WinInvalidateRect(hwnd,0,FALSE);
              break;}
      } //switch command
     break;
  }
  case WM_DESTROY:
      {
          WinStopTimer(WinQueryAnchorBlock(psknclk->hWnd), psknclk->hWnd, MID_TIMER);
          GpiDeleteBitmap(psknclk->backgr);
          GpiDeleteBitmap(psknclk->digits);
        break;
      }
     } // switch
  return 0;
      //pfnWcStatic(hwnd, msg, mp1, mp2);
    }

void set_clock(PSKN_CLK p,int sec)
{
    DATETIME d;
    div_t tt;
    tt=div(sec,3600); // calc hours
    d.hours=tt.quot;
    tt=div(tt.rem,60); // calc hours
    d.minutes=tt.quot;
    d.seconds=tt.rem;
    p->datetime=d;
// WinPostMsg(p->hWnd,WM_COMMAND,MPFROM2SHORT(MCL_SETTIME,0),MPFROMLONG(&d));
}

void reset_clock(PSKN_CLK p,BOOL st)
{
 WinPostMsg(p->hWnd,WM_COMMAND,MPFROM2SHORT(MCL_RESETCLOCK,0),MPFROMLONG(st));
}
