/*
 * WarpVision GUI button procedures
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

void measure_button(PSKN_BUTT b)
{
  WinSetWindowPos (b->hWnd, HWND_TOP,b->x, b->y, b->width, b->heigth, SWP_SIZE | SWP_MOVE);
 return;
}

void set_button_state(PSKN_BUTT b, USHORT nw, BOOL np)
{
    USHORT oldst;
    oldst = b->bstate;
    b->bstate=nw;
    // new set mouse state
    if ((oldst & MBS_MOUSEOVER) == MBS_MOUSEOVER)  // if mouse is over, then save it
        b->bstate = b->bstate | MBS_MOUSEOVER;
    if (b->butt_on1 && b->butt_off1 && b->butt_mouover1) // if button can be double pos
        b->dblpos = np;
 WinInvalidateRect(b->hWnd,NULLHANDLE,FALSE); // redraw button
 return;
 }

void add_button(HWND parent, PSKN_BUTT pskb)
 {
       pskb->hWnd = WinCreateWindow (parent, WC_BUTTON ,
        "", WS_VISIBLE , // BS_NOCURSORSELECT,// | BS_NOPOINTERFOCUS,
                                     0, 0, 0, 0, parent, HWND_TOP , pskb->id, NULL, NULL);
        WinSetWindowPtr(pskb->hWnd,QWL_USER, pskb);
        pskb->oldButtonProc = WinSubclassWindow(pskb->hWnd, (PFNWP)newButtonProc);
       return;
    }

void redraw_button(HPS hps, PSKN_BUTT pbtn)
 {
    HBITMAP hBm;
    HBITMAP oldbmp;
    DEVOPENSTRUC dop = { 0L, "DISPLAY", NULL, 0L,0L, 0L, 0L, 0L, 0L };
    POINTL              pts[3];
    HPS                 memdc;
    HPS                 tmp_ps;
    HDC                 hdc;
    HAB                 hab;
    SIZEL               sizl = { 0, 0 };
    USHORT   ptsn;
    USHORT   st1;

    hab = WinQueryAnchorBlock(pbtn->hWnd );
    hdc = DevOpenDC( hab, OD_MEMORY, "*", 5L,(PDEVOPENDATA)&dop, NULLHANDLE );
    memdc = GpiCreatePS( hab, hdc, &sizl, PU_PELS | GPIA_ASSOC );
    ptsn = 3;
    // ᥣ 㥬  ⬠
    pts[2].x = 0;
    pts[2].y = 0;
// 㥬 䮭
    pts[0].x = 0;
    pts[0].y = 0;
    pts[1].x = pbtn->width;
    pts[1].y = pbtn->heigth;

       st1 = pbtn->bstate;
       st1 &= ~MBS_MOUSEOVER;
       if (st1 != MBS_DISABLED) {
             switch (st1) {
             case MBS_PRESSED: {
                 if (!pbtn->dblpos) hBm = pbtn->butt_on;
                     else hBm = pbtn->butt_on1;
                 break; }
             case MBS_RELEASED: {
                 if (!pbtn->dblpos)
                     hBm = pbtn->butt_off;
                 else hBm = pbtn->butt_off1;
                 break; }
//             case MBS_DISABLED: {hBm = pbtn->butt_dis; break; }
             }
             if ((pbtn->bstate & MBS_MOUSEOVER) == MBS_MOUSEOVER) {
                 if (!pbtn->dblpos) hBm = pbtn->butt_mouover;
                 else hBm = pbtn->butt_mouover1;
             }
       } // if mbs_disabled
       else hBm = pbtn->butt_dis;

    oldbmp = GpiSetBitmap( memdc, hBm );
    GpiBitBlt( hps, memdc, ptsn, pts, ROP_SRCCOPY, BBO_IGNORE );
    GpiSetBitmap( memdc, oldbmp );
    GpiDestroyPS( memdc );
    DevCloseDC( hdc );

 }

MRESULT EXPENTRY newButtonProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
 {
 PSKN_BUTT psknbtn;
 HPS hpsb;
 RECTL rclb,rcl;
 POINTL ptl;
 int now_x,newpos;
 USHORT st;
// WinSetAccelTable (WinQueryAnchorBlock (hwnd), NULLHANDLE, NULLHANDLE);

psknbtn = (PSKN_BUTT)WinQueryWindowPtr(hwnd,QWL_USER);

// st =
  switch (msg) {
  case WM_TIMER:
      {
          if (psknbtn->isHelp) {
              WinDestroyWindow(bhhwnd);
//              psknbtn->isHelp = FALSE;
          } else {
              startbubblehelp(psknbtn->hWnd,psknbtn->help);
              psknbtn->isHelp = TRUE;
          }
          WinStartTimer(hab,psknbtn->hWnd,BH_TIMER,1500L);
                 break;
       }
     case WM_PAINT:
         {
        hpsb = WinBeginPaint(hwnd, NULLHANDLE, NULL);
        redraw_button(hpsb,psknbtn);
        WinEndPaint(hpsb);
         return (MRESULT)FALSE;
         //         return(oldSliderProc(hwnd, msg, mp1, mp2));
         }
       case WM_CONTEXTMENU:
           {
            WinSendMsg (WinQueryWindow (hwnd, QW_OWNER), WM_CONTROL,
                        MPFROM2SHORT (WinQueryWindowUShort(hwnd, QWS_ID),
                       WM_CONTEXTMENU), (MPARAM)0L);
         break;
           }

  case WM_BUTTON1MOTIONSTART:
//  case WM_BUTTON2MOTIONSTART:
      {
          if ((psknbtn->bstate == MBS_PRESSED) && !psknbtn->latch)
          {
//              psknbtn->bstate = MBS_RELEASED;
//              WinInvalidateRect(hwnd,0,FALSE);
            }
          break;
       }

     case WM_BUTTON1CLICK:
//     case WM_BUTTON1DBLCLK:
//     case WM_BUTTON2CLICK:
//     case WM_BUTTON2DBLCLK:
         {

             st = psknbtn->bstate;
             st &= ~MBS_MOUSEOVER;

    //  ࠡ   ⥫   ॠ㥬
             if ((psknbtn->bstate & MBS_DISABLED) == MBS_DISABLED || !psknbtn->latch) return (MRESULT)TRUE;;
             switch(st) {
             case MBS_RELEASED:
//             case MBS_MOUSEOVER:
                 {psknbtn->bstate = MBS_PRESSED; break;}
             case MBS_PRESSED: {
                 psknbtn->bstate = MBS_RELEASED | MBS_MOUSEOVER; break;}
             }
            WinInvalidateRect(hwnd,0,FALSE);
      return (MRESULT)TRUE;
       }
     case WM_BUTTON1DOWN:
//     case WM_BUTTON2DOWN:
          WinSetFocus(HWND_DESKTOP,WinQueryWindow(hwnd,QW_OWNER)); // set focuse to owner
     case WM_BUTTON1DBLCLK:
//     case WM_BUTTON2DBLCLK:
         {
          st = psknbtn->bstate;
          st &= ~MBS_MOUSEOVER;

          //  ࠡ  ⥫   ॠ㥬
          if ((psknbtn->bstate & MBS_DISABLED) == MBS_DISABLED || psknbtn->latch) return (MRESULT)TRUE;;
        switch(st) {
        case MBS_RELEASED:
//        case MBS_MOUSEOVER:
            { psknbtn->bstate = st = MBS_PRESSED; break;}
        } // switch buttons.state
             WinPostMsg(WinQueryWindow(hwnd,QW_OWNER), WM_CONTROL,
      MPFROM2SHORT(WinQueryWindowUShort(hwnd,QWS_ID),NBM_BSCHANGED),
      MPFROMSHORT(st));
        WinInvalidateRect(hwnd,0,FALSE);
        mbp = TRUE; // button is pressed
        return (MRESULT)TRUE;;
       }
     case WM_BUTTON1UP:
//     case WM_BUTTON2UP:
         {
        if ((psknbtn->bstate & MBS_DISABLED) == MBS_DISABLED) return (MRESULT)TRUE;;
             if (!psknbtn->latch) { // ᫨   ⥫쭠 - ᪠
                 psknbtn->bstate = MBS_RELEASED | MBS_MOUSEOVER;
                 // 饫 ਣ஬, ᫨ ᠩ ⨫ ਣ묨 ⬠
                 if (psknbtn->butt_on1 && psknbtn->butt_off1 && psknbtn->butt_mouover1) psknbtn->dblpos = !psknbtn->dblpos;
             }
             st = psknbtn->bstate;
             st &= ~MBS_MOUSEOVER;
       WinInvalidateRect(hwnd,0,FALSE);
      WinPostMsg(WinQueryWindow(hwnd,QW_OWNER), WM_CONTROL,
      MPFROM2SHORT(WinQueryWindowUShort(hwnd,QWS_ID),NBM_BSCHANGED),
                 MPFROMSHORT(st));
             mbp = FALSE; // button is released
             break;
         }
  case WM_MOUSEMOVE:
      {
//       if (psknbtn->isHelp) {
//           WinDestroyWindow(bhhwnd);
//           psknbtn->isHelp = FALSE; }
//          WinStartTimer(hab,hwnd,BH_TIMER,1000L);
        break;

             }
  case WM_MOUSEENTER:
      {
          if ((psknbtn->bstate & MBS_DISABLED) != MBS_DISABLED) {
          if (mbp && !psknbtn->latch)
          {   // ૨  ⮩ 
              psknbtn->bstate = MBS_PRESSED;
              WinInvalidateRect(hwnd,0,FALSE);
           }
          switch (psknbtn->bstate)
          {
          case MBS_RELEASED:
              {
              psknbtn->bstate = psknbtn->bstate | MBS_MOUSEOVER;
              WinInvalidateRect(hwnd,0,FALSE);
              break;
              }
            }
          }
            if (!WinStartTimer(hab,psknbtn->hWnd,BH_TIMER,1500L)) DosBeep(2000,100);;
            break;
      }
  case WM_MOUSEEXIT:
      {
          // ᨬ 㡫 奫
          if (psknbtn->isHelp) {
              WinDestroyWindow(bhhwnd);
              psknbtn->isHelp = FALSE;
          }
          WinStopTimer(hab,psknbtn->hWnd,BH_TIMER);
        if ((psknbtn->bstate & MBS_DISABLED) != MBS_DISABLED) {
          if (!psknbtn->latch) psknbtn->bstate = MBS_RELEASED;

          if ((psknbtn->bstate & MBS_MOUSEOVER) == MBS_MOUSEOVER)
              psknbtn->bstate = MBS_RELEASED;
            WinInvalidateRect(hwnd,0,FALSE);
          }
            break;
      }

             //         return (MRESULT)TRUE;
//             break;
//      }
     case WM_CHAR: //  ⥫   
         {

            switch(CHARMSG(&msg)->vkey) {
              case VK_LEFT:
              case VK_UP:
                  {
//        if (psknsld->arm_pos == 1) return (MRESULT)TRUE; // ⨯  ⮢ 祭
//        psknsld->arm_pos--;
        WinQueryWindowRect(hwnd,&rclb);
        WinInvalidateRect(hwnd,&rclb,FALSE);

                      return (MRESULT)TRUE;
                  }
            default: psknbtn->oldButtonProc(hwnd, msg, mp1, mp2);
            } // switch vkey
         } // case wm_char
  case WM_TRANSLATEACCEL: // .. 祬,   ⮣ 뭠
      {
          return (MRESULT)WinDefWindowProc(hwnd, msg, mp1, mp2);
              // oldSliderProc(hwnd, msg, mp1, mp2);
      }
  case WM_DESTROY:
      {    GpiDeleteBitmap(psknbtn->butt_off);
           GpiDeleteBitmap(psknbtn->butt_on);
           GpiDeleteBitmap(psknbtn->butt_off1);
           GpiDeleteBitmap(psknbtn->butt_on1);
           GpiDeleteBitmap(psknbtn->butt_mouover);
           GpiDeleteBitmap(psknbtn->butt_mouover1);
           GpiDeleteBitmap(psknbtn->butt_dis);
          return 0;
       }
//  default:
//      {
//    if(psknbtn->bstate == MBS_MOUSEOVER)
//    {
//        SWP swp;
//        POINTL ptlPoint;

//        WinQueryWindowPos(hwnd, &swp);
//        WinQueryPointerPos(HWND_DESKTOP, &ptlPoint);
//        WinMapWindowPoints(HWND_DESKTOP, hwnd, &ptlPoint, 1);
//        if(ptlPoint.x <= 0 || ptlPoint.y <= 0 ||
//           ptlPoint.x >= swp.cx || ptlPoint.y >= swp.cy)
//        {
//            psknbtn->bstate = MBS_RELEASED;
//            WinInvalidateRect(hwnd, 0, TRUE);
//        }
//    }
    //     psknbtn->oldButtonProc(hwnd, msg, mp1, mp2);
//      }
     } // switch
           return (MRESULT)TRUE;
    }

