/*
 * WarpVision GUI bmp
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

static void bitmap_size( HBITMAP bmp, int FAR * pwidth, int FAR * pheight)
{
    BITMAPINFOHEADER    bitmap;

    bitmap.cbFix = sizeof( BITMAPINFOHEADER );
    GpiQueryBitmapParameters( bmp, &bitmap );
    *pwidth = bitmap.cx;
    *pheight = bitmap.cy;
}

static void button_size( HWND hwnd, int id, int FAR * pwidth, int FAR * pheight )
{
    HBITMAP             bmp;
    BITMAPINFOHEADER    bitmap;
    HPS                 hps;
    int x,y;

    hwnd = hwnd;
    hps = WinGetPS( HWND_DESKTOP );
    bmp = GpiLoadBitmap( hps, 0, (ULONG) id, 0, 0 );
    WinReleasePS( hps );
    if( !bmp ) return;
    bitmap_size(bmp,&x,&y);
    *pwidth = x;
    *pheight = y;
}

BOOL VidLoadBitmap(HPS hps, PSZ pszFile, PHBITMAP phbm)
{
     HFILE hFile;
     HBITMAP hbm;
     ULONG ulNumBytes;
     ULONG ulFileLength;
     PBYTE pbBuffer;
     PBITMAPFILEHEADER2 pImgHdr;

     if (DosOpen (pszFile, &hFile, &ulNumBytes, 0, FILE_NORMAL,
     OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW,
     OPEN_ACCESS_READONLY | OPEN_SHARE_DENYREADWRITE |
     OPEN_FLAGS_SEQUENTIAL | OPEN_FLAGS_NO_CACHE, NULL))
      {
          return 1;
      }


     DosSetFilePtr (hFile, 0, FILE_END, &ulFileLength);
     DosSetFilePtr (hFile, 0, FILE_BEGIN, &ulNumBytes);


     if (DosAllocMem ((PPVOID)&pImgHdr, (sizeof(BITMAPFILEHEADER2)+sizeof(RGB2)*256),
     PAG_COMMIT | PAG_READ | PAG_WRITE))
      {
          DosClose(hFile);
          return 1;
      }


     if (DosRead (hFile, pImgHdr,
     (sizeof(BITMAPFILEHEADER2)+sizeof(RGB2)*256),
     &ulNumBytes))
      {
         DosFreeMem(pImgHdr);
         DosClose(hFile);
       return 1;
      }

     if (DosAllocMem ((PPVOID)&pbBuffer, ulFileLength,
     PAG_COMMIT | PAG_READ | PAG_WRITE))
       {
          DosFreeMem(pImgHdr);
          DosClose(hFile);
        return 1;
       }

     DosSetFilePtr (hFile, 0, FILE_BEGIN, &ulNumBytes);

     if (DosRead(hFile, pbBuffer, ulFileLength,
     &ulNumBytes))
     {
          DosFreeMem(pImgHdr);
          DosFreeMem(pbBuffer);
          DosClose(hFile);
          return 1;
     }

     hbm=GpiCreateBitmap(hps, &pImgHdr->bmp2, CBM_INIT,
     pbBuffer+pImgHdr->offBits, (PBITMAPINFO2)&pImgHdr->bmp2);


     if (hbm==-1)
      {
          DosFreeMem(pImgHdr);
          DosFreeMem(pbBuffer);
          DosClose(hFile);
          return 1;
          }

     DosFreeMem(pbBuffer);
     DosFreeMem(pImgHdr);

     DosClose(hFile);


     *phbm=hbm;
     return 0;
}


