/*
 * WarpVision GUI audio part
 *
 * CopyRight Vlad Stelmahovsky
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/


void set_sound_state(BOOL state)
{

    USHORT             usDeviceID;
    MCI_SET_PARMS      msp;
    USHORT ushSt;

    if (state) ushSt = MCI_SET_ON;
     else ushSt = MCI_SET_OFF;
//    msp.dwLevel = vol;                  /* 50% of volume */
    msp.dwAudio = MCI_SET_AUDIO_ALL;
    mciSendCommand(DART.DeviceID,
                   MCI_SET,
                   MCI_WAIT | MCI_SET_AUDIO | ushSt,
                   (DWORD)&msp, 0);

  return;

}

void set_volume(ULONG vol)
{

    USHORT             usDeviceID;
    MCI_SET_PARMS      msp;

    msp.dwLevel = vol;                  /* 50% of volume */
    msp.dwAudio = MCI_SET_AUDIO_ALL;
    mciSendCommand(DART.DeviceID,
                   MCI_SET,
                   MCI_WAIT | MCI_SET_AUDIO |
                   MCI_SET_VOLUME,
                   (DWORD)&msp, 0);

  set_slider_volume(&skn->audio_sld, vol); // set volume from the driver

  return;

}

USHORT get_volume()
{
   ULONG    ulError;
   BOOL     disc_loaded;
   USHORT    vol;
                    /* Set to TRUE by this example if media is present */
   MCI_STATUS_PARMS  mstatusp;
   memset ( &mstatusp, 0, sizeof ( MCI_STATUS_PARMS ) );
   mstatusp.dwItem = MCI_STATUS_VOLUME;

   ulError = mciSendCommand(DART.DeviceID,      /* Device ID              */
    MCI_STATUS,                              /* MCI status message     */
    MCI_WAIT | MCI_STATUS_ITEM,
                                             /* Flags for this message */
    (DWORD) &mstatusp,                       /* Data structure         */
    0);                                      /* No user parm           */

   if (!(ulError & 0xffff))
     {
       vol = LOUSHORT(mstatusp.dwReturn);    /* Media present
                                                     status            */
     } else vol = 0;
return vol;
}

#define AUDIO_FRAME_SIZE   65535
extern "C" {
    sample_t *my_a52_data;
    a52_state_t *my_a52_state;
    static int my_a52_flags;
    sample_t my_a52_level, my_a52_bias;
    int my_a52_sample_rate;
    int my_a52_bit_rate;

    UCHAR *my_audio_buffer;
    UCHAR *my_input_audio_buffer;
    int my_input_audio_buffer_len;

int my_a52_fill_buffer(sh_audio_t *sh_audio)
{
    int length;

    my_input_audio_buffer_len = 0;

    // Sync frame
    for(;;)
    {
        while(my_input_audio_buffer_len < 7)
        {
            int chr;

            chr = demux_getc(sh_audio->ds);

            if (chr < 0)
               return -1;

            my_input_audio_buffer[my_input_audio_buffer_len++] = chr;
        }

        length = a52_syncinfo(my_input_audio_buffer,
                              &my_a52_flags,
                              &my_a52_sample_rate,
                              &my_a52_bit_rate);
        // if done
        if(length >= 7 && length <= 3840)
            break;

        // resync
        memmove(my_input_audio_buffer, my_input_audio_buffer + 1, 6);
        my_input_audio_buffer_len--;
    }

    // read a52 frame
    my_input_audio_buffer_len = demux_read_data(sh_audio->ds,
                                             my_input_audio_buffer + 7,
                                             length - 7);
    return length;
}

ULONG get_audio_bps(sh_audio_t *sh_audioLL)
{
    int rc;
//    sample_t *a52_data;
//    a52_state_t *a52_state;
//    static int a52_flags;
//    sample_t a52_level, a52_bias;
//    int a52_sample_rate;
//    int a52_bit_rate;

//    UCHAR *audio_buffer;
//    UCHAR *input_audio_buffer;
//    int input_audio_buffer_len;
    audio_header_t audio_header;
    ULONG bps;

    my_input_audio_buffer = (UCHAR *)malloc(AUDIO_FRAME_SIZE * 4);
    my_input_audio_buffer_len = 0;

    my_audio_buffer = (UCHAR *)malloc(AUDIO_FRAME_SIZE * 4);
    audio_header.audio_buffer_used = 0;

//    memset(&audio_header, 0, sizeof(audio_header_t));

    switch(sh_audioLL->codec->codec_type)
    {
        case AUDIO_MPEG:

            MP3_Init();
            MP3_DecodeFrame(my_audio_buffer, -1);
            bps = (ULONG)MP3_bitrate*(1000/8);
//            MP3_Close();

        break;

    case AUDIO_AC3:
//        printf("a52 initing\n");fflush(stdout);
           my_a52_state = a52_init(0);
           if (my_a52_state == NULL) return 0L;
//           printf("a52 buffer fulling\n");fflush(stdout);
//           if (sh_audio != NULL) {
          if (my_a52_fill_buffer(sh_audioLL) < 0) return 0L;
//          } else printf("sh_audio shit!!!\n");fflush(stdout);
          //            printf("a52 decoding frame\n");fflush(stdout);
            my_a52_flags = A52_STEREO;
            my_a52_flags |= A52_ADJUST_LEVEL;
            my_a52_level = 1;
            my_a52_bias = 384;

           if (a52_frame(my_a52_state,
                          my_input_audio_buffer,
                          &my_a52_flags, &my_a52_level, my_a52_bias) != 0)
                return 0L;
                bps = (ULONG)(float)my_a52_bit_rate/8;

        break;

        case AUDIO_PCM:
            bps = (ULONG)sh_audioLL->wf->nAvgBytesPerSec;
            break;
    }
   return bps;
} // get_audio_bps
} // extern C
