/*
 * WarpVision codecs
 *
 * Copyleft Alex Strelnikov.
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

// Codec types

#define VIDEO_MPEG     1
#define VIDEO_DIVX     2
#define VIDEO_ODIVX    3
#define VIDEO_MP4V1    4
#define VIDEO_MP4V2    5
#define VIDEO_INDEO3   6
#define VIDEO_INDEO4   7
#define VIDEO_INDEO5   8
#define VIDEO_CINEPAK  9
#define VIDEO_WMV1     10
#define VIDEO_WMV2     11
#define VIDEO_MJPG     12

#define AUDIO_MPEG     100
#define AUDIO_AC3      101
#define AUDIO_PCM      102
#define AUDIO_ACM      103
#define AUDIO_DIVX     104
#define AUDIO_ADPCM    105
#define AUDIO_ALAW     106
#define AUDIO_MULAW    107
#define AUDIO_IMAADPCM 108

typedef struct codecs_st {

    char codec_name[64];
    int  codec_type;
    int  codec_supported;

} codecs_st;

codecs_st *find_audio_codec(ULONG fourcc);
codecs_st *find_video_codec(ULONG fourcc);
