/*
 * WarpVision codecs
 *
 * Copyleft Alex Strelnikov.
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include <os2.h>
#include <mmio.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "codecs.h"

codecs_st *find_audio_codec(ULONG fourcc)
{
    static codecs_st codec;

    switch(fourcc)
    {
        case 0x2000:
            strcpy(codec.codec_name, "Dolby AC-3");
            codec.codec_type = AUDIO_AC3;
            codec.codec_supported = TRUE;
        break;

        case 0x50:
        case 0x55:
            strcpy(codec.codec_name, "MPEG Layer-1,2,3");
            codec.codec_type = AUDIO_MPEG;
            codec.codec_supported = TRUE;
        break;

        case 0x01:
            strcpy(codec.codec_name, "Uncompressed PCM");
            codec.codec_type = AUDIO_PCM;
            codec.codec_supported = TRUE;
        break;

        case 0x160:
        case 0x161:
            strcpy(codec.codec_name, "DivX audio (not supported)");
            codec.codec_type = AUDIO_DIVX;
            codec.codec_supported = FALSE;
        break;

        case 0x02:
            strcpy(codec.codec_name, "ADPCM (not supported)");
            codec.codec_type = AUDIO_ADPCM;
            codec.codec_supported = FALSE;
        break;

        case 0x06:
            strcpy(codec.codec_name, "RIFF ALAW (not supported)");
            codec.codec_type = AUDIO_ALAW;
            codec.codec_supported = FALSE;
        break;

        case 0x07:
            strcpy(codec.codec_name, "RIFF MULAW (not supported)");
            codec.codec_type = AUDIO_MULAW;
            codec.codec_supported = FALSE;
        break;

        case 0x11:
            strcpy(codec.codec_name, "IMA ADPCM (not supported)");
            codec.codec_type = AUDIO_IMAADPCM;
            codec.codec_supported = FALSE;
        break;

        default:
            strcpy(codec.codec_name, "Unknown audio codec");
            codec.codec_supported = FALSE;
        break;
    }

    return &codec;
}

codecs_st *find_video_codec(ULONG fourcc)
{
    static codecs_st codec;

    switch(fourcc)
    {
        case mmioFOURCC('D', 'I', 'V', 'X'):
        case mmioFOURCC('d', 'i', 'v', 'x'):
        case mmioFOURCC('D', 'I', 'V', '1'):
        case mmioFOURCC('d', 'i', 'v', '1'):
        case mmioFOURCC('M', 'P', '4', 'S'):
        case mmioFOURCC('m', 'p', '4', 's'):
        case mmioFOURCC('X', 'V', 'I', 'D'):
        case mmioFOURCC('x', 'v', 'i', 'd'):
        case mmioFOURCC('X', 'v', 'i', 'D'):
        case mmioFOURCC('D', 'X', '5', '0'):
            strcpy(codec.codec_name, "FFmpeg OpenDivX (MPEG-4 v2)");
            codec.codec_type = VIDEO_ODIVX;
            codec.codec_supported = TRUE;
        break;

        case mmioFOURCC('D', 'I', 'V', '3'):
        case mmioFOURCC('d', 'i', 'v', '3'):
        case mmioFOURCC('D', 'I', 'V', '4'):
        case mmioFOURCC('d', 'i', 'v', '4'):
        case mmioFOURCC('M', 'P', 'G', '3'):
        case mmioFOURCC('m', 'p', 'g', '3'):
        case mmioFOURCC('M', 'P', '4', '3'):
        case mmioFOURCC('m', 'p', '4', '3'):
        case mmioFOURCC('D', 'I', 'V', '5'):
        case mmioFOURCC('d', 'i', 'v', '5'):
        case mmioFOURCC('D', 'I', 'V', '6'):
        case mmioFOURCC('d', 'i', 'v', '6'):
        case mmioFOURCC('A', 'P', '4', '1'):
            strcpy(codec.codec_name, "FFmpeg DivX ;-) (MS MPEG-4 v3)");
            codec.codec_type = VIDEO_DIVX;
            codec.codec_supported = TRUE;
        break;

        case 0x10000001:
        case 0x10000002:
            strcpy(codec.codec_name, "libmpeg2 MPEG-1/2");
            codec.codec_type = VIDEO_MPEG;
            codec.codec_supported = TRUE;
        break;

        case mmioFOURCC('M', 'J', 'P', 'G'):
            strcpy(codec.codec_name, "FFmpeg MJPEG");
            codec.codec_type = VIDEO_MJPG;
            codec.codec_supported = TRUE;
        break;

        case mmioFOURCC('M', 'P', 'G', '4'):
        case mmioFOURCC('m', 'p', 'g', '4'):
            strcpy(codec.codec_name, "FFmpeg MPEG-4 v1");
            codec.codec_type = VIDEO_MP4V1;
            codec.codec_supported = TRUE;
        break;

        case mmioFOURCC('M', 'P', '4', '2'):
        case mmioFOURCC('m', 'p', '4', '2'):
            strcpy(codec.codec_name, "FFmpeg MPEG-4 v2");
            codec.codec_type = VIDEO_MP4V2;
            codec.codec_supported = TRUE;
        break;

        case mmioFOURCC('I', 'V', '3', '1'):
        case mmioFOURCC('i', 'v', '3', '1'):
            strcpy(codec.codec_name, "Intel Indeo3 (not supported)");
            codec.codec_type = VIDEO_INDEO3;
            codec.codec_supported = FALSE;
        break;

        case mmioFOURCC('I', 'V', '4', '1'):
        case mmioFOURCC('i', 'v', '4', '1'):
            strcpy(codec.codec_name, "Intel Indeo4 (not supported)");
            codec.codec_type = VIDEO_INDEO4;
            codec.codec_supported = FALSE;
        break;

        case mmioFOURCC('I', 'V', '5', '0'):
        case mmioFOURCC('i', 'v', '5', '0'):
            strcpy(codec.codec_name, "Intel Indeo5 (not supported)");
            codec.codec_type = VIDEO_INDEO5;
            codec.codec_supported = FALSE;
        break;

        case mmioFOURCC('C', 'V', 'I', 'D'):
        case mmioFOURCC('c', 'v', 'i', 'd'):
            strcpy(codec.codec_name, "Cinepak Video (not supported)");
            codec.codec_type = VIDEO_CINEPAK;
            codec.codec_supported = FALSE;
        break;

        case mmioFOURCC('W', 'M', 'V', '1'):
            strcpy(codec.codec_name, "Windows Media Video 7");
            codec.codec_type = VIDEO_WMV1;
            codec.codec_supported = TRUE;
        break;

        case mmioFOURCC('W', 'M', 'V', '2'):
            strcpy(codec.codec_name, "Windows Media Video 8 (not supported)");
            codec.codec_type = VIDEO_WMV2;
            codec.codec_supported = TRUE;
        break;

        default:
            strcpy(codec.codec_name, "Unknown video codec");
            codec.codec_supported = FALSE;
        break;
    }

    return &codec;
}