/*
    Direct Audio Interface library for OS/2
    Copyright (C) 1998 by Andrew Zabolotny <bit@eltech.ru>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Modified by Alex Strelnikov
*/

#ifndef __DART_H__
#define __DART_H__


typedef size_t (*dartInputCallback) (void *Buffer, size_t BufferSize);


typedef struct DartStruct
{
    int                Stopped;
    int                Paused;
    int                WaitStreamEnd;
    int                BytesPlayed;
    int                BufLen;
    int                BufferCount;
    int                ResampleFlg;
    LONG               SeekPosition;
    BOOL               Shareable;

    USHORT             DeviceID;
    MCI_MIX_BUFFER     *MixBuffers;
    MCI_MIXSETUP_PARMS MixSetupParms;
    MCI_BUFFER_PARMS   BufferParms;
    CHAR               ErrorCode[CCHMAXPATH];

    dartInputCallback  InputCallback;

} DartStruct;


int dart_init(int DeviceIndex, int BitsPerSample, int SamplingRate,
              int DataFormat, int Channels, int Buffers,
              dartInputCallback Callback);
int dart_close(void);
int dart_play(void);
void dart_stop(void);
void dart_pause(void);
void dart_resume(void);
ULONG dart_get_pos(void);
void dart_set_pos(ULONG new_position);
int dart_error(APIRET rc);
void dart_set_sound_state(BOOL state);
void dart_set_volume(ULONG vol);
USHORT dart_get_volume(void);

#endif
