/*
 * WarpVision audio
 *
 * Copyleft Alex Strelnikov.
 *
 * WarpVision is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WarpVision is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#define RESAMPLE_NONE       0
#define RESAMPLE_TO_44100   1
#define RESAMPLE_TO_48000   2

typedef struct audio_header_t {

    int bits_per_sample;
    int sample_rate;
    int resample_rate;
    int bit_rate;
    int channels;
    int format;
    int dart_buffer_size;
    int audio_buffer_used;

} audio_header_t;

int audio_init(sh_audio_t *sh_audio, int, int);
int audio_decode(sh_audio_t *sh_audio, int init_flag);
