/*
 *@@sourcefile domsubsidizer.cpp:
 *  archive unit
 *
 *
 */

/*      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define ENABLE_ERROR_PRINTING_CXMLSUBSIDIZER

#include "wipengine\cdomsubsidizer.h"

//
// CNodeBase class:
//

CNodeBase::CNodeBase(PNODEBASE p_pNodeBase) {

    _pNodeBase = p_pNodeBase;

}


CNodeBase::~CNodeBase() {

    // Does nothing.

}


NODEBASETYPE CNodeBase::getNodeType() {

    return _pNodeBase->ulNodeType;

}

BSString *CNodeBase::getNodeName() {

    BSString *pbssNodeName =
        new BSString(_pNodeBase->strNodeName.psz);

    return pbssNodeName;

}


//
// CElementParticle class:
//

CElementParticle::CElementParticle(PCMELEMENTPARTICLE p_pElementParticle) :
    CNodeBase(&(p_pElementParticle->NodeBase)) {

    _pElementParticle = p_pElementParticle;

}


CElementParticle::~CElementParticle() {

    // Does nothing.

}



//
// CElementDeclNode class:
//

CElementDeclNode::CElementDeclNode(PCMELEMENTDECLNODE p_pElementDeclNode) :
    CElementParticle(&(p_pElementDeclNode->Particle)){

    _pElementDeclNode = p_pElementDeclNode;

}


CElementDeclNode::~CElementDeclNode() {

    // Does nothing since we should not free the ElementDeclNode.

}


NODEBASETYPE CElementDeclNode::getElementType() {

    return getNodeType();

}

BSString *CElementDeclNode::getElementName() {


    return getNodeName();

}


//
// CAttributeDecl class:
//

CAttributeDecl::CAttributeDecl(PCMATTRIBUTEDECL p_pAttributeDecl) :
    CNodeBase(&(p_pAttributeDecl->NodeBase)) {

    _pAttributeDecl = p_pAttributeDecl;

}


CAttributeDecl::~CAttributeDecl() {

    // Does nothing since we should not free the ElementDeclNode.

}


ATTRIBTYPE CAttributeDecl::getAttributeType() {

    return _pAttributeDecl->ulAttrType;

}

BSString *CAttributeDecl::getAttributeName() {

    return getNodeName();

}

ATTRIBCONSTRAINT CAttributeDecl::getAttributeConstraint() {

    return _pAttributeDecl->ulConstraint;
}

BSString *CAttributeDecl::getDefaultValue() {

    BSString *pbssDefaultValue =
        new BSString(_pAttributeDecl->pstrDefaultValue->psz);

    return pbssDefaultValue;

}



//
// CAttributeDeclBase class:
//

CAttributeDeclBase::CAttributeDeclBase(PCMATTRIBUTEDECLBASE p_pAttributeDeclBase) :
    CNodeBase(&(p_pAttributeDeclBase->NodeBase)) {

    _pAttributeDeclBase = p_pAttributeDeclBase;

}


CAttributeDeclBase::~CAttributeDeclBase() {

    // Does nothing since we should not free the ElementDeclNode.

}


/*
 *@findAttributeDecl:
 *  returns the CAttributeDecl for the specified
 *  element and attribute name, or NULL if none exists.
 *  We little bit break rules when using xmlFindAttribDecl
 *  function since when calling first time the pointer
 *  pointed by ppAttribDeclBase should point to null.
 */
CAttributeDecl *CAttributeDeclBase::
    findAttributeDecl(BSString &p_bssAttribName) {

    PCMATTRIBUTEDECL pcmAttributeDecl = NULL;
    CAttributeDecl *pAttributeDecl = NULL;
    XSTRING xsAttribName;

    // Create XSTRING type string from BSString type string.
    // Because xmlXXXX helpers use XSTRING we must do the conversion.
    // Sorry about that.
    xstrInitCopy(&xsAttribName, p_bssAttribName.c_str(), 0);

    // We give real name of this CMATTRIBUTEDECLNAME since
    // xmlFindElementDecl function needs the name although it
    // does not use it since we don't give NULL pointer to
    // CMATTRIBUTEDECLBASE. Also the first parameter is NULL
    // because _pAttributeDeclBase parameter is not NULL
    // so the first parameter is not begin used in the function.
    pcmAttributeDecl =
        xmlFindAttribDecl(NULL,
                          &(_pAttributeDeclBase->NodeBase.strNodeName),
                          &xsAttribName,
                          &_pAttributeDeclBase);

    pAttributeDecl = new CAttributeDecl(pcmAttributeDecl);

    // Release the memory allocated for the XSTRING variable.
    xstrClear(&xsAttribName);

    return pAttributeDecl;

}


//
// CDomNode class:
//

CDomNode::CDomNode(PDOMNODE p_pDomNode) :
    CNodeBase(&(p_pDomNode->NodeBase)) {

    _pDomNode = p_pDomNode;

}


CDomNode::~CDomNode() {

    // Does nothing.

}

BSString *CDomNode::getNodeValue() {

    BSString *pbssNodeValue =
        new BSString(_pDomNode->pstrNodeValue->psz);

    return pbssNodeValue;

}


CDomNode *CDomNode::getFirstChild() {

    CDomNode *pFirstChild = NULL;
    PDOMNODE pDomNode = NULL;

    pDomNode = xmlGetFirstChild(_pDomNode);

    pFirstChild = new CDomNode(pDomNode);


    return pFirstChild;
}


CDomNode *CDomNode::getLastChild() {

    CDomNode *pLastChild = NULL;
    PDOMNODE pDomNode = NULL;

    pDomNode = xmlGetLastChild(_pDomNode);

    pLastChild = new CDomNode(pDomNode);


    return pLastChild;
}


CDomNode *CDomNode::getFirstText() {

    CDomNode *pFirstText = NULL;
    PDOMNODE pDomNode = NULL;

    pDomNode = xmlGetFirstText(_pDomNode);

    pFirstText = new CDomNode(pDomNode);


    return pFirstText;
}


vector<CDomNode*> *CDomNode::getElementsByTagName(const BSString &p_bssName) {

    PLINKLIST pllElements = NULL;
    vector<CDomNode*> *pDomNodeVector = new vector<CDomNode*>;
    XSTRING xsName;

    // Create XSTRING type string from BSString type string.
    // Because xmlXXXX helpers use XSTRING we must do the conversion.
    // Sorry about that.
    xstrInitCopy(&xsName, p_bssName.c_str(), 0);


    pllElements = xmlGetElementsByTagName(_pDomNode, xsName.psz);

    // Convert C style linked list to C++ STL styled linked list.
    PLISTNODE pNode = lstQueryFirstNode(pllElements);
    while (pNode)
    {
        PDOMNODE pDomNode = (PDOMNODE)pNode->pItemData;
        CDomNode *pCDomNode = new CDomNode(pDomNode);
        pDomNodeVector->push_back(pCDomNode);
        pNode = pNode->pNext;
    }

    // Release the memory allocated for the list.
    lstFree(&pllElements);

    // Release the memory allocated for the XSTRING variable.
    xstrClear(&xsName);

    return pDomNodeVector;
}


//
// CDomDocTypeNode class:
//

CDomDocTypeNode::CDomDocTypeNode(PDOMDOCTYPENODE p_pDomDocTypeNode) :
    CDomNode(&(p_pDomDocTypeNode->DomNode)) {

    _pDomDocTypeNode = p_pDomDocTypeNode;

}


CDomDocTypeNode::~CDomDocTypeNode() {

    // Does nothing.

}

BSString *CDomDocTypeNode::getPublicId() {

    BSString *pbssPublicId =
        new BSString(_pDomDocTypeNode->strPublicID.psz);


    return pbssPublicId;
}


BSString *CDomDocTypeNode::getSystemId() {

    BSString *pbssSystemId =
        new BSString(_pDomDocTypeNode->strSystemID.psz);


    return pbssSystemId;
}

BOOL CDomDocTypeNode::hasInternalSubset() {

    return _pDomDocTypeNode->fHasInternalSubset;
}


//
// CDomDocumentNode class:
//
CDomDocumentNode::CDomDocumentNode(PDOMDOCUMENTNODE p_pDomDocumentNode) :
    CDomNode(&(p_pDomDocumentNode->DomNode)) {

    _pDomDocumentNode = p_pDomDocumentNode;

}

CDomDocumentNode::~CDomDocumentNode() {

}



//
// CEntityDeclNode class:
//
CEntityDeclNode::CEntityDeclNode(PCMENTITYDECLNODE p_pEntityDeclNode) :
    CNodeBase(&(p_pEntityDeclNode->NodeBase)) {

    _pEntityDeclNode = p_pEntityDeclNode;

}

CEntityDeclNode::~CEntityDeclNode() {

}


//
// CNotationDeclNode class:
//
CNotationDeclNode::CNotationDeclNode(PCMNOTATIONDECLNODE p_pNotationDeclNode) :
    CNodeBase(&(p_pNotationDeclNode->NodeBase)) {

    _pNotationDeclNode = p_pNotationDeclNode;
}

CNotationDeclNode::~CNotationDeclNode() {

}



//
// CXmlDom class:
//
CXmlDom::CXmlDom(XMLDOM *p_pXmlDom) {

    _pXmlDom = p_pXmlDom;
}


CXmlDom::~CXmlDom() {

}


CElementDeclNode *CXmlDom::
    findElementDecl(const BSString &p_bssElementName) {

    PCMELEMENTDECLNODE pcmElementDeclNode = NULL;
    CElementDeclNode *pElementDeclNode = NULL;
    XSTRING xsElementName;

    // Create XSTRING type string from BSString type string.
    // Because xmlXXXX helpers use XSTRING we must do the conversion.
    // Sorry about that.
    xstrInitCopy(&xsElementName, p_bssElementName.c_str(), 0);

    pcmElementDeclNode = xmlFindElementDecl(_pXmlDom, &xsElementName);

    pElementDeclNode = new CElementDeclNode(pcmElementDeclNode);

    // Release the memory allocated for the XSTRING variable.
    xstrClear(&xsElementName);

    return pElementDeclNode;
}


CAttributeDeclBase *CXmlDom::
    findAttribDeclBase(const BSString &p_bssElementName) {

    PCMATTRIBUTEDECLBASE pcmAttributeDeclBase = NULL;
    CAttributeDeclBase *pAttributeDeclBase = NULL;
    XSTRING xsElementName;

    // Create XSTRING type string from BSString type string.
    // Because xmlXXXX helpers use XSTRING we must do the conversion.
    // Sorry about that.
    xstrInitCopy(&xsElementName, p_bssElementName.c_str(), 0);

    pcmAttributeDeclBase = xmlFindAttribDeclBase(_pXmlDom, &xsElementName);

    pAttributeDeclBase = new CAttributeDeclBase(pcmAttributeDeclBase);

    // Release the memory allocated for the XSTRING variable.
    xstrClear(&xsElementName);

    return pAttributeDeclBase;
}


XMLDOM *CXmlDom::getXmlDom() {

    return _pXmlDom;
}


//
// CDomSubsidizer class:
//
CDomSubsidizer::CDomSubsidizer() {

#ifdef ENABLE_ERROR_PRINTING_CXMLSUBSIDIZER
    printf("CDomSubsidizer::CDomSubsidizer()\n");
    fflush(stdout);
#endif

    PXMLDOM pDom = NULL;

    APIRET rc = xmlCreateDOM(eParseComments,
                             NULL,
                             NULL,
                             NULL,
                             &pDom);

    _pDom = new CXmlDom(pDom);

    if (rc != NO_ERROR) {
        _initialized = FALSE;
        return;
    }

    _ulParserFlags = eParseComments;

    _initialized = TRUE;

#ifdef ENABLE_ERROR_PRINTING_CXMLSUBSIDIZER
    printf(" _pDom          = 0x%X\n"
           "  rc            = 0x%X\n"
           " _ulParserFlags = 0x%X\n"
           " _initialized   = %i\n\n",
           _pDom, rc, _ulParserFlags, _initialized);
    fflush(stdout);
#endif


}



CDomSubsidizer::~CDomSubsidizer() {

    _initialized = FALSE;

}






