/*
 *              WicPM - WarpIN Archive Creator for PM
 *                  (c) Copyright Teemu Ahola 2000
 *
 *@@sourcefile:trad_arc_thread.cpp
 *  This file contains thread related stuff used during archive creating in
 *  traditional mode.
 */



#define INCL_PM
#define INCL_WIN
#define INCL_DOS
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "setup.h"

#include "helpers\winh.h"       // winhXXXX functions created by Ulrich Mller.
#include "helpers\comctl.h"     // progress bar from Ulrich Mller.
#include "helpers\dosh.h"
#include "helpers\linklist.h"
// #include <list>
#include "helpers\cnrh.h"
#include "helpers\stringh.h"
#include "helpers\xstring.h"

#include "base\bs_base.h"           // V0.9.14 (2001-07-07) [umoeller]
#include "base\bs_string.h"
#include "base\bs_list.h"       // V0.9.14 (2001-07-07) [umoeller]

#include "wicpm\script.hpp"

#include "wiarchive\wiarchive.h" // WIArchive created by Jens Bckman.

#include "wicpm\wicpm.h"
#include "wicpm\gui_trad_cntr.h"
#include "wicpm\gui_objwnd.h"
#include "wicpm\gui_wicpm.h"
#include "wicpm\gui_notebook.h"
#include "wicpm\gui_trad_nb_dlgproc.h"
#include "wicpm\wicpmres.h"
#include "wicpm\gui_helpers.h"
#include "wicpm\trad_arc_thread.h"


// Globals.
HWND g_hwndStatusDlg = NULLHANDLE;
HEV g_hevStatusDlgReady = 0;

/*
 *@@WICallback:
 *      This is the callback function which is
 *      given to the WIArchive class.
 *          in:
 *              CBM_* flags defined in wiarchive.h
 *              percentage of current file
 *              file header of current file
 *
 *@@changed V0.9.20 (2002-07-03) [umoeller]: adjusted with enCallbackMode
 */

int WICallback(enCallbackMode mode,  // In: CBM_* flags defined in wiarchive.h.
               short s,            // Percentage of current file.
               WIFileHeader* pwifh,// File header of current file.
               PVOID pvData)       // User defined data?
    {
    int rc = CBRC_ABORT;
    switch (mode)
        {
        case CBM_PERCENTAGE:
            {
            WinPostMsg(g_hwndStatusDlg, USER_ARCTM_FILE_PRECENTAGE,
                       MPFROMSHORT(s), MPFROMP(pwifh->name));
            // Wait main thread to set the semaphore.
            DosWaitEventSem(g_hevStatusDlgReady, SEM_INDEFINITE_WAIT);
            break;
            }
        case CBM_UPDATING:
            {
            WinPostMsg(g_hwndStatusDlg, USER_ARCTM_FILE_UPDATING,
                       MPFROMSHORT(s), MPFROMP(pwifh->name));
            // Wait main thread to set the semaphore.
            DosWaitEventSem(g_hevStatusDlgReady, SEM_INDEFINITE_WAIT);
            break;
            }
        }
    return rc;
    }



/*
 *@@thTradArcThread:
 *  This function is used as a parameter in _beginthread function in gui_wicpm.cpp
 *  file. This function does the actuall archive creating with assist of WIArchive
 *  object being based of ScriptWarpIN object and list of packages. ScriptWarpIN
 *  contains the script of the packages and pages. List of packages contains mainly
 *  information about the files to be added. Also file name for the archive is
 *  included in pThreadArg parameter. This function posts results while archive
 *  creating to status dialog window and syncronization between this thread and
 *  the status window is organized by using event semaphore. Now message queue
 *  will not overflow.
 */
VOID _Optlink thTradArcThread (PVOID pThreadArg)
    {
    ULONG rc = 0;
    QMSG qmsg;
    TradArcThreadInfo* pThreadInfo = (TradArcThreadInfo*)pThreadArg;

    g_hwndStatusDlg = pThreadInfo->hwndStatusDlg;
    g_hevStatusDlgReady = pThreadInfo->hevStatusDlgReady;

    pThreadInfo->bThreadBusy = TRUE;
    pThreadInfo->bThreadInitialized = FALSE;
    pThreadInfo->bThreadKilled = FALSE;
    pThreadInfo->usThreadError = 0;

    pThreadInfo->bThreadInitialized = TRUE;

    // Tell the main window that we are ready.
    //WinPostMsg(pThreadInfo->hwndMainWnd, USER_ARCTM_THREADY, 0, 0);
    pThreadInfo->bThreadBusy = FALSE;
    // Wait until the status dlg is ready to start.
    //DosWaitEventSem(pThreadInfo->hevStatusDlgReady, SEM_INDEFINITE_WAIT);

    WIArchiveRW Arc;
    WIArcHeader ArcHeader;

    //WinPostMsg(pThreadInfo->hwndStatusDlg, USER_ARCTH_INIT_ARC, NULL, NULL);
    Arc.open(pThreadInfo->pszArchiveFileName,1);

    // It is important to initialize next fields because otherwice there can
    // be carbage in them which can cause random craches. (oh! I know)
    // Those things will be removed from future version of WIArchive (Jens promised
    // that). We actually don't need them because all important information
    // can be found from script.
    strcpy(ArcHeader.szAppName, "WicPM");
    strcpy(ArcHeader.szDeveloper, "Teemu Ahola");
    strcpy(ArcHeader.szInternetAddr, "N/A");
    ArcHeader.sAppRevision = 1;
    ArcHeader.szPath[0] = '\0';
    ArcHeader.lExtended = 0; // I think this should be set to 0.
    Arc.setArcHeader(ArcHeader);

    list<DBPackage*>::iterator PckStart = pThreadInfo->listPackages.begin(),
                               PckEnd = pThreadInfo->listPackages.end();
    for (; PckStart != PckEnd; PckStart++)
        {
        DBPackage* pDBPackageThis = *PckStart;

        CHAR szPackageName[20];
        sprintf(szPackageName, "Pck%03d", (LONG)pDBPackageThis->usPckIndexAttr);

        // Post message to the status dialog so it can show some information about
        // package to being set.
        WinPostMsg(pThreadInfo->hwndStatusDlg, USER_ARCTM_SET_PCK,
            MPFROMP(pDBPackageThis), NULL);
        // Wait until the status dialog is ready.
        DosWaitEventSem(pThreadInfo->hevStatusDlgReady, SEM_INDEFINITE_WAIT);

        Arc.setPackage((LONG)pDBPackageThis->usPckIndexAttr, szPackageName);

        // For future compatibility. We transfer old style C based list system to
        // STL list template which is more handy. At some point I will change all
        // lists to STL list template. That's why there is this converting system
        // now.
        list<DBFile*> listFiles(SHADOW);
        DBFile *pDBFile = NULL;
        PLISTNODE pNode = lstQueryFirstNode(pDBPackageThis->plFileList);
        while(pNode)
            {
            pDBFile = (DBFile*)pNode->pItemData;
            listFiles.push_back(pDBFile);
            pNode = pNode->pNext;
            }

        list<DBFile*>::iterator FileStart = listFiles.begin(),
                                FileEnd = listFiles.end();
        for (; FileStart != FileEnd; FileStart++)
            {
            CHAR szFileName[CCHMAXPATH], szFileInstallName[CCHMAXPATH];
            DBFile* pDBFileThis = *FileStart;

            sprintf(szFileName, "%s%s", pDBFileThis->szFilePath, pDBFileThis->szFileName);
            sprintf(szFileInstallName, "%s%s", pDBFileThis->szFileInstallPath,
                    pDBFileThis->szFileName);
            // Post message to the status dialog so it can show some information about
            // file to being added.
            //WinPostMsg(pThreadInfo->hwndStatusDlg, USER_ARCTM_ADD_FILE,
            //    MPFROMP(pDBFileThis), 0);
            // Wait until the status dialog is ready.
            //DosWaitEventSem(pThreadInfo->hevStatusDlgReady, SEM_INDEFINITE_WAIT);
            Arc.add(szFileName, szFileInstallName, pDBPackageThis->usPckIndexAttr);
            }
        }

    PSZ pszScript = pThreadInfo->pWarpIN->MakeScriptText();

    // Show information about the script. I don't think that there is a need for
    // waiting of event semaphore because at this point there is not many messages
    // sended by this thread in the main thread message queue because all message
    // posting in this thread before this posting was organized with semaphore.
    WinPostMsg(pThreadInfo->hwndStatusDlg, USER_ARCTM_SET_SCRIPT,
               MPFROMLONG(strlen(pszScript)), 0);
    // Wait until the status dlg is ready to continue.
    //DosWaitEventSem(pThreadInfo->hevStatusDlgReady, SEM_INDEFINITE_WAIT);

    Arc.setScript(pszScript);
    Arc.setCallbackFunc(WICallback, NULL);

    WinPostMsg(pThreadInfo->hwndStatusDlg, USER_ARCTM_COMPRESS, 0, 0);
    // Wait until the status dlg is ready to continue.
    //DosWaitEventSem(pThreadInfo->hevStatusDlgReady, SEM_INDEFINITE_WAIT);

    // Now the real file processing starts. We will get a lot of callbacks to
    // WICallback function from WIArchive object.
    Arc.close();

    WinPostMsg(pThreadInfo->hwndStatusDlg, USER_ARCTM_DONE, 0, 0);
    pThreadInfo->bThreadKilled = TRUE;
    pThreadInfo->bThreadBusy = FALSE;
    _endthread();
    }




