/*
 *              WicPM - WarpIN Archive Creator for PM
 *                  (c) Copyright Teemu Ahola 2000
 *
 * gui_wicpm.cpp
 *  This file contains PM-specific stuff for WarpIN Archive Creator for PM.
 */

#define INCL_PM
#define INCL_WIN
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "setup.h"

#include "helpers\winh.h"       // winhXXXX functions created by Ulrich Mller.
#include "helpers\comctl.h"     // progress bar from Ulrich Mller.
#include "helpers\dosh.h"
#include "helpers\linklist.h"
#include "helpers\cnrh.h"
// #include <list>
#include "helpers\stringh.h"
#include "helpers\xstring.h"

#include "base\bs_base.h"           // V0.9.14 (2001-07-07) [umoeller]
#include "base\bs_string.h"
#include "base\bs_list.h"       // V0.9.14 (2001-07-07) [umoeller]

#include "wicpm\wicpm.h"

#include "wicpm\script.hpp"

#include "wiarchive\wiarchive.h" // WIArchive created by Jens Bckman.

#include "wicpm\gui_trad_cntr.h"
#include "wicpm\gui_objwnd.h"
#include "wicpm\gui_wicpm.h"
#include "wicpm\gui_notebook.h"
#include "wicpm\gui_trad_nb_dlgproc.h"
#include "wicpm\wicpmres.h"
#include "wicpm\gui_helpers.h"
#include "wicpm\trad_arc_thread.h"

#include "bl_wicpm.h"


/* Global variables */
HWND hwndArcCreate;
NLSSTRINGS G_nlsStringTable;
PPCKRECORD G_pSelectedPckRecord = NULL;
PPCKRECORD G_pSourcePckRecord = NULL;
PFILERECORD G_pSelectedFileRecord = NULL;
PFILERECORD G_pSourceFileRecord = NULL;

DEFINE_CLASS(DBPackage, BSRoot);
DEFINE_CLASS(DBFile, BSRoot);
DEFINE_CLASS(Message, BSRoot);
DEFINE_CLASS(ScriptPage, BSRoot);

/* Function prototypes */
MRESULT EXPENTRY fnMainClientProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY fnPckAddDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY fnScriptAddDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
DBPackage *FindDBPckItem(PLINKLIST plPackageList, USHORT usIndex);
ScriptPackage *FindScriptPackageObject(ScriptGroup *Group, USHORT usPackageIndex,
    ScriptGroup **pReturnGroup = NULL);
MRESULT EXPENTRY fnTradCreateArcDlgProc (HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);


/****************************************************************************
 *@@guiBeginTraditionalMode
 *  Begins traditional mode of WicPM. Creates main window and containers.
 *  Starts message looping and posts event semaphore to object window thread
 *  so it knows that main windows is created.
 *
 */
USHORT guiBeginTraditionalMode(HAB hab, // Anchor block handler.
                              HWND hwndObjectWnd, // Obj. wnd. hwnd
                              CHAR szArchiveFile[CCHMAXPATH], // File which should to be opened.
                              HEV hevEventMainWndInited,
                              HWND *hwndMainWnd, // Hwnd of the main wnd. to obj. wnd. thread.
                              HMQ *hmq // Pointer to message queue.
                              )
    {
    QMSG qmsg;
    RECTL rectl;
    static ULONG ulFrameFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER | FCF_MENU |
                                FCF_MINMAX | FCF_SHELLPOSITION | FCF_TASKLIST |
                                FCF_NOBYTEALIGN | FCF_ICON;
    PMAINWINDOWINFO pMainWndInfo = (PMAINWINDOWINFO)new MAINWINDOWINFO;
    if (!pMainWndInfo)
        return 1;

    // Setup hab (anchor block handler) in main window info.
    pMainWndInfo->hab = hab;


    // Register client window class. This function allocates memory for
    // pointer to pWindowInfo.
    if (!WinRegisterClass(pMainWndInfo->hab, G_nlsStringTable.pszMainWinTitle,
            fnMainClientProc, CS_SIZEREDRAW, sizeof (PMAINWINDOWINFO)))
        return 2;

    // Create main window.
    pMainWndInfo->hwndMainWnd =
        WinCreateStdWindow(HWND_DESKTOP,0 , &ulFrameFlags,
        G_nlsStringTable.pszMainWinTitle, G_nlsStringTable.pszMainWinTitle,
        0L, 0, IDM_MAIN, 0);
    if (!pMainWndInfo->hwndMainWnd)
        return 2;
    // Set main window position and size accordingly to saved values.
    if (!winhRestoreWindowPos(pMainWndInfo->hwndMainWnd, HINI_USER, INIAPP_WICPM,
                             INIKEY_MAINWINSIZEPOS, SWP_MOVE | SWP_SIZE | SWP_SHOW))
        // INI data not found. Use default locations so only show the window.
        WinSetWindowPos(pMainWndInfo->hwndMainWnd, HWND_TOP, 0, 0, 0, 0,
                        SWP_SHOW);

    // Get the client handler of the main window.
    pMainWndInfo->hwndMainWndClient = WinWindowFromID(pMainWndInfo->
        hwndMainWnd, FID_CLIENT);

    // Create both containers. First their sizes are 0*0 but splitbar will
    // resize them.
        // Create the package container. (The left one)
    pMainWndInfo->pckContainerInfo.hwndContainer =
        WinCreateWindow(pMainWndInfo->hwndMainWndClient, WC_CONTAINER,
            G_nlsStringTable.pszMainWndPckCont, WS_VISIBLE | WS_CLIPCHILDREN,
            0, 0, 0, 0, pMainWndInfo->hwndMainWndClient, HWND_TOP,
            IDD_MAIN_PCKCONTAINER, NULL, NULL);
        // Create the file container. (The right one)
    pMainWndInfo->fileContainerInfo.hwndContainer =
        WinCreateWindow(pMainWndInfo->hwndMainWndClient, WC_CONTAINER,
            G_nlsStringTable.pszMainWndPckCont, WS_VISIBLE | WS_CLIPCHILDREN,
            0, 0, 0, 0, pMainWndInfo->hwndMainWndClient, HWND_TOP,
            IDD_MAIN_FILECONTAINER, NULL, NULL);

    // Initialize splitbar data structures and create split bar.
    // Detailed information about sliptbar can be found from
    // winh.c.
    pMainWndInfo->mainWndSBarData.ulSplitWindowID = IDD_MAIN_SPLITBAR;
    pMainWndInfo->mainWndSBarData.ulCreateFlags = SBCF_VERTICAL | SBCF_MOVEABLE |
                                                  SBCF_PERCENTAGE;
    // Set split bar position in persents. Try to find it first from os2.ini and
    // if it was not found use default value SPLITBARPOSITIONPERCENTS.
    ULONG ulSize = sizeof(LONG);
    if (!PrfQueryProfileData(HINI_USERPROFILE, INIAPP_WICPM, INIKEY_MAINWINSPLITBARPOS,
        &pMainWndInfo->mainWndSBarData.lPos, &ulSize))
        pMainWndInfo->mainWndSBarData.lPos = SPLITBARPOSITIONPERCENTS;
    pMainWndInfo->mainWndSBarData.ulLeftOrBottomLimit = SPLITBARLEFTPOSLIMIT;
    pMainWndInfo->mainWndSBarData.ulRightOrTopLimit = SPLITBARRIGHTPOSLIMIT;
    pMainWndInfo->mainWndSBarData.hwndParentAndOwner = pMainWndInfo->hwndMainWndClient;
    pMainWndInfo->hwndSplitWindow = ctlCreateSplitWindow(pMainWndInfo->hab,
        &pMainWndInfo->mainWndSBarData);
    // Send message SPLM_SETLINKS to the split window so it will know
    // which two windows should be splitted.
    WinSendMsg(pMainWndInfo->hwndSplitWindow, SPLM_SETLINKS,
               MPFROMHWND(pMainWndInfo->pckContainerInfo.hwndContainer),
               MPFROMHWND(pMainWndInfo->fileContainerInfo.hwndContainer));
    // Query main window client size and resize split window's size equal
    // to client size. Both two containers are resized automatically by
    // split window.
    WinQueryWindowRect(pMainWndInfo->hwndMainWndClient, &rectl);
    WinSetWindowPos(pMainWndInfo->hwndSplitWindow, HWND_TOP, 0, 0,
                    rectl.xRight, rectl.yTop, SWP_SIZE | SWP_MOVE);

    // Load container's context menus.
    pMainWndInfo->pckContainerInfo.hwndContextMenu = WinLoadMenu(pMainWndInfo->
        pckContainerInfo.hwndContainer, 0, IDM_PCKCONTAINER_MENU);
    pMainWndInfo->fileContainerInfo.hwndContextMenu = WinLoadMenu(pMainWndInfo->
        fileContainerInfo.hwndContainer, 0, IDM_FILECONTAINER_MENU);

    // Setup hwndMainMenu.
    pMainWndInfo->hwndMainMenu = WinWindowFromID(pMainWndInfo->hwndMainWnd,
        FID_MENU);

    // Set pointer into the main window reserved window words.
    WinSetWindowPtr(pMainWndInfo->hwndMainWndClient, 0, pMainWndInfo);

    // Set thread info's hwndMainWnd.
    *hwndMainWnd = pMainWndInfo->hwndMainWndClient;
    // Post event semaphore to object window thread so it knows that
    // main window is initialized.
    DosPostEventSem(hevEventMainWndInited);

    // Start message loopping.
    while (WinGetMsg(pMainWndInfo->hab, &qmsg, NULLHANDLE, 0, 0))
        WinDispatchMsg(pMainWndInfo->hab, &qmsg);

    // Send WM_QUIT message to the object window.
    WinSendMsg(pMainWndInfo->hwndObjectWnd, WM_QUIT, 0, 0);
    // Save main window size and position.
    winhSaveWindowPos(pMainWndInfo->hwndMainWnd, HINI_USER, INIAPP_WICPM,
                      INIKEY_MAINWINSIZEPOS);
    // Save split bar position.
    LONG lSBPos = ctlQuerySplitPos(pMainWndInfo->hwndSplitWindow);
    PrfWriteProfileData(HINI_USERPROFILE, INIAPP_WICPM, INIKEY_MAINWINSPLITBARPOS,
                        (PVOID)&lSBPos, sizeof(LONG));
    // Destroy main window
    WinDestroyWindow(pMainWndInfo->hwndMainWnd);

    free(pMainWndInfo);
    pMainWndInfo = NULL;
    // We do not destroy message queue here because main function may need it.
    // Destroying of the message queue is done in the main function.
    return 0;
    }


/****************************************************************************
 *@@guiInitialize
 *  Initializes gui accordingly WicPM mode.
 *
 */
USHORT guiInitialize(HAB hab, USHORT usMode, NLSSTRINGS nlsStrings, HMQ *hmq)
    {
    G_nlsStringTable = nlsStrings;

    // Create message queue. It is important on PM programs.
    if (!(*hmq = WinCreateMsgQueue (hab, 0)))
        return 1;
    return 0;
    }


/****************************************************************************
 *@@guiClearUp
 *
 */
USHORT guiClearUp(PWICPMINFO pWicPMInfo)
    {
    if (pWicPMInfo->objWndThreadInfo.hwndObjectWnd)
        WinSendMsg(pWicPMInfo->objWndThreadInfo.hwndObjectWnd, WM_QUIT, NULL, NULL);
    if (pWicPMInfo->hmq)
        WinDestroyMsgQueue(pWicPMInfo->hmq);
    return 0;
    }




/****************************************************************************
 *@@guiInitializeObjWndThread
 *  Initializes object window thread. Returns thread identifier.
 *
 */
PID guiInitializeObjWndThread(POBJWNDTHREADINFO pObjWndThreadInfo)
    {
    // Create thread for object window.
    return _beginthread(thObjectWndThread, NULL, THREADSTACKSIZE,
                        pObjWndThreadInfo);
    }




MRESULT EXPENTRY fnMainClientProc(HWND hwndWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_CREATE:
            {
            break;
            }
            // Message is posted by object window thread after it has been
            // initialized. This message tells to the main window that
            // it can use the object window for lenghty jobs.
        case USER_THREADINITIALIZED:
            {
            PMAINWINDOWINFO pWinInfo = (PMAINWINDOWINFO)WinQueryWindowPtr(hwndWnd, 0);
            pWinInfo->hwndObjectWnd = LONGFROMMP(mp1);
                // Both containers are disabled so context menus doesn't work.
                // This prevents unexpected "things" from happend while
                // initializing the containers.
            WinEnableWindow(pWinInfo->pckContainerInfo.hwndContainer, FALSE);
            WinEnableWindow(pWinInfo->fileContainerInfo.hwndContainer, FALSE);
                // Send message to the obj wnd so it will initalize the containers.
            WinPostMsg(pWinInfo->hwndObjectWnd, USER_INITMAINCNTRS,
                MPFROMP(&(pWinInfo->pckContainerInfo)),
                MPFROMP(&(pWinInfo->fileContainerInfo)));
            break;
            }
            // Is posted by object window thread when the main containers are
            // initialized.
        case USER_MAINCNTRSINITIALIZED:
            {
            PMAINWINDOWINFO pWinInfo = (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
                // Both containers must enable in order to user can use them.
            WinEnableWindow(pWinInfo->pckContainerInfo.hwndContainer, TRUE);
            WinEnableWindow(pWinInfo->fileContainerInfo.hwndContainer, TRUE);
            WinEnableMenuItem(pWinInfo->fileContainerInfo.hwndContextMenu,
                IDM_FILECONTAINER_REMOVE, FALSE);
            WinEnableMenuItem(pWinInfo->fileContainerInfo.hwndContextMenu,
                IDM_FILECONTAINER_ADD, FALSE);
            WinEnableMenuItem(pWinInfo->fileContainerInfo.hwndContextMenu,
                IDM_FILECONTAINER_EDITINSTALLPATH, FALSE);
            break;
            }
        case WM_SIZE:
            {
            PMAINWINDOWINFO pWinInfo = (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
            RECTL rectl;
            if (pWinInfo)
                {
                WinQueryWindowRect(pWinInfo->hwndMainWndClient, &rectl);
                WinSetWindowPos(pWinInfo->hwndSplitWindow, HWND_TOP, 0, 0,
                                rectl.xRight, rectl.yTop, SWP_SIZE | SWP_MOVE);
                }
            return 0;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case IDM_MAIN_HELP_INFO:
                    {
                    CHAR szVersionCompilerInfo[256];
                    HWND hwndAbout = WinLoadDlg(HWND_DESKTOP,       // Parent.
                                                hwndWnd,            // Owner.
                                                WinDefDlgProc,
                                                NULLHANDLE,
                                                IDD_ABOUT_DIALOG,   // Recource ID.
                                                NULL);
                    sprintf(szVersionCompilerInfo, "%s with %s", __DATE__,
                        #ifdef __EMX__
                            "EMX/GCC"
                        #elif __IBMCPP__
                            "IBM VisualAge C++ 3.08"
                        #else
                            "unknown compiler"
                        #endif
                            );
                    WinSetDlgItemText(hwndAbout, IDD_ABOUT_VERSION, BLDLEVEL_VERSION);
                    WinSetDlgItemText(hwndAbout, IDD_ABOUT_COMPILEDDATETIME,
                                      szVersionCompilerInfo);
                    WinProcessDlg(hwndAbout);
                    break;
                    }
                case IDM_MAIN_FILE_EXIT:
                    {
                    WinSendMsg (hwndWnd, WM_CLOSE, 0, 0);
                    break;
                    }
                case IDM_MAIN_FILE_NEW:
                    {
                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);


                    break;
                    }
                case IDM_MAIN_FILE_OPEN:
                    {
                    guiShowMessageBox(hwndWnd, "Not implemented.",
                        "Opening of exiting archive for editing\n"
                        "doesn't work yet because current version\n"
                        "of WIArchive used in this program doesn't\n"
                        "support required operations.");
                    break;
                    }
                case IDM_MAIN_FILE_SAVESCRIPT:
                    {
                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
                    PSZ pszFileName = NULL;
                    PSZ pszScriptText = NULL;

                    if (guiShowFileDialog(hwndWnd, FILEDLG_TYPE_SAVE,
                            G_nlsStringTable.pszOpenFile, NULL, NULL, &pszFileName,
                            NULL, NULL)
                       == RET_FD_OK)
                        if (pszScriptText = pWinInfo->WarpIN.MakeScriptText())
                            if (doshWriteTextFile(pszFileName, pszScriptText,
                                NULL, NULL)
                                != NO_ERROR)
                                guiShowMessageBox(hwndWnd, "Write error",
                                    "Write error occurred during\n"
                                    "writting of the script.");
                    delete pszScriptText;
                    delete pszFileName;
                    break;
                    }
                case IDM_PCKCONTAINER_EDIT:
                    {
                    PPCKDLGINFO pPckDlgInfo = new PCKDLGINFO;
                    PMSGDATA pMsgData = new MSGDATA;
                    ScriptPackage *pPckTemp = new ScriptPackage, *pPckTemp1 = NULL;
                    DBPackage *pDBPck = NULL;
                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
                    ScriptGroup *pScript =
                        pWinInfo->WarpIN.ReturnHeadObject()->ReturnVirtualGroupObject();
                    ScriptPackageID *pPckIDTemp = NULL;

                    // Find ScriptPackage object which index attribute corresponding
                    // to the package index of the selected record.
                    pPckTemp1 = FindScriptPackageObject(pScript, G_pSourcePckRecord->sPackage);
                    // Do same thing to package database list.
                    pDBPck = FindDBPckItem(pWinInfo->plPackageList, G_pSourcePckRecord->sPackage);
                    // Copy original package to temporarily one so if user presses cancel
                    // button, no changes has been made to the original one.
                    *pPckTemp = *pPckTemp1;
                    pPckDlgInfo->pPackage = pPckTemp;
                    pPckDlgInfo->hwndObjWnd = pWinInfo->hwndObjectWnd;
                    HWND hwndAdd = WinLoadDlg(HWND_DESKTOP,
                                              hwndWnd,
                                              fnPckAddDlgProc,
                                              NULLHANDLE,
                                              IDD_ADDPCK_DIALOG,
                                              (PVOID)pPckDlgInfo);
                    WinSetWindowPtr(hwndAdd, 0, NULL);

                    if (WinProcessDlg(hwndAdd)) // Processing of the main window procedure
                        {                       // stops while proessing Add package dialog.

                        *pPckTemp1 = *pPckTemp; // Update original package object.
                        pDBPck->usPckIndexAttr = pPckTemp1->ReturnPackageIndexNumber();
                        pPckIDTemp = pPckTemp1->ReturnPackageIDObject();
                        strcpy(pDBPck->szPackageID, pPckIDTemp->ReturnPackage());
                        strcpy(pDBPck->szApplication, pPckIDTemp->ReturnApplication());
                        strcpy(pDBPck->szAuthor, pPckIDTemp->ReturnVendor());
                        strcpy(pDBPck->szPath, pPckTemp1->ReturnTargetText());
                        sprintf(pDBPck->szVersion, "%i.%i.%i", pPckIDTemp->ReturnMajor(),
                             pPckIDTemp->ReturnMinor(), pPckIDTemp->ReturnRevision());

                        // pMsgData is deleted in obj wnd procedure.
                        pMsgData->hwndSender = hwndWnd;
                        pMsgData->hwndObject = pWinInfo->pckContainerInfo.hwndContainer;
                        pMsgData->mp1 = MPFROMP(pDBPck);
                        pMsgData->mp2 = MPFROMP(G_pSourcePckRecord);
                        WinPostMsg(pWinInfo->hwndObjectWnd, USER_UPDATERECORD_PACKAGECNTR,
                            MPFROMP(pMsgData), 0);
                        }
                    delete pPckTemp;
                    break;
                    }
                case IDM_MAIN_EDIT_ADD_PCK:
                case IDM_PCKCONTAINER_ADD:
                    {
                    PMSGDATA pMsgData = NULL;
                    ScriptPackage *pPckTemp = NULL;
                    ScriptPackageID *pPckIDTemp = NULL;

                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
                    ScriptGroup *pScript =
                        pWinInfo->WarpIN.ReturnHeadObject()->ReturnVirtualGroupObject();
                    PLINKLIST plPckList = pWinInfo->plPackageList;
                    PLINKLIST plPckListToObjWnd = lstCreate(FALSE);

                    DBPackage *pDBPck = NULL;
                    PPCKDLGINFO pPckInfo = new PCKDLGINFO;
                    pPckInfo->hwndObjWnd = pWinInfo->hwndObjectWnd;
                    pPckInfo->pPackage = new ScriptPackage();
                    pPckInfo->pPackage->
                        SetPackageIndex((USHORT)lstCountItems(plPckList) + 1);

                    HWND hwndAdd = WinLoadDlg(HWND_DESKTOP,
                                              hwndWnd,
                                              fnPckAddDlgProc,
                                              NULLHANDLE,
                                              IDD_ADDPCK_DIALOG,
                                              (PVOID)pPckInfo);
                    WinSetWindowPtr(hwndAdd, 0, NULL);

                    if (WinProcessDlg(hwndAdd)) // Processing of the main window procedure
                        {                       // stops while proessing Add package dialog.
                        pPckTemp = pScript->CreatePackageObject(pPckInfo->pPackage);
                        pDBPck = new DBPackage;
                        pDBPck->usPckIndexAttr = pPckTemp->ReturnPackageIndexNumber();
                        pPckIDTemp = pPckTemp->ReturnPackageIDObject();
                        strcpy(pDBPck->szPackageID, pPckIDTemp->ReturnPackage());
                        strcpy(pDBPck->szApplication, pPckIDTemp->ReturnApplication());
                        strcpy(pDBPck->szAuthor, pPckIDTemp->ReturnVendor());
                        strcpy(pDBPck->szPath, pPckTemp->ReturnTargetText());
                        sprintf(pDBPck->szVersion, "%i.%i.%i", pPckIDTemp->ReturnMajor(),
                             pPckIDTemp->ReturnMinor(), pPckIDTemp->ReturnRevision());

                        // Append new package to the main package list.
                        lstAppendItem(pWinInfo->plPackageList, pDBPck);

                        // Append the package to object window package list too.
                        // This list is freed by object window after it has inserted
                        // package related data to package container.
                        // When plPckListToObjWnd is created, FALSE parameter was used so
                        // while deleting the list with lstFree the free() will not be
                        // invoked automatically for each list item.
                        lstAppendItem(plPckListToObjWnd, pDBPck);

                        pMsgData = new MSGDATA;
                        pMsgData->hwndSender = hwndWnd;
                        pMsgData->hwndObject = pWinInfo->pckContainerInfo.hwndContainer;
                        pMsgData->pData = (PVOID)plPckListToObjWnd;
                        WinPostMsg(pWinInfo->hwndObjectWnd, USER_ADDRECORDS_PACKAGECNTR,
                            MPFROMP(pMsgData), 0);
                        }
                    delete pPckInfo->pPackage;
                    delete pPckInfo;
                    break;
                    }
                case IDM_MAIN_EDIT_REMOVE_PCK:
                case IDM_PCKCONTAINER_REMOVE:
                    {
                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
                    ScriptGroup *pScript =
                        pWinInfo->WarpIN.ReturnHeadObject()->ReturnVirtualGroupObject();
                    PLINKLIST plPckList = pWinInfo->plPackageList;
                    ScriptGroup *pTempGroup = NULL;
                    PMSGDATA pMsgData = NULL;
                    ScriptPackage *pPckTemp1 = NULL;
                    DBPackage *pDBPck = NULL;

                    // Find ScriptPackage object which index attribute corresponding
                    // to the package index of the selected record.
                    pPckTemp1 =
                        FindScriptPackageObject(pScript, G_pSourcePckRecord->sPackage,
                            &pTempGroup);
                    // Do same thing to package database list.
                    pDBPck = FindDBPckItem(pWinInfo->plPackageList, G_pSourcePckRecord->sPackage);

                    pTempGroup->DeletePackageObject(pPckTemp1->ReturnIndex());

                    lstRemoveItem(plPckList, (PVOID)pDBPck);

                    // Remove selected record from package container.
                    guiRemoveContainerRecords(pWinInfo->pckContainerInfo.hwndContainer,
                        (PVOID)G_pSourcePckRecord, 1);

                    // Remove all records from file container.
                    guiRemoveContainerRecords(pWinInfo->fileContainerInfo.hwndContainer,
                        NULL, 0);
                    break;
                    }
                case IDM_MAIN_EDIT_ADD_FILE_FILEDLG:
                case IDM_FILECONTAINER_ADD_FILEDLG:
                    {
                    PMSGDATA pMsgData = NULL;
                    PSZ pszFileName = "*.*";
                    CHAR szDriver[_MAX_DRIVE], szDir[_MAX_DIR], szFName[_MAX_FNAME];
                    CHAR szExt[_MAX_EXT];
                    PAPSZ papszFQFileName = NULL; // Will be deleted in object window proc.
                    ULONG ulFQFCount = 0;
                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO)WinQueryWindowPtr(hwndWnd, 0);

                    if (guiShowFileDialog(hwndWnd, FILEDLG_TYPE_SELECT,
                            G_nlsStringTable.pszOpenFile, NULL, NULL, &pszFileName,
                            &papszFQFileName, &ulFQFCount)
                            == RET_FD_OK)
                        {
                        DBPackage *pDBPck =
                            FindDBPckItem(pWinInfo->plPackageList,
                                G_pSelectedPckRecord->sPackage);
                        pMsgData = new MSGDATA;
                        pMsgData->hwndSender = hwndWnd;
                        pMsgData->hwndObject = pWinInfo->fileContainerInfo.hwndContainer;
                        pMsgData->hwndObject2 = pWinInfo->pckContainerInfo.hwndContainer;
                        pMsgData->pData = papszFQFileName;
                        pMsgData->mp1 = MPFROMP(G_pSelectedPckRecord);
                        pMsgData->mp2 = MPFROMP(pDBPck);
                        pMsgData->ulData = ulFQFCount;
                        WinPostMsg (pWinInfo->hwndObjectWnd, USER_ADDFILES_DBRECCNTR,
                            MPFROMP(pMsgData), 0);
                        }
                    break;
                    }
                case IDM_MAIN_EDIT_REMOVE_FILE:
                case IDM_FILECONTAINER_REMOVE:
                    {
                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
                    PLINKLIST plPckList = pWinInfo->plPackageList;
                    PMSGDATA pMsgData = NULL;

                    pMsgData = new MSGDATA;
                    pMsgData->hwndSender = hwndWnd;
                    pMsgData->hwndObject = pWinInfo->fileContainerInfo.hwndContainer;
                    pMsgData->hwndObject2 = pWinInfo->pckContainerInfo.hwndContainer;
                    pMsgData->pData = (PVOID)plPckList;
                    pMsgData->mp1 = MPFROMP(G_pSourceFileRecord);
                    pMsgData->mp2 = MPFROMP(G_pSelectedPckRecord);
                    pMsgData->ulData = 0;
                    WinPostMsg (pWinInfo->hwndObjectWnd, USER_REMOVEFILE_DBRECCNTR,
                        MPFROMP(pMsgData), 0);

                    break;
                    }
                case IDM_FILECONTAINER_EDITINSTALLPATH:
                    {
                    /*PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO)WinQueryWindowPtr(hwndWnd, 0);
                    CNREDITDATA cnrEditData;

                    cnrEditData.cb = sizeof(CNREDITDATA);
                    cnrEditData.hwndCnr = pWinInfo->fileContainerInfo.hwndContainer;
                    cnrEditData.pRecord = (PRECORDCORE)G_pSourceFileRecord;
                    cnrEditData.pFieldInfo = NULL;
                    cnrEditData.ppszText = NULL;
                    cnrEditData.cbText = 0;
                    cnrEditData.id = IDD_MAIN_FILECONTAINER;
                    WinSendMsg(pWinInfo->fileContainerInfo.hwndContainer,
                        CM_OPENEDIT, MPFROMP(&cnrEditData), 0);*/
                    break;
                    }
                case IDM_MAIN_EDIT_EDITSCRIPT:
                    {
                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO)WinQueryWindowPtr(hwndWnd, 0);
                    PSCRIPTDLGINFO pScriptInfo = new SCRIPTDLGINFO;
                    pScriptInfo->hwndObjWnd = pWinInfo->hwndObjectWnd;
                    pScriptInfo->pWarpIN = &pWinInfo->WarpIN;
                    HWND hwndAdd = WinLoadDlg(HWND_DESKTOP,
                                              hwndWnd,
                                              fnScriptAddDlgProc,
                                              NULLHANDLE,
                                              IDD_ADDSCRIPT_DIALOG,
                                              (PVOID)pScriptInfo);
                    WinSetWindowPtr(hwndAdd, 0, NULL);

                    WinProcessDlg(hwndAdd);
                    break;
                    }
                case IDM_MAIN_FILE_SAVEAS:
                    {
                    PMAINWINDOWINFO pWinInfo =
                        (PMAINWINDOWINFO)WinQueryWindowPtr(hwndWnd, 0);
                    PSZ pszFileName = NULL;

                    if (guiShowFileDialog(hwndWnd, FILEDLG_TYPE_SAVE,
                            G_nlsStringTable.pszOpenFile, NULL, NULL, &pszFileName,
                            NULL, NULL)
                            != RET_FD_OK)
                        break;

                    TradArcThreadInfo *pTradArcThInfo = new TradArcThreadInfo;
                    pTradArcThInfo->hwndMainWnd = hwndWnd;
                    pTradArcThInfo->pszArchiveFileName = pszFileName;
                    pTradArcThInfo->pWarpIN = &(pWinInfo->WarpIN);
                    DosCreateEventSem(SEM_STATUSDLGREADY,
                                      &pTradArcThInfo->hevStatusDlgReady,
                                      0L,
                                      FALSE);
                    PLISTNODE pNode = lstQueryFirstNode(pWinInfo->plPackageList);
                    DBPackage *pDBPackage;
                    while(pNode)
                        {
                        pDBPackage = (DBPackage*)pNode->pItemData;
                        pTradArcThInfo->listPackages.push_back(pDBPackage);
                        pNode = pNode->pNext;
                        }

                    // Start the archive thread.
                    pWinInfo->tidArchiveThread =
                        _beginthread(thTradArcThread,
                                     NULL,
                                     THREADSTACKSIZE,
                                     pTradArcThInfo);

                    StatusDlgInfo *pSDlgInfo = new StatusDlgInfo;
                    pSDlgInfo->tidArcThread = pWinInfo->tidArchiveThread;
                    pSDlgInfo->pszArchiveFile = pszFileName;
                    pSDlgInfo->hevStatusDlgReady = pTradArcThInfo->hevStatusDlgReady;

                    // Show status dialog.
                    pTradArcThInfo->hwndStatusDlg =
                        WinLoadDlg(HWND_DESKTOP,
                                   hwndWnd,
                                   fnTradCreateArcDlgProc,
                                   NULLHANDLE,
                                   IDD_CREATING_DIALOG,
                                   (PVOID)pSDlgInfo);

                    WinProcessDlg(pTradArcThInfo->hwndStatusDlg);
                    DosCloseEventSem(pTradArcThInfo->hevStatusDlgReady);
                    delete pTradArcThInfo;
                    delete pSDlgInfo;
                    break;
                    }
                } // endswitch
            break;
            } // endcase WM_COMMAND
        case WM_CONTROL:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case IDD_MAIN_PCKCONTAINER: // The package container sent message.
                    {
                    switch (SHORT2FROMMP(mp1))
                        {
                        case CN_CONTEXTMENU:// The container sent this notification code
                            {               // when user wanted the popup menu to be showed
                            POINTL pt;
                            PMAINWINDOWINFO pWinInfo =
                                (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
                            G_pSourcePckRecord = (PPCKRECORD)mp2;
                            if (G_pSourcePckRecord)
                                {
                                WinEnableMenuItem(
                                    pWinInfo->pckContainerInfo.hwndContextMenu,
                                    IDM_PCKCONTAINER_REMOVE, TRUE);
                                WinEnableMenuItem(
                                    pWinInfo->pckContainerInfo.hwndContextMenu,
                                    IDM_PCKCONTAINER_EDIT, TRUE);
                                }
                            else
                                {
                                WinEnableMenuItem(
                                    pWinInfo->pckContainerInfo.hwndContextMenu,
                                    IDM_PCKCONTAINER_REMOVE, FALSE);
                                WinEnableMenuItem(
                                    pWinInfo->pckContainerInfo.hwndContextMenu,
                                    IDM_PCKCONTAINER_EDIT, FALSE);
                                }
                            // Show the popup menu. Pointer position is also needed
                            // because the popup menu must be beside mouse pointer.
                            WinQueryPointerPos (HWND_DESKTOP, &pt);
                            WinPopupMenu (HWND_DESKTOP, hwndWnd,
                                         pWinInfo->pckContainerInfo.hwndContextMenu,
                                         (SHORT)pt.x, (SHORT)pt.y, 0,
                                         PU_NONE | PU_MOUSEBUTTON1 |
                                         PU_MOUSEBUTTON2 | PU_KEYBOARD);
                            break;
                            }
                        case CN_EMPHASIS:// One of the records was been selected by the user
                            {            // so here is determined which record it was and is set
                                         // selected pointer to point to it.
                            PNOTIFYRECORDEMPHASIS pnre = (PNOTIFYRECORDEMPHASIS)mp2;
                            if ((pnre->fEmphasisMask & CRA_SELECTED) &&
                                (pnre->pRecord) &&
                                (G_pSelectedPckRecord != (PPCKRECORD)pnre->pRecord))
                                {
                                PMAINWINDOWINFO pWinInfo =
                                    (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
                                G_pSelectedPckRecord = (PPCKRECORD)pnre->pRecord;
                                DBPackage *pDBPck =
                                    FindDBPckItem(pWinInfo->plPackageList,
                                        G_pSelectedPckRecord->sPackage);
                                PMSGDATA pMsgData = new MSGDATA;
                                pMsgData->hwndSender = hwndWnd;
                                pMsgData->hwndObject =
                                    pWinInfo->fileContainerInfo.hwndContainer;
                                pMsgData->pData = (PVOID)pDBPck->plFileList;
                                pMsgData->ulData = REMOVE_PREV_RECORDS;
                                WinPostMsg(pWinInfo->hwndObjectWnd,
                                    USER_ADDRECORDS_FILECNTR,
                                    MPFROMP(pMsgData), 0);
                                WinEnableMenuItem(
                                    pWinInfo->fileContainerInfo.hwndContextMenu,
                                    IDM_FILECONTAINER_ADD, TRUE);
                                WinEnableMenuItem(
                                    pWinInfo->hwndMainMenu,
                                    IDM_MAIN_EDIT_ADD_FILE, TRUE);
                                }
                            break;
                            }
                        } // end of switch
                    break;
                    } // endcase IDD_MAIN_CONTAINER

                case IDD_MAIN_FILECONTAINER:// The file container sent message.
                    {
                    switch (SHORT2FROMMP(mp1))
                        {
                        case CN_CONTEXTMENU:// The container sent this notification code
                            {               // when user wanted the popup menu to be showed.
                            POINTL pt;
                            PMAINWINDOWINFO pWinInfo =
                                (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);

                            G_pSourceFileRecord = (PFILERECORD)mp2;
                            if (G_pSourceFileRecord)
                                {
                                WinEnableMenuItem(pWinInfo->
                                    fileContainerInfo.hwndContextMenu,
                                    IDM_FILECONTAINER_EDITINSTALLPATH, TRUE);
                                WinEnableMenuItem(pWinInfo->
                                    fileContainerInfo.hwndContextMenu,
                                    IDM_FILECONTAINER_REMOVE, TRUE);
                                }
                            else
                                {
                                WinEnableMenuItem(pWinInfo->
                                    fileContainerInfo.hwndContextMenu,
                                    IDM_FILECONTAINER_EDITINSTALLPATH, FALSE);
                                WinEnableMenuItem(pWinInfo->
                                    fileContainerInfo.hwndContextMenu,
                                    IDM_FILECONTAINER_REMOVE, FALSE);
                                }

                            // Show the popup menu. Pointer position is also needed
                            // because the popup menu must be beside mouse pointer.
                            WinQueryPointerPos (HWND_DESKTOP, &pt);
                            WinPopupMenu (HWND_DESKTOP, hwndWnd,
                                         pWinInfo->fileContainerInfo.hwndContextMenu,
                                         (SHORT)pt.x, (SHORT)pt.y, 0,
                                         PU_NONE | PU_MOUSEBUTTON1 |
                                         PU_MOUSEBUTTON2 | PU_KEYBOARD);
                            break;
                            }
                        case CN_EMPHASIS:// One of the records was been selected by the user
                            {            // so here determined which record it was and set
                                         // selected pointer to point to it.
                            PNOTIFYRECORDEMPHASIS pEmphasis = (PNOTIFYRECORDEMPHASIS)mp2;
                            PMAINWINDOWINFO pWinInfo =
                                (PMAINWINDOWINFO)WinQueryWindowPtr(hwndWnd, 0);
                            if ((pEmphasis->fEmphasisMask & CRA_SELECTED) &&
                                (pEmphasis->pRecord) &&
                                (G_pSelectedFileRecord != (PFILERECORD)pEmphasis->pRecord))
                                {
                                WinEnableMenuItem(
                                    pWinInfo->hwndMainMenu,
                                    IDM_MAIN_EDIT_REMOVE_FILE, TRUE);
                                }
                            }
                        } // endswitch
                    break;
                    } // endcase IDD_MAIN_FILECONTAINER
                } // endswitch
            break;
            } // end of case WM_CONTROL
        case WM_MENUEND:
            {
            PMAINWINDOWINFO pWinInfo =
               (PMAINWINDOWINFO) WinQueryWindowPtr(hwndWnd, 0);
            if (HWNDFROMMP(mp2) == pWinInfo->pckContainerInfo.hwndContextMenu)
                {
                cnrhSetSourceEmphasis(pWinInfo->pckContainerInfo.hwndContainer,
                    G_pSourcePckRecord, FALSE);
                }
            else if (HWNDFROMMP(mp2) == pWinInfo->fileContainerInfo.hwndContextMenu)
                {
                cnrhSetSourceEmphasis(pWinInfo->fileContainerInfo.hwndContainer,
                    G_pSourceFileRecord, FALSE);
                }
            break;
            }
        default:
            {
            mrc = WinDefWindowProc (hwndWnd, msg, mp1, mp2);
            break;    // Default WINDOW message procedure.
            }         // Any message not processed must be
        }             // passed on to WinDefWindowProc and
                      // the value from WinDefWindowProc must
    return mrc;       // be returned from the procedure.
    }




MRESULT EXPENTRY fnPckAddDlgProc (HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    static PNOTEBOOKINFO pNBInfo;

    switch (msg)
        {
        case WM_INITDLG:
            {
            PRECTL pRectl;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            pNBInfo = (PNOTEBOOKINFO) malloc (sizeof (NOTEBOOKINFO));
            pNBInfo->usNbPageCount = 12;
            pNBInfo->hwndNotebook = WinWindowFromID (hwndDlg, IDD_ADDPCK_NOTEBOOK);

            pNBInfo->nbPage[0].ulIDDialogPage = IDD_NB_GENERAL_DIALOG;
            pNBInfo->nbPage[0].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[0].pNbPageDlgProc = fnTradGeneralNBPageProc;
            pNBInfo->nbPage[0].pszStatusLine = G_nlsStringTable.pszTitleGeneral;
            pNBInfo->nbPage[0].pszTab = G_nlsStringTable.pszTabGeneral;
            pNBInfo->nbPage[1].ulIDDialogPage = IDD_NB_GENERAL_DESCRIPTION;
            pNBInfo->nbPage[1].usNbPageStyle = NBP_STYLE_MINOR;
            pNBInfo->nbPage[1].pNbPageDlgProc = fnTradDescriptionNBPageProc;
            pNBInfo->nbPage[1].pszStatusLine = G_nlsStringTable.pszTitleDescription;
            pNBInfo->nbPage[1].pszTab = G_nlsStringTable.pszTabDescription;
            pNBInfo->nbPage[2].ulIDDialogPage = IDD_NB_GENERAL_KEYWORDS;
            pNBInfo->nbPage[2].usNbPageStyle = NBP_STYLE_MINOR;
            pNBInfo->nbPage[2].pNbPageDlgProc = fnTradKeywordsNBPageProc;
            pNBInfo->nbPage[2].pszStatusLine = G_nlsStringTable.pszTitleKeywords;
            pNBInfo->nbPage[2].pszTab = G_nlsStringTable.pszTabKeywords;
            pNBInfo->nbPage[3].ulIDDialogPage = IDD_NB_CONFIGSYS_DIALOG;
            pNBInfo->nbPage[3].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[3].pNbPageDlgProc = fnTradConfigsysPageProc;
            pNBInfo->nbPage[3].pszStatusLine = G_nlsStringTable.pszTitleConfigSys;
            pNBInfo->nbPage[3].pszTab = G_nlsStringTable.pszTabConfigSys;
            pNBInfo->nbPage[4].ulIDDialogPage = IDD_NB_OBJECT_DIALOG;
            pNBInfo->nbPage[4].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[4].pNbPageDlgProc = fnTradObjectPageProc;
            pNBInfo->nbPage[4].pszStatusLine = G_nlsStringTable.pszTitleObject;
            pNBInfo->nbPage[4].pszTab = G_nlsStringTable.pszTabObject;
            pNBInfo->nbPage[5].ulIDDialogPage = IDD_NB_CLASS_REGISTERCLASS_DIALOG;
            pNBInfo->nbPage[5].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[5].pNbPageDlgProc = fnTradRegisterClassPageProc;
            pNBInfo->nbPage[5].pszStatusLine = G_nlsStringTable.pszTitleWPSClassRegister;
            pNBInfo->nbPage[5].pszTab = G_nlsStringTable.pszTabWPSClassRegister;
            pNBInfo->nbPage[6].ulIDDialogPage = IDD_NB_CLASS_REPLACECLASS_DIALOG;
            pNBInfo->nbPage[6].usNbPageStyle = NBP_STYLE_MINOR;
            pNBInfo->nbPage[6].pNbPageDlgProc = fnTradReplaceClassPageProc;
            pNBInfo->nbPage[6].pszStatusLine = G_nlsStringTable.pszTitleWPSClassReplace;
            pNBInfo->nbPage[6].pszTab = G_nlsStringTable.pszTabWPSClassReplace;
            pNBInfo->nbPage[7].ulIDDialogPage = IDD_NB_REQUIRES_DIALOG;
            pNBInfo->nbPage[7].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[7].pNbPageDlgProc = fnTradRequiresPageProc;
            pNBInfo->nbPage[7].pszStatusLine = G_nlsStringTable.pszTitleRequires;
            pNBInfo->nbPage[7].pszTab = G_nlsStringTable.pszTabRequires;
            pNBInfo->nbPage[8].ulIDDialogPage = IDD_NB_ADDITIONAL_EXEC_DIALOG;
            pNBInfo->nbPage[8].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[8].pNbPageDlgProc = fnTradExecutePageProc;
            pNBInfo->nbPage[8].pszStatusLine = G_nlsStringTable.pszTitleExecute;
            pNBInfo->nbPage[8].pszTab = G_nlsStringTable.pszTabExecute;
            pNBInfo->nbPage[9].ulIDDialogPage = IDD_NB_ADDITIONAL_CLEARPROFILE_DIALOG;
            pNBInfo->nbPage[9].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[9].pNbPageDlgProc = fnTradClearProfilePageProc;
            pNBInfo->nbPage[9].pszStatusLine = G_nlsStringTable.pszTitleClearProfile;
            pNBInfo->nbPage[9].pszTab = G_nlsStringTable.pszTabClearProfile;
            pNBInfo->nbPage[10].ulIDDialogPage = IDD_NB_ADDITIONAL_WRITEPROFILE_DIALOG;
            pNBInfo->nbPage[10].usNbPageStyle = NBP_STYLE_MINOR;
            pNBInfo->nbPage[10].pNbPageDlgProc = fnTradWriteProfilePageProc;
            pNBInfo->nbPage[10].pszStatusLine = G_nlsStringTable.pszTitleWriteProfile;
            pNBInfo->nbPage[10].pszTab = G_nlsStringTable.pszTabWriteProfile;
            pNBInfo->nbPage[11].ulIDDialogPage = IDD_NB_BROWSER_DIALOG;
            pNBInfo->nbPage[11].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[11].pNbPageDlgProc = fnTradBrowserNBPageProc;
            pNBInfo->nbPage[11].pszStatusLine = G_nlsStringTable.pszTitleBrowser;
            pNBInfo->nbPage[11].pszTab = G_nlsStringTable.pszTabBrowser;

            pNBInfo->nbPage[0].pWinPtrData = NULL;
            pNBInfo->nbPage[1].pWinPtrData = NULL;
            pNBInfo->nbPage[2].pWinPtrData = NULL;
            pNBInfo->nbPage[3].pWinPtrData = NULL;
            pNBInfo->nbPage[4].pWinPtrData = NULL;
            pNBInfo->nbPage[5].pWinPtrData = NULL;
            pNBInfo->nbPage[6].pWinPtrData = NULL;
            pNBInfo->nbPage[7].pWinPtrData = NULL;
            pNBInfo->nbPage[8].pWinPtrData = NULL;
            pNBInfo->nbPage[9].pWinPtrData = NULL;
            pNBInfo->nbPage[10].pWinPtrData = NULL;
            pNBInfo->nbPage[11].pWinPtrData = NULL;

            pNBInfo->nbPage[0].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[1].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[2].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[3].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[4].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[5].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[6].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[7].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[8].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[9].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[10].pCreateParams = (PVOID)pPckDlgInfo;
            pNBInfo->nbPage[11].pCreateParams = (PVOID)pPckDlgInfo;
            InitializeNotebook (pNBInfo);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                    {
                    free (pNBInfo);
                    WinDismissDlg (hwndDlg, TRUE);
                    break;
                    }
                case DID_CANCEL:
                    {
                    free (pNBInfo);
                    WinDismissDlg (hwndDlg, FALSE);
                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case BKN_PAGESELECTED:
                    {
                    PPAGESELECTNOTIFY pPageSelNotify = (PPAGESELECTNOTIFY)PVOIDFROMMP(mp2);
                    // Add script to script browser when user selects browser page.
                    if (pPageSelNotify->ulPageIdNew == pNBInfo->nbPage[11].ulNBPageID)
                        WinPostMsg (pNBInfo->nbPage[11].hwndNbPage,
                            USER_CREATESCRIPTTEXT, MPNULL, MPNULL);
                    break;
                    }
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }



MRESULT EXPENTRY fnScriptAddDlgProc (HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    static PNOTEBOOKINFO pNBInfo;

    switch (msg)
        {
        case WM_INITDLG:
            {
            PRECTL pRectl;
            PSCRIPTDLGINFO pScriptDlgInfo = (PSCRIPTDLGINFO)mp2;
            pNBInfo = new NOTEBOOKINFO;
            pNBInfo->usNbPageCount = 6;
            pNBInfo->hwndNotebook = WinWindowFromID (hwndDlg, IDD_ADDSCRIPT_NOTEBOOK);

            pNBInfo->nbPage[0].ulIDDialogPage = IDD_ASNB_WARPIN_DIALOG;
            pNBInfo->nbPage[0].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[0].pNbPageDlgProc = fnTradWarpINPageProc;
            pNBInfo->nbPage[0].pszStatusLine = G_nlsStringTable.pszTitleWarpIN;
            pNBInfo->nbPage[0].pszTab = G_nlsStringTable.pszTabWarpIN;
            pNBInfo->nbPage[1].ulIDDialogPage = IDD_ASNB_HEAD_DIALOG;
            pNBInfo->nbPage[1].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[1].pNbPageDlgProc = WinDefDlgProc;
            pNBInfo->nbPage[1].pszStatusLine = G_nlsStringTable.pszTitleHead;
            pNBInfo->nbPage[1].pszTab = G_nlsStringTable.pszTabHead;
            pNBInfo->nbPage[2].ulIDDialogPage = IDD_ASNB_GROUP_DIALOG;
            pNBInfo->nbPage[2].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[2].pNbPageDlgProc = WinDefDlgProc;
            pNBInfo->nbPage[2].pszStatusLine = G_nlsStringTable.pszTitleGroup;
            pNBInfo->nbPage[2].pszTab = G_nlsStringTable.pszTabGroup;
            pNBInfo->nbPage[3].ulIDDialogPage = IDD_ASNB_BODY_DIALOG;
            pNBInfo->nbPage[3].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[3].pNbPageDlgProc = WinDefDlgProc;
            pNBInfo->nbPage[3].pszStatusLine = G_nlsStringTable.pszTitleBody;
            pNBInfo->nbPage[3].pszTab = G_nlsStringTable.pszTabBody;
            pNBInfo->nbPage[4].ulIDDialogPage = IDD_ASNB_PAGE_DIALOG;
            pNBInfo->nbPage[4].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[4].pNbPageDlgProc = fnTradScriptPageProc;
            pNBInfo->nbPage[4].pszStatusLine = G_nlsStringTable.pszTitlePage;
            pNBInfo->nbPage[4].pszTab = G_nlsStringTable.pszTabPage;
            pNBInfo->nbPage[5].ulIDDialogPage = IDD_ASNB_BROWSER_DIALOG;
            pNBInfo->nbPage[5].usNbPageStyle = NBP_STYLE_MAJOR;
            pNBInfo->nbPage[5].pNbPageDlgProc = fnTradScriptBrowserPageProc;
            pNBInfo->nbPage[5].pszStatusLine = G_nlsStringTable.pszTitleBrowser;
            pNBInfo->nbPage[5].pszTab = G_nlsStringTable.pszTabBrowser;

            pNBInfo->nbPage[0].pWinPtrData = NULL;
            pNBInfo->nbPage[1].pWinPtrData = NULL;
            pNBInfo->nbPage[2].pWinPtrData = NULL;
            pNBInfo->nbPage[3].pWinPtrData = NULL;
            pNBInfo->nbPage[4].pWinPtrData = NULL;
            pNBInfo->nbPage[5].pWinPtrData = NULL;

            pNBInfo->nbPage[0].pCreateParams = (PVOID)pScriptDlgInfo;
            pNBInfo->nbPage[1].pCreateParams = (PVOID)pScriptDlgInfo;
            pNBInfo->nbPage[2].pCreateParams = (PVOID)pScriptDlgInfo;
            pNBInfo->nbPage[3].pCreateParams = (PVOID)pScriptDlgInfo;
            pNBInfo->nbPage[4].pCreateParams = (PVOID)pScriptDlgInfo;
            pNBInfo->nbPage[5].pCreateParams = (PVOID)pScriptDlgInfo;
            InitializeNotebook (pNBInfo);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                    {
                    free (pNBInfo);
                    WinDismissDlg (hwndDlg, TRUE);
                    break;
                    }
                case DID_CANCEL:
                    {
                    free (pNBInfo);
                    WinDismissDlg (hwndDlg, FALSE);
                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case BKN_PAGESELECTED:
                    {
                    PPAGESELECTNOTIFY pPageSelNotify = (PPAGESELECTNOTIFY)PVOIDFROMMP(mp2);
                    // Add script to script browser when user selects browser page.
                    if (pPageSelNotify->ulPageIdNew == pNBInfo->nbPage[5].ulNBPageID)
                        WinPostMsg (pNBInfo->nbPage[5].hwndNbPage,
                            USER_CREATESCRIPTBROWSERTEXT, MPNULL, MPNULL);
                    break;
                    }
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/*@@FindDBPckItem
 *  Finds package item which usPckIndexAttr corresponds to usIndex from list and
 *  returns pointer to it. This function simply goes through the linked list and
 *  compares usPckIndexAttr to usIndex.
 */
DBPackage *FindDBPckItem(PLINKLIST plPackageList, USHORT usIndex)
    {
    PLISTNODE pNode = lstQueryFirstNode(plPackageList);
    DBPackage *pDBPck = (DBPackage*)pNode->pItemData;

    while(pNode)
        {
        if (pDBPck->usPckIndexAttr == usIndex)
            return pDBPck;
        pNode = pNode->pNext;
        pDBPck = (DBPackage*)pNode->pItemData;
        }

    return NULL;
    }




/*@@FindScriptPackageObject
 *  Searches ScriptPackage object which IndexAttribute corresponding to usIndex from
 *  ScriptGroup object. Searches sub groups too. If package object is found, returns
 *  pointer to it.
 */
ScriptPackage *FindScriptPackageObject(ScriptGroup *pGroup, USHORT usPackageIndex,
    ScriptGroup **pReturnGroup)
    {
    ScriptPackage *pTmpPackage = NULL, *pTmpPackage2 = NULL;
    ScriptGroup *pTmpGroup = NULL;
    USHORT usIndex = 1;

    // First go through all ScriptPackage objects.
    pTmpPackage = pGroup->ReturnPackageObject(usIndex);
    while (pTmpPackage)
        {
        if (pTmpPackage->ReturnPackageIndexNumber() == usPackageIndex)
            {
            if (pReturnGroup)
                *pReturnGroup = pGroup;
            return pTmpPackage;
            }
        usIndex ++;
        pTmpPackage = pGroup->ReturnPackageObject(usIndex);
        }

    // If not found go recursively through all sub groups.
    usIndex = 1;
    pTmpGroup = pGroup->ReturnSubGroupObject(usIndex);
    while (pTmpGroup)
        {
        pTmpPackage2 = FindScriptPackageObject(pTmpGroup, usPackageIndex);
        if (pTmpPackage2)
            {
            if (pReturnGroup)
                *pReturnGroup = pTmpGroup;
            return pTmpPackage2;
            }

        usIndex ++;
        pTmpGroup = pGroup->ReturnSubGroupObject(usIndex);
        }

    return NULL;
    }



MRESULT EXPENTRY fnTradCreateArcDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    StatusDlgInfo *pSDlgInfo = (StatusDlgInfo*)WinQueryWindowPtr(hwndDlg, 0);

    switch (msg)
        {
        case WM_INITDLG:
            {
            StatusDlgInfo *pSDInfo = (StatusDlgInfo*)mp2;
            WinSetWindowPtr(hwndDlg, 0, pSDInfo);
            ctlProgressBarFromStatic(WinWindowFromID(hwndDlg, IDD_CREATING_COMPLETED),
                                     PBA_ALIGNCENTER);
            DosPostEventSem(pSDInfo->hevStatusDlgReady);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                    {
                    break;
                    }
                case DID_CANCEL:
                    {
                    WinDismissDlg(hwndDlg, ID_MSG_CANCEL);
                    break;
                    }
                case IDD_CREATING_SAVEREPORT: // User wants to save the report.
                    {
                    break;
                    }
                }
            break;
            } /* endcase WM_COMMAND */
        case USER_ARCTM_DONE:
            {
            WinSetDlgItemText (hwndDlg, IDD_CREATING_STATUS, "Ready");
            WinSetDlgItemText (hwndDlg, IDD_CREATING_PACKAGE, "");
            WinSetDlgItemText (hwndDlg, IDD_CREATING_FILE, "");
            WinEnableControl (hwndDlg, IDD_CREATING_SAVEREPORT,TRUE);
            break;
            }
        /*case USER_TM_ARCINITIALIZING:
            {
            WinSetDlgItemText (hwndDlg, IDD_CREATING_STATUS, "Collecting files");
            WinEnableControl (hwndDlg, IDD_CREATING_SAVEREPORT,FALSE);
            break;
            }*/
        case USER_ARCTM_COMPRESS:
            {
            WinSetDlgItemText (hwndDlg, IDD_CREATING_STATUS, "Compressing files");
            WinEnableControl (hwndDlg, IDD_CREATING_SAVEREPORT,FALSE);
            DosPostEventSem(pSDlgInfo->hevStatusDlgReady);
            break;
            }
        /*case USER_TM_ARCCANCEL:
            {
            pWindowInfo->usKillThread = FALSE;
            pWindowInfo->tidCreateArchive = -1;
            WinDismissDlg (hwndDlg, ID_MSG_CANCEL);
            break;
            }*/
        case USER_ARCTM_SET_PCK:
            {
            DBPackage *pDBPck = (DBPackage *)mp1;
            CHAR szMessage[1024];
            sprintf (szMessage, "Process package: %s\n"
                                "\t- %i file(s).\n"
                                "\t- %i bytes total size.\n",
                                pDBPck->szPackageID,
                                pDBPck->ulFiles,
                                pDBPck->ulTotalSize);
            WinSendMsg(WinWindowFromID(hwndDlg, IDD_CREATING_REPORT),
                       MLM_INSERT,
                       (MPARAM)szMessage,
                       MPNULL);
            WinSetDlgItemText (hwndDlg, IDD_CREATING_PACKAGE, pDBPck->
                               szPackageID);
            DosPostEventSem(pSDlgInfo->hevStatusDlgReady);
            break;
            }
        case USER_ARCTM_FILE_PRECENTAGE:
            {
            USHORT usPercentage = SHORT1FROMMP(mp1), usMaxPercentage = 100;
            WinSendDlgItemMsg(hwndDlg, IDD_CREATING_COMPLETED,
                              WM_UPDATEPROGRESSBAR,
                              MPFROMSHORT(usPercentage),
                              MPFROMSHORT(usMaxPercentage));
            WinSetDlgItemText(hwndDlg, IDD_CREATING_FILE, (PSZ)mp2);
            // Post semaphore so WIArchive can continue it's work.
            DosPostEventSem(pSDlgInfo->hevStatusDlgReady);
            break;
            }
        // A file has been added to archive so insert information
        // to MLE.
        case USER_ARCTM_FILE_UPDATING:
            {
            XSTRING xstrStatus;
            CHAR szRation[4];
            USHORT usCompRation = SHORT1FROMMP(mp1);
            xstrInit(&xstrStatus, 0);
            xstrcat(&xstrStatus, "File ", 0);
            xstrcat(&xstrStatus, (PSZ)mp2, 0);
            xstrcat(&xstrStatus, " has been compressed.\n", 0);
            sprintf(szRation, "%i", usCompRation);
            xstrcat(&xstrStatus, "\t-> ", 0);
            xstrcat(&xstrStatus, szRation, 0);
            xstrcat(&xstrStatus, "% compression ratio.\n", 0);
            WinSendMsg(WinWindowFromID(hwndDlg, IDD_CREATING_REPORT),
                       MLM_INSERT,
                       (MPARAM)xstrStatus.psz,
                       MPNULL);
            xstrClear(&xstrStatus);
            // Post semaphore so WIArchive can continue it's work.
            DosPostEventSem(pSDlgInfo->hevStatusDlgReady);
            break;
            }
        /*case USER_TM_FILENOTFOUND: // File is missing so report to user.
            {
            CHAR szMessage[STRINGBUFFERSIZE];
            PSZ pszFileName = (PSZ) PVOIDFROMMP(mp1);
            IPT iOffset = -1;
            sprintf (szMessage, "Error: File %s not found.\n", pszFileName);
            WinSetDlgItemText (hwndDlg, IDD_CREATING_FILE, szMessage);
            InsertMLEText (hwndDlg, IDD_CREATING_REPORT, szMessage, &iOffset);
            break;
            }*/
        case USER_ARCTM_ADD_FILE:
            {
            DBFile *pDBFile = (DBFile*)mp1;
            CHAR szMessage[1024];
            sprintf (szMessage, "Add file: %s%s\n",pDBFile->szFilePath,
                     pDBFile->szFileName);
            WinSendMsg(WinWindowFromID(hwndDlg, IDD_CREATING_REPORT),
                       MLM_INSERT,
                       (MPARAM)szMessage,
                       MPNULL);
            DosPostEventSem(pSDlgInfo->hevStatusDlgReady);
            break;
            }
        case USER_ARCTM_SET_SCRIPT:
            {
            CHAR szMessage[1024];
            sprintf (szMessage,
                     "Generate and add the WarpIN script.\n"
                     "\t- The script size is %i bytes.\n",
                     LONGFROMMP(mp1));
            WinSendMsg(WinWindowFromID(hwndDlg, IDD_CREATING_REPORT),
                       MLM_INSERT,
                       (MPARAM)szMessage,
                       MPNULL);
            DosPostEventSem(pSDlgInfo->hevStatusDlgReady);
            break;
            }
        default:
            {
            mrc = WinDefDlgProc(hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }






