/*
 *              WicPM - WarpIN Archive Creator for PM
 *                  (c) Copyright Teemu Ahola 2000
 *
 * gui_trad_nb_dlgproc.cpp
 *  This file contains dialog procedures for notebook dialog pages used
 *  in WicPM traditional mode.
 */



#define INCL_PM
#define INCL_WIN
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "setup.h"

#include "helpers\winh.h"       // winhXXXX functions created by Ulrich Mller.
#include "helpers\comctl.h"     // progress bar from Ulrich Mller.
#include "helpers\dosh.h"
#include "helpers\linklist.h"
#include "helpers\cnrh.h"
#include "helpers\stringh.h"
#include "helpers\xstring.h"

#include "base\bs_base.h"           // V0.9.14 (2001-07-07) [umoeller]
#include "base\bs_string.h"
#include "base\bs_list.h"           // V0.9.14 (2001-07-07) [umoeller]

#include "wiarchive\wiarchive.h" // WIArchive created by Jens Bckman.

#include "wicpm\wicpm.h"
#include "wicpm\gui_objwnd.h"
#include "wicpm\script.hpp"
#include "wicpm\gui_trad_nb_dlgproc.h"
#include "wicpm\wicpmres.h"
#include "wicpm\gui_helpers.h"
#include "wicpm\gui_trad_cntr.h"
#include "wicpm\gui_wicpm.h"

#include "bl_wicpm.h"


// Global variables.
PPAGERECORD G_pSelectedPageRecord = NULL;
PPAGERECORD G_pSourcePageRecord = NULL;




/*@@FindScriptPageObject
 *  Searches ScriptPage object which usPageIndex corresponding to usIndex from
 *  ScriptBody object.
 */
ScriptPage *FindScriptPageObject(ScriptBody *pBody, USHORT usPageIndex)
    {
    ScriptPage *pTmpPage = NULL;
    USHORT usIndex = 1;

    // Go through all ScriptPage objects.
    pTmpPage = pBody->ReturnPageObject(usIndex);
    while (pTmpPage)
        {
        if (pTmpPage->ReturnPageIndex() == usPageIndex)
            return pTmpPage;
        usIndex ++;
        pTmpPage = pBody->ReturnPageObject(usIndex);
        }

    return NULL;
    }




/*********************************************************************************
 *@@fnTradGeneralPageProc
 *  Dialog procedure for general page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradGeneralNBPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    static BOOL bSelectedFromList = FALSE;

    switch (msg)
        {
        case WM_INITDLG:
            {
            CHAR szNumber[6];
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptPackageID *pPckID = pPck->ReturnPackageIDObject();
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            // Initialize dialog controls.
            guiSetEntryFieldTextLimit(hwndDlg, IDD_NB_GENERAL_PCKNAME, MAXPCKNAMELENGTH);
            guiSetEntryFieldTextLimit(hwndDlg, IDD_NB_GENERAL_AUTHORNAME,
                MAXVENDORNAMELENGTH);
            guiSetEntryFieldTextLimit(hwndDlg, IDD_NB_GENERAL_APPNAME, MAXAPPNAMELENGTH);
            guiSetEntryFieldTextLimit(hwndDlg, IDD_NB_GENERAL_TITLE, MAXTITLELENGTH);
            guiSetEntryFieldTextLimit(hwndDlg, IDD_NB_GENERAL_TARGETPATH, CCHMAXPATH);
            sprintf(szNumber, "%d", pPck->ReturnPackageIndexNumber());
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_INDEX, szNumber);
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_PCKNAME, pPckID->ReturnPackage());
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_AUTHORNAME,
                pPckID->ReturnVendor());
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_APPNAME,
                pPckID->ReturnApplication());
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_TITLE, pPck->ReturnTitleText());
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_TARGETPATH,
                pPck->ReturnTargetText());
            sprintf(szNumber, "%d", pPckID->ReturnMajor());
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_VERSIONMAJOR, szNumber);
            sprintf(szNumber, "%d", pPckID->ReturnMinor());
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_VERSIONMINOR, szNumber);
            sprintf(szNumber, "%d", pPckID->ReturnRevision());
            WinSetDlgItemText(hwndDlg, IDD_NB_GENERAL_VERSIONREVISION, szNumber);

            // Insert target combo box list items.
            /*HWND hwndTarget = WinWindowFromID(hwndDlg, IDD_NB_GENERAL_TARGETPATH);
            WinInsertLboxItem(hwndTarget, LIT_END, TEXT_TARGET_DEFAPPPATH);
            WinInsertLboxItem(hwndTarget, LIT_END, TEXT_TARGET_DEFTOOLPATH);
            WinInsertLboxItem(hwndTarget, LIT_END, TEXT_TARGET_BOOTDRIVER);
            WinInsertLboxItem(hwndTarget, LIT_END, TEXT_TARGET_PCKINDEX);
            WinInsertLboxItem(hwndTarget, LIT_END, TEXT_TARGET_PCK);
            WinInsertLboxItem(hwndTarget, LIT_END, TEXT_TARGET_ENV);*/

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_CANCEL:
                case DID_OK:
                    {
                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case EN_KILLFOCUS:
                    {
                    CHAR szString[256];
                    *szString = '\0';
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr(hwndDlg, 0);
                    ScriptPackageID *pPckID =
                        pPckDlgInfo->pPackage->ReturnPackageIDObject();
                    // If one of the entryfields in General page loses
                    // its focus specific entryfield's text is being
                    // queried.
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_GENERAL_PCKNAME:
                            {
                            WinQueryDlgItemText(hwndDlg, IDD_NB_GENERAL_PCKNAME,
                                               MAXPCKNAMELENGTH, szString);
                            pPckID->SetPackage(szString);

                            break;
                            }
                        case IDD_NB_GENERAL_AUTHORNAME:
                            {
                            WinQueryDlgItemText(hwndDlg, IDD_NB_GENERAL_AUTHORNAME,
                                               MAXVENDORNAMELENGTH, szString);
                            pPckID->SetVendor(szString);
                            break;
                            }
                        case IDD_NB_GENERAL_APPNAME:
                            {
                            WinQueryDlgItemText(hwndDlg, IDD_NB_GENERAL_APPNAME,
                                               MAXAPPNAMELENGTH, szString);
                            pPckID->SetApplication(szString);
                            break;
                            }
                        case IDD_NB_GENERAL_VERSIONMAJOR:
                            {
                            WinQueryDlgItemText(hwndDlg, IDD_NB_GENERAL_VERSIONMAJOR,
                                               MAXVERSIONLENGTH, szString);
                            pPckID->SetMajor(atoi(szString));
                            break;
                            }
                        case IDD_NB_GENERAL_VERSIONMINOR:
                            {
                            WinQueryDlgItemText(hwndDlg, IDD_NB_GENERAL_VERSIONMINOR,
                                               MAXVERSIONLENGTH, szString);
                            pPckID->SetMinor(atoi(szString));
                            break;
                            }
                        case IDD_NB_GENERAL_VERSIONREVISION:
                            {
                            WinQueryDlgItemText(hwndDlg, IDD_NB_GENERAL_VERSIONREVISION,
                                               MAXVERSIONLENGTH, szString);
                            pPckID->SetRevision(atoi(szString));
                            break;
                            }
                        case IDD_NB_GENERAL_TITLE:
                            {
                            WinQueryDlgItemText(hwndDlg, IDD_NB_GENERAL_TITLE,
                                               MAXTITLELENGTH, szString);
                            pPckDlgInfo->pPackage->SetTitle(szString);
                            //break;
                          //  }
                        //case IDD_NB_GENERAL_TARGETPATH:
                            //{
                            WinQueryDlgItemText(hwndDlg, IDD_NB_GENERAL_TARGETPATH,
                                               CCHMAXPATH, szString);
                            pPckDlgInfo->pPackage->SetTarget(szString);
                            break;
                            }
                        }
                    break;
                    } // endcase EN_KILLFOCUS.
                /*case CBN_LBSELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_GENERAL_TARGETPATH:
                            {
                            // An item has been selected from list.
                            //bSelectedFromList = TRUE;
                            break;
                            }
                        }
                    break;
                    }*/
                /*case CBN_LBSELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_GENERAL_TARGETPATH:
                            {
                            CHAR szTemp[CCHMAXPATH];
                            PSZ pszFirst = NULL, pszLast = NULL, pszTemp = NULL;
                            USHORT usFirst = 0, usLast = 0;
                            HWND hwndEF = (HWND)LONGFROMMP(mp2);

                            // Check that the text was selected from the list.
                            // If not, break.
                            if (bSelectedFromList == FALSE)
                                break;
                            bSelectedFromList = FALSE;

                            WinQueryWindowText(hwndEF, CCHMAXPATH, szTemp);

                            // Check if there is '(' somewhere.
                            pszFirst = strchr(szTemp, '(');
                            // If there is '(', try to find ending ')'.
                            if (pszFirst)
                                {
                                pszLast = strchr(szTemp, ')');
                                // There is no ')' in the string. Leave.
                                if (!pszLast)
                                    break;
                                // Get first ('s index.
                                pszTemp = szTemp;
                                while (pszTemp != pszFirst)
                                    {
                                    usFirst ++;
                                    pszTemp ++;
                                    }
                                // Get last )'s index.
                                pszTemp = szTemp;
                                while (pszTemp != pszLast)
                                    {
                                    usLast ++;
                                    pszTemp ++;
                                    }
                                // Select the text between '(' and ')'.
                                WinSendMsg(hwndEF, EM_SETSEL,
                                           MPFROM2SHORT(usFirst + 1, usLast - 1), 0);
                                }
                            break;
                            }
                        }
                    break;
                    }*/
                }
            break;
            } // endcase WM_CONTROL.
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }



/*********************************************************************************
 *@@fnTradDescriptionPageProc
 *  Dialog procedure for general page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradDescriptionNBPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                             MPARAM mp2)
    {
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            PSZ pszScript = pPckDlgInfo->pPackage->ReturnDescription();
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            guiClearMLE (hwndDlg, IDD_NB_GENERAL_DESCR_MLE);
            guiSetMLEText (hwndDlg, IDD_NB_GENERAL_DESCR_MLE, pszScript);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_CANCEL:
                case DID_OK:
                    {
                    break;
                    }
                case IDD_NB_GENERAL_DESCR_IMPORT:
                    {
                    HWND  hwndMle = WinWindowFromID(hwndDlg, IDD_NB_GENERAL_DESCR_MLE);
                    PSZ pszText = NULL;
                    IPT   lOffset = 0;
                    PSZ   pszTextFile;
                    HFILE hf;
                    ULONG cbCopied;
                    ULONG ulAction;
                    ULONG cbBytesRead;
                    PSZ pszFileName = "*.*";
                    APSZ apszITypeList[2];
                    (*apszITypeList)[0] = "Plain Text";
                    (*apszITypeList)[1] = NULL;
                    if (guiShowFileDialog (hwndDlg, FILEDLG_TYPE_OPEN,
                       G_nlsStringTable.pszOpenFile, apszITypeList,
                       (*apszITypeList)[0], &pszFileName, NULL, NULL)
                       == RET_FD_OK)
                        {
                        // Clear the MLE.
                        //guiClearMLE(hwndDlg, IDD_NB_GENERAL_DESCR_MLE);
                        // Open the file and read text from it.
                        doshLoadTextFile(pszFileName, &pszText, NULL);

                        WinSetWindowText(hwndMle, pszText);
                        WinSetFocus(HWND_DESKTOP, hwndMle);
                        delete pszText;
                        // Close the file.
                        DosClose(hf);
                        }
                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case MLN_KILLFOCUS:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        // If description multi line entryfield (MLE) loses
                        // focus, MLE's text is being queried.
                        case IDD_NB_GENERAL_DESCR_MLE:
                            {
                            HWND hwndMle =
                                WinWindowFromID(hwndDlg, IDD_NB_GENERAL_DESCR_MLE);
                            PPCKDLGINFO pPckDlgInfo =
                                (PPCKDLGINFO)WinQueryWindowPtr(hwndDlg, 0);
                            LONG lTextLength = WinQueryWindowTextLength(hwndMle);
                            PSZ pszDescription = new CHAR[lTextLength + 1];
                            *pszDescription = '\0';
                            WinQueryWindowText(hwndMle, lTextLength, pszDescription);

                            if (pPckDlgInfo)
                                pPckDlgInfo->pPackage->SetDescription(pszDescription);
                            delete [] pszDescription;
                            break;
                            }
                        }
                    break;
                    } // endcase MLN_KILLFOCUS.
                }
            break;
            } // endcase WM_CONTROL.
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }





/******************************************************************************
 *@@fnTradKeywordsPageProc
 *  Dialog procedure for general page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradKeywordsNBPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                           MPARAM mp2)
    {
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptKeyWord *pKW = pPck->ReturnKeyWordObject();
            USHORT usKW = pKW->ReturnKeyWord();
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            // Set check button's states accordingly.
            if (usKW & KEYWORD_BASE)
                WinSendDlgItemMsg(hwndDlg, IDD_NB_GENERAL_KW_BASE,
                                 BM_SETCHECK, MPFROMSHORT(1), 0);
            if (usKW & KEYWORD_FIXED)
                WinSendDlgItemMsg(hwndDlg, IDD_NB_GENERAL_KW_FIXED,
                                 BM_SETCHECK, MPFROMSHORT(1), 0);
            if (usKW & KEYWORD_SELECT)
                WinSendDlgItemMsg(hwndDlg, IDD_NB_GENERAL_KW_SELECT,
                                 BM_SETCHECK, MPFROMSHORT(1), 0);
            if (usKW & KEYWORD_NODESELECT)
                WinSendDlgItemMsg(hwndDlg, IDD_NB_GENERAL_KW_NODESELECT,
                                 BM_SETCHECK, MPFROMSHORT(1), 0);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_CANCEL:
                case DID_OK:
                    {
                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case BN_CLICKED:
                case BN_DBLCLICKED:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptKeyWord *pKW = pPck->ReturnKeyWordObject();
                    // If  one of the keyword checkboxes is selected, set keywords.
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_GENERAL_KW_BASE:
                            {
                            USHORT usCheckState = WinQueryButtonCheckstate (hwndDlg,
                                                  IDD_NB_GENERAL_KW_BASE);
                            if (usCheckState)
                                pKW->SetBase(TRUE);
                            else
                                pKW->SetBase(FALSE);
                            break;
                            }
                        case IDD_NB_GENERAL_KW_FIXED:
                            {
                            USHORT usCheckState = WinQueryButtonCheckstate (hwndDlg,
                                                  IDD_NB_GENERAL_KW_FIXED);
                            if (usCheckState)
                                pKW->SetFixed(TRUE);
                            else
                                pKW->SetFixed(FALSE);
                            break;
                            }
                        case IDD_NB_GENERAL_KW_SELECT:
                            {
                            USHORT usCheckState = WinQueryButtonCheckstate (hwndDlg,
                                                  IDD_NB_GENERAL_KW_SELECT);
                            if (usCheckState)
                                pKW->SetSelect(TRUE);
                            else
                                pKW->SetSelect(FALSE);
                            break;
                            }
                        case IDD_NB_GENERAL_KW_NODESELECT:
                            {
                            USHORT usCheckState = WinQueryButtonCheckstate (hwndDlg,
                                                  IDD_NB_GENERAL_KW_NODESELECT);
                            if (usCheckState)
                                pKW->SetNoDeselect(TRUE);
                            else
                                pKW->SetNoDeselect(FALSE);
                            break;
                            }
                        }
                    break;
                    } // endcase BN_CLICKED & BN_DBLCLICKED.
                }
            break;
            } // endcase WM_CONTROL
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }



/******************************************************************************
 *@@fnTradConfigsysPageProc
 *  Dialog procedure for general page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradConfigsysPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
        // This tells which item of the list box is selected so we don't have to
        // query selected items every time when we want to know if a item is selected.
    static USHORT sSelected;
    static USHORT usModifiers;
    MRESULT mrc = 0;


    switch (msg)
        {
        case WM_INITDLG:
            {
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            sSelected = 0;
            usModifiers = 0;
            WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_REMOVE, FALSE);
            break;
            }
        case WM_COMMAND:
            {
            PSZ pszScript = NULL;
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                case DID_CANCEL:
                    {
                    break;
                    }
                case IDD_NB_CONFIGSYS_ADD:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg, IDD_NB_CONFIGSYS_STATEMENTLIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptConfigSys *pCfgSys = NULL;
                    if (sSelected == 0)
                        pCfgSys = pPck->CreateConfigSysObject();
                    else
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pCfgSys = pPck->ReturnConfigSysObject((USHORT)sSelected);
                        }
                    CHAR szTemp[1024];
                        /* Read entry fields text */
                    WinQueryDlgItemText (hwndDlg, IDD_NB_CONFIGSYS_STATEMENTEF,
                                        MAXSTATEMENTLENGTH, szTemp);
                    pCfgSys->SetStatement(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_CONFIGSYS_SEARCHSTRING,
                                        MAXSEARCHSTRINGLENGTH, szTemp);
                    pCfgSys->SetSearchString(szTemp);
                        /* Set modifiers base on user selection */
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE))
                        pCfgSys->SetUnique(TRUE);
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT))
                        pCfgSys->SetAddRight(TRUE);
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT))
                        pCfgSys->SetAddLeft(TRUE);
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDTOP))
                        pCfgSys->SetAddTop(TRUE);
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDAFTER))
                        pCfgSys->SetAddAfter(TRUE);
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDBEFORE))
                        pCfgSys->SetAddBefore(TRUE);
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE))
                        pCfgSys->SetRemoveLine(TRUE);
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART))
                        pCfgSys->SetRemovePart(TRUE);

                    pszScript = pCfgSys->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndLbox, pCfgSys->ReturnIndex() - 1, pszScript);
                    delete [] pszScript;

                    sSelected = 0;
                    usModifiers = MODIFIER_NONE;

                    // Set control states.
                    WinSendMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                        MPFROMSHORT(MODIFIER_NONE), 0);
                        // Clear entry fields.
                    WinSetDlgItemText (hwndDlg, IDD_NB_CONFIGSYS_STATEMENTEF, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_CONFIGSYS_SEARCHSTRING, "");
                        /* Enable Remove button. There is now atleast one item.  */
                    WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_REMOVE,
                                     TRUE);
                    break;
                    }
                case IDD_NB_CONFIGSYS_CLEAR:
                    {
                    WinSendMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                        MPFROMSHORT(MODIFIER_NONE), 0);
                        // Clear entry fields.
                    WinSetDlgItemText (hwndDlg, IDD_NB_CONFIGSYS_STATEMENTEF, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_CONFIGSYS_SEARCHSTRING, "");

                    WinSendDlgItemMsg(hwndDlg, IDD_NB_CONFIGSYS_STATEMENTLIST,
                        LM_SELECTITEM, MPFROMSHORT(LIT_NONE), FALSE);
                    sSelected = 0;
                    usModifiers = MODIFIER_NONE;
                    break;
                    }
                case IDD_NB_CONFIGSYS_REMOVE:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_CONFIGSYS_STATEMENTLIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    if (sSelected != 0)
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                                  0);
                        pPck->DeleteConfigSysObject((USHORT)sSelected);
                        // Set control states.
                        WinSendMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                            MPFROMSHORT(MODIFIER_NONE), 0);
                        // Clear entry fields.
                        WinSetDlgItemText (hwndDlg, IDD_NB_CONFIGSYS_STATEMENTEF, "");
                        WinSetDlgItemText (hwndDlg, IDD_NB_CONFIGSYS_SEARCHSTRING, "");
                        }
                    sSelected = 0;
                    usModifiers = MODIFIER_NONE;
                    if (pPck->ReturnConfigSysObjectCount() == 0)
                        WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_REMOVE, FALSE);

                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case BN_CLICKED:
                case BN_DBLCLICKED:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_CONFIGSYS_MOD_UNIQUE:
                            {
                            USHORT usCheckState = WinQueryButtonCheckstate (hwndDlg,
                                                            IDD_NB_CONFIGSYS_MOD_UNIQUE);
                            if (usCheckState == 1)
                                {
                                usModifiers |= MODIFIER_UNIQUE;
                                WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                                }
                            else
                                {
                                usModifiers &= ~MODIFIER_UNIQUE;
                                WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                                }
                            break;
                            }
                        case IDD_NB_CONFIGSYS_MOD_ADDRIGHT:
                            {
                            usModifiers |= MODIFIER_ADDRIGHT;
                            usModifiers &= ~MODIFIER_ADDLEFT;
                            usModifiers &= ~MODIFIER_ADDTOP;
                            WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                            break;
                            }
                        case IDD_NB_CONFIGSYS_MOD_ADDLEFT:
                            {
                            usModifiers |= MODIFIER_ADDLEFT;
                            usModifiers &= ~MODIFIER_ADDRIGHT;
                            usModifiers &= ~MODIFIER_ADDTOP;
                            WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                            break;
                            }
                        case IDD_NB_CONFIGSYS_MOD_ADDTOP:
                            {
                            usModifiers |= MODIFIER_ADDTOP;
                            usModifiers &= ~MODIFIER_ADDRIGHT;
                            usModifiers &= ~MODIFIER_ADDLEFT;
                            WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                            break;
                            }
                        case IDD_NB_CONFIGSYS_MOD_ADDAFTER:
                            {
                            usModifiers |= MODIFIER_ADDAFTER;
                            WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                            break;
                            }
                        case IDD_NB_CONFIGSYS_MOD_ADDBEFORE:
                            {
                            usModifiers |= MODIFIER_ADDBEFORE;
                            WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                            break;
                            }
                        case IDD_NB_CONFIGSYS_MOD_REMOVELINE:
                            {
                            usModifiers |= MODIFIER_REMOVELINE;
                            WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                            break;
                            }
                        case IDD_NB_CONFIGSYS_MOD_REMOVEPART:
                            {
                            usModifiers |= MODIFIER_REMOVEPART;
                            WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                                    MPFROMSHORT(usModifiers), 0);
                            break;
                            }
                        case IDD_NB_CONFIGSYS_STATEMENTLIST:
                            {
                            // Query selected list box item.
                            SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_CONFIGSYS_STATEMENTLIST, LM_QUERYSELECTION,
                                MPFROMSHORT(LIT_FIRST), 0));
                            if (sRet != LIT_NONE)
                                {
                                sSelected = sRet + 1;
                                WinPostMsg(hwndDlg, USER_CFGSYS_SETDLGITEMS, NULL,
                                           NULL);
                                }
                            break;
                            }
                        } /* endswitch */
                    break;
                    } /* endcase BN_CLICKED BN_DBLCLICKED*/
                switch (SHORT1FROMMP(mp1))
                    {
                    case IDD_NB_CONFIGSYS_STATEMENTLIST:
                        {
                        switch (SHORT2FROMMP(mp1))
                            {
                            case LN_SELECT:
                                {
                                // Query selected list box item.
                                /*SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                    IDD_NB_CONFIGSYS_STATEMENTLIST, LM_QUERYSELECTION,
                                    MPFROMSHORT(LIT_FIRST), 0));
                                if (sRet != LIT_NONE)
                                    {
                                    sSelected = sRet + 1;
                                    WinPostMsg(hwndDlg, USER_CFGSYS_SETDLGITEMS, NULL,
                                               NULL);
                                    }*/
                                break;
                                }
                            }
                        break;
                        }
                    }
                }
            break;
            } /* endcase WM_CONTROL */
        case USER_CFGSYS_SETDLGITEMS:
            {
            CONFIGSYSDATA cfgSysData;
            PSZ pszTemp = NULL;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
            HWND hwndLbox = WinWindowFromID (hwndDlg, IDD_NB_CONFIGSYS_STATEMENTLIST);
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptConfigSys *pCfgSys = NULL;
            if (sSelected > 0)
                {
                pCfgSys = pPck->ReturnConfigSysObject((USHORT)sSelected);
                cfgSysData = pCfgSys->ReturnConfigSys();
                usModifiers = cfgSysData.usModifiers;
                pszTemp = pCfgSys->ReturnStatement();
                WinSetDlgItemText(hwndDlg, IDD_NB_CONFIGSYS_STATEMENTEF, pszTemp);
                pszTemp = pCfgSys->ReturnSearchString();
                WinSetDlgItemText(hwndDlg, IDD_NB_CONFIGSYS_SEARCHSTRING, pszTemp);
                WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                    MPFROMSHORT(MODIFIER_NONE), NULL);
                WinPostMsg(hwndDlg, USER_CFGSYS_SETCNTRLSTATES,
                    MPFROMSHORT(usModifiers), MPFROMSHORT(TRUE));
                }
            break;
            }
        // Sets control window states in config sys dialog.
        // Note that this does not ensure that modifier combinations are valid.
        // If mp2 is true, controls will be selected too.
        case USER_CFGSYS_SETCNTRLSTATES:
            {
            USHORT usMod = SHORT1FROMMP(mp1);
            if (usMod == MODIFIER_NONE) // No modifiers.
                {
                // Enable all controls.
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDTOP, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDAFTER, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDBEFORE, TRUE);
                // Uncheck all controls.
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDTOP, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDAFTER, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDBEFORE, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, 0);
                }
            if (usMod & MODIFIER_UNIQUE)  // One of the modifiers is unique.
                {
                // Disable AddRight and AddLeft controls.
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDTOP, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDAFTER, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDBEFORE, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, FALSE);
                // Uncheck them too.
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, 0);
                if ((BOOL)mp2)
                    WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE, 1);
                }
            // One of the modifiers is addright or addleft.
            if ((usMod & MODIFIER_ADDRIGHT) || (usMod & MODIFIER_ADDLEFT))
                {
                // Disable controls.
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDTOP, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDAFTER, TRUE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDBEFORE, TRUE);
                // Uncheck controls.
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE, 0);
                if (((BOOL)mp2) && (usMod & MODIFIER_ADDRIGHT))
                    WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT, 1);
                if (((BOOL)mp2) && (usMod & MODIFIER_ADDLEFT))
                    WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT, 1);
                }
            // One of the modifiers is removeline or removepart.
            if ((usMod & MODIFIER_REMOVELINE) || (usMod & MODIFIER_REMOVEPART))
                {
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDTOP, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDAFTER, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDBEFORE, FALSE);
                // Uncheck all controls.
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDTOP, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDAFTER, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDBEFORE, 0);
                if (((BOOL)mp2) && (usMod & MODIFIER_REMOVELINE))
                    WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, 1);
                if (((BOOL)mp2) && (usMod & MODIFIER_REMOVEPART))
                    WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, 1);
                }
            // One of the modifiers is addtop, addbefore or addafter.
            if ((usMod & MODIFIER_ADDTOP) || (usMod & MODIFIER_ADDBEFORE)
                || (usMod & MODIFIER_ADDAFTER))
                {
                if ((!usMod & MODIFIER_ADDLEFT) && (!usMod & MODIFIER_ADDRIGHT))
                    WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_UNIQUE, TRUE);
                if (!usMod & MODIFIER_UNIQUE)
                    {
                    WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDRIGHT, TRUE);
                    WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDLEFT, TRUE);
                    }
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, FALSE);
                WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, FALSE);
                // Uncheck controls.
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVELINE, 0);
                WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_REMOVEPART, 0);
                if (((BOOL)mp2) && (usMod & MODIFIER_ADDTOP))
                    WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDTOP, 1);
                if (((BOOL)mp2) && (usMod & MODIFIER_ADDAFTER))
                    WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDAFTER, 1);
                if (((BOOL)mp2) && (usMod & MODIFIER_ADDBEFORE))
                    WinCheckButton (hwndDlg, IDD_NB_CONFIGSYS_MOD_ADDBEFORE, 1);
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }



/******************************************************************************
 *@@fnTradObjectPageProc
 *  Dialog procedure for object page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradObjectPageProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    static SHORT sSelected;
    switch (msg)
        {
        case WM_INITDLG:
            {
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            POBJCLASS pObjClass = NULL;
            PMSGDATA pMsgData = NULL;
            ULONG ulSize = 0;
            ScriptPackage *pPackage = pPckDlgInfo->pPackage;
            sSelected = 0;
            HWND hwndListLbox = WinWindowFromID (hwndDlg, IDD_NB_OBJECT_LIST);
            HWND hwndLocLbox = WinWindowFromID (hwndDlg, IDD_NB_OBJECT_LOCATION);
            HWND hwndClassLbox = WinWindowFromID (hwndDlg, IDD_NB_OBJECT_CLASSNAME);
            HWND hwndConfigLbox = WinWindowFromID (hwndDlg, IDD_NB_OBJECT_CONFIG);

            /*  // Subclass config listbox's window procedure with fnCnfgLbox.
                // This way we can modify the function of the listbox.
                PFNWP OldLboxProc = WinSubclassWindow(hwndConfigLbox, fnCnfgLbox);
                if (OldLboxProc)
                    {
                    OLDPROC *pData = (OLDPROC*)malloc(sizeof(OLDPROC));
                    pData->OldProc = OldLboxProc;
                    WinSetWindowULong(hwndConfigLbox, QWL_USER, (ULONG)pData);
                    }
            */

            pMsgData = new MSGDATA;
            pMsgData->hwndSender = hwndDlg;
            pMsgData->hwndObject = hwndListLbox;
            pMsgData->pData = (PVOID)pPackage;
            WinPostMsg(pPckDlgInfo->hwndObjWnd, USER_INIT_OBJECT_LISTBOX,
                MPFROMP(pMsgData), 0);

            // Insert different object locations to the location combo-box.
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_WPNOWHERE);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_WPDESKTOP);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_WPOS2SYS);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_WPTEMPS);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_WPCONFIG);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_WPSTART);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_WPINFO);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_WPDRIVERS);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_PROMPTS);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_TOOLS);
            WinInsertLboxItem (hwndLocLbox, LIT_END, TEXT_SYSTEMFOLDER_GAMES);

            // Insert different object locations to the config combo-box.
            WinInsertLboxItem (hwndConfigLbox, LIT_END, TEXT_SETUPSTRING_EXENAME);
            WinInsertLboxItem (hwndConfigLbox, LIT_END, TEXT_SETUPSTRING_OBJECTID);

            // Returns a list of all registered WPS classes.
            if (WinEnumObjectClasses(NULL, &ulSize))
                {
                // Allocate buffer.
                pObjClass = (POBJCLASS)malloc(ulSize+1);
                // Load the classes into it.
                WinEnumObjectClasses(pObjClass, &ulSize);
                }
            // Put the names of the classes to combo-box.
            while (pObjClass)
                {
                WinInsertLboxItem (hwndClassLbox, LIT_END, pObjClass->pszClassName);
                pObjClass = pObjClass->pNext;
                }
            delete [] pObjClass;

            guiSetEntryFieldTextLimit(hwndDlg, IDD_NB_OBJECT_CONFIG, MAXCLASSCONFIGLENGTH);

            WinEnableControl (hwndDlg, IDD_NB_CONFIGSYS_REMOVE, FALSE);
            WinEnableControl (hwndDlg, IDD_NB_OBJECT_UP, FALSE);
            WinEnableControl (hwndDlg, IDD_NB_OBJECT_DOWN, FALSE);
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                case DID_CANCEL:
                    {
                    break;
                    }
                case IDD_NB_OBJECT_ADD:
                    {
                    PSZ pszScript = NULL;
                    CHAR szTemp[1024];
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg, IDD_NB_OBJECT_LIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptCreateObject *pObject = NULL;
                    if (sSelected == 0)
                        pObject = pPck->CreateCreateObjectObject();
                    else
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pObject = pPck->ReturnCreateObjectObject((USHORT)sSelected);
                        }
                        /* Read entry fields text */
                    WinQueryDlgItemText (hwndDlg, IDD_NB_OBJECT_CLASSNAME,
                                        MAXCLASSNAMELENGTH,
                                        szTemp);
                    pObject->SetClassName(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_OBJECT_TITLE,
                                        MAXCLASSTITLELENGTH, szTemp);
                    pObject->SetTitle(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_OBJECT_LOCATION,
                                        CCHMAXPATH, szTemp);
                    pObject->SetLocation(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_OBJECT_CONFIG,
                                        MAXCLASSCONFIGLENGTH, szTemp);
                    pObject->SetConfig(szTemp);
                    if (WinQueryButtonCheckstate (hwndDlg, IDD_NB_OBJECT_REPLACE) == 1)
                        pObject->SetReplace(TRUE);

                    pszScript = pObject->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndLbox, pObject->ReturnIndex() - 1, pszScript);
                    delete [] pszScript;
                        // Now there is atleast one item in list box so enable
                        // remove button.
                    WinEnableControl (hwndDlg, IDD_NB_OBJECT_REMOVE, TRUE);
                        // Clear entry fields.
                    WinSetDlgItemText (hwndDlg, IDD_NB_OBJECT_CLASSNAME, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_OBJECT_TITLE, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_OBJECT_LOCATION, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_OBJECT_CONFIG, "");
                        // Uncheck replace check button.
                    WinCheckButton (hwndDlg, IDD_NB_OBJECT_REPLACE, FALSE);

                    WinEnableControl (hwndDlg, IDD_NB_OBJECT_UP, FALSE);
                    WinEnableControl (hwndDlg, IDD_NB_OBJECT_DOWN, FALSE);

                    sSelected = 0;
                    break;
                    }
                case IDD_NB_OBJECT_REMOVE:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr(hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID(hwndDlg,
                        IDD_NB_OBJECT_LIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    if (sSelected != 0)
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pPck->DeleteCreateObjectObject((USHORT)sSelected);
                            // Clear entry fields.
                        WinSetDlgItemText(hwndDlg, IDD_NB_OBJECT_CLASSNAME, "");
                        WinSetDlgItemText(hwndDlg, IDD_NB_OBJECT_TITLE, "");
                        WinSetDlgItemText(hwndDlg, IDD_NB_OBJECT_LOCATION, "");
                        WinSetDlgItemText(hwndDlg, IDD_NB_OBJECT_CONFIG, "");
                            // Uncheck replace check button.
                        WinCheckButton(hwndDlg, IDD_NB_OBJECT_REPLACE, FALSE);
                        }
                    sSelected = 0;
                    if (pPck->ReturnCreateObjectObjectCount() == 0)
                        WinEnableControl(hwndDlg, IDD_NB_OBJECT_REMOVE, FALSE);
                    WinEnableControl(hwndDlg, IDD_NB_OBJECT_UP, FALSE);
                    WinEnableControl(hwndDlg, IDD_NB_OBJECT_DOWN, FALSE);
                    break;
                    }
                case IDD_NB_OBJECT_UP:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_OBJECT_LIST);
                    ScriptCreateObject *pObject = NULL, *pDestination = NULL, temp;
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    PSZ pszScript = NULL;

                    // If user has selected an list box item and it is not the first
                    // one, it can be moved upwards.
                    if (sSelected > 1)
                        {
                        // Get selected entity.
                        pObject = pPck->ReturnCreateObjectObject(sSelected);
                        // Get entity before selected entity.
                        pDestination = pPck->ReturnCreateObjectObject(sSelected - 1);
                        // Swap the contents of the entities.
                        temp = *pObject;
                        *pObject = *pDestination;
                        *pDestination = temp;
                        // Swap indexes.
                        pDestination->SetIndex(pObject->ReturnIndex());
                        pObject->SetIndex(temp.ReturnIndex());
                        // Delete old list box items. We have to substract 1 and 2
                        // because indexing in script class doesn't start from 0
                        // but it starts from 1 and sSelected tells which object
                        // is selected and not which list index is selected.
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                                   0);
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 2),
                                   0);
                        // Set proper script texts to the list box.
                        pszScript = pDestination->MakeScriptText(FALSE);
                        WinInsertLboxItem(hwndLbox, pDestination->ReturnIndex() - 1,
                                          pszScript);
                        delete [] pszScript;
                        pszScript = pObject->MakeScriptText(FALSE);
                        WinInsertLboxItem(hwndLbox, pObject->ReturnIndex() - 1,
                                          pszScript);
                        delete [] pszScript;
                        // Select object which was selected before.
                        WinSendMsg(hwndLbox, LM_SELECTITEM, MPFROMSHORT(sSelected - 2),
                                   MPFROMSHORT(TRUE));
                        }
                    break;
                    }
                case IDD_NB_OBJECT_DOWN:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_OBJECT_LIST);
                    ScriptCreateObject *pObject = NULL, *pDestination = NULL, temp;
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    PSZ pszScript = NULL;

                    // If user has selected an list box item and it is not the last
                    // one, it can be moved downwards.
                    if (sSelected < pPck->ReturnCreateObjectObjectCount())
                        {
                        // Get selected entity.
                        pObject = pPck->ReturnCreateObjectObject(sSelected);
                        // Get entity after selected entity.
                        pDestination = pPck->ReturnCreateObjectObject(sSelected + 1);
                        // Swap the contents of the entities.
                        temp = *pObject;
                        *pObject = *pDestination;
                        *pDestination = temp;
                        // Swap indexes.
                        pDestination->SetIndex(pObject->ReturnIndex());
                        pObject->SetIndex(temp.ReturnIndex());
                        // Delete old list box items. We have to subtract 1
                        // because indexing in script class doesn't start from 0
                        // but it starts from 1 and sSelected tells which object
                        // is selected and not which list index is selected.
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected),
                                   0);
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                                   0);
                        // Set proper script texts to the list box.
                        pszScript = pObject->MakeScriptText(FALSE);
                        WinInsertLboxItem(hwndLbox, pObject->ReturnIndex() - 1,
                                          pszScript);
                        delete [] pszScript;
                        pszScript = pDestination->MakeScriptText(FALSE);
                        WinInsertLboxItem(hwndLbox, pDestination->ReturnIndex() - 1,
                                          pszScript);
                        delete [] pszScript;
                        // Select object which was selected before.
                        WinSendMsg(hwndLbox, LM_SELECTITEM, MPFROMSHORT(sSelected),
                                   MPFROMSHORT(TRUE));
                        }
                    break;
                    }
                }
            break; // endcase WM_COMMAND.
            }
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case LN_SELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_OBJECT_LIST:
                            {
                            // Query selected list box item.
                            SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_OBJECT_LIST, LM_QUERYSELECTION,
                                MPFROMSHORT(LIT_FIRST), 0));
                            SHORT sCount = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_OBJECT_LIST, LM_QUERYITEMCOUNT, 0, 0));
                            // If something is selected.
                            if (sRet != LIT_NONE)
                                {
                                sSelected = sRet + 1;
                                // Send message to this dialog, which is actually
                                // converted to function call, to set controls.
                                WinSendMsg(hwndDlg, USER_OBJECT_SETDLGITEMS, NULL,
                                           NULL);
                                if (sRet == 0)
                                    WinEnableControl (hwndDlg, IDD_NB_OBJECT_UP, FALSE);
                                else
                                    WinEnableControl (hwndDlg, IDD_NB_OBJECT_UP, TRUE);
                                if (sRet == sCount - 1)
                                    WinEnableControl (hwndDlg, IDD_NB_OBJECT_DOWN, FALSE);
                                else
                                    WinEnableControl (hwndDlg, IDD_NB_OBJECT_DOWN, TRUE);
                                }
                            break;
                            }
                        }
                    break;
                    } // endof LN_SELECT
                }
            break;
            } // endcase WM_CONTROL.
        case USER_OBJECT_SETDLGITEMS:
            {
            CREATEOBJECTDATA objData;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
            HWND hwndLbox = WinWindowFromID (hwndDlg, IDD_NB_OBJECT_LIST);
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptCreateObject *pObject = NULL;
            if (sSelected > 0)
                {
                // Get object which index is sSelected.
                pObject = pPck->ReturnCreateObjectObject((USHORT)sSelected);
                // Get data from the object.
                objData = pObject->ReturnCreateObject();
                WinSetDlgItemText(hwndDlg, IDD_NB_OBJECT_CLASSNAME, objData.szClassName);
                WinSetDlgItemText(hwndDlg, IDD_NB_OBJECT_TITLE, objData.szTitle);
                WinSetDlgItemText(hwndDlg, IDD_NB_OBJECT_LOCATION, objData.szLocation);
                WinSetDlgItemText(hwndDlg, IDD_NB_OBJECT_CONFIG, objData.szConfig);
                if (objData.bReplace)
                    WinCheckButton (hwndDlg, IDD_NB_OBJECT_REPLACE, 1);
                else
                    WinCheckButton (hwndDlg, IDD_NB_OBJECT_REPLACE, 0);
                }
            break;
            }
        case USER_OBJECT_LISTBOX_INITIALIZED:
            {
            // The list box was initialized.
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradRegisterClassProc
 *  Dialog procedure for Register WSP class page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradRegisterClassPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                              MPARAM mp2)
    {
    static sSelected;
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            MSGDATA *pMsgData = NULL;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            sSelected = 0;

            pMsgData = new MSGDATA;
            pMsgData->hwndSender = hwndDlg;
            pMsgData->hwndObject =
                WinWindowFromID (hwndDlg, IDD_NB_CLASS_REGISTERCLASS_REGISTERLIST);
            pMsgData->pData = (PVOID)pPckDlgInfo->pPackage;
            WinPostMsg(pPckDlgInfo->hwndObjWnd, USER_INIT_REGCLASS_LISTBOX,
                MPFROMP(pMsgData), 0);

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                case DID_CANCEL:
                    {
                    break;
                    }
                case IDD_NB_CLASS_REGISTERCLASS_REGISTERADD:
                    {
                    PSZ pszScript = NULL;
                    CHAR szTemp[1024];
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox =
                        WinWindowFromID (hwndDlg, IDD_NB_CLASS_REGISTERCLASS_REGISTERLIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptRegisterClass *pClass = NULL;
                    if (sSelected == 0)
                        pClass = pPck->CreateRegisterClassObject();
                    else
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pClass = pPck->ReturnRegisterClassObject((USHORT)sSelected);
                        }
                        // Read entry fields text.
                    WinQueryDlgItemText (hwndDlg, IDD_NB_CLASS_REGISTERCLASS_CLASSNAME,
                                        MAXCLASSNAMELENGTH, szTemp);
                    pClass->SetClassName(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_CLASS_REGISTERCLASS_DLLPATH,
                                        CCHMAXPATH, szTemp);
                    pClass->SetDLLPath(szTemp);
                    pszScript = pClass->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndLbox, pClass->ReturnIndex() - 1, pszScript);
                    delete [] pszScript;
                        // Now there is atleast one item in list box so enable
                        // remove button.
                    WinEnableControl (hwndDlg,
                        IDD_NB_CLASS_REGISTERCLASS_REGISTERREMOVE, TRUE);

                        // Clear entry fields.
                    WinSetDlgItemText (hwndDlg, IDD_NB_CLASS_REGISTERCLASS_CLASSNAME, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_CLASS_REGISTERCLASS_DLLPATH, "");

                    sSelected = 0;

                    break;
                    }
                case IDD_NB_CLASS_REGISTERCLASS_REGISTERREMOVE:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_CLASS_REGISTERCLASS_REGISTERLIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    if (sSelected != 0)
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pPck->DeleteRegisterClassObject((USHORT)sSelected);
                            // Clear entry fields.
                        WinSetDlgItemText (hwndDlg, IDD_NB_CLASS_REGISTERCLASS_CLASSNAME, "");
                        WinSetDlgItemText (hwndDlg, IDD_NB_CLASS_REGISTERCLASS_DLLPATH, "");
                        }
                    sSelected = 0;
                    if (pPck->ReturnRegisterClassObjectCount() == 0)
                        WinEnableControl (hwndDlg,
                            IDD_NB_CLASS_REGISTERCLASS_REGISTERREMOVE, FALSE);
                    break;
                    }
                break;
                }
            break;
            } /* encase WM_COMMAND */
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case LN_SELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_CLASS_REGISTERCLASS_REGISTERLIST:
                            {
                            // Query selected list box item.
                            SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_CLASS_REGISTERCLASS_REGISTERLIST,
                                LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), 0));
                            if (sRet != LIT_NONE)
                                {
                                sSelected = sRet + 1;
                                WinSendMsg(hwndDlg, USER_REGCLASS_SETDLGITEMS, NULL,
                                           NULL);
                                }
                            break;
                            }
                        }
                    break;
                    }
                }
            break;
            } // endcase WM_CONTROL.
        case USER_REGCLASS_SETDLGITEMS:
            {
            REGISTERCLASSDATA classData;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
            HWND hwndLbox = WinWindowFromID (hwndDlg,
                IDD_NB_CLASS_REGISTERCLASS_REGISTERLIST);
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptRegisterClass *pClass = NULL;
            if (sSelected > 0)
                {
                // Get object which index is sSelected.
                pClass = pPck->ReturnRegisterClassObject((USHORT)sSelected);
                // Get data from the object.
                classData = pClass->ReturnRegisterClass();
                WinSetDlgItemText(hwndDlg, IDD_NB_CLASS_REGISTERCLASS_CLASSNAME,
                    classData.szClassname);
                WinSetDlgItemText(hwndDlg, IDD_NB_CLASS_REGISTERCLASS_DLLPATH,
                    classData.szDLLPath);
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradReplaceClassProc
 *  Dialog procedure for Replace WSP class page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradReplaceClassPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                             MPARAM mp2)
    {
    static sSelected;
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            MSGDATA *pMsgData = NULL;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            sSelected = 0;

            pMsgData = new MSGDATA;
            pMsgData->hwndSender = hwndDlg;
            pMsgData->hwndObject =
                WinWindowFromID (hwndDlg, IDD_NB_CLASS_REPLACECLASS_REPLACELIST);
            pMsgData->pData = (PVOID)pPckDlgInfo->pPackage;
            WinPostMsg(pPckDlgInfo->hwndObjWnd, USER_INIT_REPCLASS_LISTBOX,
                MPFROMP(pMsgData), 0);

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                case DID_CANCEL:
                    {
                    break;
                    }
                case IDD_NB_CLASS_REPLACECLASS_REPLACEADD:
                    {
                    PSZ pszScript = NULL;
                    CHAR szTemp[1024];
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox =
                        WinWindowFromID (hwndDlg, IDD_NB_CLASS_REPLACECLASS_REPLACELIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptReplaceClass *pClass = NULL;
                    if (sSelected == 0)
                        pClass = pPck->CreateReplaceClassObject();
                    else
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pClass = pPck->ReturnReplaceClassObject((USHORT)sSelected);
                        }
                        // Read entry fields text.
                    WinQueryDlgItemText (hwndDlg, IDD_NB_CLASS_REPLACECLASS_NEWCLASSNAME,
                                        MAXCLASSNAMELENGTH, szTemp);
                    pClass->SetNewClassName(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_CLASS_REPLACECLASS_OLDCLASSNAME,
                                        CCHMAXPATH, szTemp);
                    pClass->SetClassName(szTemp);
                    pszScript = pClass->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndLbox, pClass->ReturnIndex() - 1, pszScript);
                    delete [] pszScript;
                        // Now there is atleast one item in list box so enable
                        // remove button.
                    WinEnableControl (hwndDlg,
                        IDD_NB_CLASS_REPLACECLASS_REPLACEREMOVE, TRUE);

                        // Clear entry fields.
                    WinSetDlgItemText (hwndDlg, IDD_NB_CLASS_REPLACECLASS_OLDCLASSNAME, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_CLASS_REPLACECLASS_NEWCLASSNAME, "");

                    sSelected = 0;

                    break;
                    }
                case IDD_NB_CLASS_REPLACECLASS_REPLACEREMOVE:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_CLASS_REPLACECLASS_REPLACELIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    if (sSelected != 0)
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pPck->DeleteReplaceClassObject((USHORT)sSelected);
                            // Clear entry fields.
                        WinSetDlgItemText (hwndDlg, IDD_NB_CLASS_REPLACECLASS_OLDCLASSNAME, "");
                        WinSetDlgItemText (hwndDlg, IDD_NB_CLASS_REPLACECLASS_NEWCLASSNAME, "");
                        }
                    sSelected = 0;
                    if (pPck->ReturnRegisterClassObjectCount() == 0)
                        WinEnableControl (hwndDlg,
                            IDD_NB_CLASS_REPLACECLASS_REPLACEREMOVE, FALSE);
                    break;
                    }
                break;
                }
            break;
            } /* encase WM_COMMAND */
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case LN_SELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_CLASS_REPLACECLASS_REPLACELIST:
                            {
                            // Query selected list box item.
                            SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_CLASS_REPLACECLASS_REPLACELIST,
                                LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), 0));
                            if (sRet != LIT_NONE)
                                {
                                sSelected = sRet + 1;
                                WinSendMsg(hwndDlg, USER_REGCLASS_SETDLGITEMS, NULL,
                                           NULL);
                                }
                            break;
                            }
                        }
                    break;
                    }
                }
            break;
            } // endcase WM_CONTROL.
        case USER_REGCLASS_SETDLGITEMS:
            {
            REPLACECLASSDATA classData;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
            HWND hwndLbox = WinWindowFromID (hwndDlg,
                IDD_NB_CLASS_REPLACECLASS_REPLACELIST);
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptReplaceClass *pClass = NULL;
            if (sSelected > 0)
                {
                // Get object which index is sSelected.
                pClass = pPck->ReturnReplaceClassObject((USHORT)sSelected);
                // Get data from the object.
                classData = pClass->ReturnReplaceClass();
                WinSetDlgItemText(hwndDlg, IDD_NB_CLASS_REPLACECLASS_OLDCLASSNAME,
                    classData.szOldClassName);
                WinSetDlgItemText(hwndDlg, IDD_NB_CLASS_REPLACECLASS_NEWCLASSNAME,
                    classData.szNewClassName);
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradRequiresProc
 *  Dialog procedure for Requires page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradRequiresPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                         MPARAM mp2)
    {
    static sSelected;
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            MSGDATA *pMsgData = NULL;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            sSelected = 0;

            pMsgData = new MSGDATA;
            pMsgData->hwndSender = hwndDlg;
            pMsgData->hwndObject =
                WinWindowFromID (hwndDlg, IDD_NB_REQUIRES_LIST);
            pMsgData->pData = (PVOID)pPckDlgInfo->pPackage;
            WinPostMsg(pPckDlgInfo->hwndObjWnd, USER_INIT_REQUIRES_LISTBOX,
                MPFROMP(pMsgData), 0);

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                case DID_CANCEL:
                    {
                    break;
                    }
                case IDD_NB_REQUIRES_ADD:
                    {
                    PSZ pszScript = NULL;
                    CHAR szTemp[1024];
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox =
                        WinWindowFromID (hwndDlg, IDD_NB_REQUIRES_LIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptRequires *pReq = NULL;
                    if (sSelected == 0)
                        pReq = pPck->CreateRequiresObject();
                    else
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pReq = pPck->ReturnRequiresObject((USHORT)sSelected);
                        }
                        // Read entry fields text.
                    WinQueryDlgItemText (hwndDlg, IDD_NB_REQUIRES_VENDOR,
                                        MAXVENDORNAMELENGTH, szTemp);
                    pReq->SetVendor(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_REQUIRES_APPLICATION,
                                        MAXAPPNAMELENGTH, szTemp);
                    pReq->SetApplication(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_REQUIRES_PACKAGE,
                                        MAXPCKNAMELENGTH, szTemp);
                    pReq->SetPackage(szTemp);
                    WinQueryDlgItemText (hwndDlg, IDD_NB_REQUIRES_VERSIONMAJOR,
                                        MAXVERSIONLENGTH, szTemp);
                    pReq->SetMajor(atoi(szTemp));
                    WinQueryDlgItemText (hwndDlg, IDD_NB_REQUIRES_VERSIONMINOR,
                                        MAXVERSIONLENGTH, szTemp);
                    pReq->SetMinor(atoi(szTemp));
                    pszScript = pReq->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndLbox, pReq->ReturnIndex() - 1, pszScript);
                    delete [] pszScript;
                        // Now there is atleast one item in list box so enable
                        // remove button.
                    WinEnableControl (hwndDlg, IDD_NB_REQUIRES_REMOVE, TRUE);

                        // Clear entry fields.
                    WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_VENDOR, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_APPLICATION, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_PACKAGE, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_VERSIONMAJOR, "");
                    WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_VERSIONMINOR, "");

                    sSelected = 0;

                    break;
                    }
                case IDD_NB_REQUIRES_REMOVE:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_REQUIRES_LIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    if (sSelected != 0)
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pPck->DeleteRequiresObject((USHORT)sSelected);
                            // Clear entry fields.
                        WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_VENDOR, "");
                        WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_APPLICATION, "");
                        WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_PACKAGE, "");
                        WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_VERSIONMAJOR, "");
                        WinSetDlgItemText (hwndDlg, IDD_NB_REQUIRES_VERSIONMINOR, "");
                        }
                    sSelected = 0;
                    if (pPck->ReturnRequiresObjectCount() == 0)
                        WinEnableControl (hwndDlg, IDD_NB_REQUIRES_REMOVE, FALSE);
                    break;
                    }
                break;
                }
            break;
            } /* encase WM_COMMAND */
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case LN_SELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_REQUIRES_LIST:
                            {
                            // Query selected list box item.
                            SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_REQUIRES_LIST,
                                LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), 0));
                            if (sRet != LIT_NONE)
                                {
                                sSelected = sRet + 1;
                                WinSendMsg(hwndDlg, USER_REQUIRES_SETDLGITEMS, NULL,
                                           NULL);
                                }
                            break;
                            }
                        }
                    break;
                    }
                }
            break;
            } // endcase WM_CONTROL.
        case USER_REQUIRES_SETDLGITEMS:
            {
            CHAR szTemp[10];
            REQUIRESDATA reqData;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
            HWND hwndLbox = WinWindowFromID (hwndDlg, IDD_NB_REQUIRES_LIST);
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptRequires *pReq = NULL;
            if (sSelected > 0)
                {
                // Get object which index is sSelected.
                pReq = pPck->ReturnRequiresObject((USHORT)sSelected);
                // Get data from the object.
                reqData = pReq->ReturnRequires();
                WinSetDlgItemText(hwndDlg, IDD_NB_REQUIRES_VENDOR, reqData.szVendor);
                WinSetDlgItemText(hwndDlg, IDD_NB_REQUIRES_APPLICATION,
                    reqData.szApplication);
                WinSetDlgItemText(hwndDlg, IDD_NB_REQUIRES_PACKAGE, reqData.szPackage);
                sprintf(szTemp, "%i", reqData.usMajor);
                WinSetDlgItemText(hwndDlg, IDD_NB_REQUIRES_VERSIONMAJOR, szTemp);
                sprintf(szTemp, "%i", reqData.usMinor);
                WinSetDlgItemText(hwndDlg, IDD_NB_REQUIRES_VERSIONMINOR, szTemp);
                }
            break;
            }
        case USER_REQUIRES_LISTBOX_INITIALIZED:
            {
            if (SHORT1FROMMP(mp1) > 0)
                WinEnableControl (hwndDlg, IDD_NB_REQUIRES_REMOVE, TRUE);
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradExecuteProc
 *  Dialog procedure for Execute page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradExecutePageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                        MPARAM mp2)
    {
    static sSelected;
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            MSGDATA *pMsgData = NULL;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            sSelected = 0;

            pMsgData = new MSGDATA;
            pMsgData->hwndSender = hwndDlg;
            pMsgData->hwndObject =
                WinWindowFromID (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTELIST);
            pMsgData->pData = (PVOID)pPckDlgInfo->pPackage;
            WinPostMsg(pPckDlgInfo->hwndObjWnd, USER_INIT_EXECUTE_LISTBOX,
                MPFROMP(pMsgData), 0);

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                case DID_CANCEL:
                    {
                    break;
                    }
                case IDD_NB_ADDITIONAL_EXEC_EXECUTEADD:
                    {
                    PSZ pszScript = NULL;
                    CHAR szTemp[1024];
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox =
                        WinWindowFromID (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTELIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptExecute *pExec = NULL;
                    if (sSelected == 0)
                        pExec = pPck->CreateExecuteObject();
                    else
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pExec = pPck->ReturnExecuteObject((USHORT)sSelected);
                        }
                        // Read entry fields text.
                    WinQueryDlgItemText (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTE,
                                        CCHMAXPATH, szTemp);
                    pExec->SetExecFileParams(szTemp);
                    if (WinQueryButtonCheckstate (hwndDlg,
                        IDD_NB_ADDITIONAL_EXEC_CONTEXT_CONFIGSYS))
                        pExec->SetContext(FLAG_CONFIGSYS);
                    else if (WinQueryButtonCheckstate (hwndDlg,
                        IDD_NB_ADDITIONAL_EXEC_CONTEXT_REGISTERCLASS))
                        pExec->SetContext(FLAG_REGISTERCLASS);
                    else if (WinQueryButtonCheckstate (hwndDlg,
                        IDD_NB_ADDITIONAL_EXEC_CONTEXT_CREATEOBJECT))
                        pExec->SetContext(FLAG_CREATEOBJECT);
                    else
                        pExec->SetContext(FLAG_NOCONTEXT);
                    pszScript = pExec->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndLbox, pExec->ReturnIndex() - 1, pszScript);
                    delete [] pszScript;
                        // Now there is atleast one item in list box so enable
                        // remove button.
                    WinEnableControl (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTEREMOVE, TRUE);

                        // Clear entry field and uncheck buttons.
                    WinSetDlgItemText (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTE, "");
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_CONFIGSYS,
                        FALSE);
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_REGISTERCLASS,
                        FALSE);
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_CREATEOBJECT,
                        FALSE);

                    sSelected = 0;

                    break;
                    }
                case IDD_NB_ADDITIONAL_EXEC_EXECUTEREMOVE:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_ADDITIONAL_EXEC_EXECUTELIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    if (sSelected != 0)
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pPck->DeleteExecuteObject((USHORT)sSelected);
                            // Clear entry fields.
                        WinSetDlgItemText (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTE, "");
                        WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_CONFIGSYS,
                            FALSE);
                        WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_REGISTERCLASS,
                            FALSE);
                        WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_CREATEOBJECT,
                            FALSE);
                        }
                    sSelected = 0;
                    if (pPck->ReturnExecuteObjectCount() == 0)
                        WinEnableControl (hwndDlg,
                            IDD_NB_ADDITIONAL_EXEC_EXECUTEREMOVE, FALSE);
                    break;
                    }
                break;
                }
            break;
            } /* encase WM_COMMAND */
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case LN_SELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_ADDITIONAL_EXEC_EXECUTELIST:
                            {
                            // Query selected list box item.
                            SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_ADDITIONAL_EXEC_EXECUTELIST,
                                LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), 0));
                            if (sRet != LIT_NONE)
                                {
                                sSelected = sRet + 1;
                                WinSendMsg(hwndDlg, USER_EXECUTE_SETDLGITEMS, NULL,
                                           NULL);
                                }
                            break;
                            }
                        }
                    break;
                    }
                }
            break;
            } // endcase WM_CONTROL.
        case USER_EXECUTE_SETDLGITEMS:
            {
            CHAR szTemp[10];
            EXECUTEDATA execData;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
            HWND hwndLbox = WinWindowFromID (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTELIST);
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptExecute *pExec = NULL;
            if (sSelected > 0)
                {
                // Get object which index is sSelected.
                pExec = pPck->ReturnExecuteObject((USHORT)sSelected);
                // Get data from the object.
                execData = pExec->ReturnExecute();
                WinSetDlgItemText (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTE,
                    execData.szExecFileParams);
                if (execData.fusContext == FLAG_CONFIGSYS)
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_CONFIGSYS,
                        TRUE);
                else if (execData.fusContext == FLAG_REGISTERCLASS)
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_REGISTERCLASS,
                        TRUE);
                else if (execData.fusContext == FLAG_CREATEOBJECT)
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_CREATEOBJECT,
                        TRUE);
                else
                    {
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_CONFIGSYS,
                        FALSE);
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_REGISTERCLASS,
                        FALSE);
                    WinCheckButton (hwndDlg, IDD_NB_ADDITIONAL_EXEC_CONTEXT_CREATEOBJECT,
                        FALSE);
                    }
                }
            break;
            }
        case USER_EXECUTE_LISTBOX_INITIALIZED:
            {
            if (SHORT1FROMMP(mp1) > 0)
                WinEnableControl (hwndDlg, IDD_NB_ADDITIONAL_EXEC_EXECUTEREMOVE, TRUE);
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradClearProfileProc
 *  Dialog procedure for Clear profile page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradClearProfilePageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                            MPARAM mp2)
    {
    static sSelected;
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            MSGDATA *pMsgData = NULL;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            sSelected = 0;

            pMsgData = new MSGDATA;
            pMsgData->hwndSender = hwndDlg;
            pMsgData->hwndObject =
                WinWindowFromID (hwndDlg, IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILELIST);
            pMsgData->pData = (PVOID)pPckDlgInfo->pPackage;
            WinPostMsg(pPckDlgInfo->hwndObjWnd, USER_INIT_CLEARPROFILE_LISTBOX,
                MPFROMP(pMsgData), 0);

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                case DID_CANCEL:
                    {
                    break;
                    }
                case IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEADD:
                    {
                    PSZ pszScript = NULL;
                    CHAR szTemp[1024];
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox =
                        WinWindowFromID (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILELIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptClearProfile *pClear = NULL;
                    if (sSelected == 0)
                        pClear = pPck->CreateClearProfileObject();
                    else
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pClear = pPck->ReturnClearProfileObject((USHORT)sSelected);
                        }
                        // Read entry fields text.
                    WinQueryDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEAPP,
                        MAXPROFILEAPPLICATIONLENGTH, szTemp);
                    pClear->SetApplication(szTemp);
                    WinQueryDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEKEY,
                        MAXPROFILEKEYLENGTH, szTemp);
                    pClear->SetKey(szTemp);
                    WinQueryDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILESTRING,
                        CCHMAXPATH, szTemp);
                    pClear->SetProfileString(szTemp);
                    pszScript = pClear->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndLbox, pClear->ReturnIndex() - 1, pszScript);
                    delete [] pszScript;
                        // Now there is atleast one item in list box so enable
                        // remove button.
                    WinEnableControl (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEREMOVE, TRUE);

                        // Clear entry fields.
                    WinSetDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEAPP, "");
                    WinSetDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEKEY, "");
                    WinSetDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILESTRING, "");

                    sSelected = 0;

                    break;
                    }
                case IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEREMOVE:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILELIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    if (sSelected != 0)
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pPck->DeleteClearProfileObject((USHORT)sSelected);
                            // Clear entry fields.
                        WinSetDlgItemText (hwndDlg,
                            IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEAPP, "");
                        WinSetDlgItemText (hwndDlg,
                            IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEKEY, "");
                        WinSetDlgItemText (hwndDlg,
                            IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILESTRING, "");
                        }
                    sSelected = 0;
                    if (pPck->ReturnClearProfileObjectCount() == 0)
                        WinEnableControl (hwndDlg,
                            IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEREMOVE, FALSE);
                    break;
                    }
                break;
                }
            break;
            } /* encase WM_COMMAND */
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case LN_SELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILELIST:
                            {
                            // Query selected list box item.
                            SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILELIST,
                                LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), 0));
                            if (sRet != LIT_NONE)
                                {
                                sSelected = sRet + 1;
                                WinSendMsg(hwndDlg, USER_CLEARPROFILE_SETDLGITEMS, NULL,
                                           NULL);
                                }
                            break;
                            }
                        }
                    break;
                    }
                }
            break;
            } // endcase WM_CONTROL.
        case USER_CLEARPROFILE_SETDLGITEMS:
            {
            CHAR szTemp[10];
            PROFILEDATA profData;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
            HWND hwndLbox =
                WinWindowFromID (hwndDlg, IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILELIST);
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptClearProfile *pClear = NULL;
            if (sSelected > 0)
                {
                // Get object which index is sSelected.
                pClear = pPck->ReturnClearProfileObject((USHORT)sSelected);
                // Get data from the object.
                profData = pClear->ReturnProfile();
                WinSetDlgItemText (hwndDlg,
                    IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEAPP, profData.szApplication);
                WinSetDlgItemText (hwndDlg,
                    IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEKEY, profData.szKey);
                WinSetDlgItemText (hwndDlg,
                    IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILESTRING, profData.szProfile);
                }
            break;
            }
        case USER_REQUIRES_LISTBOX_INITIALIZED:
            {
            if (SHORT1FROMMP(mp1) > 0)
                WinEnableControl (hwndDlg, IDD_NB_ADDITIONAL_CLEARPROFILE_PROFILEREMOVE,
                    TRUE);
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradWriteProfileProc
 *  Dialog procedure for Write profile page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradWriteProfilePageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                            MPARAM mp2)
    {
    static sSelected;
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            MSGDATA *pMsgData = NULL;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            sSelected = 0;

            pMsgData = new MSGDATA;
            pMsgData->hwndSender = hwndDlg;
            pMsgData->hwndObject =
                WinWindowFromID (hwndDlg, IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILELIST);
            pMsgData->pData = (PVOID)pPckDlgInfo->pPackage;
            WinPostMsg(pPckDlgInfo->hwndObjWnd, USER_INIT_WRITEPROFILE_LISTBOX,
                MPFROMP(pMsgData), 0);

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                case DID_CANCEL:
                    {
                    break;
                    }
                case IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEADD:
                    {
                    PSZ pszScript = NULL;
                    CHAR szTemp[1024];
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox =
                        WinWindowFromID (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILELIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    ScriptWriteProfile *pWrite = NULL;
                    if (sSelected == 0)
                        pWrite = pPck->CreateWriteProfileObject();
                    else
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pWrite = pPck->ReturnWriteProfileObject((USHORT)sSelected);
                        }
                        // Read entry fields text.
                    WinQueryDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEAPP,
                        MAXPROFILEAPPLICATIONLENGTH, szTemp);
                    pWrite->SetApplication(szTemp);
                    WinQueryDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEKEY,
                        MAXPROFILEKEYLENGTH, szTemp);
                    pWrite->SetKey(szTemp);
                    WinQueryDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILESTRING,
                        CCHMAXPATH, szTemp);
                    pWrite->SetProfileString(szTemp);
                    WinQueryDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_STRING,
                        256, szTemp);
                    pWrite->SetString(szTemp);
                    pszScript = pWrite->MakeScriptText(FALSE);
                    WinInsertLboxItem (hwndLbox, pWrite->ReturnIndex() - 1, pszScript);
                    delete [] pszScript;
                        // Now there is atleast one item in list box so enable
                        // remove button.
                    WinEnableControl (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEREMOVE, TRUE);

                        // Write entry fields.
                    WinSetDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEAPP, "");
                    WinSetDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEKEY, "");
                    WinSetDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILESTRING, "");
                    WinSetDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_STRING, "");

                    sSelected = 0;

                    break;
                    }
                case IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEREMOVE:
                    {
                    PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndLbox = WinWindowFromID (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILELIST);
                    ScriptPackage *pPck = pPckDlgInfo->pPackage;
                    if (sSelected != 0)
                        {
                        WinSendMsg(hwndLbox, LM_DELETEITEM, MPFROMSHORT(sSelected - 1),
                            0);
                        pPck->DeleteWriteProfileObject((USHORT)sSelected);
                            // Write entry fields.
                        WinSetDlgItemText (hwndDlg,
                            IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEAPP, "");
                        WinSetDlgItemText (hwndDlg,
                            IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEKEY, "");
                        WinSetDlgItemText (hwndDlg,
                            IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILESTRING, "");
                        WinSetDlgItemText (hwndDlg,
                            IDD_NB_ADDITIONAL_WRITEPROFILE_STRING, "");
                        }
                    sSelected = 0;
                    if (pPck->ReturnWriteProfileObjectCount() == 0)
                        WinEnableControl (hwndDlg,
                            IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEREMOVE, FALSE);
                    break;
                    }
                break;
                }
            break;
            } /* encase WM_COMMAND */
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case LN_SELECT:
                    {
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILELIST:
                            {
                            // Query selected list box item.
                            SHORT sRet = SHORT1FROMMR(WinSendDlgItemMsg(hwndDlg,
                                IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILELIST,
                                LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), 0));
                            if (sRet != LIT_NONE)
                                {
                                sSelected = sRet + 1;
                                WinSendMsg(hwndDlg, USER_WRITEPROFILE_SETDLGITEMS, NULL,
                                           NULL);
                                }
                            break;
                            }
                        }
                    break;
                    }
                }
            break;
            } // endcase WM_CONTROL.
        case USER_WRITEPROFILE_SETDLGITEMS:
            {
            CHAR szTemp[10];
            PSZ pszTemp = NULL;
            PROFILEDATA profData;
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
            HWND hwndLbox =
                WinWindowFromID (hwndDlg, IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILELIST);
            ScriptPackage *pPck = pPckDlgInfo->pPackage;
            ScriptWriteProfile *pWrite = NULL;
            if (sSelected > 0)
                {
                // Get object which index is sSelected.
                pWrite = pPck->ReturnWriteProfileObject((USHORT)sSelected);
                // Get data from the object.
                profData = pWrite->ReturnProfile();
                WinSetDlgItemText (hwndDlg,
                    IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEAPP, profData.szApplication);
                WinSetDlgItemText (hwndDlg,
                    IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEKEY, profData.szKey);
                WinSetDlgItemText (hwndDlg,
                    IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILESTRING, profData.szProfile);
                pszTemp = pWrite->ReturnString();
                WinSetDlgItemText (hwndDlg,
                        IDD_NB_ADDITIONAL_WRITEPROFILE_STRING, pszTemp);
                }
            break;
            }
        case USER_REQUIRES_LISTBOX_INITIALIZED:
            {
            if (SHORT1FROMMP(mp1) > 0)
                WinEnableControl (hwndDlg, IDD_NB_ADDITIONAL_WRITEPROFILE_PROFILEREMOVE,
                    TRUE);
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }






/******************************************************************************
 *@@fnTradBrowserPageProc
 *  Dialog procedure for browser page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradBrowserNBPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                          MPARAM mp2)
    {
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)mp2;
            WinSetWindowPtr (hwndDlg, 0, pPckDlgInfo);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_CANCEL:
                case DID_OK:
                    {
                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            break;
            } // endcase WM_CONTROL.
        case USER_CREATESCRIPTTEXT:
            {
            PPCKDLGINFO pPckDlgInfo = (PPCKDLGINFO)WinQueryWindowPtr(hwndDlg, 0);
            PSZ pszScript = pPckDlgInfo->pPackage->MakeScriptText();
            guiClearMLE (hwndDlg, IDD_NB_BROWSER_MLE);
            guiSetMLEText (hwndDlg, IDD_NB_BROWSER_MLE, pszScript);
            delete [] pszScript;
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }






/******************************************************************************
 *@@fnTradWarpINPageProc
 *  Dialog procedure for WarpIN dialog in the script notebook.
 */
MRESULT EXPENTRY fnTradWarpINPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                       MPARAM mp2)
    {
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            PSCRIPTDLGINFO pScriptDlgInfo = (PSCRIPTDLGINFO)mp2;
            ScriptWarpIN *pWarpIN = pScriptDlgInfo->pWarpIN;
            WinSetWindowPtr (hwndDlg, 0, pScriptDlgInfo);
            USHORT usReqVer = pWarpIN->ReturnOSValue();
            CHAR szNumber[125];
            USHORT usMajor = 0, usMinor = 0;

            // Set radio button's states accordingly.
            if (usReqVer == OS_OS2_3X)
                WinSendDlgItemMsg(hwndDlg, IDD_ASNB_WARPIN_OS23X,
                                 BM_SETCHECK, MPFROMSHORT(1), 0);
            else if (usReqVer == OS_OS2_4X)
                WinSendDlgItemMsg(hwndDlg, IDD_ASNB_WARPIN_OS24X,
                                 BM_SETCHECK, MPFROMSHORT(1), 0);
            else
                WinSendDlgItemMsg(hwndDlg, IDD_ASNB_WARPIN_OS22X,
                                 BM_SETCHECK, MPFROMSHORT(1), 0);

            // Initialize version number and codepage fields.
            pWarpIN->ReturnVersionNumber(&usMajor, &usMinor);
            sprintf(szNumber, "%d", usMajor);
            WinSetDlgItemText(hwndDlg, IDD_ASNB_WARPIN_MAJOR, szNumber);
            sprintf(szNumber, "%d", usMinor);
            WinSetDlgItemText(hwndDlg, IDD_ASNB_WARPIN_MINOR, szNumber);
            sprintf(szNumber, "%d", pWarpIN->ReturnCodePageNumber());
            WinSetDlgItemText(hwndDlg, IDD_ASNB_WARPIN_CODEPAGE, szNumber);

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_CANCEL:
                case DID_OK:
                    {
                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            switch (SHORT2FROMMP(mp1))
                {
                case EN_KILLFOCUS:
                    {
                    CHAR szString[256], szString2[256];
                    *szString = '\0';
                    PSCRIPTDLGINFO pScriptDlgInfo =
                        (PSCRIPTDLGINFO)WinQueryWindowPtr(hwndDlg, 0);
                    ScriptWarpIN *pWarpIN = pScriptDlgInfo->pWarpIN;
                    // If one of the entry fields loses
                    // its focus specific entryfield's text is being
                    // queried.
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_ASNB_WARPIN_MAJOR:
                        case IDD_ASNB_WARPIN_MINOR:
                            {
                            WinQueryDlgItemText (hwndDlg, IDD_ASNB_WARPIN_MAJOR,
                                                5, szString);
                            WinQueryDlgItemText (hwndDlg, IDD_ASNB_WARPIN_MINOR,
                                                5, szString2);
                            pWarpIN->SetVersionNumber(atoi(szString), atoi(szString2));
                            break;
                            }
                        case IDD_ASNB_WARPIN_CODEPAGE:
                            {
                            WinQueryDlgItemText (hwndDlg, IDD_ASNB_WARPIN_CODEPAGE,
                                                5, szString);
                            pWarpIN->SetCodePageNumber(atoi(szString));
                            break;
                            }
                        }
                    break;
                    }
                case BN_CLICKED:
                    {
                    PSCRIPTDLGINFO pScriptDlgInfo =
                        (PSCRIPTDLGINFO)WinQueryWindowPtr (hwndDlg, 0);
                    ScriptWarpIN *pWarpIN = pScriptDlgInfo->pWarpIN;

                    // If  one of the radio buttons is selected, set required OS version.
                    switch (SHORT1FROMMP(mp1))
                        {
                        case IDD_ASNB_WARPIN_OS22X:
                            {
                            USHORT usCheckState = WinQueryButtonCheckstate (hwndDlg,
                                                  IDD_ASNB_WARPIN_OS22X);
                            if (usCheckState)
                                pWarpIN->SetOSValue(OS_OS2_2X);
                            break;
                            }
                        case IDD_ASNB_WARPIN_OS23X:
                            {
                            USHORT usCheckState = WinQueryButtonCheckstate (hwndDlg,
                                                  IDD_ASNB_WARPIN_OS23X);
                            if (usCheckState)
                                pWarpIN->SetOSValue(OS_OS2_3X);
                            break;
                            }
                        case IDD_ASNB_WARPIN_OS24X:
                            {
                            USHORT usCheckState = WinQueryButtonCheckstate (hwndDlg,
                                                  IDD_ASNB_WARPIN_OS24X);
                            if (usCheckState)
                                pWarpIN->SetOSValue(OS_OS2_4X);
                            break;
                            }
                        }
                    break;
                    } // endcase BN_CLICKED & BN_DBLCLICKED.
                }
            break;
            } // endcase WM_CONTROL
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }



/******************************************************************************
 *@@fnTradScriptPageProc
 *  Dialog procedure for page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradScriptPageProc(HWND hwndDlg, ULONG msg, MPARAM mp1,
                                      MPARAM mp2)
    {
    MRESULT mrc = 0;
    static CONTAINERINFO cntrInfo;
    // Popup menu for Add button.
    static HWND hwndPopupMenu;

    switch (msg)
        {
        case WM_INITDLG:
            {
            cntrInfo.hwndContainer = WinWindowFromID(hwndDlg, IDD_ASNB_PAGE_CONTAINER);
            WinSetWindowPtr(hwndDlg, 0, (PVOID)mp2); // PSCRIPTDLGINFO
            cntrInfo.hwndContextMenu = WinLoadMenu(cntrInfo.hwndContainer, 0,
                IDM_PAGE_MENU);
            hwndPopupMenu = WinLoadMenu(HWND_DESKTOP, 0, IDM_PAGE_MENU);
            guiInitializePageContainer(&cntrInfo, NULL);
            PMSGDATA pMsgData = new MSGDATA;
            pMsgData->pData = ((PSCRIPTDLGINFO)mp2)->pWarpIN->ReturnBodyObject();
            pMsgData->hwndObject = cntrInfo.hwndContainer;
            pMsgData->hwndSender = hwndDlg;
            // Put object window thread to work. Initialize page container.
            WinPostMsg(((PSCRIPTDLGINFO)mp2)->hwndObjWnd, USER_INIT_PAGE_CONTAINER,
                MPFROMP(pMsgData), 0);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_CANCEL:
                case DID_OK:
                    {
                    break;
                    }
                case IDD_ASNB_PAGE_ADD:
                    {
                    SWP swpButton;
                    HWND hwndAddButton = WinWindowFromID(hwndDlg, IDD_ASNB_PAGE_ADD);

                    if (G_pSelectedPageRecord)
                        WinEnableMenuItem(hwndPopupMenu,
                            IDM_PAGE_EDITPAGE, TRUE);
                    else
                        WinEnableMenuItem(hwndPopupMenu,
                            IDM_PAGE_EDITPAGE, FALSE);

                    WinQueryWindowPos(hwndAddButton, &swpButton);
                    WinPopupMenu(hwndDlg, hwndDlg,
                                 hwndPopupMenu,
                                 (SHORT)swpButton.x,
                                 (SHORT)swpButton.y, 0,
                                 PU_NONE | PU_MOUSEBUTTON1 |
                                 PU_MOUSEBUTTON2 | PU_KEYBOARD);
                    break;
                    }
                case IDM_PAGE_ADDTEXT:
                    {
                    list<ScriptPage*> listPage(SHADOW);
                    PSCRIPTDLGINFO pScriptInfo =
                        (PSCRIPTDLGINFO) WinQueryWindowPtr (hwndDlg, 0);
                    HWND hwndCntr = WinWindowFromID(hwndDlg, IDD_ASNB_PAGE_CONTAINER);
                    ScriptBody *pBody = pScriptInfo->pWarpIN->ReturnBodyObject();
                    ScriptPage Page, *pTempPage;
                    Page.SetPageType(PAGE_TYPES_TEXT);
                    Page.SetPageIndex(pBody->ReturnPageObjectCount() + 1);
                    if (WinDlgBox(HWND_DESKTOP,
                                  hwndDlg,
                                  fnTradTextDlgProc,
                                  NULLHANDLE,
                                  IDD_PAGE_TEXT_DIALOG,
                                  (PVOID)&Page))
                        {
                        pTempPage = pBody->CreatePageObject();
                        Page.SetIndex(pTempPage->ReturnIndex());
                        *pTempPage = Page;
                        listPage.push_back(pTempPage);
                        guiSetPageContainerRecords(hwndCntr, &listPage, 1);
                        }

                    break;
                    }
                case IDM_PAGE_ADDREADME:
                    {
                    PSCRIPTDLGINFO pScriptInfo =
                        (PSCRIPTDLGINFO) WinQueryWindowPtr (hwndDlg, 0);
                    list<ScriptPage*> listPage(SHADOW);
                    HWND hwndCntr = WinWindowFromID(hwndDlg, IDD_ASNB_PAGE_CONTAINER);
                    ScriptBody *pBody = pScriptInfo->pWarpIN->ReturnBodyObject();
                    ScriptPage Page, *pTempPage;
                    Page.SetPageType(PAGE_TYPES_README);
                    Page.SetPageIndex(pBody->ReturnPageObjectCount() + 1);
                    if (WinDlgBox(HWND_DESKTOP,
                                  hwndDlg,
                                  fnTradReadmeDlgProc,
                                  NULLHANDLE,
                                  IDD_PAGE_README_DIALOG,
                                  (PVOID)&Page))
                        {
                        pTempPage = pBody->CreatePageObject();
                        Page.SetIndex(pTempPage->ReturnIndex());
                        *pTempPage = Page;
                        listPage.push_back(pTempPage);
                        guiSetPageContainerRecords(hwndCntr, &listPage, 1);
                        }
                    break;
                    }
                case IDM_PAGE_ADDCONTAINER:
                    {
                    PSCRIPTDLGINFO pScriptInfo =
                        (PSCRIPTDLGINFO) WinQueryWindowPtr (hwndDlg, 0);
                    list<ScriptPage*> listPage(SHADOW);
                    HWND hwndCntr = WinWindowFromID(hwndDlg, IDD_ASNB_PAGE_CONTAINER);
                    ScriptBody *pBody = pScriptInfo->pWarpIN->ReturnBodyObject();
                    ScriptPage Page, *pTempPage;
                    Page.SetPageType(PAGE_TYPES_CONTAINER);
                    Page.SetPageIndex(pBody->ReturnPageObjectCount() + 1);
                    if (WinDlgBox(HWND_DESKTOP,
                                  hwndDlg,
                                  fnTradCntrDlgProc,
                                  NULLHANDLE,
                                  IDD_PAGE_CONTAINER_DIALOG,
                                  (PVOID)&Page))
                        {
                        pTempPage = pBody->CreatePageObject();
                        Page.SetIndex(pTempPage->ReturnIndex());
                        *pTempPage = Page;
                        listPage.push_back(pTempPage);
                        guiSetPageContainerRecords(hwndCntr, &listPage, 1);
                        }
                    break;
                    }
                case IDM_PAGE_ADDCONFIGURE:
                    {
                    PSCRIPTDLGINFO pScriptInfo =
                        (PSCRIPTDLGINFO) WinQueryWindowPtr (hwndDlg, 0);
                    list<ScriptPage*> listPage(SHADOW);
                    HWND hwndCntr = WinWindowFromID(hwndDlg, IDD_ASNB_PAGE_CONTAINER);
                    ScriptBody *pBody = pScriptInfo->pWarpIN->ReturnBodyObject();
                    ScriptPage Page, *pTempPage;
                    Page.SetPageType(PAGE_TYPES_CONFIGURE);
                    Page.SetPageIndex(pBody->ReturnPageObjectCount() + 1);
                    if (WinDlgBox(HWND_DESKTOP,
                                  hwndDlg,
                                  fnTradCnfgDlgProc,
                                  NULLHANDLE,
                                  IDD_PAGE_CONFIGURE_DIALOG,
                                  (PVOID)&Page))
                        {
                        pTempPage = pBody->CreatePageObject();
                        Page.SetIndex(pTempPage->ReturnIndex());
                        *pTempPage = Page;
                        listPage.push_back(pTempPage);
                        guiSetPageContainerRecords(hwndCntr, &listPage, 1);
                        }
                    break;
                    }
                case IDM_PAGE_EDITPAGE:
                    {
                    ScriptPage *pPage = NULL;
                    PSCRIPTDLGINFO pScriptInfo =
                        (PSCRIPTDLGINFO) WinQueryWindowPtr (hwndDlg, 0);
                    USHORT usIndex = G_pSelectedPageRecord->usPageIndex;
                    ScriptBody *pBody = pScriptInfo->pWarpIN->ReturnBodyObject();
                    pPage = FindScriptPageObject(pBody, usIndex);

                    switch (pPage->ReturnPageType())
                        {
                        case PAGE_TYPES_TEXT:
                            {
                            ScriptPage Page;
                            Page = *pPage;
                            if (WinDlgBox(HWND_DESKTOP,
                                         hwndDlg,
                                         fnTradTextDlgProc,
                                         NULLHANDLE,
                                         IDD_PAGE_TEXT_DIALOG,
                                         (PVOID)&Page))
                                {
                                *pPage = Page;
                                guiUpdatePageContRecord(cntrInfo.hwndContainer,
                                    G_pSelectedPageRecord, pPage, TRUE);
                                }
                            break;
                            }
                        case PAGE_TYPES_README:
                            {
                            ScriptPage Page;
                            Page = *pPage;
                            if (WinDlgBox(HWND_DESKTOP,
                                         hwndDlg,
                                         fnTradReadmeDlgProc,
                                         NULLHANDLE,
                                         IDD_PAGE_README_DIALOG,
                                         (PVOID)&Page))
                                {
                                *pPage = Page;
                                guiUpdatePageContRecord(cntrInfo.hwndContainer,
                                    G_pSelectedPageRecord, pPage, TRUE);
                                }
                            break;
                            }
                        case PAGE_TYPES_CONTAINER:
                            {
                            ScriptPage Page;
                            Page = *pPage;
                            if (WinDlgBox(HWND_DESKTOP,
                                         hwndDlg,
                                         fnTradCntrDlgProc,
                                         NULLHANDLE,
                                         IDD_PAGE_CONTAINER_DIALOG,
                                         (PVOID)&Page))
                                {
                                *pPage = Page;
                                guiUpdatePageContRecord(cntrInfo.hwndContainer,
                                    G_pSelectedPageRecord, pPage, TRUE);
                                }
                            break;
                            }
                        case PAGE_TYPES_CONFIGURE:
                            {
                            ScriptPage Page;
                            Page = *pPage;
                            if (WinDlgBox(HWND_DESKTOP,
                                         hwndDlg,
                                         fnTradCnfgDlgProc,
                                         NULLHANDLE,
                                         IDD_PAGE_CONFIGURE_DIALOG,
                                         (PVOID)&Page))
                                {
                                *pPage = Page;
                                guiUpdatePageContRecord(cntrInfo.hwndContainer,
                                    G_pSelectedPageRecord, pPage, TRUE);
                                }
                            break;
                            }
                        }
                    break;
                    }
                case IDD_ASNB_PAGE_REMOVE:
                    {
                    if (G_pSelectedPageRecord)
                        {
                        ScriptPage *pPage = NULL;
                        PSCRIPTDLGINFO pScriptInfo =
                            (PSCRIPTDLGINFO) WinQueryWindowPtr (hwndDlg, 0);
                        USHORT usPageIndex = G_pSelectedPageRecord->usPageIndex;
                        ScriptBody *pBody = pScriptInfo->pWarpIN->ReturnBodyObject();
                        pPage = FindScriptPageObject(pBody, usPageIndex);
                        pBody->DeletePageObject(pPage->ReturnIndex());
                        guiRemoveContainerRecords(cntrInfo.hwndContainer,
                                                 (PVOID)G_pSelectedPageRecord,
                                                 1);
                        }

                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case IDD_ASNB_PAGE_CONTAINER:
                    {
                    switch (SHORT2FROMMP(mp1))
                        {
                        case CN_CONTEXTMENU:
                            {
                            POINTL pt;
                            // Show the popup menu. Pointer position is also needed
                            // because the popup menu must be beside mouse pointer.
                            WinQueryPointerPos(HWND_DESKTOP, &pt);
                            WinPopupMenu(HWND_DESKTOP, cntrInfo.hwndContainer,
                                         cntrInfo.hwndContextMenu,
                                         (SHORT)pt.x, (SHORT)pt.y, 0,
                                         PU_NONE | PU_MOUSEBUTTON1 |
                                         PU_MOUSEBUTTON2 | PU_KEYBOARD);
                            G_pSourcePageRecord = (PPAGERECORD)mp2;
                            if (G_pSourcePageRecord)
                                WinEnableMenuItem(cntrInfo.hwndContextMenu,
                                    IDM_PAGE_EDITPAGE, TRUE);
                            else
                                WinEnableMenuItem(cntrInfo.hwndContextMenu,
                                    IDM_PAGE_EDITPAGE, FALSE);

                            break;
                            }
                        case CN_EMPHASIS:// One of the records was been selected by the user
                            {            // so here determined which record it was and set
                                         // selected pointer to point to it.
                            PNOTIFYRECORDEMPHASIS pnre = (PNOTIFYRECORDEMPHASIS)mp2;
                            if ((pnre->fEmphasisMask & CRA_SELECTED) &&
                                    (pnre->pRecord) &&
                                    (G_pSelectedPageRecord != (PPAGERECORD)pnre->pRecord))
                                G_pSelectedPageRecord = (PPAGERECORD)pnre->pRecord;
                            else
                                G_pSelectedPageRecord = NULL;
                            break;
                            }
                        }
                    break;
                    }
                }
            break;
            } // endcase WM_CONTROL.
        case WM_MENUEND:
            {
            cnrhSetSourceEmphasis(cntrInfo.hwndContainer, G_pSourcePageRecord, FALSE);
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradScriptBrowserPageProc
 *  Dialog procedure for browser page dialog in the package notebook.
 */
MRESULT EXPENTRY fnTradScriptBrowserPageProc (HWND hwndDlg, ULONG msg, MPARAM mp1,
                                              MPARAM mp2)
    {
    MRESULT mrc = 0;

    switch (msg)
        {
        case WM_INITDLG:
            {
            WinSetWindowPtr (hwndDlg, 0, mp2);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_CANCEL:
                case DID_OK:
                    {
                    break;
                    }
                }
            break;
            }
        case WM_CONTROL:
            {
            break;
            } // endcase WM_CONTROL.
        case USER_CREATESCRIPTBROWSERTEXT:
            {
            PSCRIPTDLGINFO pScriptDlgInfo = (PSCRIPTDLGINFO)WinQueryWindowPtr(hwndDlg, 0);
            PSZ pszScript = pScriptDlgInfo->pWarpIN->MakeScriptText();
            guiClearMLE (hwndDlg, IDD_ASNB_BROWSER_MLE);
            guiSetMLEText (hwndDlg, IDD_ASNB_BROWSER_MLE, pszScript);
            delete [] pszScript;
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradTextDlgProc
 *  Dialog procedure for text dialog.
 */
MRESULT EXPENTRY fnTradTextDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    switch (msg)
        {
        case WM_INITDLG:
            {
            CHAR szNumber[5];
            ScriptPage *pPage = (ScriptPage *)mp2;
            WinSetWindowPtr (hwndDlg, 0, (PVOID)pPage);
            sprintf(szNumber, "%i", pPage->ReturnPageIndex());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_TEXT_INDEX, szNumber);
            WinSetDlgItemText(hwndDlg, IDD_PAGE_TEXT_NEXTBTNTEXT,
                pPage->ReturnNextButtonObject()->ReturnNextButton());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_TEXT_TEXT, pPage->ReturnText());
            sprintf(szNumber, "%i", pPage->ReturnNextButtonObject()->ReturnTarget());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_TEXT_NEXTBTNINDEX, szNumber);

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                    {
                    ScriptPage *pPage = (ScriptPage *)WinQueryWindowPtr(hwndDlg, 0);
                    ScriptNextButton *pNextBtn;
                    CHAR szIndex[5], szText[MAXNEXTBTNTEXTLENGTH];
                    PSZ pszText = NULL;
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_TEXT_INDEX,
                                        4, szIndex);
                    pPage->SetPageIndex(atoi(szIndex));
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_TEXT_NEXTBTNINDEX,
                                        4, szIndex);
                    pNextBtn = pPage->ReturnNextButtonObject();
                    pNextBtn->SetTarget(atoi(szIndex));
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_TEXT_NEXTBTNTEXT,
                                        MAXNEXTBTNTEXTLENGTH, szText);
                    pNextBtn->SetNextButton(szText);
                    HWND hwndMle = WinWindowFromID(hwndDlg, IDD_PAGE_TEXT_TEXT);
                    LONG lTextLength = WinQueryWindowTextLength(hwndMle);
                    pszText = new CHAR[lTextLength + 1];
                    *pszText = '\0';
                    WinQueryWindowText(hwndMle, lTextLength, pszText);
                    pPage->SetText(pszText);
                    delete [] pszText;
                    WinDismissDlg (hwndDlg, TRUE);
                    break;
                    }
                case DID_CANCEL:
                    {
                    WinDismissDlg (hwndDlg, FALSE);
                    break;
                    }
                case IDD_PAGE_TEXT_IMPORT:
                    {
                    HWND  hwndMle = WinWindowFromID(hwndDlg, IDD_PAGE_TEXT_TEXT);
                    PSZ pszText = NULL;
                    PSZ pszFileName = "*.*";
                    //APSZ apszITypeList[2];
                    //(*apszITypeList)[0] = "Plain Text";
                    //(*apszITypeList)[1] = NULL;
                    if (guiShowFileDialog (hwndDlg, FILEDLG_TYPE_OPEN,
                       G_nlsStringTable.pszOpenFile, NULL,
                       NULL, &pszFileName, NULL, NULL)
                       == RET_FD_OK)
                        {
                        // Open the file and read text from it.
                        doshLoadTextFile(pszFileName, &pszText, NULL);
                        // Put the text to MLE window.
                        WinSetWindowText(hwndMle, pszText);
                        delete pszText;
                        }
                    break;
                    }
                break;
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradReadmeDlgProc
 *  Dialog procedure for readme dialog.
 */
MRESULT EXPENTRY fnTradReadmeDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    switch (msg)
        {
        case WM_INITDLG:
            {
            CHAR szNumber[5];
            ScriptPage *pPage = (ScriptPage *)mp2;
            WinSetWindowPtr (hwndDlg, 0, (PVOID)pPage);
            sprintf(szNumber, "%i", pPage->ReturnPageIndex());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_README_INDEX, szNumber);
            WinSetDlgItemText(hwndDlg, IDD_PAGE_README_NEXTBTNTEXT,
                pPage->ReturnNextButtonObject()->ReturnNextButton());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_README_TEXT, pPage->ReturnText());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_README_READMETEXT,
                pPage->ReturnReadMeText());
            sprintf(szNumber, "%i", pPage->ReturnNextButtonObject()->ReturnTarget());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_README_NEXTBTNINDEX, szNumber);

            switch(pPage->ReturnReadMeObject()->ReturnFormat())
                {
                case README_FORMAT_NONE:
                    {
                    WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_PLAIN,
                        BM_SETCHECK, MPFROMSHORT(0), 0);
                    WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_FLOW,
                        BM_SETCHECK, MPFROMSHORT(0), 0);
                    WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_HTML,
                        BM_SETCHECK, MPFROMSHORT(0), 0);
                    break;
                    }
                case README_FORMAT_PLAIN:
                    {
                    WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_PLAIN,
                        BM_SETCHECK, MPFROMSHORT(1), 0);
                    break;
                    }
                case README_FORMAT_FLOW:
                    {
                    WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_FLOW,
                        BM_SETCHECK, MPFROMSHORT(1), 0);
                    break;
                    }
                case README_FORMAT_HTML:
                    {
                    WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_HTML,
                        BM_SETCHECK, MPFROMSHORT(1), 0);
                    break;
                    }
                }

            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                    {
                    ScriptPage *pPage = (ScriptPage *)WinQueryWindowPtr(hwndDlg, 0);
                    ScriptNextButton *pNextBtn;
                    CHAR szIndex[5], szText[MAXNEXTBTNTEXTLENGTH], szText1[125];
                    PSZ pszText = NULL;

                    // Query readme format.
                    if (WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_PLAIN,
                            BM_QUERYCHECK, 0, 0) == MRESULT(1))
                        pPage->ReturnReadMeObject()->SetFormat(README_FORMAT_PLAIN);
                    else if (WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_FLOW,
                                BM_QUERYCHECK, 0, 0) == MRESULT(1))
                        pPage->ReturnReadMeObject()->SetFormat(README_FORMAT_FLOW);
                    else if (WinSendDlgItemMsg(hwndDlg, IDD_PAGE_README_FORMAT_HTML,
                                BM_QUERYCHECK, 0, 0) == MRESULT(1))
                        pPage->ReturnReadMeObject()->SetFormat(README_FORMAT_HTML);
                    else
                        pPage->ReturnReadMeObject()->SetFormat(README_FORMAT_NONE);

                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_README_INDEX,
                                        4, szIndex);
                    pPage->SetPageIndex(atoi(szIndex));
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_README_NEXTBTNINDEX,
                                        4, szIndex);
                    pNextBtn = pPage->ReturnNextButtonObject();
                    pNextBtn->SetTarget(atoi(szIndex));
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_README_NEXTBTNTEXT,
                                        MAXNEXTBTNTEXTLENGTH, szText);
                    pNextBtn->SetNextButton(szText);
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_README_TEXT,
                                        125, szText1);
                    pPage->SetText(szText1);
                    HWND hwndMle = WinWindowFromID(hwndDlg, IDD_PAGE_README_READMETEXT);
                    LONG lTextLength = WinQueryWindowTextLength(hwndMle);
                    pszText = new CHAR[lTextLength + 1];
                    *pszText = '\0';
                    WinQueryWindowText(hwndMle, lTextLength, pszText);
                    pPage->SetReadMeText(pszText);
                    delete [] pszText;
                    WinDismissDlg (hwndDlg, TRUE);
                    break;
                    }
                case DID_CANCEL:
                    {
                    WinDismissDlg (hwndDlg, FALSE);
                    break;
                    }
                case IDD_PAGE_README_IMPORT:
                    {
                    HWND  hwndMle = WinWindowFromID(hwndDlg, IDD_PAGE_README_READMETEXT);
                    PSZ pszText = NULL;
                    IPT   lOffset = 0;
                    PSZ   pszTextFile;
                    HFILE hf;
                    ULONG cbCopied;
                    ULONG ulAction;
                    ULONG cbBytesRead;
                    PSZ pszFileName = "*.*";
                    //APSZ apszITypeList[4];
                    //(*apszITypeList)[0] = "Plain Text";
                    //(*apszITypeList)[1] = "HTML";
                    //(*apszITypeList)[2] = "text/html";
                    //(*apszITypeList)[3] = NULL;
                    if (guiShowFileDialog (hwndDlg, FILEDLG_TYPE_OPEN,
                       G_nlsStringTable.pszOpenFile, NULL,
                       NULL, &pszFileName, NULL, NULL)
                       == RET_FD_OK)
                        {
                        // Open the file and read text from it.
                        doshLoadTextFile(pszFileName, &pszText, NULL);
                        // Put the text to MLE window.
                        WinSetWindowText(hwndMle, pszText);
                        delete pszText;
                        }
                    break;
                    }
                break;
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }




/******************************************************************************
 *@@fnTradCntrDlgProc
 *  Dialog procedure for container dialog.
 */
MRESULT EXPENTRY fnTradCntrDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    switch (msg)
        {
        case WM_INITDLG:
            {
            CHAR szNumber[5];
            ScriptPage *pPage = (ScriptPage *)mp2;
            WinSetWindowPtr (hwndDlg, 0, (PVOID)pPage);
            sprintf(szNumber, "%i", pPage->ReturnPageIndex());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_CONTAINER_INDEX, szNumber);
            WinSetDlgItemText(hwndDlg, IDD_PAGE_CONTAINER_NEXTBTNTEXT,
                pPage->ReturnNextButtonObject()->ReturnNextButton());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_CONTAINER_TEXT, pPage->ReturnText());
            sprintf(szNumber, "%i", pPage->ReturnNextButtonObject()->ReturnTarget());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_CONTAINER_NEXTBTNINDEX, szNumber);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                    {
                    ScriptPage *pPage = (ScriptPage *)WinQueryWindowPtr(hwndDlg, 0);
                    ScriptNextButton *pNextBtn;
                    CHAR szIndex[5], szText[MAXNEXTBTNTEXTLENGTH], szText1[125];
                    PSZ pszText = NULL;

                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_CONTAINER_INDEX,
                                        4, szIndex);
                    pPage->SetPageIndex(atoi(szIndex));
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_CONTAINER_NEXTBTNINDEX,
                                        4, szIndex);
                    pNextBtn = pPage->ReturnNextButtonObject();
                    pNextBtn->SetTarget(atoi(szIndex));
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_CONTAINER_NEXTBTNTEXT,
                                        MAXNEXTBTNTEXTLENGTH, szText);
                    pNextBtn->SetNextButton(szText);
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_CONTAINER_TEXT,
                                        125, szText1);
                    pPage->SetText(szText1);
                    WinDismissDlg (hwndDlg, TRUE);
                    break;
                    }
                case DID_CANCEL:
                    {
                    WinDismissDlg (hwndDlg, FALSE);
                    break;
                    }
                break;
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }





/******************************************************************************
 *@@fnTradCnfgDlgProc
 *  Dialog procedure for configure dialog.
 */
MRESULT EXPENTRY fnTradCnfgDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    MRESULT mrc = 0;
    switch (msg)
        {
        case WM_INITDLG:
            {
            CHAR szNumber[5];
            ScriptPage *pPage = (ScriptPage *)mp2;
            WinSetWindowPtr (hwndDlg, 0, (PVOID)pPage);
            sprintf(szNumber, "%i", pPage->ReturnPageIndex());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_CONFIGURE_INDEX, szNumber);
            WinSetDlgItemText(hwndDlg, IDD_PAGE_CONFIGURE_NEXTBTNTEXT,
                pPage->ReturnNextButtonObject()->ReturnNextButton());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_CONFIGURE_TEXT, pPage->ReturnText());
            sprintf(szNumber, "%i", pPage->ReturnNextButtonObject()->ReturnTarget());
            WinSetDlgItemText(hwndDlg, IDD_PAGE_CONFIGURE_NEXTBTNINDEX, szNumber);
            break;
            }
        case WM_COMMAND:
            {
            switch (SHORT1FROMMP(mp1))
                {
                case DID_OK:
                    {
                    ScriptPage *pPage = (ScriptPage *)WinQueryWindowPtr(hwndDlg, 0);
                    ScriptNextButton *pNextBtn;
                    CHAR szIndex[5], szText[MAXNEXTBTNTEXTLENGTH], szText1[125];
                    PSZ pszText = NULL;

                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_CONFIGURE_INDEX,
                                        4, szIndex);
                    pPage->SetPageIndex(atoi(szIndex));
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_CONFIGURE_NEXTBTNINDEX,
                                        4, szIndex);
                    pNextBtn = pPage->ReturnNextButtonObject();
                    pNextBtn->SetTarget(atoi(szIndex));
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_CONFIGURE_NEXTBTNTEXT,
                                        MAXNEXTBTNTEXTLENGTH, szText);
                    pNextBtn->SetNextButton(szText);
                    WinQueryDlgItemText (hwndDlg, IDD_PAGE_CONFIGURE_TEXT,
                                        125, szText1);
                    pPage->SetText(szText1);
                    WinDismissDlg (hwndDlg, TRUE);
                    break;
                    }
                case DID_CANCEL:
                    {
                    WinDismissDlg (hwndDlg, FALSE);
                    break;
                    }
                break;
                }
            break;
            }
        default:
            {
            mrc = WinDefDlgProc (hwndDlg, msg, mp1, mp2);
            break;
            }
        }
    return mrc;
    }


/*
 *@@fnCnfgLbox:
 *      This is the window procedure for the config listbox control.
 *
 *      This is not a stand-alone window procedure, but must only
 *      be used with config listbox control subclassed in
 *      fnTradObjectPageProc.
 *
 */
MRESULT EXPENTRY fnCnfgLbox(HWND hwndWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
    {
    OLDPROC *pOldProc = (OLDPROC*)WinQueryWindowULong(hwndWnd, QWL_USER);

    MRESULT mrc = NULL;

    if (pOldProc)
        {
        PFNWP OldLboxProc = pOldProc->OldProc;
        switch(msg)
            {
            case WM_DESTROY:
                {
                mrc = OldLboxProc(hwndWnd, msg, mp1, mp2);
                free(pOldProc);
                break;
                }
            case WM_CONTROL:
                {
                switch (SHORT2FROMMP(mp1))
                    {
                    case CBN_EFCHANGE:
                        {
                        CHAR szTemp[256];
                        CHAR szTemp1[256];
                        CHAR szTemp2[512];
                        SHORT sItem = SHORT1FROMMR(WinSendMsg(hwndWnd,
                                                             LM_QUERYSELECTION,
                                                             MPFROMSHORT(LIT_FIRST),
                                                             MPFROMSHORT(0)));
                        WinSendMsg(hwndWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(sItem, 256),
                                   MPFROMP(szTemp));
                        WinQueryWindowText(hwndWnd, 256, szTemp1);
                        sprintf(szTemp2, "%s|%s", szTemp1, szTemp);
                        WinSetWindowText(hwndWnd, szTemp2);
                        break;
                        }
                    }
                break;
                }
            default:
                {
                mrc = OldLboxProc(hwndWnd, msg, mp1, mp2);
                break;
                }
            }
        }
    return(mrc);
    }

