/*
 *              WicPM - WarpIN Archive Creator for PM
 *                  (c) Copyright Teemu Ahola 2000
 *
 * gui_helpers.cpp
 *  This file contains functions for few special purpose. Not WicPM specific.
 *
 *  Copyright (C) 1999-2000 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 */

#include "wicpm\gui_helpers.h"
#include <string.h>

/****************************************************************************
 *@@ ShowErrorInformation
 *  Shows messagebox with error code and description.
 *      In:     HWND    hwndOwner   owner window handler
 *              USHORT  usErrorCode error code
 *              PSZ     pszCaption  the caption of the messagebox (not yet used)
 *      Return: USHORT  the return value of the WinMessageBox
 */
USHORT guiShowErrorInformation (HWND hwndOwner,
                                USHORT usErrorCode,
                                USHORT usCaption,
                                PSZ pszDetails
                                )
    {
    CHAR szMessage[50];
    PSZ pszCaption = NULL;
    sprintf (szMessage, "Error message: %i\nDescription: %s", usErrorCode, pszCaption);
    return WinMessageBox (HWND_DESKTOP, hwndOwner, szMessage, pszCaption, 0,
                         MB_OK | MB_HELP | MB_ERROR | MB_APPLMODAL);
    }

/****************************************************************************
 *@@ ShowMessageBox
 *  Shows basic warning messagebox with OK button.
 *    In:       HWND    hwndOwner
 *              PSZ     pszCaption
 *              PSZ     pszMessage
 *    Return:   USHORT  the return value of the WinMessageBox
 */
USHORT guiShowMessageBox (HWND hwndOwner, PSZ pszCaption, PSZ pszMessage)
    {
    return WinMessageBox (HWND_DESKTOP, hwndOwner, pszMessage, pszCaption, 0,
                         MB_OK | MB_WARNING | MB_APPLMODAL);
    }

/****************************************************************************
 *@@ ShowYesNoMessageBox
 *  This shows basic warning messagebox with yes and no buttons.
 *      in: owner hwnd
 *          caption psz
 *          message psz
 */
USHORT ShowYesNoMessageBox (HWND hwndOwner, PSZ pszCaption, PSZ pszMessage)
    {
    return WinMessageBox (HWND_DESKTOP, hwndOwner, pszMessage, pszCaption, 0,
                         MB_YESNO | MB_WARNING | MB_APPLMODAL);
    }

/****************************************************************************
 *@@ ShowYesNoCancelMessageBox
 *  This shows basic warning messagebox with yes, no and cancel buttons.
 *      in: owner hwnd
 *          caption psz
 *          message psz
 */
USHORT ShowYesNoCancelMessageBox (HWND hwndOwner, PSZ pszCaption, PSZ pszMessage)
    {
    return WinMessageBox (HWND_DESKTOP, hwndOwner, pszMessage, pszCaption, 0,
                         MB_YESNOCANCEL | MB_WARNING | MB_APPLMODAL);
    }


/****************************************************************************
 *@@ guiSetMLEText
 *  Set text to MLE control.
 *      In:     HWND    hwndParent
 *              ULONG   ulMLEId
 *              PSZ     pszText
 *
 */
INT guiSetMLEText (HWND hwndParent, ULONG ulMLEId, PSZ pszText)
    {
    IPT iOffset = 0;
    USHORT usBytesRead = 0;
    CHAR pszMleBuffer[512];

    if (!pszText)
        return ID_MSG_NULLPOINTERERROR;

    usBytesRead = strlen(pszText);
    WinSendDlgItemMsg(hwndParent, ulMLEId, MLM_SETIMPORTEXPORT, MPFROMP(pszText),
                      MPFROMSHORT(usBytesRead));

    WinSendDlgItemMsg(hwndParent, ulMLEId, MLM_IMPORT, MPFROMP(&iOffset),
                      MPFROMP(&usBytesRead));


    /*

    if ( !WinSendMsg(hwndPage, MLM_SETIMPORTEXPORT,
         MPFROMP(pszMleBuffer),
         MPFROMSHORT(sizeof(pszMleBuffer))))
     return FALSE;

     memset(pszMleBuffer,'\0',sizeof(pszMleBuffer));
     strcpy(pszMleBuffer, pszNoteBookText);

   if ( !WinSendMsg(hwndPage, MLM_IMPORT, &ipt,
         MPFROMSHORT(sizeof(pszMleBuffer))))
     return FALSE;

    */

    return ID_MSG_OK;
    }


/****************************************************************************
 *@@ InsertMLEText
 *  Insert text to MLE control.
 *      In:     HWND    hwndParent
 *              ULONG   ulMLEId
 *              PSZ     pszText
 *              IPT     iOffset     Insertion point for MLE. If -1 insert
 *                                  starting from current curson position.
 *
 */
INT InsertMLEText (HWND hwndParent, ULONG ulMLEId, PSZ pszText, IPT *iOffset)
    {
    ULONG ulBytesRead;

    ulBytesRead = strlen (pszText) + 1;
    WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_SETIMPORTEXPORT, MPFROMP (pszText),
                      MPFROMSHORT ((USHORT) ulBytesRead));
    WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_IMPORT, MPFROMP (iOffset),
                      MPFROMP(&ulBytesRead));

    return ID_MSG_OK;
    }



/****************************************************************************
 *@@ guiClearMLE
 *  This function clears MLE.
 *      In:     HWND    hwndParent
 *              ULONG   ulMLEId
 */
INT guiClearMLE (HWND hwndParent, ULONG ulMLEId)
    {
        /* Disable refresh */
    WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_DISABLEREFRESH, NULL, NULL);
        /* Select content */
    WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_SETSEL, MPFROMSHORT (NULL),(MPARAM)
                        WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_QUERYTEXTLENGTH,
                        NULL, NULL));
        /* Clear content */
    WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_CLEAR, NULL, NULL);
        /* Enable refresh */
    WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_ENABLEREFRESH, NULL, NULL);

    return ID_MSG_OK;
    }

/****************************************************************************
 *@@ guiGetMLEText
 *  This function exports text from MLE. Returns newly allocated string.
 *      In:     HWND    hwndParent
 *              ULONG   ulMLEId
 *      Out:    PSZ     *pszText        Text from MLE.
 *      Return: ID_MSG_OK
 *              ID_MSG_MEMALLOCERROR
 */
INT guiGetMLEText (HWND hwndParent, // Parent window handler.
                   ULONG ulMLEId, // MLE id number.
                   PSZ *pszText // Address of pointer to string.
                   )
    {
    ULONG ulCopy;
    IPT iOffset = 0;
    PSZ pszTemp = NULL;
    CHAR szMleBuff[1024];
    memset(szMleBuff, 0, sizeof(szMleBuff));

     WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_SETIMPORTEXPORT,
                      MPFROMP(szMleBuff), MPFROMSHORT(sizeof(szMleBuff)));

    ulCopy = (ULONG) WinSendDlgItemMsg (hwndParent, ulMLEId,
                                        MLM_QUERYFORMATTEXTLENGTH, MPFROMLONG
                                        (iOffset), MPFROMLONG ((-1)));
    pszTemp = (PSZ) new CHAR[1024];
    if (!pszTemp)
        return ID_MSG_MEMALLOCERROR;
    memset(pszTemp, 0, ulCopy);

    WinSendDlgItemMsg (hwndParent, ulMLEId, MLM_EXPORT, MPFROMP (&iOffset),
                      MPFROMP (&ulCopy));

    strcpy(pszTemp, szMleBuff);
    *pszText = pszTemp;
    return ID_MSG_OK;
    }




/****************************************************************************
 *@@ guiSetEntryFieldTextLimit
 *  This function sets entry field text limit.
 */
USHORT guiSetEntryFieldTextLimit(HWND hwndParent, // Parent window handler.
                                 ULONG ulEFId, // Entry field ID.
                                 SHORT sTextLimit // Text limit.
                                 )
    {
    WinSendDlgItemMsg(hwndParent, ulEFId, EM_SETTEXTLIMIT, (MPARAM)sTextLimit,
                      (MPARAM)0);
    return 0;
    }



/****************************************************************************
 *@@ guiShowFileDialog
 *  Shows standard file dialog. Different types are FILEDLG_TYPE_SAVE,
 *  FILEDLG_TYPE_OPEN and FILEDLG_TYPE_SELECT.
 */
USHORT guiShowFileDialog (HWND hwndMainWndClient,// Client wnd handler.
                         USHORT usFileDlgType,// File dialog type.
                         PSZ pszDialogTitle,// The title of the file dialog.
                         PAPSZ papszITypeList,// Pointer to table of pointers of EA types.
                         PSZ pszIType, // Pointer to default EA type.
                         PSZ *pszFileName,// In: default file name, out: selected file name.
                         PAPSZ *papszFQFileName, // Pointer to table of pointers to selected
                                                 // file names.
                         ULONG *ulFQFCount // The size of the papszFQFileName
                         )
    {
    PFILEDLG pFileDlgInfo;
    char szString[1024];
    USHORT mrc;

    // Allocate and initialize file dialog structure.
    pFileDlgInfo = (PFILEDLG) malloc (sizeof (FILEDLG));

    memset(pFileDlgInfo, 0, sizeof(FILEDLG));

    pFileDlgInfo->cbSize = sizeof(FILEDLG);  // Size of structure.

    if (usFileDlgType == FILEDLG_TYPE_SAVE)
        {
        pFileDlgInfo->fl = FDS_CENTER |          // Behavior flags for save as dialog.
                           FDS_SAVEAS_DIALOG;
        pFileDlgInfo->pszTitle = pszDialogTitle; // Dialog title string.
        }
    else if (usFileDlgType == FILEDLG_TYPE_OPEN)
        {
        pFileDlgInfo->fl = FDS_CENTER |          // Behavior flags for open dialog.
                           FDS_OPEN_DIALOG;
        pFileDlgInfo->pszTitle = pszDialogTitle; // Dialog title string.
        }
    else if (usFileDlgType == FILEDLG_TYPE_SELECT)
        {
        pFileDlgInfo->fl = FDS_CENTER |          // Behavior flags for file selection
                           FDS_OPEN_DIALOG |     // dialog.
                           FDS_MULTIPLESEL;
        pFileDlgInfo->pszTitle = pszDialogTitle; // Dialog title string.
        }
    else return RET_FD_PARAM_ERROR;

    pFileDlgInfo->ulUser = 0;               // No user data.
    pFileDlgInfo->lReturn = 0;              // Result code - returned.
    pFileDlgInfo->lSRC = 0;                 // System return code.

    pFileDlgInfo->pfnDlgProc = NULL;        // Use subclassing dialog procedure.
    pFileDlgInfo->pszIType = pszIType;      // Extended attribute type filters.
    pFileDlgInfo->papszITypeList = papszITypeList; //List of EA types.
    pFileDlgInfo->pszIDrive = NULL;         // Initial drive.
    pFileDlgInfo->papszIDriveList = NULL;   // No specified list of drives.
    pFileDlgInfo->hMod = (HMODULE) NULL;    // No custom dialog resources.
    pFileDlgInfo->pszOKButton = NULL;

    // The fully-qualified name of the file.
    if (*pszFileName)
        strcpy (pFileDlgInfo->szFullFile, *pszFileName);

    pFileDlgInfo->ulFQFCount = 0;           // Number of files selected - returned.
    pFileDlgInfo->usDlgId = 0;              // No custom dialog id.
    pFileDlgInfo->x = FDS_CENTER;           // Display in center of parent.
    pFileDlgInfo->y = FDS_CENTER;
    pFileDlgInfo->sEAType = 0;              // Selected EA type. Not used in Open dialog.

    WinFileDlg (HWND_DESKTOP, hwndMainWndClient, pFileDlgInfo);

    if (pFileDlgInfo->lReturn == DID_OK)    // If user pressed "OK".
        {
        if (pszFileName)
            *pszFileName = strdup (pFileDlgInfo->szFullFile);
        if (ulFQFCount)
            *ulFQFCount = pFileDlgInfo->ulFQFCount;
        if (papszFQFileName)
            *papszFQFileName = pFileDlgInfo->papszFQFilename;
        else
            WinFreeFileDlgList(pFileDlgInfo->papszFQFilename);
        mrc = RET_FD_OK;
        }
    else mrc = RET_FD_CANCEL;

    free (pFileDlgInfo);

    return mrc;
    }


USHORT guiLoadString(HAB habThread, ULONG ulID, PSZ *ppsz)
    {
    CHAR szBuf[255];
    USHORT rc = 0;

    if (*ppsz)
        free(*ppsz);
    if (WinLoadString(habThread, NULLHANDLE, ulID ,
                      sizeof(szBuf), szBuf))
        *ppsz = strdup(szBuf);
    else
        {
        *ppsz = strdup("Error: String resource not found");
        rc = 1;
        }

    return rc;
    }
