
/*
 *@@sourcefile wic.h:
 *      header file for the WIC sources.
 *
 */

/*
 *      This file Copyright (C) 1998-2001 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/* class BSCancelExcpt                     //bird
{                                       //bird
public:                                 //bird
    int iErrno;                         //bird
    BSCancelExcpt(int iErrno)           //bird
        : iErrno(iErrno)                //bird
    {}                                  //bird
};                                      //bird
*/

/*
 *@@ WICExcpt:
 *      exception thrown by GetEnvironment (warpin.cpp)
 *      if an invalid environment variable value
 *      has been encountered.
 */

class WICExcpt : public BSExcptBase
{
    public:
        int     _rc;

        WICExcpt(int rc)
        {
            _rc = rc;
        }
};

/*
 *@@ PackageMaskSpec:
 *      structure created for each package passed
 *      on the command line in "add" mode.
 *
 *      These things are created in main() and passed to AddMode().
 */

struct PackageMaskSpec : public BSRoot
{
    public:
        DECLARE_CLASS(PackageMaskSpec);

    public:
        LONG        lPackage;           // package no. to add to (as on cmd line)
        string      strSubdir;          // if != NULL: directory where to search
                                        // for files ("-c" switch)
        BOOL        fRecurse;           // if TRUE: recurse into subdirectories ("-r" switch)
        list<string*>   listFileMasks;      // list of file masks to add to package, as
                                        // specified on command line
        ULONG       cFileMasks;         // count of file masks in listFileMasks

        // constructor
        PackageMaskSpec()
            : BSRoot(tPackageMaskSpec), listFileMasks(STORE)
        {
            lPackage = 0;
            fRecurse = FALSE;
            cFileMasks = 0;
        }
};

// mode options
#define MODE_ADD            1
// #define MODE_DELETE         2
#define MODE_LIST           3
#define MODE_SETSCRIPT      4
#define MODE_EXTRACT        5
#define MODE_EXTRACTSCRIPT  6
#define MODE_TESTSCRIPT     7
#define MODE_QUERY_ARC      8
#define MODE_INSTALL        9

VOID Error(APIRET arc,          // out: error code to exit with
           PCSZ pcszFormat,
           ...);

VOID TestScriptMode(const char *pcszScriptName,
                    string &strWICPath);

extern BOOL G_fRexxAllowed;

VOID InstallMode(PCSZ pcszCID,
                 string &strWICPath);

VOID QueryArcMode(PCSZ pcszArchive,
                  string &strWICPath);



