/*
 * $Id: buildin.c,v 1.1 2001/07/15 20:33:42 jens Exp $
 *
 * Create a ready-to run SelfIN file.
 *
 * While WarpIN is a very good utility for installing other applications, you
 * can't install WarpIN itself using WarpIN. This small utility, named SelfIN,
 * will remedy that. By using the same powerful BZ2 compression code that is
 * used in WarpIN itself, the installer will be very small. Best of all, you no
 * longer have to use Zip archives for distributing WarpIN. Finally, WarpIN can
 * be installed by using (an extremely compact version of) itself.
 *
 * This file Copyright (C) 2001 Jens B&auml;ckman
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, in version 2 as it comes in the COPYING
 * file of this distribution.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <stdio.h>
#include "selfin/common.h"

/*****************************************************************************
 * Compress a file and store it inside another file.
 *
 * Arguments - out: File handle to storage spot.
 *             filename: Name and path to file we should store.
 *             nameToStore: Under which name we should store the file.
 **/
void compress(FILE *out, char *filename, char *nameToStore)
{
    #define BUFFERSIZE 0x10000
    unsigned char outBuffer[BUFFERSIZE];/* Output data buffer         */
    unsigned char inBuffer[BUFFERSIZE]; /* Input data buffer          */
    unsigned long bytesCompressed;      /* File size originally       */
    unsigned long bytesOriginal;        /* File size after BZ2        */
    unsigned long headerPosition;       /* File position for header   */
    unsigned long readBytes;            /* Total number of bytes read */
    bz_stream bz;                       /* BZ2 control structure      */
    FILE *file;                         /* Input file                 */
    int status;                         /* BZ2 library status         */
    int count;
    char c;

    /* Do some basic initialization before we get started. */
    file = fopen(filename, "rb");
    fseek(file, 0, SEEK_END);
    bytesOriginal = ftell(file);
    rewind(file);
    bytesCompressed = 0;
    readBytes       = 0;

    /* Make sure that BZ2 knows what's going on here. */
    bz.bzalloc   = NULL;
    bz.bzfree    = NULL;
    bz.opaque    = NULL;
    bz.avail_in  = 0;
    bz.avail_out = BUFFERSIZE;
    bz.next_out  = outBuffer;
    BZ2_bzCompressInit (&bz, 9, 0, 0);

    /* Write fake header. */
    headerPosition = ftell(out);
    fwrite(outBuffer, sizeof(unsigned long) * 2 + 1 + strlen(nameToStore), 1, out);

    for (;;) {
        if (bz.avail_in == 0) {
            bz.next_in = inBuffer;
            bz.avail_in = fread(inBuffer, BUFFERSIZE, 1, file);
            readBytes += bz.avail_in;
        }
        if (bz.avail_in == 0 || bz.avail_in == 0xFFFFFFFF)  break;

        status = BZ2_bzCompress(&bz, BZ_RUN);
        if (status < 0) {
            /* TODO: Error handling, please. */
            return;
        }
        count = BUFFERSIZE - bz.avail_out;
        if (count > 0) {
            fwrite(outBuffer, count, 1, out);
            bytesCompressed += count;
            bz.next_out  = outBuffer;
            bz.avail_out = BUFFERSIZE;
        }
    }

    /* Flush the pending compressed data. */
    if (readBytes > 0) {
        do {
            status = BZ2_bzCompress(&bz, BZ_FINISH);
            count  = BUFFERSIZE - bz.avail_out;
            if (count > 0) {
                fwrite(outBuffer, count, 1, out);
                bytesCompressed += count;
                bz.next_out  = outBuffer;
                bz.avail_out = BUFFERSIZE;
            }
        } while (status != BZ_STREAM_END);
    }

    /* Write real header */
    fseek(out, headerPosition, SEEK_SET);
    fwrite(&bytesCompressed, sizeof(unsigned long), 1, out);
    fwrite(&bytesOriginal, sizeof(unsigned long), 1, out);
    c = strlen(nameToStore);
    fwrite(&c, 1, 1, out);
    fwrite(nameToStore, c, 1, out);
    fseek(out, 0, SEEK_END);

    fclose(file);
    BZ2_bzCompressEnd (&bz);
}

/*****************************************************************************
 * Application entry point.
 **/
int main(int argc, char *argv[])
{
    FILE *installer;
    FILE *listfile;
    FILE *out;
    char filename[256];
    char realname[256];
    unsigned char buffer[8192];
    int files;
    int i;

    if (argc != 3) {
        printf("Usage: %s <destination file> <file with wanted files>\n", argv[0]);
        return 0;
    }

    /* Try to open the installer. */
    installer = fopen("selfin.exe", "rb");
    if (installer == NULL) {
        printf("There is no selfin.exe, and no spoon either.\n");
        return 1;
    }

    /* Open up the listfile. */
    listfile = fopen(argv[2], "rb");
    if (listfile == NULL) {
        printf("The listfile you specified could not be opened.\n");
        return 1;
    }

    /* Copy the installer. */
    out = fopen(argv[1], "rb");
    i = fread(buffer, 8192, 1, installer);
    while (i) {
        fwrite(buffer, i, 1, out);
        i = fread(buffer, 8192, 1, installer);
    }

    /* Start adding files. */
    fscanf(listfile, "%d\n", &files);
    while (files--) {
        fscanf(listfile, "%s\n", filename);
        fscanf(listfile, "%s\n", realname);
        printf("Compressing %s\n", realname);
        compress(out, filename, realname);
    }

    fclose(out);
    fclose(listfile);
    fclose(installer);
    return 0;
}

