#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

#include "net\WINet.hpp"
#include "net\WISocket.hpp"

Socket::Socket()
{
  bIsConnected = false;
}

Socket::~Socket(void)
{
  // Automatically disconnect if necessary
  if (bIsConnected)
    Disconnect();
}

socket_Error Socket::Connect(const char*        hostaddress,
                             unsigned short int addresslength,
                             unsigned short int port)
{
  if (bIsConnected)
    return socket_Error_Already_Connected;

  // Create the socket

  iSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
  if (iSocket == -1)
    return socket_Socket_Creation_Error;

  // Setup sockaddr_in structure

  struct sockaddr_in Sockaddr_in = { 0 };
  Sockaddr_in.sin_family = AF_INET;
  Sockaddr_in.sin_port   = htons(port);
  memcpy(&Sockaddr_in.sin_addr, hostaddress, addresslength);

  // Connect (using connect() from <sys/socket.h>)

  if (connect(iSocket,
              (struct sockaddr *) &Sockaddr_in,
              sizeof(Sockaddr_in)) == -1)
    return socket_Connect_Error;

  // We're happy now and create our file handles

  sockIn  = fdopen(iSocket, "r");
  sockOut = fdopen(iSocket, "w");
  bIsConnected = true;

  return socket_Success;
}

socket_Error
Socket::Disconnect()
{
  if (bIsConnected)
  {
    shutdown(iSocket, 2);
    fclose(sockIn);
    fclose(sockOut);
    bIsConnected = false;

    return socket_Success;
  }
  else
    return socket_Error_Not_Connected;
}

socket_Error
Socket::ReadLine(char *buffer,
                 int   bufsize)
{
    if (bIsConnected)
    {
        if (fgets(buffer, bufsize, sockIn) == NULL)
            return socket_Read_Error;
        else
        {
            // Remove trailing control characters (especially #10, #13)

            while (buffer[strlen(buffer)-1] < 32)
            {
                if (strlen(buffer) == 0)
                    break;
                buffer[strlen(buffer)-1] = '\0';
            }
#ifdef DEBUG
            PrintDebug("Socket::ReadLine():  %s\n", buffer);
#endif // DEBUG
            return socket_Success;
        }
    }
    else
        return socket_Error_Not_Connected;
}

socket_Error
Socket::ReadChar(char *buffer)
{
  if (bIsConnected)
  {
    *buffer = fgetc(sockIn);
    return socket_Success;
  }
  else
    return socket_Error_Not_Connected;
}

socket_Error
Socket::ReadBytes(char* buffer, size_t buflen, size_t* bytesRead)
{
  if (bIsConnected)
  {
    *bytesRead = fread(buffer, 1, buflen, sockIn);
#ifdef DEBUG
    PrintDebug("Socket::ReadBytes(): [%lu bytes]\n", *bytesRead);
#endif // DEBUG
    if ((*bytesRead != buflen) && (!feof(sockIn)))
      return socket_Read_Error;
    else
      return socket_Success;
  }
  else
    return socket_Error_Not_Connected;
}

socket_Error
Socket::Printf(const char* format, ...)
{
    if (bIsConnected)
    {
        va_list arg_ptr;

        va_start(arg_ptr, format);
#ifdef DEBUG
        char buffer[4096];
        vsprintf(buffer, format, arg_ptr);
        PrintDebug("Socket::Printf():    %s", buffer);
#endif // DEBUG
        vfprintf(sockOut, format, arg_ptr);
        va_end(arg_ptr);

        fflush(sockOut);

        return socket_Success;
    }
    else
        return socket_Error_Not_Connected;
}
