/******************************************************************************
 *@@sourcefile WIP_HTTP_Header.cpp:
 *      Implements WIP_HTTP_Header class to store HTTP response headers.
 *
 *@@header "net/WIP_HTTP_Header.hpp"
 */

#include "net\WIP_HTTP_Header.hpp"

/******************************************************************************
 *@@ WIP_HTTP_Header:
 *  <P>This constructor will split <CODE>pcszLine</CODE> into name and value
 *      field, removing leading and trailing LWS from the value field.
 */

WIP_HTTP_Header::WIP_HTTP_Header(PCSZ pcszLine) // in: header line to parse
{
    // Split header into name and value

    _strHeaderName._extract_from(pcszLine, strchr(pcszLine, ':'));
    _strHeaderValue = (strchr(pcszLine, ':') + 1);

    // Remove leading and trailing linear white space (LWS) from value

    while ((!_strHeaderValue.empty()) &&
           ((_strHeaderValue[0] == ' ') ||
            (_strHeaderValue[0] == '\t')))
      _strHeaderValue.erase(0, 1);

    while ((!_strHeaderValue.empty()) &&
           ((_strHeaderValue[_strHeaderValue.size()-1] == ' ') ||
            (_strHeaderValue[_strHeaderValue.size()-1] == '\t')))
      _strHeaderValue.erase(_strHeaderValue.size()-1);
}

/******************************************************************************
 *@@ WIP_HTTP_Header:
 *  <P>The copy constructor just copies all data from the given instance.
 */

WIP_HTTP_Header::WIP_HTTP_Header(const WIP_HTTP_Header& wipHTTP_Header)
                                                // in: instance to copy from
{
  _strHeaderName  = wipHTTP_Header._strHeaderName;
  _strHeaderValue = wipHTTP_Header._strHeaderValue;
}

/******************************************************************************
 *@@ AppendValue:
 *  <P>Appends values to the strHeaderValue field, separated by a single SP.
 *      Leading and trailing LWS is removed before.
 */

VOID
WIP_HTTP_Header::AppendValue(PCSZ pcszLine)
{
    // Remove leading and trailing LWS

    PCSZ pcszTmp = pcszLine;
    while ((strlen(pcszTmp) > 0) &&
           ((pcszTmp[0] == ' ') ||
            (pcszTmp[0] == '\t')))
        pcszTmp++;
    string str = pcszTmp;
    while ((!str.empty()) &&
           ((str[str.size()-1] == ' ') ||
            (str[str.size()-1] == '\t')))
        str.erase(str.size()-1);

  // Append value

  _strHeaderValue += " " + str;
}
