/******************************************************************************
 *@@sourcefile WIP_HTTP.cpp:
 *      Document me!
 *
 *@@header "net/WIP_HTTP.hpp"
 *@@header "net/WIProtocol.hpp"
 */

#define INCL_DOSMISC            // DosQuerySysInfo()
#include "bldlevel.h"           // BLDLEVEL_VERSION
#include "net\WIP_HTTP.hpp"

static PCSZ pcszHTTPVersion = "HTTP/1.1";

/******************************************************************************
 *@@ WIP_HTTP:
 *      <P>Document me!
 */

WIP_HTTP::WIP_HTTP(WINet* pwiNet) : WIProtocol(pwiNet)
{
}

/******************************************************************************
 *@@ Fetch:
 *      <P>Document me!
 */

BOOL
WIP_HTTP::Fetch(WIURL& wiURL,
                PCSZ   pcszSavefileName,
                BOOL   fResume)
{
#ifdef DEBUG
    PrintDebug("WIP_HTTP::Fetch():   http://%s:%hu%s --> %s\n",
               wiURL.GetServerName(), wiURL.GetServerPort(),
               wiURL.GetDocumentPath(), pcszSavefileName);
#endif // DEBUG

    _pcszSavefileName = pcszSavefileName;

    return GET_Method(wiURL);
}


/******************************************************************************
 *@@ GET_Method:
 *      <P>Document me!
 */

BOOL
WIP_HTTP::GET_Method(WIURL& wiURL)
{
    BOOL fSuccess = false;

    Callback(CBM_NET_CONNECT, 0, wiURL);

    fSuccess = (_socket.Connect(wiURL.GetServerAddress(),
                                wiURL.GetAddressLength(),
                                wiURL.GetServerPort()) == socket_Success);

    if (!fSuccess)
        Callback(CBM_NET_CONNECT_FAILED, errno, wiURL);
    else
    {
        Callback(CBM_NET_REQUEST, 0, wiURL);
        const WIP_HTTP_Response&
            response = WriteRequest(_socket, wiURL, "GET");

        USHORT usStatusCode = response.GetStatusCode();

        if (usStatusCode != 200)
        {
            Callback(CBM_NET_REQUEST_FAILED, usStatusCode, wiURL);
            fSuccess = FALSE;

//            PCSZ pcszReasonPhrase = response.GetReasonPhrase();

            /* Status code 1xx */
            if (usStatusCode/100 == 1)
            {
//                _pwiNet->Callback("[Informational] %hu %s",
//                                  usStatusCode, pcszReasonPhrase);
            }
            /* Status code 2xx */
            else if (usStatusCode/100 == 2)
            {
//                _pwiNet->Callback("[Successful] %hu %s",
//                                  usStatusCode, pcszReasonPhrase);
            }
            /* Status code 3xx */
            else if (usStatusCode/100 == 3)
            {
//                _pwiNet->Callback("[Redirection] %hu %s",
//                                  usStatusCode, pcszReasonPhrase);
            }
            /* Status code 4xx */
            else if (usStatusCode/100 == 4)
            {
//                _pwiNet->Callback("[Client Error] %hu %s",
//                                  usStatusCode, pcszReasonPhrase);
            }
            /* Status code 5xx */
            else if (usStatusCode/100 == 5)
            {
//                _pwiNet->Callback("[Server Error] %hu %s",
//                                 usStatusCode, pcszReasonPhrase);
            }
        }
        else if ((response.GetTransferEncoding() != TE_IDENTITY) &&
                (response.GetTransferEncoding() != TE_CHUNKED))
            fSuccess = FALSE;
        else
        {
            HFILE hFile;
            ULONG ulFileSize = 0;

            if (response.ContentLengthGiven())
                ulFileSize = response.GetContentLength();
            Callback(CBM_NET_FILESIZE, ulFileSize, wiURL);

            fSuccess = OpenFile(&hFile, ulFileSize);
            if (fSuccess)
            {
                fSuccess = FetchToFile(response, hFile, wiURL);
                CloseFile(hFile);
            }
        }

       _socket.Disconnect();
    }

    return fSuccess;
}

/******************************************************************************
 *@@ WriteRequest:
 *      <P>Document me!
 */

WIP_HTTP_Response
WIP_HTTP::WriteRequest(Socket& socket,
                       WIURL&  wiURL,
                       PCSZ    pcszMethod)
{
    // Write request line. Example:
    // GET http://www.os2.org:80/ HTTP/1.1

    socket.Printf("%s http://%s:%hu%s %s\n",
                  pcszMethod, wiURL.GetServerName(), wiURL.GetServerPort(),
                  wiURL.GetDocumentPath(), pcszHTTPVersion);

    // Good practice: 1) General header fields, 2) Request header fields
    // Notes: 1) Connection:Currently there is no support for persistent connections
    //        2) Host: is mandatory, the rest is optional

    socket.Printf("Connection: close\n");

    socket.Printf("Host: %s\n", wiURL.GetServerName());

    ULONG aulVersionInfo[3];
    DosQuerySysInfo(QSV_VERSION_MAJOR, QSV_VERSION_REVISION,
                    aulVersionInfo, 3*sizeof(ULONG));

    socket.Printf("User-Agent: WarpIn/%s OS2/%lu.%lu.%lu\n",
                  BLDLEVEL_VERSION, aulVersionInfo[0],
                  aulVersionInfo[1], aulVersionInfo[2]);

    // Terminate request header

    socket.Printf("\n");

    return WIP_HTTP_Response(socket);
}

/******************************************************************************
 *@@ OpenFile:
 *      Document me!
 */

BOOL
WIP_HTTP::OpenFile(PHFILE phFile,
                   ULONG  ulFileSize)
{
    BOOL  fSuccess = FALSE;
    ULONG ulAction = 0;

    // Open the file for writing

    fSuccess = (DosOpen(_pcszSavefileName, phFile,
                        &ulAction, 0, FILE_NORMAL, FILE_OPEN,
                        OPEN_ACCESS_WRITEONLY | OPEN_SHARE_DENYWRITE,
                        (PEAOP2) NULL) == 0);

    // If it fails, create the file for writing

    if (!fSuccess)
    {
        ulAction = 0;
        fSuccess = (DosOpen(_pcszSavefileName, phFile,
                            &ulAction, ulFileSize, FILE_NORMAL, FILE_CREATE,
                            OPEN_ACCESS_WRITEONLY | OPEN_SHARE_DENYWRITE,
                            (PEAOP2) NULL) == 0);
    }

    return fSuccess;
}

/******************************************************************************
 *@@ FetchToFile:
 *      Document me!
 */

BOOL
WIP_HTTP::FetchToFile(const WIP_HTTP_Response& response,
                            HFILE              hFile,
                      const WIURL&             wiURL)
{
    BOOL fSuccess             = FALSE;
    BOOL fWriteFailure        = FALSE;
    enumTE enTransferEncoding = response.GetTransferEncoding();
    ULONG  ulTotalBytesRead   = 0;

    APIRET RC;
    ULONG  ulBuflen = 4096;
    BYTE*  pBytes = new BYTE[ulBuflen];
    ULONG  ulBytesToRead;
    ULONG  ulBytesRead;
    ULONG  ulBytesWritten;

    // Transfer-Encoding: identity

    if (enTransferEncoding == TE_IDENTITY)
    {

        BOOL bCanCheckLength = response.ContentLengthGiven();
        ULONG ulTotalToRead;

        if (bCanCheckLength)
            ulTotalToRead = response.GetContentLength();
        else
            ulTotalToRead = 0xFFFFFFFF;

        while (ulTotalToRead > 0)
        {
            if (ulTotalToRead > ulBuflen)
                ulBytesToRead = ulBuflen;
            else
                ulBytesToRead = ulTotalToRead;

            _socket.ReadBytes(pBytes, ulBytesToRead, &ulBytesRead);

            ulTotalToRead    -= ulBytesRead;
            ulTotalBytesRead += ulBytesRead;

            // Write data

            RC = DosWrite(hFile, pBytes, ulBytesRead, &ulBytesWritten);
            if ((RC != 0) || (ulBytesWritten != ulBytesRead))
            {
                fWriteFailure = TRUE;
                break;
            }

            Callback(CBM_NET_BYTES_TRANSFERRED, ulTotalBytesRead, wiURL);

            // Finished?

            if (ulBytesRead < ulBytesToRead)
                break;
        }

        if ((!bCanCheckLength) ||
            (ulTotalBytesRead == response.GetContentLength()))
            fSuccess = TRUE && (!fWriteFailure);
    }

    // Transfer-Encoding: chunked

    else if (enTransferEncoding == TE_CHUNKED)
    {
        // Read first chunk size

        _socket.ReadLine(pBytes, ulBuflen);
        sscanf(pBytes, "%lx", &ulBytesToRead);

        while (ulBytesToRead > 0)
        {
            // Read chunk

            _socket.ReadBytes(pBytes, ulBytesToRead, &ulBytesRead);

            ulTotalBytesRead += ulBytesRead;

            // Write data

            RC = DosWrite(hFile, pBytes, ulBytesRead, &ulBytesWritten);
            if ((RC != 0) || (ulBytesWritten != ulBytesRead))
            {
                fWriteFailure = TRUE;
                break;
            }

            Callback(CBM_NET_BYTES_TRANSFERRED, ulTotalBytesRead, wiURL);

            // Finished?

            if (ulBytesRead < ulBytesToRead)
                break;

            // Skip CRLF

            _socket.ReadLine(pBytes, ulBuflen);

            // Read next chunk size

            _socket.ReadLine(pBytes, ulBuflen);
            sscanf(pBytes, "%lx", &ulBytesToRead);
        }

        if (ulBytesToRead == 0)
            fSuccess = TRUE;
    }

    delete pBytes;

    return fSuccess;
}

/******************************************************************************
 *@@ CloseFile:
 *      Document me!
 */

BOOL
WIP_HTTP::CloseFile(HFILE hFile)
{
    return (DosClose(hFile) == 0);
}
