
/*
 *@@sourcefile gui_drive_info.cpp:
 *      this implements the GUI "drive info" window.
 *
 *      This is additional code for the "free space on drives"
 *      window which is displayed only on the container page
 *      of the main window. This basically deals with the ugly
 *      Details view container messaging and updating it.
 *
 *      This has been separated from gui.cpp to reduce
 *      source code dependencies and speed up compile times.
 *
 *@@added V0.9.1 (2000-02-06) [umoeller]
 */

/*
 *
 *      This file Copyright (C) 1998-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define OS2EMX_PLAIN_CHAR
    // this is needed for "os2emx.h"; if this is defined,
    // emx will define PSZ as _signed_ char, otherwise
    // as unsigned char

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_WIN
#define INCL_WINWORKPLACE
#define INCL_GPILOGCOLORTABLE
#define INCL_GPIPRIMITIVES
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>           // included with wiarchive.h
#ifdef __IBMCPP__
    #include <direct.h>
#endif
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <setjmp.h>             // needed for except.h
#include <assert.h>             // needed for except.h
#include <io.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "setup.h"

// include's from helpers
#include "helpers\dosh.h"
#include "helpers\cnrh.h"
#include "helpers\nls.h"
#include "helpers\nlscache.h"
#include "helpers\stringh.h"
#include "helpers\threads.h"
#include "helpers\winh.h"
#include "helpers\xstring.h"

// base includes (99-11-07) [umoeller]
#include "base\bs_base.h"
#include "base\bs_list.h"
#include "base\bs_string.h"
#include "base\bs_errors.h"
#include "base\bs_logger.h"
#include "base\bs_config.h"

#include "base\bs_config.h"

// back-end includes
#include "wiarchive\wiarchive.h"

// front-end includes
#include "engine\fe_base.h"

#include "engine\fe_script.h"

#include "engine\fe_package.h"
#include "engine\fe_package_arc.h"
#include "engine\fe_package_db.h"
#include "engine\fe_archive.h"
#include "engine\fe_job.h"
#include "engine\fe_database.h"

#include "engine\fe_engine.h"

#include "frontend\warpin.h"
#include "frontend\calbacks.h"

#include "frontend\dlgids.h"
#include "frontend\gui.h"

#pragma hdrstop

/* ******************************************************************
 *
 *  Global variables
 *
 ********************************************************************/

CHAR            G_szAllDrives[30];
ULONG           G_cDrives = 0;
double          G_adSpaceRequired[28] = {0};
PDRIVERECORD    G_pDrvReccsInvalid[28];

/*
 *@@ fncbreccSumUpSize:
 *      callback for cnrhForAllRecords upon the Drive
 *      info window.
 *      This goes thru all record cores and sums up
 *      the total free and required space on all the
 *      drives (in KB).
 *      This is needed for the bottommost row in the
 *      drive info container.
 *
 *@@changed V0.9.0 (99-11-30) [umoeller]: prototype adjusted for new cnrhForAllRecords
 */

ULONG EXPENTRY fncbreccSumUpSize(HWND hwndCnr, PRECORDCORE precc, ULONG ul1, ULONG ul2)
{
    FEInstallJob *pJob;
    if (pJob = ((PPACKAGERECORD)precc)->pJob->IsInstallJob())
        if (pJob->Is2BeInstalled())
        {
            // package selected:
            const char *pszTargetPath = pJob->QueryTargetPath().GetBuffer();
            LONG lDriveNum = (toupper(*pszTargetPath)) - 'A' + 1;
            // drive number (A = 1, B = 2, ...)
            if ((lDriveNum > 0) && (lDriveNum < 27))
                G_adSpaceRequired[lDriveNum] += (double)(pJob->QueryPckSizeRounded());
        }

    return (0); // continue
}

/*
 *@@ fnwpDriveInfo:
 *      wnd proc for the "Drive Info" window.
 *      This needs to handle a lot of ugly messages
 *      for cnr Details view.
 *
 *@@changed V0.9.2 (2000-03-04) [umoeller]: made drive bytes double values
 *@@changed V0.9.12 (2001-05-31) [umoeller]: values were totally wrong after drive letter gaps, fixed
 *@@changed V0.9.18 (2002-03-03) [umoeller]: added GUIInstallEngine* to QWL_USER
 */

MRESULT EXPENTRY fnwpDriveInfo(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mrc = 0;

    // engine is in QWL_USER V0.9.18 (2002-03-03) [umoeller]
    GUIInstallEngine *pEngine = (GUIInstallEngine *)WinQueryWindowPtr(hwndDlg, QWL_USER);

    switch (msg)
    {
        /*
         * WM_INITDLG:
         *
         */

        case WM_INITDLG:
            // GUIInstallEngine* is in mp2, so store this!
            // V0.9.18 (2002-03-03) [umoeller]
            WinSetWindowPtr(hwndDlg, QWL_USER, mp2);

            mrc = WinDefDlgProc(hwndDlg, msg, mp1, mp2);

            // set fonts
            winhSetControlsFont(hwndDlg, 0, 500,
                        gshrQueryDefaultFont());

            // initialize container data
            WinPostMsg(hwndDlg, WPIM_QUERYDRIVES, NULL, NULL);
        break;

        /*
         * WPIM_QUERYDRIVES:
         *      this is posted to initialize the container data.
         */

        case WPIM_QUERYDRIVES:
        {
            HWND    hwndDriveCnr = WinWindowFromID(hwndDlg, ID_WIDI_DRIVECNR);
            ULONG   ul;
            double  dTotalFree = 0;
            // PFIELDINFO  pFieldInfoFirst;
                        // pFieldInfo2;
            PDRIVERECORD precc;
            PSZ     pszTitle;

            // setup the container
            BEGIN_CNRINFO()
            {
                cnrhSetView(CV_DETAIL | CA_DETAILSVIEWTITLES);
            } END_CNRINFO(hwndDriveCnr);

            // set up data for Details view columns
            XFIELDINFO      xfi[3];

            xfi[0].ulFieldOffset = FIELDOFFSET(RECORDCORE, pszIcon);
            xfi[0].pszColumnTitle = nlsGetString(WPSI_DRIVE);
            xfi[0].ulDataType = CFA_STRING;
            xfi[0].ulOrientation = CFA_LEFT;

            xfi[1].ulFieldOffset = FIELDOFFSET(DRIVERECORD, pszFree);
            xfi[1].pszColumnTitle = nlsGetString(WPSI_FREEKB);
            xfi[1].ulDataType = CFA_STRING;
            xfi[1].ulOrientation = CFA_RIGHT;

            xfi[2].ulFieldOffset = FIELDOFFSET(DRIVERECORD, pszRequired);
            xfi[2].pszColumnTitle = nlsGetString(WPSI_REQUIREDKB);
            xfi[2].ulDataType = CFA_STRING;
            xfi[2].ulOrientation = CFA_RIGHT;

            PFIELDINFO pFieldInfoLast
                = cnrhSetFieldInfos(hwndDriveCnr,
                                    &xfi[0],
                                    (sizeof(xfi) / sizeof(XFIELDINFO)),   // array item count
                                    TRUE,          // draw lines
                                    0);            // column index to return

            // now insert the record cores

            doshEnumDrives(G_szAllDrives,
                           NULL, // all filesystems
                           TRUE); // skip removeable drives
            G_cDrives = strlen(G_szAllDrives);

            for (ul = 0;
                 ul <= G_cDrives;   // drives count + 1; the last one is total
                 ul++)
            {
                FSALLOCATE  fsa;
                precc = (PDRIVERECORD)cnrhAllocRecords(hwndDriveCnr,
                                                       sizeof(DRIVERECORD),
                                                       1);
                pszTitle = (PSZ)malloc(100);
                if (ul < G_cDrives)
                {
                    sprintf(pszTitle, "%c:", G_szAllDrives[ul]);
                    // precc->ulDrive = ul + 3; // start with drive C:
                    // bullshit, fixed V0.9.12 (2001-05-31) [umoeller]
                    precc->ulDrive = G_szAllDrives[ul] + 1 - 'A';
                    DosQueryFSInfo(precc->ulDrive, FSIL_ALLOC, &fsa, sizeof(fsa));
                    precc->dFree = ((((double)fsa.cSectorUnit) * fsa.cbSector * fsa.cUnitAvail)
                                    + 512)
                                    / 1024;
                    dTotalFree += precc->dFree;
                }
                else
                {
                    precc->ulDrive = 0;     // total entry has drive no. 0
                    sprintf(pszTitle, "Total:");
                    precc->dFree = dTotalFree;
                }

                // setup strings
                nlsThousandsDouble(precc->szFree,
                                   precc->dFree,
                                   G_szThousand[0]);
                precc->pszFree = precc->szFree;

                precc->dRequired = 0;

                cnrhInsertRecords(hwndDriveCnr,
                                  (PRECORDCORE)NULL,
                                  (PRECORDCORE)precc,
                                  TRUE,
                                  pszTitle,
                                  CRA_RECORDREADONLY,
                                  1);
            }
        }
        break;

        /*
         * WPIM_UPDATE:
         *      this is posted whenever the drive display needs
         *      to be updated, e.g. when the user enters a different
         *      target path for a package.
         *      Parameters:
         *          BOOL mp1    if TRUE, the window will be updated
         *                      and shown and a timer will be started;
         *                      if FALSE, the window will be hidden
         *                      and the timer will be stopped.
         */

        case WPIM_UPDATE:
        {
            HWND hwndDriveCnr = WinWindowFromID(hwndDlg, ID_WIDI_DRIVECNR);
            HWND hwndClient,
                 hwndPackagesCnr;

            static ULONG    idTimerRunning = 0;

            if (    (mp1)
                 && (hwndClient = WinWindowFromID(G_hwndMainFrame, FID_CLIENT))
                 && (hwndPackagesCnr = WinWindowFromID(hwndClient, ID_WIDI_PACKAGESCNR))
               )
            {
                // show window:
                PDRIVERECORD precc = NULL;
                ULONG   ulDrive = 3,
                        ul;
                double dTotalSize = 0;

                memset(G_pDrvReccsInvalid, 0, sizeof(G_pDrvReccsInvalid));

                for (ul = 0;
                     ul < sizeof(G_adSpaceRequired) / sizeof(G_adSpaceRequired[0]);
                     ul++)
                    G_adSpaceRequired[ul] = 0;

                // go thru the cnr in the main window
                // and update drive/size array
                cnrhForAllRecords(hwndPackagesCnr,
                                  NULL,     // start at root
                                  fncbreccSumUpSize,
                                  0, 0);
                    // the items in G_adSpaceRequired have the
                    // proper required space per drive now

                // now update the drives window with the
                // new required disk space per drive by
                // going over all the record cores

                // reset the global warning flag
                G_WpiGlobals.fPlentyOfSpace = TRUE;
                do {
                    precc =
                        (PDRIVERECORD)WinSendMsg(hwndDriveCnr,
                                                 CM_QUERYRECORD,
                                                 (MPARAM)precc,
                                                 MPFROM2SHORT(((precc == NULL)
                                                                 ? CMA_FIRST
                                                                 : CMA_NEXT),
                                                              CMA_ITEMORDER)
                                                 );
                    if ((LONG)precc == -1)
                        precc = NULL;
                    if (precc)
                    {
                        if (precc->ulDrive)
                        {
                            precc->dRequired = G_adSpaceRequired[ulDrive];
                            dTotalSize += G_adSpaceRequired[ulDrive];
                        }
                        else
                            // "Total" entry
                            precc->dRequired = dTotalSize;

                        // setup strings
                        nlsThousandsDouble(precc->szRequired,
                                           precc->dRequired,
                                           G_szThousand[0]);
                        precc->pszRequired = precc->szRequired;

                        // if the required space on a drive
                        // exceeds the available space, draw
                        // the drive with "picked" emphasis
                        if (precc->dRequired > precc->dFree)
                        {
                            // not enough space:
                            G_WpiGlobals.fPlentyOfSpace = FALSE;
                            precc->recc.flRecordAttr |= CRA_SELECTED; // CRA_PICKED;
                            G_pDrvReccsInvalid[ulDrive] = precc;
                        }
                        else
                        {
                            precc->recc.flRecordAttr &= ~CRA_SELECTED; // CRA_PICKED;
                            G_pDrvReccsInvalid[ulDrive] = 0;
                        }
                    }

                    ulDrive++;
                } while (precc);

                WinSendMsg(hwndDriveCnr,
                           CM_INVALIDATERECORD,
                           (MPARAM)NULL,       // all records
                           MPFROM2SHORT(0, CMA_ERASE));

                WinShowWindow(hwndDlg, TRUE);

                if (idTimerRunning == 0)
                    idTimerRunning = WinStartTimer(pEngine->_Locals._habThread1,
                                                   hwndDlg,
                                                   2, 400);
            }
            else
            {
                // hide window:
                if (idTimerRunning)
                {
                    WinStopTimer(pEngine->_Locals._habThread1, hwndDlg, 2);
                    idTimerRunning = 0;
                }

                WinShowWindow(hwndDlg, FALSE);
            }
        }
        break;

        /*
         * WM_TIMER:
         *
         */

        case WM_TIMER:
        {
            HWND hwndDriveCnr = WinWindowFromID(hwndDlg, ID_WIDI_DRIVECNR);
            ULONG ul;

            for (ul = 0; ul < 28; ul++)
            {
                if (G_pDrvReccsInvalid[ul])
                {
                    G_pDrvReccsInvalid[ul]->recc.flRecordAttr ^= CRA_SELECTED; // XOR
                    WinSendMsg(hwndDriveCnr,
                               CM_SETRECORDEMPHASIS,
                               (MPARAM)G_pDrvReccsInvalid[ul],
                               MPFROM2SHORT(!((G_pDrvReccsInvalid[ul]->recc.flRecordAttr & CRA_SELECTED) != 0),
                                            CRA_SELECTED));
                }
            }
        }
        break;

        default:
            mrc = WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    }

    return (mrc);
}


