
/*
 *@@sourcefile fe_package_arc.cpp:
 *      this implements the "archive package" classes
 *      (FEArcPackageBase and the two subclasses
 *      FEArcPackagePck and FEArcPackageGroup).
 *
 *      This has been separated from fe_package.cpp to reduce
 *      source code dependencies and speed up compile times.
 *
 *@@added V0.9.1 (2000-02-08) [umoeller]
 *@@header "engine\fe_package_arc.h"
 */

/*
 *      This file Copyright (C) 1999-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define OS2EMX_PLAIN_CHAR
    // this is needed for "os2emx.h"; if this is defined,
    // emx will define PSZ as _signed_ char, otherwise
    // as unsigned char

#define INCL_WINSHELLDATA
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <limits.h>
#include <time.h>               // needed for WIFileHeader

#include "setup.h"

// include's from helpers
#include "helpers\configsys.h"
#include "helpers\nls.h"
#include "helpers\stringh.h"
#include "helpers\xstring.h"

// base includes (99-11-07) [umoeller]
#include "base\bs_base.h"
#include "base\bs_list.h"
#include "base\bs_string.h"
#include "base\bs_errors.h"

#include "base\bs_logger.h"
#include "base\bs_config.h"
#include "base\bs_config_impl.h"

// back-end includes
#include "wiarchive\wiarchive.h"

// front-end includes
#include "engine\fe_base.h"

#include "engine\fe_script.h"

#include "engine\fe_package.h"
#include "engine\fe_package_arc.h"
#include "engine\fe_archive.h"
#include "engine\fe_package_db.h"
#include "engine\fe_database.h"

#pragma hdrstop

DEFINE_CLASS(FEArcPackageBase, FEPackageBase);
DEFINE_CLASS(FEArcPackagePck, FEArcPackageBase);
DEFINE_CLASS(FEArcPackageGroup, FEArcPackageBase);

/* ******************************************************************
 *
 *  FEArcPackageBase implementation
 *
 ********************************************************************/

/*
 *@@ FEArcPackageBase:
 *      protected default constructor.
 *
 *      This is only to be used by descendants.
 *
 *      Throws:
 *      -- FEConstructorExcpt.
 */

FEArcPackageBase::FEArcPackageBase(FEArchive &Archive,
                                   FEArcPackageGroup *pGroup,
                                   FEPckDeclBase &Decl,
                                   BSClassID &Class)
    : FEPackageBase(&Decl, Class),
      _Archive(Archive)
{
    _pGroup = pGroup;
    _ulSizeRounded = 0;

    if (_pGroup)
        // group specified: store ourselves in the group's member list
        _pGroup->_GroupMembersList.push_back(this);
}

/* ******************************************************************
 *
 *  FEArcPackagePck implementation
 *
 ********************************************************************/

/*
 *@@ FEArcPackagePck:
 *      constructor for creating an FEArcPackagePck
 *      from an archive.
 *
 *      This constructor is used by FEArchive::CreatePackages
 *      to create packages filled with the data from
 *      the install script.
 *
 *      This is the only constructor for this class,
 *      so there's no way to create archive packages
 *      other than thru install scripts.
 *
 *@@changed V0.9.9 (2001-02-28) [umoeller]: added callback param
 */

FEArcPackagePck::FEArcPackagePck(FEArchive &Archive,    // in: "parent" archive; must be valid!
                                 FEArcPackageGroup *pGroup,  // in: "parent" group; can be NULL
                                 FEPckDeclBase &Decl)
                 : FEArcPackageBase(Archive,
                                    pGroup,
                                    Decl,
                                    tFEArcPackagePck),
                   // create FEPackageID for this immediately
                   // V0.9.18 (2002-02-06) [umoeller]
                   _PckID(Archive._Locals,
                          Decl._ustrID,
                          __FILE__, __LINE__,
                          FALSE)        // no short format
{
    // look up the package in the archive
    // V0.9.14 (2001-07-26) [umoeller]
    WIPackHeader *pPackHeader;
    if (!(pPackHeader = _Archive.FindPackHeader(Decl._ulIndexInArchive)))
    {
        // doesn't exist in archive:
        ustring str;
        str._itoa10( _pDecl->_ulIndexInArchive, Archive._Locals._cThousands);
        throw FEFatalErrorExcpt(_Archive._Locals,
                                203,            // invalid package index
                                &str,
                                1);
    }

    // copy package header from WIArchive
    memcpy(&_PackHeader, pPackHeader, sizeof(*pPackHeader));

    // convert package size to KByte
    _ulSizeRounded = (pPackHeader->origsize + 512) / 1024;

}

/*
 *@@ Unpack:
 *      simple wrapper around WIArchive::unpack. This
 *      unpacks all files in the package and does
 *      not return until all files have been unpacked
 *      or a fatal error occured.
 *
 *      Gets called by FEInstallJob::Unpack, which in
 *      turn gets called on the WarpIN install thread.
 *
 *      This produces tons of calls to the callback that
 *      was specified with the FEArcPackagePck constructor.
 *
 *@@added V0.9.9 (2001-02-28) [umoeller]
 *@@changed V0.9.14 (2001-07-26) [umoeller]: added pWICallback and param
 */

VOID FEArcPackagePck::Unpack(PFNWICALLBACK pWICallback,     // in: callback to use
                             void *pvUser)                  // in: user param for callback
{
    _Archive._Arc.setCallbackFunc(pWICallback,
                                  pvUser);
    _Archive._Arc.unpack(_PackHeader.number);
}

/*
 *@@ AddFileHeader:
 *      this appends the given WIFileHeader to
 *      the pszFilesList member. This is used while
 *      files are being unpacked to create a files
 *      list which can later be stored in the database.
 *
 *      This function updates pszFilesList and
 *      cbFilesList in pPckInfo. With each call,
 *      the buffer that pszFilesList points to
 *      is reallocated.
 *
 *      The format of each entry in pszFilesList is as follows:
 *
 +          CHAR[x]   BYTE time_t  time_t  ULONG    BYTE
 +          filename   0   writedt creatdt filesize  0
 +                                         (uncompressed)
 *      All file entries are simply stored in sequential
 *      order.
 *
 *      <B>Preconditions:</B>
 *
 *      If this is the first call, pszFilesList and
 *      cbFilesList in pPckInfo must be 0.
 *      No check is made for whether the given file
 *      is already in the list.
 *
 *@@changed V0.9.0 (99-10-26) [umoeller]: this used to be datAddFileHeader; made this a FEPackage method
 *@@changed V0.9.20 (2002-07-22) [umoeller]: optimized
 */

VOID FEArcPackagePck::AddFileHeader(WIFileHeader* pwifh)
{
    ULONG   cbFilesListOld = _cbFilesList;
    ULONG   cbFilename = strlen(pwifh->name);

    _cbFilesList +=   cbFilename
                    + (2 * sizeof(time_t))
                    + sizeof(ULONG)
                    + 2;
                        // two null bytes

    // PSZ pszTemp = _pszFilesList;
    // _pszFilesList = (PSZ)malloc(_cbFilesList);

    // optimized V0.9.20 (2002-07-22) [umoeller]
    _pszFilesList = (PSZ)realloc(_pszFilesList,
                                 _cbFilesList);

    PSZ pTarget = _pszFilesList + cbFilesListOld;

    /*
    if (pszTemp)
    {
        // not first call:
        // copy old file list
        memcpy(_pszFilesList, pszTemp, cbFilesListOld);
        // append new file name
        free(pszTemp);
    }
    */

    memcpy(pTarget,       // optimized V0.9.20 (2002-07-22) [umoeller]
           pwifh->name,
           cbFilename + 1);
    pTarget += cbFilename + 1;
    memcpy(pTarget, &pwifh->lastwrite, sizeof(pwifh->lastwrite));
    pTarget += sizeof(pwifh->lastwrite);        // with VAC++, this is a long
    memcpy(pTarget, &pwifh->creation, sizeof(pwifh->creation));
    pTarget += sizeof(pwifh->creation);        // with VAC++, this is a long
    memcpy(pTarget, &pwifh->origsize, sizeof(pwifh->origsize));
    pTarget += sizeof(pwifh->origsize);

    *pTarget = '\0';
}

/*
 *@@ Store:
 *      gets called by FEInstallJob::Store to store
 *      the constant package data into the database.
 *
 *@@added V0.9.18 (2002-02-06) [umoeller]
 *@@changed V0.9.20 (2002-07-22) [umoeller]: added created directories
 */

BOOL FEArcPackagePck::Store(HINI hiniDB,
                            PCSZ pcszIDSix)
{
    // write files list which was set by the
    // Install thread
    BOOL brc = PrfWriteProfileData(hiniDB,
                                   pcszIDSix,
                                   WPIKEY_FILESLIST,
                                   _pszFilesList,
                                   _cbFilesList);

    _logRequiresIDs.Store(hiniDB,
                          pcszIDSix,
                          WPIKEY_REQUIRES);

    _pDecl->_logCfgSysAttrs.Store(hiniDB,
                                  pcszIDSix,
                                  WPIKEY_CONFIGATTRS);
    _logCfgSysDone.Store(hiniDB,
                         pcszIDSix,
                         WPIKEY_CONFIGDONE);

    _pDecl->_logRegisterClassAttrs.Store(hiniDB,
                                         pcszIDSix,
                                         WPIKEY_REGISTERATTRS);
    _logRegisterClassesDone.Store(hiniDB,
                                  pcszIDSix,
                                  WPIKEY_REGISTERDONE);

    _pDecl->_logReplaceClassAttrs.Store(hiniDB,
                                        pcszIDSix,
                                        WPIKEY_REPLACEATTRS);
    _logReplaceClassDone.Store(hiniDB,
                               pcszIDSix,
                               WPIKEY_REPLACEDONE);

    _pDecl->_logWPSObjectAttrs.Store(hiniDB,
                                     pcszIDSix,
                                     WPIKEY_WPSOBJECTATTRS);
    _logWPSObjectsDone.Store(hiniDB,
                             pcszIDSix,
                             WPIKEY_WPSOBJECTDONE);

    _pDecl->_logClearPrfAttrs.Store(hiniDB,
                                    pcszIDSix,
                                    WPIKEY_CLEARPRFATTRS);
    _pDecl->_logWritePrfAttrs.Store(hiniDB,
                                    pcszIDSix,
                                    WPIKEY_WRITEPRFATTRS);
    _logWritePrfsDone.Store(hiniDB,
                            pcszIDSix,
                            WPIKEY_WRITEPRFDONE);

    _pDecl->_logExecuteAttrs.Store(hiniDB,
                                   pcszIDSix,
                                   WPIKEY_EXECUTEATTRS);
    _logExecutesDone.Store(hiniDB,
                           pcszIDSix,
                           WPIKEY_EXECUTEDONE);

    _pDecl->_logDeExecuteAttrs.Store(hiniDB,
                                     pcszIDSix,
                                     WPIKEY_DEEXECUTEATTRS);
    _logDeExecutesResolved.Store(hiniDB,
                                 pcszIDSix,
                                 WPIKEY_DEEXECUTERESOLVED);

    _pDecl->_logKillProcessAttrs.Store(hiniDB,
                                       pcszIDSix,
                                       WPIKEY_KILLPROCESSATTRS);

    PrfWriteProfileData(hiniDB,
                        pcszIDSix,
                        WPIKEY_WIPACKHEADER,
                        (PVOID)&_PackHeader,
                        sizeof(_PackHeader));

    // store codepage V0.9.2 (2000-03-11) [umoeller]
    // CHAR szCodepage[20];
    // sprintf(szCodepage, "%u", QueryCodepage());
    // null existing codepage string, if any; we now
    // always store in utf-8
    // V0.9.18 (2002-03-08) [umoeller]
    PrfWriteProfileString(hiniDB,
                          pcszIDSix,
                          WPIKEY_CODEPAGE,
                          NULL);

    // store directories that were created
    // V0.9.20 (2002-07-22) [umoeller]
    _logDirsCreated.Store(hiniDB,
                          pcszIDSix,
                          WPIKEY_DIRSCREATED);

    return TRUE;
}

/* ******************************************************************
 *
 *  FEArcPackageGroup implementation
 *
 ********************************************************************/

/*
 *@@ FEArcPackageGroup:
 *      constructor.
 */

FEArcPackageGroup::FEArcPackageGroup(FEArchive &Archive,       // in: archive we're being created from
                                     FEArcPackageGroup *pGroup, // in: group this group belongs to or NULL if none
                                     FEGroupDecl &Decl)
                   : FEArcPackageBase(Archive,
                                      pGroup,
                                      Decl,
                                      tFEArcPackageGroup),
                                      // mark as group:
                                      // PCK_GROUP),
                     _GroupMembersList(SHADOW)
                            // fixed V0.9.15 (2001-08-26) [umoeller]:
                            // list must be in SHADOW mode
{
    _pDecl->_Type = GROUP;
}


