/*
 * mlu.hpp:
 *      header file for mlu.cpp.
 *
 *@@include <map>
 *@@include "base\bs_string.h"
 *@@include "wipengine\interface.hpp"
 *@@include "helpers\stringh.h"
 *@@include "helpers\xstring.h"
 *@@include "wipengine\threadbase.h"
 */

/*
 *      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef _MLU_H_
#define _MLU_H_


/*
 * Detailed message information.
 */
#define DETAIL_MSG_NONE                     0
#define DETAIL_MSG_ARCUNIT_INITIALIZED      1
#define DETAIL_MSG_ARCUNIT_ARC_OPENING_FAILED 2

/*
 * Status indicators.
 */
#define STATUS_MSG_SUCCESSFULL              "Successfull"
#define STATUS_MSG_FAIL                     "Fail"


/*
 *Message types:
 */
#define TYPE_MSG_NONE                       0
#define TYPE_MSG_INFORMATIVE                1
#define TYPE_MSG_WARNING                    2
#define TYPE_MSG_ERROR                      3
#define TYPE_MSG_CRITICAL                   4


/*
 *Return values:
 */
#define RET_ERR_MLU_CALLBACK_NOT_DEFINED    RET_BASE_MLU + 0
#define RET_ERR_MLU_THREAD_CREATION_FAILED  RET_BASE_MLU + 1
#define RET_ERR_MSG_NOT_FOUND               RET_BASE_MLU + 2

/*
 *Queue messages:
 */
#define QUE_MSG_QUIT                        1
#define QUE_MSG_LOG                         2
#define QUE_MSG_DELETE                      3
#define QUE_MSG_FIND                        4


/*
 *Call-back types:
 */
#define CB_TYPE_MLU_LOGGING_COMPLETED       CB_BASE_MLU + 1
#define CB_TYPE_MLU_FINDING_COMPLETED       CB_BASE_MLU + 2
#define CB_TYPE_MLU_DELETION_COMPLETED      CB_BASE_MLU + 3
#define CB_TYPE_MLU_QUIT_COMPLETED          CB_BASE_MLU + 4



/*
 *@@MsgClass:
 *  generic class for messages. Contains information about message data itself,
 *  it's type and sender thread id.
 */
class MsgClass {
    public:
    AID             _aidSender; // Archive id of sender.
    BSString        _bssMessage; // A string for message text.
    USHORT          _usMessageType; // Type of message.
    LONG            _lDetailInfo; // Detailed information.

    // Message type enumeration.
    enum            eMsgTypes {eNone, eInformative, eWarning, eError, eCritical};

    MsgClass() {
        _bssMessage = "";
        _usMessageType = TYPE_MSG_NONE;
        _lDetailInfo = DETAIL_MSG_NONE;
        _aidSender = 0;
        };
    MsgClass(const MsgClass &p_msg) {
        _aidSender = p_msg._aidSender;
        _bssMessage = p_msg._bssMessage;
        _usMessageType = p_msg._usMessageType;
        _lDetailInfo = p_msg._lDetailInfo;

        }
    MsgClass &operator=(const MsgClass &p_msg) {
        _aidSender = p_msg._aidSender;
        _bssMessage = p_msg._bssMessage;
        _usMessageType = p_msg._usMessageType;
        _lDetailInfo = p_msg._lDetailInfo;
        return *this;
        }

    int compare(const MsgClass &) const;

    };

int operator==(const MsgClass &, const MsgClass &);

int operator<(const MsgClass &, const MsgClass &);

int operator<=(const MsgClass &, const MsgClass &);

int operator!=(const MsgClass &, const MsgClass &);

int operator>(const MsgClass &, const MsgClass &);

int operator>=(const MsgClass &, const MsgClass &);


/*
 *@@MessageMap:
 *  typedef for a MsgClass multimap.
 */
typedef multimap<AID, // key class
                MsgClass, // data class
                less<AID> // comparsion method
                > MessageMap;

/*
 *@@MessageVector:
 *  typedef for message vector.
 */
typedef vector<MsgClass> MessageVector;

/*
 * Default callback function.
 */
LONG mluDefaultCallBack(SHORT p_sCBType, LONG, PVOID p_pData, PVOID);

/*
 *@@MsgLoggingUnit:
 *  this class is responsible for storing messages. In the Start
 *  function a thread is created which starts to wait messages.
 */
class MsgLoggingUnit: public ThreadBase {
    public:
    HQUEUE          _hQReceiver; // Message queue for receiving.
    // Enumerated message priorities.
    enum            eMsgPriority {eLowest = QUE_MSG_PRIORITY_LOWEST,
                                  eLower = QUE_MSG_PRIORITY_LOWER,
                                  eNormal = QUE_MSG_PRIORITY_NORMAL,
                                  eHigher = QUE_MSG_PRIORITY_HIGHER,
                                  eHighest = QUE_MSG_PRIORITY_HIGHEST};

    private:
    HEV             _hevSemInit; // For initialization syncronization.
    HMTX            _mtxSemHMap; // For coordination of _Messages usage.
    PFNWIPECALLBACK _pfnWipeCallBack; // A call-back for informing the engine interface.
    PVOID           _pUserData; // A pointer to a user data. This pointer is used as a
                                // one of the parameters of the call-back function.
    MessageMap      _Messages; // Multimap styled container for messages.

    public:
    /*
     *Constructors for MsgLoggingUnit class.
     */
    MsgLoggingUnit() {
        _pfnWipeCallBack = &mluDefaultCallBack;
        _pUserData = NULL;
        _hQReceiver = NULLHANDLE;
        _hevSemInit = NULLHANDLE;
        InitSemaphores();
        }
    MsgLoggingUnit(PFNWIPECALLBACK p_pfnWipeCallBack, PVOID p_pUserData) {
        // If user provides to us an callback, use it.
        if (p_pfnWipeCallBack)
            _pfnWipeCallBack = p_pfnWipeCallBack;
        // Otherwice use our own default one.
        else
            _pfnWipeCallBack = &mluDefaultCallBack;

        _pUserData = p_pUserData;
        _hQReceiver = NULLHANDLE;
        _hevSemInit = NULLHANDLE;
        InitSemaphores();
        }
    void SetCallBackData(PFNWIPECALLBACK p_pfnWipeCallBack, PVOID p_pUserData) {
        // If user provides to us an callback, use it.
        if (p_pfnWipeCallBack)
            _pfnWipeCallBack = p_pfnWipeCallBack;
        // Otherwice use our own default one.
        else
            _pfnWipeCallBack = &mluDefaultCallBack;
        _pUserData = p_pUserData;
        }
    ~MsgLoggingUnit();

    USHORT Start(VOID);

    // Interface functions. These functions should be used when the user
    // wants to log, find or delete messages.
    static USHORT LogMessage(AID, BSString &, USHORT,
                             LONG, HQUEUE, HEV = NULLHANDLE,
                             eMsgPriority = eNormal);
    static USHORT FindMessage(AID, MessageVector *, HQUEUE,
                              HEV = NULLHANDLE,
                              eMsgPriority = eNormal);
    static USHORT DeleteMessage(AID, HQUEUE, HEV = NULLHANDLE,
                                eMsgPriority = eNormal);

    private:
    USHORT LogMessage(MsgClass &, const AID);
    USHORT FindMessages(MessageVector &, AID);
    USHORT DeleteMessages(AID);
    VOID _ThdFunction();
    VOID InitSemaphores(VOID);
    };


#endif

