/*
 * fdu.h:
 *      header file for fdu.cpp.
 *
 *@@include <deque>
 *@@include <vector>
 *@@include "helpers\stringh.h"
 *@@include "helpers\xstring.h"
 *@@include "base\bs_string.h"
 */

/*
 *      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef _FDU_H_
#define _FDU_H_


/*
 *Return values:
 */
#define RET_ERR_NOT_FOUND               RET_BASE_FDU + 0
#define RET_ERR_PARAM_ERROR             RET_BASE_FDU + 1


/*
 *@@FileClass:
 *  a class for file related information.
 */
class FileClass {
    public:
    // Describes whether the file is inside an archive file or
    // is located in disk.
    BOOL        _bArchived;

    BSString    _bssFileName;
    BSString    _bssFilePath;
    BSString    _bssInstallPath;

    SHORT       _sCmprsMethod;  // Compress method used.
    LONG        _lOrigSize;     // Size of file (original)
    LONG        _lCompSize;     // Size of file (compressed)
    SHORT       _sPackage;     // Package id the file belongs to.

    FileClass() {};

    // p_bArchived should not used outside wipengine classes.
    FileClass(BSString p_bssFileName, BSString p_bssFilePath,
              BSString p_bssInstallPath, SHORT p_sPackage,
              BOOL p_bArchived = FALSE) {
        _bssFileName = p_bssFileName;
        _bssFilePath = p_bssFilePath;
        _bssInstallPath = p_bssInstallPath;
        _bArchived = p_bArchived;
        _sPackage = p_sPackage;
        }

    int compare(const FileClass &) const;
    };

int operator==(const FileClass &, const FileClass &);

int operator<(const FileClass &, const FileClass &);

int operator<=(const FileClass &, const FileClass &);

int operator!=(const FileClass &, const FileClass &);

int operator>(const FileClass &, const FileClass &);

int operator>=(const FileClass &, const FileClass &);


/*
 *@@
 *  typedef for a FileClass deque.
 */
typedef deque<FileClass // data class
             > FileDeque;

/*
 *@@FileVector:
 *  typedef for file vector.
 */
typedef vector<FileClass> FileVector;


class FileDatabaseUnit {
    public:
    FileDeque   _Files;
    public:
    FileDatabaseUnit() {}
    FileDatabaseUnit(ULONG p_ulDefSize) {
        _Files.resize(p_ulDefSize);
        }
    ~FileDatabaseUnit() {
        }

    USHORT InsertFile(const FileClass &);
    USHORT InsertFiles(const FileVector &);
    USHORT DeleteFile(const FileClass &);
    USHORT DeleteFile(ULONG);
    USHORT ReplaceFile(const FileClass &, const FileClass &);
    USHORT ReplaceFile(ULONG, const FileClass &);
    USHORT QueryFiles(FileVector &);
    USHORT QueryFile(ULONG, FileClass &);
    ULONG ReturnFileCount() {
        return _Files.size();
        }
    };




#endif


