/*
 * arcunit.hpp:
 *      header file for arcunit.cpp.
 *
 *@@include <map>
 *@@include "helpers\stringh.h"
 *@@include "helpers\xstring.h"
 *@@include "base\bs_string.h"
 *@@include "wipengine\wipebase.h"
 *@@include "wipengine\fdu.h"
 *@@include "wipengine\arcsubsys.h"
 */

/*
 *      Copyright (C) 2000-2001 Teemu Ahola.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef _ARCUNIT_H_
#define _ARCUNIT_H_

/*
 *Return values:
 */
#define RET_ERR_ASS_START_FAILED        RET_BASE_ARC_UNIT + 0
#define RET_ERR_ASS_NOT_FOUND           RET_BASE_ARC_UNIT + 1

/*
 *@@UserDataMap:
 *  typedef for a user data map.
 */
typedef map<AID, // key class
            PVOID, // data class
            less<AID> // comparsion method
            > UserDataPtrMap;


class ArchiveUnit {
    private:
    HQUEUE              _hQMessageLogger; // MLU's message queue handler.
    PFNWIPECALLBACK     _pfnWipeCallBack; // A call-back for the archive unit.
    PVOID               _pvUserData; // A pointer to a user data. This pointer is used as
                                     // a one of the parameters of the call-back function.
    ArcSubSystemPtrMap  _assPtrMap; // A map of pointers to archive subsystems. The key
                                    // value is AID (Archive Identifier).

    public:
    UserDataPtrMap      _userDataPtrMap;
    ArchiveUnit(HQUEUE, PFNWIPECALLBACK, PVOID);
    ~ArchiveUnit();

    ULONG               _ulArcSubSysRc; // Is set by the call-back function if an error
                                        // has been occurred during initialization of
                                        // an archive subsystem. Must be public since
                                        // the call-back needs access to this attribute.

    // Member functions for general archive handling.
    AID CreateArchive(BSString, PVOID);
    USHORT DeleteArchive(AID);
    AID OpenArchive(BSString);
    HQUEUE ReturnQueueHdlr(AID);


    // Archive subsystem handling functions.
    // File handling functions.
    USHORT AddFiles(AID , FileVector *, HEV = NULLHANDLE);
    USHORT QueryFiles(AID , FileVector *, HEV = NULLHANDLE);
    USHORT DeleteFiles(AID , FileVector *, HEV = NULLHANDLE);

    // Script handling functions.

    };

#endif
