

#ifndef _GUI_TRAD_ARC_THREAD_H_
#define _GUI_TRAD_ARC_THREAD_H_


#define USER_ARCTM_INIT_ARC                 WM_USER + 2000
#define USER_ARCTM_SET_PCK                  WM_USER + 2001
#define USER_ARCTM_ADD_FILE                 WM_USER + 2002
#define USER_ARCTM_FILE_PRECENTAGE          WM_USER + 2003
#define USER_ARCTM_THREADY                  WM_USER + 2004
#define USER_ARCTM_COMPRESS                 WM_USER + 2005
#define USER_ARCTM_FILE_UPDATING            WM_USER + 2006
#define USER_ARCTM_SET_SCRIPT               WM_USER + 2007
#define USER_ARCTM_DONE                     WM_USER + 2008



/* TradArcThreadInfo
 *  Structure for archive thread.
 */
struct TradArcThreadInfo
    {
        // Initialized by the main thread
    HWND            hwndMainWnd;
    HWND            hwndStatusDlg;
    BOOL            bKillThread;
    HEV             hevMainReady;
    HEV             hevStatusDlgReady;
        // Initialized by the thread itself
                // Is TRUE when the thread is finished its initialization
    BOOL            bThreadInitialized;
                // Is TRUE when the thread is killed itself
    BOOL            bThreadKilled;
                // Is TRUE while the thread is processing message
    BOOL            bThreadBusy;
                // If error occurred during message processing this is != 0
    USHORT          usThreadError;
    PSZ             pszArchiveFileName;
    list<DBPackage*> listPackages;
    ScriptWarpIN    *pWarpIN;

    TradArcThreadInfo()
        : listPackages(SHADOW)
        {
        hevMainReady = 0;
        hevStatusDlgReady = 0;
        hwndMainWnd = NULLHANDLE;
        bKillThread = FALSE;
        hwndStatusDlg = NULLHANDLE;
        bThreadInitialized = FALSE;
        bThreadKilled = FALSE;
        bThreadBusy = FALSE;
        usThreadError = FALSE;
        pWarpIN = NULL;
        pszArchiveFileName = NULL;
        }

    };


VOID _Optlink thTradArcThread (PVOID pThreadArg);



#endif
