/*
 *              WicPM - WarpIN Archive Creator for PM
 *                  (c) Copyright Teemu Ahola 2000
 *
 *              WarpIN Script Class 0.9.5
 *
 *@@script.hpp
 *  Header file for script.cpp.
 *  This file contains class headers for script classes.
 *
 *
 */



#ifndef _SCRIPT_HPP
#define _SCRIPT_HPP

#define MAXCHILDREN                                     20

#define MAXAPPNAMELENGTH                                64
#define MAXVENDORNAMELENGTH                             64
#define MAXPCKNAMELENGTH                                32
#define MAXINETADDRESSLENGTH                            128
#define MAXVERSIONLENGTH                                10
#define MAXTITLELENGTH                                  128
#define MAXSTATEMENTLENGTH                              128
#define MAXSEARCHSTRINGLENGTH                           128
#define MAXCLASSNAMELENGTH                              256
#define MAXCLASSTITLELENGTH                             256
#define MAXCLASSCONFIGLENGTH                            256
#define MAXSCRIPTLENGTH                                 4096
#define MAXSCRIPTLINELENGTH                             256
#define MAXSCRIPTSTRINGLENGTH                           256
#define MAXPROFILEAPPLICATIONLENGTH                     256
#define MAXPROFILEKEYLENGTH                             256
#define MAXPAGETEXTLENGTH                               1024
#define MAXPAGETITLELENGTH                              256
#define MAXNEXTBTNTEXTLENGTH                            256
#define MAXMESSAGELENGTH                                256
#define MAXOPERATIGSYSTEMLENGTH                         64
#define MAXTARGETLENGTH                                 256
#define MAXTAGLENGTH                                    256
#define MAXATTRIBUTELENGTH                              256

// Keyword attributes.
#define KEYWORD_BASE                                    1
#define KEYWORD_FIXED                                   2
#define KEYWORD_SELECT                                  4
#define KEYWORD_NODESELECT                              8

// ConfigSys modifiers.
#define MODIFIER_NONE                                   0
#define MODIFIER_UNIQUE                                 1
#define MODIFIER_ADDRIGHT                               2
#define MODIFIER_ADDLEFT                                4
#define MODIFIER_ADDTOP                                 8
#define MODIFIER_ADDAFTER                               16
#define MODIFIER_ADDBEFORE                              32
#define MODIFIER_REMOVELINE                             64
#define MODIFIER_REMOVEPART                             128

// Execute context flags
#define FLAG_NOCONTEXT                                  0
#define FLAG_CONFIGSYS                                  1
#define FLAG_REGISTERCLASS                              2
#define FLAG_CREATEOBJECT                               3

// ReadMe formats.
#define README_FORMAT_NONE                              0
#define README_FORMAT_PLAIN                             1
#define README_FORMAT_FLOW                              2
#define README_FORMAT_HTML                              3

// Page types.
#define PAGE_TYPES_TEXT                                 0
#define PAGE_TYPES_README                               1
#define PAGE_TYPES_CONTAINER                            2
#define PAGE_TYPES_CONFIGURE                            3

// Operating system
#define OS_OS2_2X                                       0
#define OS_OS2_3X                                       1
#define OS_OS2_4X                                       2


// Error codes
#define NO_ERROR                                        0
#define STRING_TOO_LONG                                 1
#define MEM_ALLOC_ERROR                                 2

    // Configsys error codes
#define ERR_CONFIGSYS_ADDRIGHT_SETTED                   1
#define ERR_CONFIGSYS_ADDLEFT_SETTED                    2
#define ERR_CONFIGSYS_UNIQUE_SETTED                     4
#define ERR_CONFIGSYS_ADDTOP_SETTED                     8
#define ERR_CONFIGSYS_ADDAFTER_SETTED                   16
#define ERR_CONFIGSYS_ADDBEFORE_SETTED                  32
#define ERR_CONFIGSYS_REMOVELINE_SETTED                 64
#define ERR_CONFIGSYS_REMOVEPART_SETTED                 128

    // Script parsing errors
#define ERR_PARSE_NOERROR                               0
#define ERR_PARSE_NULLPOINTER                           1
#define ERR_PARSE_PCK_NOTFOUND                          2
#define ERR_PARSE_INDEX_NOTFOUND                        3
#define ERR_PARSE_PCKID_NOTFOUND                        4
#define ERR_PARSE_TITLE_NOTFOUND                        5
#define ERR_PARSE_TARGET_NOTFOUND                       6
#define ERR_PARSE_KEYWORD_NOTFOUND                      7
#define ERR_PARSE_REQUIRES_NOTFOUND                     8
#define ERR_PARSE_REQUIRES_MAJOR_NOTFOUND               9
#define ERR_PARSE_REQUIRES_PACKAGE_NOTFOUND             10
#define ERR_PARSE_REQUIRES_VENDOR_NOTFOUND              11
#define ERR_PARSE_REQUIRES_APP_NOTFOUND                 12
#define ERR_PARSE_EXECUTE_NOTFOUND                      13
#define ERR_PARSE_CLEARPROFILE_NOTFOUND                 14
#define ERR_PARSE_CLEARPROFILE_STRINGTOOLONG            15
#define ERR_PARSE_CONFIGSYS_NOTFOUND                    16
#define ERR_PARSE_REGISTERCLASS_NOTFOUND                17
#define ERR_PARSE_REPLACECLASS_NOTFOUND                 18
#define ERR_PARSE_CREATEOBJECT_NOTFOUND                 19
#define ERR_PARSE_CREATEOBJECT_LOCATION_NOTFOUND        20
#define ERR_PARSE_CREATEOBJECT_TITLE_NOTFOUND           21
#define ERR_PARSE_CREATEOBJECT_CLASSNAME_NOTFOUND       22
#define ERR_PARSE_KILLPROCESS_NOTFOUND                  23
#define ERR_PARSE_WRITEPROFILE_NOTFOUND                 24
#define ERR_PARSE_WRITEPROFILE_STRINGTOOLONG            25
#define ERR_PARSE_WRITEPROFILE_APP_NOTFOUND             26
#define ERR_PARSE_WRITEPROFILE_KEY_NOTFOUND             27
#define ERR_PARSE_WRITEPROFILE_STRING_NOTFOUND          28

// Message class types:
#define MSG_TYPE_UNDEF                                  0
#define MSG_TYPE_INFO                                   1
#define MSG_TYPE_WARNING                                2
#define MSG_TYPE_ERROR                                  3

// Message values.
#define MSG_VALUE_UNDEF                                 0
#define MSG_ATTRIBUTE_INDEX_NOTFOUND                    1
#define MSG_ATTRIBUTE_PACKAGEID_NOTFOUND                2
#define MSG_ATTRIBUTE_PACKAGEID_MAJOR_NOTFOUND          3
#define MSG_ATTRIBUTE_PACKAGEID_MINOR_NOTFOUND          4
#define MSG_ATTRIBUTE_PACKAGEID_PACKAGE_NOTFOUND        5
#define MSG_ATTRIBUTE_PACKAGEID_APPL_NOTFOUND           6
#define MSG_ATTRIBUTE_PACKAGEID_VENDOR_NOTFOUND         7
#define MSG_ATTRIBUTE_PACKAGEID_PACKAGE_STRTOOLONG      8
#define MSG_ATTRIBUTE_PACKAGEID_APPL_STRTOOLONG         9
#define MSG_ATTRIBUTE_PACKAGEID_VENDOR_STRTOOLONG       10
#define MSG_ATTRIBUTE_TITLE_TITLE_STRTOOLONG            11
#define MSG_ATTRIBUTE_TITLE_TITLE_NOTFOUND              12
#define MSG_ATTRIBUTE_TARGET_TARGET_STRTOOLONG          13
#define MSG_ATTRIBUTE_TARGET_TARGET_NOTFOUND            14
#define MSG_KEYWORD_PCKKW_NOTFOUND                      15
#define MSG_ATTRIBUTE_REQUIRES_NOTFOUND                 16
#define MSG_ATTRIBUTE_REQUIRES_MINOR_NOTFOUND           17
#define MSG_ATTRIBUTE_REQUIRES_MAJOR_NOTFOUND           18
#define MSG_ATTRIBUTE_REQUIRES_PACKAGE_NOTFOUND         19
#define MSG_ATTRIBUTE_REQUIRES_APPL_NOTFOUND            20
#define MSG_ATTRIBUTE_REQUIRES_VENDOR_NOTFOUND          21
#define MSG_ATTRIBUTE_REQUIRES_REV_NOTFOUND             22
#define MSG_ATTRIBUTE_REQUIRES_VENDOR_STRTOOLONG        23
#define MSG_ATTRIBUTE_REQUIRES_APPL_STRTOOLONG          24
#define MSG_ATTRIBUTE_REQUIRES_PACKAGE_STRTOOLONG       25
#define MSG_ATTRIBUTE_CFGSYS_MODIFIER_WRONGCOMB         26
#define MSG_ATTRIBUTE_CFGSYS_STATEMENT_STRTOOLONG       27
#define MSG_ATTRIBUTE_CFGSYS_NOTFOUND                   28
#define MSG_ATTRIBUTE_REGISTER_NOTFOUND                 29
#define MSG_ATTRIBUTE_REGISTER_CLASSNAME_NOTFOUND       30
#define MSG_ATTRIBUTE_REGISTER_DLLPATH_NOTFOUND         31
#define MSG_ATTRIBUTE_REGISTER_CLASSNAME_STRTOOLONG     32
#define MSG_ATTRIBUTE_REGISTER_DLLPATH_STRTOOLONG       33
#define MSG_ATTRIBUTE_REPLACE_CLASSNAME_STRTOOLONG      34
#define MSG_ATTRIBUTE_REPLACE_NEWNAME_STRTOOLONG        35
#define MSG_ATTRIBUTE_REPLACE_NOTFOUND                  36
#define MSG_ATTRIBUTE_REGISTER_CLASSNAME_MISSING        37
#define MSG_ATTRIBUTE_CREATE_CLASSNAME_STRTOOLONG       38
#define MSG_ATTRIBUTE_CREATE_TITLE_STRTOOLONG           39
#define MSG_ATTRIBUTE_CREATE_LOCATION_STRTOOLONG        40
#define MSG_ATTRIBUTE_CREATE_CONFIG_STRTOOLONG          41
#define MSG_ATTRIBUTE_CREATE_NOTFOUND                   42
#define MSG_ATTRIBUTE_CREATE_LOCATION_MISSING           43
#define MSG_ATTRIBUTE_CREATE_TITLE_MISSING              44
#define MSG_ATTRIBUTE_CREATE_CLASSNAME_MISSING          45
#define MSG_ATTRIBUTE_EXECUTE_EXEFILEPARAM_STRTOOLONG   46
#define MSG_ATTRIBUTE_EXECUTE_MISSING                   47
#define MSG_ATTRIBUTE_EXECUTE_EXEFILEPARAM_MISSING      48
#define MSG_ATTRIBUTE_EXECUTE_CONTEXT_MISSING           49
#define MSG_ATTRIBUTE_CLRPROFILE_PROFILE_STRTOOLONG     50
#define MSG_ATTRIBUTE_CLRPROFILE_APPL_STRTOOLONG        51
#define MSG_ATTRIBUTE_CLRPROFILE_KEY_STRTOOLONG         52
#define MSG_ATTRIBUTE_CLRPROFILE_PROFILE_MISSING        53
#define MSG_ATTRIBUTE_CLRPROFILE_APPL_MISSING           54
#define MSG_ATTRIBUTE_CLRPROFILE_KEY_MISSING            55
#define MSG_ATTRIBUTE_CLRPROFILE_MISSING                56

#define MSG_ATTRIBUTE_WRITEPROFILE_PROFILE_STRTOOLONG   57
#define MSG_ATTRIBUTE_WRITEPROFILE_APPL_STRTOOLONG      58
#define MSG_ATTRIBUTE_WRITEPROFILE_KEY_STRTOOLONG       59
#define MSG_ATTRIBUTE_WRITEPROFILE_PROFILE_MISSING      60
#define MSG_ATTRIBUTE_WRITEPROFILE_APPL_MISSING         61
#define MSG_ATTRIBUTE_WRITEPROFILE_KEY_MISSING          62
#define MSG_ATTRIBUTE_WRITEPROFILE_MISSING              63
#define MSG_ATTRIBUTE_WRITEPROFILE_STRING_MISSING       64
#define MSG_ATTRIBUTE_KILLPROCESS_FILENAME_STRTOOLONG   65
#define MSG_ATTRIBUTE_KILLPROCESS_MISSING               66

#define MSG_TAG_PCK_NOTFOUND                            70




struct SCRIPTERROR
    {
    // Error code.
    USHORT usErrorCode;
    // The number of the line where error is located.
    ULONG ulLineNumber;
    // The start offset of the block where error is located.
    PSZ pszStart;
    // The length of the block where error is located.
    ULONG ulLength;
    };


struct PACKAGEIDDATA
    {
    CHAR                szVendor[MAXVENDORNAMELENGTH];
    CHAR                szApplication[MAXAPPNAMELENGTH];
    CHAR                szPackage[MAXPCKNAMELENGTH];
    USHORT              usMajor;
    USHORT              usMinor;
    USHORT              usRevision;
    };


struct REQUIRESDATA
    {
    CHAR                szVendor[MAXVENDORNAMELENGTH];
    CHAR                szApplication[MAXAPPNAMELENGTH];
    CHAR                szPackage[MAXPCKNAMELENGTH];
    USHORT              usMajor;
    USHORT              usMinor;
    USHORT              usRevision;
    };


struct CONFIGSYSDATA
    {
    CHAR                szStatement[MAXSCRIPTSTRINGLENGTH];
    USHORT              usModifiers;
    CHAR                szSearchString[MAXSCRIPTSTRINGLENGTH];
    };


struct REGISTERCLASSDATA
    {
    CHAR                szClassname[MAXCLASSNAMELENGTH];
    CHAR                szDLLPath[CCHMAXPATH];
    };


struct REPLACECLASSDATA
    {
    CHAR                szOldClassName[MAXCLASSNAMELENGTH];
    CHAR                szNewClassName[MAXCLASSNAMELENGTH];
    };


struct CREATEOBJECTDATA
    {
    CHAR                szClassName[MAXCLASSNAMELENGTH];
    CHAR                szTitle[MAXCLASSTITLELENGTH];
    CHAR                szLocation[CCHMAXPATH];
    CHAR                szConfig[MAXCLASSCONFIGLENGTH];
    BOOL                bReplace;
    };


struct PROFILEDATA
    {
    CHAR                szProfile[CCHMAXPATH];
    CHAR                szApplication[MAXPROFILEAPPLICATIONLENGTH];
    CHAR                szKey[MAXPROFILEKEYLENGTH];
    };


struct EXECUTEDATA
    {
    CHAR                szExecFileParams[CCHMAXPATH];
    USHORT              fusContext;
    };



/*
 *@@INDEX structure
 */
struct INDEX
    {
    unsigned short tusIndex[MAXCHILDREN];
    INDEX operator+(unsigned short);
    INDEX &operator=(unsigned short);
    INDEX(unsigned short);
    INDEX();
    short operator==(const INDEX &);
    INDEX &DeleteLastIndex();
    };


/*
 *@@Message
 *  This class is the message class used in MessageLogger.
 */
class Message : public BSRoot
    {
        public:
            DECLARE_CLASS(Message);

        private:
    USHORT      _usType;// MSG_TYPE_INFO
                        // MSG_TYPE_WARNING
                        // MSG_TYPE_ERROR
    BSString    _strMessageText;
    ULONG       _ulLineNumber;
    USHORT      _usMessageValue;
    public:
        Message();
        virtual ~Message();
        USHORT SetType(USHORT);
        USHORT SetMessageText(const BSString &);
        USHORT SetMessageText(const PSZ);
        USHORT SetLineNumber(ULONG);
        USHORT SetMessageValue(USHORT);
        USHORT ReturnType();
        BSString &ReturnMessageText();
        ULONG ReturnLineNumber();
        USHORT ReturnMessageValue();
        BSString &ComposeMessage();
   };



/*
 *@@MessageLogger
 *  This class is for logging of messages occurred during manipulating of script
 *  objects or during building of script text. There are different types of messages
 *  such as informative, warning and error in WarpINScript.
 */
class MessageLogger
    {
    list<Message*>          _lstMessage;
    USHORT                  _usMessages;
    MessageLogger           *_pParentLogger;
    public:
        MessageLogger();
        MessageLogger(MessageLogger&);
        ~MessageLogger();
        MessageLogger &operator=(MessageLogger &);
        USHORT SetParentLogger(MessageLogger&);
        USHORT LogMessage(Message &);
        USHORT ReturnMessageCount();
        const list<Message*> ReturnMessageList();
        BSString &ReturnComposedMessageString();
        USHORT DeleteLogs();
    };




/*
 *@@WarpINScriptBase
 *  This class is base class (super class) for all other classes which belongs to
 *  the script classes except for message logger class which is base class for
 *  WarpINScriptBase class. There are few virtual functions which must be definited in
 *  sub class (derived class) in order to script classes actually work.
 */
class WarpINScriptBase
    {
    USHORT              _usIndex;
    public:
        MessageLogger   _messageLogger;

        //WarpINScriptBase();
        virtual ~WarpINScriptBase();
        USHORT SetIndex(const USHORT);
        USHORT ReturnIndex();
        // virtual PSZ MakeScriptText(BOOL = TRUE){return NULL;}
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE) // V0.9.14 (2001-07-07) [umoeller]
        { return 0; }

        virtual PSZ BuildFromText(PSZ, ULONG){return NULL;}
    };


/*
 *@@ScriptIndex class
 *  This class is used in ScriptPackage and ScriptPage classes and it contains datas used
 *  while creating INDEX attribute.
 */
class ScriptIndex : public WarpINScriptBase
    {
    USHORT usIndexAttribute;

    public:
        ScriptIndex(USHORT = 1);
        virtual ~ScriptIndex();
        ScriptIndex &operator=(ScriptIndex &);

        USHORT SetIndexAttribute(USHORT);

        //void SetIndex(USHORT usIndex);

        USHORT ReturnIndexAttribute();

        //USHORT ReturnIndex();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);
    };




/*
 *@@ScriptPackageID class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating package ID attribute.
 */
class ScriptPackageID : public WarpINScriptBase
    {
    CHAR                _szVendor[MAXVENDORNAMELENGTH];
    CHAR                _szApplication[MAXAPPNAMELENGTH];
    CHAR                _szPackage[MAXPCKNAMELENGTH];
    USHORT              _usMajor;
    USHORT              _usMinor;
    USHORT              _usRevision;

    public:
        // Constructor for the class
        ScriptPackageID(USHORT = 1);
        // Destructor for the class
        virtual ~ScriptPackageID();

        // Sets datas to strings
        USHORT SetVendor(const PSZ);
        USHORT SetApplication(const PSZ);
        USHORT SetPackage(const PSZ);
        USHORT SetMajor(USHORT);
        USHORT SetMinor(USHORT);
        USHORT SetRevision(USHORT);
        USHORT SetPackageID(PACKAGEIDDATA);

        const PSZ ReturnVendor();
        const PSZ ReturnApplication();
        const PSZ ReturnPackage();
        USHORT ReturnMajor();
        USHORT ReturnMinor();
        USHORT ReturnRevision();
        PACKAGEIDDATA ReturnPackageID();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]
        PSZ BuildFromText(PSZ, ULONG);
    };



/*
 *@@ ScriptTitle class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating title attribute.
 */
class ScriptTitle : public WarpINScriptBase
    {
    CHAR        _szTitle[MAXTITLELENGTH];

    public:
        ScriptTitle(USHORT = 1);
        virtual ~ScriptTitle();

        USHORT SetTitle(const PSZ);

        const PSZ ReturnTitle();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);
    };



/*
 *@@ ScriptTarget class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating target attribute.
 */
class ScriptTarget : public WarpINScriptBase
    {
    CHAR                _szTarget[CCHMAXPATH];

    public:
        ScriptTarget(USHORT = 1);
        virtual ~ScriptTarget();

        USHORT SetTarget(const PSZ);

        const PSZ ReturnTarget();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);
    };



/*
 *@@ScriptKeyWord:
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating keyword attribute.
 */
class ScriptKeyWord : public WarpINScriptBase
    {
    BOOL                _bBase;
    BOOL                _bFixed;
    BOOL                _bSelect;
    BOOL                _bNoDeselect;

    public:
        ScriptKeyWord(USHORT = 1);
        virtual ~ScriptKeyWord();

        USHORT SetBase(BOOL);
        USHORT SetFixed(BOOL);
        USHORT SetSelect(BOOL);
        USHORT SetNoDeselect(BOOL);
        USHORT SetKeyWord(USHORT);

        BOOL ReturnBase();
        BOOL ReturnFixed();
        BOOL ReturnSelect();
        BOOL ReturnNoDeselect();
        USHORT ReturnKeyWord();

        // PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]
        PSZ BuildFromText(PSZ, ULONG);
    };




/*
 *@@ScriptRequires:
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating requires attribute.
 */
class ScriptRequires : public WarpINScriptBase
    {
    CHAR                _szVendor[MAXVENDORNAMELENGTH];
    CHAR                _szApplication[MAXAPPNAMELENGTH];
    CHAR                _szPackage[MAXPCKNAMELENGTH];
    USHORT              _usMajor;
    USHORT              _usMinor;
    USHORT              _usRevision;
    USHORT              _usPckIndex;

    public:
        // Constructor for the class
        ScriptRequires(USHORT = 1);
        // Destructor for the class
        virtual ~ScriptRequires();

        // Sets datas to strings
        USHORT SetVendor(const PSZ);
        USHORT SetApplication(const PSZ);
        USHORT SetPackage(const PSZ);
        USHORT SetMajor(USHORT);
        USHORT SetMinor(USHORT);
        USHORT SetRevision(USHORT);
        USHORT SetPckIndex(USHORT);
        USHORT SetRequires(REQUIRESDATA);

        const PSZ ReturnVendor();
        const PSZ ReturnApplication();
        const PSZ ReturnPackage();
        USHORT ReturnMajor();
        USHORT ReturnMinor();
        USHORT ReturnRevision();
        USHORT ReturnPckIndex();
        REQUIRESDATA ReturnRequires();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]
        PSZ BuildFromText(PSZ, ULONG);
    };



/*
 *@@ScriptConfigSys:
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating configsys attribute.
 */
class ScriptConfigSys : public WarpINScriptBase
    {
    CHAR                _szStatement[MAXSTATEMENTLENGTH];
    BOOL                _bUnique;
    BOOL                _bAddRight;
    BOOL                _bAddLeft;
    BOOL                _bAddTop;
    BOOL                _bAddAfter;
    BOOL                _bAddBefore;
    BOOL                _bRemoveLine;
    BOOL                _bRemovePart;
    CHAR                _szSearchString[MAXSEARCHSTRINGLENGTH];

    public:
        ScriptConfigSys(USHORT = 1);
        virtual ~ScriptConfigSys();

        USHORT SetStatement(const PSZ);
        USHORT SetUnique(BOOL);
        USHORT SetAddRight(BOOL);
        USHORT SetAddLeft(BOOL);
        USHORT SetAddTop(BOOL);
        USHORT SetAddAfter(BOOL);
        USHORT SetAddBefore(BOOL);
        USHORT SetRemoveLine(BOOL);
        USHORT SetRemovePart(BOOL);
        USHORT SetSearchString(const PSZ);
        USHORT SetConfigSys(CONFIGSYSDATA);

        const PSZ ReturnStatement();
        BOOL ReturnUnique();
        BOOL ReturnAddRight();
        BOOL ReturnAddLeft();
        BOOL ReturnAddTop();
        BOOL ReturnAddAfter();
        BOOL ReturnAddBefore();
        BOOL ReturnRemoveLine();
        BOOL ReturnRemovePart();
        const PSZ ReturnSearchString();
        CONFIGSYSDATA ReturnConfigSys();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);
    };




/*
 *@@ScriptRegisterClass:
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating register class attribute.
 */
class ScriptRegisterClass : public WarpINScriptBase
    {
    CHAR                _szClassName[MAXCLASSNAMELENGTH];
    CHAR                _szDLLPath[CCHMAXPATH];

    public:
        ScriptRegisterClass(USHORT = 1);
        virtual ~ScriptRegisterClass();

        USHORT SetClassName(const PSZ);
        USHORT SetDLLPath(const PSZ);
        USHORT SetRegisterClass(REGISTERCLASSDATA);

        const PSZ ReturnClassName();
        const PSZ ReturnDLLPath();
        REGISTERCLASSDATA ReturnRegisterClass();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]
        PSZ BuildFromText(PSZ, ULONG);


    };



/*
 *@@ScriptReplaceClass:
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating replace class attribute.
 */
class ScriptReplaceClass : public WarpINScriptBase
    {
    CHAR                _szClassName[MAXCLASSNAMELENGTH];
    CHAR                _szNewClassName[MAXCLASSNAMELENGTH];

    public:
        ScriptReplaceClass(USHORT = 1);
        virtual ~ScriptReplaceClass();

        USHORT SetClassName(const PSZ);
        USHORT SetNewClassName(const PSZ);
        USHORT SetReplaceClass(REPLACECLASSDATA);

        const PSZ ReturnClassName();
        const PSZ ReturnNewClassName();
        REPLACECLASSDATA ReturnReplaceClass();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);

    };



/*
 *@@ScriptCreateObject:
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating create object attribute.
 */
class ScriptCreateObject : public WarpINScriptBase
    {
    CHAR                _szClassName[MAXCLASSNAMELENGTH];
    CHAR                _szTitle[MAXCLASSTITLELENGTH];
    CHAR                _szLocation[CCHMAXPATH];
    CHAR                _szConfig[MAXCLASSCONFIGLENGTH];
    BOOL                _bReplace;

    public:
        ScriptCreateObject(USHORT = 1);
        virtual ~ScriptCreateObject();

        USHORT SetClassName(const PSZ);
        USHORT SetTitle(const PSZ);
        USHORT SetLocation(const PSZ);
        USHORT SetConfig(const PSZ);
        USHORT SetReplace(BOOL);
        USHORT SetCreateObject(CREATEOBJECTDATA);

        const PSZ ReturnClassName();
        const PSZ ReturnTitle();
        const PSZ ReturnLocation();
        const PSZ ReturnConfig();
        BOOL ReturnReplace();
        CREATEOBJECTDATA ReturnCreateObject();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);

    };




/*
 *@@ScriptExecute:
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating execute attribute.
 */
class ScriptExecute : public WarpINScriptBase
    {
    CHAR                _szExecFileParams[CCHMAXPATH];
    USHORT              _usContext;

    public:
        ScriptExecute(USHORT = 1);
        virtual ~ScriptExecute();

        USHORT SetExecFileParams(const PSZ);
        USHORT SetContext(USHORT);

        USHORT SetExecute(EXECUTEDATA);

        const PSZ ReturnExecFileParams();
        USHORT ReturnContext();

        EXECUTEDATA ReturnExecute();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);

    };



/*
 *@@ScriptClearProfile:
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating clearprofile attribute.
 */
class ScriptClearProfile : public WarpINScriptBase
    {
    CHAR                _szProfileString[CCHMAXPATH];
    CHAR                _szApplication[MAXPROFILEAPPLICATIONLENGTH];
    CHAR                _szKey[MAXPROFILEKEYLENGTH];

    public:
        ScriptClearProfile(USHORT = 1);
        virtual ~ScriptClearProfile();

        USHORT SetProfileString(const PSZ);
        USHORT SetApplication(const PSZ);
        USHORT SetKey(const PSZ);
        USHORT SetProfile(PROFILEDATA);

        const PSZ ReturnProfileString();
        const PSZ ReturnApplication();
        const PSZ ReturnKey();
        PROFILEDATA ReturnProfile();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);

    };




/*
 *@@ ScriptWriteProfile class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating writeprofile attribute.
 */
class ScriptWriteProfile : public WarpINScriptBase
    {
    CHAR                _szProfileString[CCHMAXPATH];
    CHAR                _szApplication[MAXPROFILEAPPLICATIONLENGTH];
    CHAR                _szKey[MAXPROFILEKEYLENGTH];
    PSZ                 _pszString;

    public:
        ScriptWriteProfile(USHORT = 1);
        virtual ~ScriptWriteProfile();
        ScriptWriteProfile &operator=(ScriptWriteProfile &);

        USHORT SetProfileString(const PSZ);
        USHORT SetApplication(const PSZ);
        USHORT SetKey(const PSZ);
        USHORT SetProfile(PROFILEDATA);
        USHORT SetString(const PSZ);

        const PSZ ReturnProfileString() const;
        const PSZ ReturnApplication() const;
        const PSZ ReturnKey() const;
        const PSZ ReturnString() const;
        PROFILEDATA ReturnProfile();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);

    };




/*
 *@@ ScriptKillProcess class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating KILLPROCESS attribute.
 */
class ScriptKillProcess : public WarpINScriptBase
    {
    CHAR                _szFileName[CCHMAXPATH];

    public:
        ScriptKillProcess(USHORT = 1);
        virtual ~ScriptKillProcess();

        USHORT SetFileName(const PSZ);

        const PSZ ReturnFileName();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        PSZ BuildFromText(PSZ, ULONG);
    };





/*
 *@@ ScriptPackage class
 *  This class is used in ScriptPackage class and it contains datas used
 *  while creating package attribute. This class contains all other classes
 *  related to package. There are two different index ordering modes...
 */
class ScriptPackage : public WarpINScriptBase
    {
        // Used when removing object from table. If TRUE object indexes are
        // automatically reordered.
        //  Ex. 0, 1, 2, 3, 4
        //  Number 3 is removed -> indexing: 0, 1, 2, 3
        //  New object -> indexing: 0, 1, 2, 3, 4
        //  => New object is now number 4.
        // If FALSE object indexes are not reordered.
        //  Ex. 0, 1, 2, 3, 4
        //  Number 3 is removed -> indexing: 0, 1, 2, 4
        //  New object -> indexing: 0, 1, 2, 4, 3
        //  => New object is now number 3.
    BOOL                _bAllowIndexArrangement;

    ScriptIndex         _Index;
    PSZ                 _pszDescription;
    ScriptPackageID     _PckID;
    ScriptTitle         _Title;
    ScriptTarget        _Target;
    ScriptKeyWord       _KeyWords;

    ScriptRequires      *_pRequires;
    USHORT              _usRequiresCount;

    ScriptConfigSys     *_pConfigSys;
    USHORT              _usConfigSysCount;

    ScriptRegisterClass *_pRegisterClass;
    USHORT              _usRegisterClassCount;

    ScriptReplaceClass  *_pReplaceClass;
    USHORT              _usReplaceClassCount;

    ScriptCreateObject  *_pCreateObject;
    USHORT              _usCreateObjectCount;

    ScriptExecute       *_pExecute;
    USHORT              _usExecuteCount;

    ScriptWriteProfile  *_pWriteProfile;
    USHORT              _usWriteProfileCount;

    ScriptClearProfile  *_pProfile;
    USHORT              _usProfileCount;

    ScriptKillProcess   *_pKillProcess;
    USHORT              _usKillProcessCount;

    public:
        ScriptPackage(USHORT = 1, BOOL = TRUE);
        virtual ~ScriptPackage();
        // Copy constructor. Needed when adding, removing or moving objects
        // because this class uses dynamic memory management.
        ScriptPackage(ScriptPackage &);
        // Assignment operator. Needed when adding, removing or moving objects.
        ScriptPackage &operator=(ScriptPackage &);
        // Clear all.
        USHORT ClearAll();

        USHORT SetDescription(const PSZ);
        //SetPackageData(PACKAGEDATA package);

        const PSZ ReturnDescription();
        //PACKAGEDATA ReturnPackageData();

        USHORT SetPackageIndex(USHORT);
        USHORT SetPackageID(PACKAGEIDDATA);
        USHORT SetTitle(const PSZ);
        USHORT SetTarget(const PSZ);
        USHORT SetKeyWords(USHORT);
        ScriptIndex *ReturnPackageIndex();
        USHORT ReturnPackageIndexNumber();
        ScriptPackageID *ReturnPackageIDObject();
        ScriptTitle *ReturnTitleObject();
        const PSZ ReturnTitleText();
        ScriptTarget *ReturnTargetObject();
        const PSZ ReturnTargetText();
        ScriptKeyWord *ReturnKeyWordObject();

        // PSZ MakeScriptText(BOOL = TRUE);
        virtual PSZ MakeScriptText(BOOL bAttribute = TRUE, BOOL bLineFeed = FALSE); // V0.9.14 (2001-07-07) [umoeller]

        // Build package accordingly to pszScriptText. If there is any errors
        // in script text, error information is returned in *pScriptError table.
        PSZ BuildFromText(PSZ, ULONG);

        // Functions for handling of requires class
            // Creates new implementation of ScriptRequiresClass and returns
            // pointer to the new object.
        ScriptRequires *CreateRequiresObject();
        ScriptRequires *CreateRequiresObject(REQUIRESDATA);
            // Returns address of ScriptRequires object which index is usIndex.
        ScriptRequires *ReturnRequiresObject(USHORT);
            // Deletes ScriptRequires object which index is usIndex.
        USHORT DeleteRequiresObject(USHORT);
            // Deletes ScriptRequires object which address is
            // *ScriptRequiresClass.
        USHORT DeleteRequiresObject(ScriptRequires *);
            // Returns how many ScriptRequires objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnRequiresObjectCount();



        // Functions for handling of configsys object
            // Creates new implementation of ScriptConfigSys and returns
            // pointer to the new object.
        ScriptConfigSys *CreateConfigSysObject();
         ScriptConfigSys *CreateConfigSysObject(CONFIGSYSDATA);
            // Returns address of ScriptConfigSys object which index is usIndex.
        ScriptConfigSys *ReturnConfigSysObject(USHORT);
            // Deletes ScriptConfigSys object which index is usIndex.
        USHORT DeleteConfigSysObject(USHORT);
            // Deletes ScriptConfigSys object which address is
            // *ScriptConfigSysObject.
        USHORT DeleteConfigSysObject(ScriptConfigSys *);
            // Returns index of object which address is *ScriptConfigSysObject.
        USHORT ReturnIndexOfConfigSysObject(ScriptConfigSys *);
            // Returns how many ScriptConfigSys objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnConfigSysObjectCount();



        // Functions for handling of register object
            // Creates new implementation of ScriptRegisterClass and returns
            // pointer to the new object.
        ScriptRegisterClass *CreateRegisterClassObject();
        ScriptRegisterClass *CreateRegisterClassObject(REGISTERCLASSDATA);
            // Returns address of ScriptRegisterClass object which index is
            // usIndex.
        ScriptRegisterClass *ReturnRegisterClassObject(USHORT);
            // Deletes ScriptRegisterClass object which index is usIndex.
        USHORT DeleteRegisterClassObject(USHORT);
            // Deletes ScriptRegisterClass object which address is
            // *ScriptRegisterClassObject.
        USHORT DeleteRegisterClassObject(ScriptRegisterClass *);
            // Returns how many ScriptRegisterClass objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnRegisterClassObjectCount();



        // Functions for handling of replace object
            // Creates new implementation of ScriptReplaceClass and returns
            // pointer to the new object.
        ScriptReplaceClass *CreateReplaceClassObject();
        ScriptReplaceClass *CreateReplaceClassObject(REPLACECLASSDATA);
            // Returns address of ScriptReplaceClass object which index is
            // usIndex.
        ScriptReplaceClass *ReturnReplaceClassObject(USHORT);
            // Deletes ScriptReplaceClass object which index is usIndex.
        USHORT DeleteReplaceClassObject(USHORT);
            // Deletes ScriptReplaceClass object which address is
            // *ScriptReplaceClassObject.
        USHORT DeleteReplaceClassObject(ScriptReplaceClass *);
            // Returns how many ScriptReplaceClass objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnReplaceClassObjectCount();



        // Functions for handling of create object object
            // Creates new implementation of ScriptCreateObject and returns
            // pointer to the new object.
        ScriptCreateObject *CreateCreateObjectObject();
        ScriptCreateObject *CreateCreateObjectObject(CREATEOBJECTDATA);
            // Returns address of ScriptCreateObject object which index is
            // usIndex.
        ScriptCreateObject *ReturnCreateObjectObject(USHORT);
            // Deletes ScriptCreateObject object which index is usIndex.
        USHORT DeleteCreateObjectObject(USHORT);
            // Deletes ScriptCreateObject object which address is
            // *ScriptCreateObjectObject.
        USHORT DeleteCreateObjectObject(ScriptCreateObject *);
            // Returns how many ScriptCreateObject objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnCreateObjectObjectCount();



        // Functions for handling of execute object
            // Creates new implementation of ScriptExecute and returns
            // pointer to the new object.
        ScriptExecute *CreateExecuteObject();
        ScriptExecute *CreateExecuteObject(PSZ);
            // Returns address of ScriptExecute object which index is
            // usIndex.
        ScriptExecute *ReturnExecuteObject(USHORT);
            // Deletes ScriptExecute object which index is usIndex.
        USHORT DeleteExecuteObject(USHORT);
            // Deletes ScriptExecute object which address is
            // *ScriptExecuteObject.
        USHORT DeleteExecuteObject(ScriptExecute *);
            // Returns how many ScriptCreateObject objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnExecuteObjectCount();



        // Functions for handling of clear profile object
            // Creates new implementation of ScriptClearProfile and returns
            // pointer to the new object.
        ScriptClearProfile *CreateClearProfileObject();
        ScriptClearProfile *CreateClearProfileObject(PROFILEDATA);
            // Returns address of ScriptClearProfile object which index is
            // usIndex.
        ScriptClearProfile *ReturnClearProfileObject(USHORT);
            // Deletes ScriptClearProfile object which index is usIndex.
        USHORT DeleteClearProfileObject(USHORT);
            // Deletes ScriptClearProfile object which address is
            // *ScriptClearProfileObject.
        USHORT DeleteClearProfileObject(ScriptClearProfile *);
            // Returns how many ScriptCreateObject objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnClearProfileObjectCount();



        // Functions for handling of write profile object
            // Creates new implementation of ScriptWriteProfile and returns
            // pointer to the new object.
        ScriptWriteProfile *CreateWriteProfileObject();
        ScriptWriteProfile *CreateWriteProfileObject(PROFILEDATA);
            // Returns address of ScriptWriteProfile object which index is
            // usIndex.
        ScriptWriteProfile *ReturnWriteProfileObject(USHORT);
            // Deletes ScriptWriteProfile object which index is usIndex.
        USHORT DeleteWriteProfileObject(USHORT);
            // Deletes ScriptWriteProfile object which address is
            // *ScriptWriteProfileObject.
        USHORT DeleteWriteProfileObject(ScriptWriteProfile *);
            // Returns how many ScriptCreateObject objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnWriteProfileObjectCount();



        // Functions for handling of kill process object
            // Creates new implementation of ScriptKillProcess and returns
            // pointer to the new object.
        ScriptKillProcess *CreateKillProcessObject();
        ScriptKillProcess *CreateKillProcessObject(const PSZ);
            // Returns address of ScriptKillProcess object which index is
            // usIndex.
        ScriptKillProcess *ReturnKillProcessObject(USHORT);
            // Deletes ScriptKillProcess object which index is usIndex.
        USHORT DeleteKillProcessObject(USHORT);
            // Deletes ScriptKillProcess object which address is
            // *ScriptKillProcessObject.
        USHORT DeleteKillProcessObject(ScriptKillProcess *);
            // Returns how many ScriptCreateObject objectes belongs to ScriptPackage
            // (this) object.
        USHORT ReturnKillProcessObjectCount();


        };



/*
 *@@ ScriptExpanded class
 *  This class is used in ScriptGroup class and it contains datas used
 *  while creating expanded attribute.
 */
class ScriptExpanded
    {
    USHORT              usIndex;

    BOOL                bExpanded;

    public:
        ScriptExpanded(USHORT usIndex = 1);
        ~ScriptExpanded();

        void SetExpanded(BOOL bExpanded);

        void SetIndex(USHORT usIndex);

        BOOL ReturnExpanded();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);
        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize, ULONG ulLineNumber);
    };




/*
 *@@ ScriptGroup class
 *  This class is used in ScriptHead class and it contains datas used
 *  while creating group tag. This class contains all other classes
 *  related to group attribute including package. ScriptGroup object with
 *  bVirtualGroup TRUE is invisible which means that virtual group does not
 *  make any changes to script text in contrast it delegates work to subclass
 *  and package objects. Virtual group is like a super group which includes all
 *  other groups and packages. Usually there is only one virtual group per
 *  ScriptWarpIN class or ScriptHead class. There is always at least one virtual
 *  group per ScriptHead class.
 */
class ScriptGroup
    {
    USHORT              usIndex;

    BOOL                bAllowIndexArrangement;

    ScriptTitle         Title;
    ScriptExpanded      Expanded;
    ScriptGroup         *pSubGroup;         // Table of group object.
    USHORT              usSubGroupCount;
    ScriptPackage       *pPackage;          // Table of package objects.
    USHORT              usPackageCount;
    BOOL                bVirtualGroup;

    // Functions for finding of unused indexes.
    // Function for copying table to another table.
        // ScriptGroup
    ScriptGroup *CopyTable(ScriptGroup *DestTable, ScriptGroup *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptGroup *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptGroup *Table, USHORT usTableSize);
        // ScriptPackage
    ScriptPackage *CopyTable(ScriptPackage *DestTable, ScriptPackage *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptPackage *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptPackage *Table, USHORT usTableSize);

    public:
        ScriptGroup(USHORT usIndex = 1, BOOL bVirtualGroup = FALSE,
                   BOOL bAllowIndexArrangement = TRUE);
        ~ScriptGroup();
        ScriptGroup(ScriptGroup &);
        USHORT ClearAll();
        ScriptGroup &operator=(ScriptGroup &);

        void SetVirtual(BOOL bVirtual);

        void SetTitle(const PSZ pszTitle);
        void SetExpanded(BOOL bExpanded);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnTitle();
        BOOL ReturnExpanded();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize, ULONG ulLineNumber);


        // Functions for handling of package objects
            // Creates new implementation of ScriptPackage and returns
            // pointer to the new object.
        ScriptPackage *CreatePackageObject();
        ScriptPackage *CreatePackageObject(ScriptPackage *pPck);
            // Returns address of ScriptPackage object which index is
            // usIndex.
        ScriptPackage *ReturnPackageObject(USHORT usIndex);
            // Returns ScriptPackage object count.
        USHORT ReturnPackageObjectCount();
            // Deletes ScriptPackage object which index is usIndex.
        USHORT DeletePackageObject(USHORT usIndex);
            // Deletes ScriptPackage object which address is
            // *ScriptPackageObject.
        USHORT DeletePackageObject(ScriptPackage
                                  *pScriptPackageObject);
            // Deletes all ScriptPackage objects of this object.
        USHORT DeleteAllPackageObjects(void);
            // Copies ScriptPackage object to sub group which index is usIndex.
        USHORT CopyPackageObjectToGroup(ScriptPackage *pPackageObject,
                                       USHORT usIndex);
            // Moves ScriptPackage object to sub group object.
        USHORT MovePackageObjectToGroup(USHORT usPckIndex, USHORT usGrpIndex);
        USHORT MovePackageObjectToGroup(USHORT usPckIndex, ScriptGroup *pDestGroupObj);
            // Moves all packages from this group object to
            // destination group object.
        USHORT MovePackageObjectsToGroup(ScriptGroup *pDestGroupObj);
            // Moves ScriptPackage objects to sub group which index is usIndex.
        USHORT MovePackageObjectsToGroup(USHORT usIndex);
        // Functions for sub group handling.
            // Adds a new sub group and returns a pointer to it.
        ScriptGroup *CreateSubGroupObject();
            // Returns a pointer to ScriptGroup object which index is usIndex.
        ScriptGroup *ReturnSubGroupObject(USHORT usIndex);
            // Deletes a sub group object which index is usIndex.
        USHORT DeleteSubGroupObject(USHORT usIndex);
            // Returns sub group object count.
        USHORT ReturnSubGroupObjectCount();
            // Move all sub group objects to group object.
        USHORT MoveSubGroupObjects(ScriptGroup *pDestGroup);




    };




/*
 *@@ ScriptTitleTag class
 *  This class is used in head class and it contains datas used
 *  while creating title tag. This class does not contain other classes.
 */
class ScriptTitleTag
    {
    USHORT              usIndex;

    CHAR                szTitle[MAXTITLELENGTH];

    public:
        ScriptTitleTag(USHORT usIndex = 1);
        ~ScriptTitleTag();

        void SetTitle(const PSZ pszTitle);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnTitle();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize, ULONG ulLineNumber);

    };


/*
 *@@ ScriptMessageTag class
 *  This class is used in head class and it contains datas used
 *  while creating message tag. This class does not contain other classes.
 */
class ScriptMessageTag
    {
    USHORT              usIndex;

    CHAR                szMessage[MAXMESSAGELENGTH];

    public:
        ScriptMessageTag(USHORT usIndex = 1);
        ~ScriptMessageTag();

        void SetMessage(const PSZ pszMessage);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnMessage();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize, ULONG ulLineNumber);
    };



/*
 *@@ ScriptHead class
 *  This class is used in WarpINScriptBase class and it contains datas used
 *  while creating head tag. This class contains all other classes
 *  related to head attribute including group, title and message. Although
 *  script does not necessarily contains GROUP tag all ScriptHead classes
 *  contains virtual group. Virtual group is abstract group which contains all
 *  other groups and packages. Virtual group does not add any group tags to
 *  script text. It delegates work to real group classes and package classes.
 *  So all packages and groups can be found from VirtualGroup class.
 */
class ScriptHead
    {
    USHORT              usIndex;

    ScriptMessageTag    Message;
    ScriptTitleTag      Title;
    ScriptGroup         VirtualGroup;

    public:
        ScriptHead(USHORT usIndex = 1);
        ~ScriptHead();

        void SetIndex(USHORT usIndex);

        void SetMessageTagText(const PSZ pszMessage);
        const PSZ ReturnMessageTagText();
        ScriptMessageTag *ReturnMessageTagObject();
        void SetTitleTagText(const PSZ pszTitle);
        const PSZ ReturnTitleTagText();
        ScriptTitleTag *ReturnTitleTagObject();
        ScriptGroup *ReturnVirtualGroupObject();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **ppScriptError,
                      USHORT *pusErrorTableSize, ULONG ulLineNumber);

    };




/*
 *@@ ScriptNextButton class
 *  This class is used in page class and it contains datas used
 *  while creating nextbutton tag. This class does not contain other classes.
 */
class ScriptNextButton
    {
    USHORT              usIndex;

    USHORT              usTarget;
    CHAR                szNextButtonText[MAXNEXTBTNTEXTLENGTH];

    public:
        ScriptNextButton(USHORT usIndex = 1);
        ~ScriptNextButton();

        void SetTarget(USHORT usTarget);
        void SetNextButton(const PSZ pszNextButtonText);
        void SetIndex(USHORT usIndex);

        USHORT ReturnTarget();
        const PSZ ReturnNextButton();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTab = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);

    };




/*
 *@@ ScriptText class
 *  This class is used in page class and it contains datas used
 *  while creating text tag.
 */
class ScriptText
    {
    USHORT              usIndex;

    PSZ                 pszText;

    public:
        ScriptText(USHORT usIndex = 1);
        ~ScriptText();
        ScriptText &operator=(const ScriptText &Text);

        void SetText(const PSZ pszText);

        void SetIndex(USHORT usIndex);

        const PSZ ReturnText();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);

    };



/*
 *@@ ScriptReadMe class
 *  This class is used in page class and it contains datas used
 *  while creating readme tag.
 */
class ScriptReadMe
    {
    USHORT              usIndex;

    PSZ                 pszReadMe;
    USHORT              usFormat;   // Format of readme text.
                                    //  README_FORMAT_NONE
                                    //  README_FORMAT_PLAIN
                                    //  README_FORMAT_FLOW
                                    //  README_FORMAT_HTML

    public:
        ScriptReadMe(USHORT usIndex = 1);
        ScriptReadMe &operator=(const ScriptReadMe &ReadMe);
        ~ScriptReadMe();

        void SetIndex(USHORT usIndex);

        void SetReadMe(const PSZ pszReadMe);
        const PSZ ReturnReadMe();

        void SetFormat(USHORT usFormat);
        USHORT ReturnFormat();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);

    };





/*
 *@@ ScriptPage class
 *  This class is used in head class and it contains datas used
 *  while creating page tag. This class contains other classes such as readme,
 *  text and nextbutton.
 */
class ScriptPage : public BSRoot
    {
        public:
            DECLARE_CLASS(ScriptPage);

        private:
    USHORT              usIndex;

    USHORT              usPageIndex;

    USHORT              usPageType; // Types:
                                    //  PAGE_TYPES_TEXT
                                    //  PAGE_TYPES_README
                                    //  PAGE_TYPES_CONTAINER
                                    //  PAGE_TYPES_CONFIGURE
    ScriptNextButton    NextButton;
    ScriptReadMe        ReadMe;
    ScriptText          Text;

    public:
        ScriptPage(USHORT usIndex = 1);
        ~ScriptPage();

        void SetPageIndex(USHORT usPageIndex);
        void SetPageType(USHORT usPageType);

        void SetIndex(USHORT usIndex);

        void SetText(const PSZ pszText);
        void SetReadMeText(const PSZ pszReadMe);
        const PSZ ReturnText();
        const PSZ ReturnReadMeText();

        USHORT ReturnPageIndex();
        USHORT ReturnPageType();

        ScriptNextButton *ReturnNextButtonObject();
        ScriptReadMe *ReturnReadMeObject();
        ScriptText *ReturnTextObject();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);
    };




/*
 *@@ ScriptBody class
 *  This class is used in WarpINScriptBase class and it contains datas used
 *  while creating body tag. This class contains page class.
 */
class ScriptBody
    {
    USHORT              usIndex;

    BOOL                bAllowIndexArrangement;

    ScriptPage          *pPage;
    USHORT              usPageCount;


        // ScriptPage object handling.
    ScriptPage *CopyTable(ScriptPage *DestTable, ScriptPage *SrcTable,
        USHORT usSize, USHORT usSkipIndex = 0);
    void ReBuildIndexes(ScriptPage *Table, USHORT usTableSize);
    USHORT FindUnusedIndex(ScriptPage *Table, USHORT usTableSize);
    public:
        ScriptBody(USHORT usIndex = 1, BOOL bAllowIndexArrangement = TRUE);
        ScriptBody(const ScriptBody &Body);
        ScriptBody &operator=(const ScriptBody &Body);
        ~ScriptBody();

        // Functions for handling of page class
            // Creates new implementation of ScriptPage and returns
            // pointer to the new class.
        ScriptPage *CreatePageObject();
            // Returns address of ScriptPage class which index is
            // usIndex.
        ScriptPage *ReturnPageObject(USHORT usIndex);
            // Deletes ScriptPage class which index is usIndex.
        USHORT DeletePageObject(USHORT usIndex);
        USHORT DeleteAllPageObjects();
            // Deletes ScriptPage class which address is
            // *ScriptPageObject.
        USHORT DeletePageObject(ScriptPage
                              *ScriptPageObject);
        USHORT ReturnPageObjectCount();

        void SetIndex(USHORT usIndex);

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);

    };



/*
 *@@ ScriptVersion class
 *  This class is used in WarpINScriptBase class and it contains datas used
 *  while creating version attribute. This class contains no other classes.
 */
class ScriptVersion
    {
    USHORT              usIndex;

    USHORT              usMajor;
    USHORT              usMinor;

    public:
        ScriptVersion(USHORT usIndex = 1);
        ~ScriptVersion();

        void SetMajor(USHORT usMajor);
        void SetMinor(USHORT usMinor);

        void SetIndex(USHORT usIndex);

        USHORT ReturnMajor();
        USHORT ReturnMinor();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);

    };




/*
 *@@ ScriptOS class
 *  This class is used in WarpINScriptBase class and it contains datas used
 *  while creating operating system attribute. This class contains no other
 *  classes.
 */
class ScriptOS
    {
    USHORT              usIndex;

    USHORT              usOS;   // Operating system:
                                //  OS_OS2_2X
                                //  OS_OS2_3X
                                //  OS_OS2_4X

    public:
        ScriptOS(USHORT usIndex = 1);
        ~ScriptOS();

        void SetOS(USHORT usOS);

        void SetIndex(USHORT usIndex);

        USHORT ReturnOS();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);

    };




/*
 *@@ ScriptCodePage class
 *  This class is used in WarpINScriptBase class and it contains datas used
 *  while creating codepage attribute. This class contains no other
 *  classes.
 */
class ScriptCodePage
    {
    USHORT              usIndex;

    USHORT              usCodePage;


    public:
        ScriptCodePage(USHORT usIndex = 1);
        ~ScriptCodePage();

        void SetCodePage(USHORT usCodePage);

        void SetIndex(USHORT usIndex);

        USHORT ReturnCodePage();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);

    };





/*
 *@@ ScriptWarpIN class
 *  This class is WarpIN script handling class and it is used in WicPM. The
 *  implementation of this class is relative to real word WarpIN script.
 *  Only one implementation of this class is needed per WarpIN archive.
 *
 */
class ScriptWarpIN
    {
    USHORT usIndex;

    // Attributes:
    ScriptOS            OS;
    ScriptVersion       Version;
    ScriptCodePage      CodePage;

    //Tags:
    ScriptHead          Head;
    ScriptBody          Body;


    public:
        ScriptWarpIN(USHORT usIndex = 1);
        ~ScriptWarpIN();

        void SetIndex(USHORT usIndex);
        USHORT ReturnIndex();

        void SetOSValue(USHORT usOS);
        USHORT ReturnOSValue();

        void SetVersionNumber(USHORT usMajor, USHORT usMinor);
        ULONG ReturnVersionNumber(USHORT *pusMajor, USHORT *pusMinor);

        void SetCodePageNumber(USHORT usCP);
        USHORT ReturnCodePageNumber();

        ScriptOS *ReturnOSObject();
        ScriptVersion *ReturnVersionObject();
        ScriptCodePage *ReturnCodePageObject();
        ScriptHead *ReturnHeadObject();
        ScriptBody *ReturnBodyObject();

        PSZ MakeScriptText(BOOL bTag = TRUE);

        PSZ BuildFromText(PSZ pszScriptText,
                          SCRIPTERROR **ppScriptError,
                          USHORT *pusErrorTableSize,
                          ULONG ulLineNumber);

    };





/*
 *@@ ScriptComment class
 *  A class for comments.
 */
class ScriptComment
    {
    USHORT              usIndex;

    PSZ                 pszComment;

    public:
        ScriptComment(USHORT usIndex = 1);
        ~ScriptComment();

        SetComment(const PSZ pszComment);

        SetIndex(USHORT usIndex);

        const PSZ ReturnComment();

        USHORT ReturnIndex();

        PSZ MakeScriptText(BOOL bAttribute = TRUE);

        PSZ BuildFromText(PSZ pszScriptText, SCRIPTERROR **pScriptError,
                         USHORT *usErrorTableSize, ULONG ulLineNumber);

    };




#endif
