/*
 * gui_notebook.h
 *  Header file for gui_notebook.cpp
 *
 *  Copyright (C) 1999-2000 Teemu Ahola.
 *
 */



#ifndef _GUI_NOTEBOOK_H_
#define _GUI_NOTEBOOK_H_


#define NOTEBOOKPAGES               15

// Return values.
#define RET_NB_OK                   0
#define RET_NB_NULLPOINTERERROR     1
#define RET_NB_SLSETERROR           2
#define RET_NB_TABTEXTINSERTERROR   3
#define RET_NB_DIALOGLOADERROR      4
#define RET_NB_SETPAGEWINDOWERROR   5
#define RET_NB_TABSIZINGERROR       6
#define RET_NB_PAGEINSERTERROR      7

// Notebook page styles.
#define NBP_STYLE_MAJOR             1
#define NBP_STYLE_MINOR             2



/* NOTEBOOKPAGE:
 *  Structure for notebook page data
 */
typedef struct _NOTEBOOKPAGE
    {
    PFNWP           pNbPageDlgProc;     // Pointer to a nb page dialog procedure.
    HWND            hwndNbPage;         // Handler of a notebook page.
    ULONG           ulNBPageID;         // Notebook page ID.
    ULONG           ulIDDialogPage;     // Notebook page dialog ID.
    USHORT          usNbPageStyle;      // Notebook page style
                                        //  (NBP_STYLE_MAJOR/NBP_STYLE_MINOR).
    PVOID           pCreateParams;      // Pointer to application defined data area
                                        //  which is passed to the dialog procedure in
                                        //  the WM_INITDLG message.
    PVOID           pWinPtrData;        // Pointer to data area which will be setted
                                        //  to the memory of reserved window word.
    PSZ             pszStatusLine;      // Page's status line text.
    PSZ             pszTab;             // Pages's tab text.
    } NOTEBOOKPAGE, *PNOTEBOOKPAGE;


/* NOTEBOOKINFO:
 *
 */
typedef struct _NOTEBOOKINFO
    {
    HWND            hwndNotebook;           // Handler of a notebook.
    NOTEBOOKPAGE    nbPage[NOTEBOOKPAGES];  // Table of notebook pages.
    USHORT          usNbPageCount;          // Number of pages in the notebook.
    } NOTEBOOKINFO, *PNOTEBOOKINFO;



USHORT InitializeNotebook (PNOTEBOOKINFO pNbInfo);


#endif
