/*
 * gui_helpers.h
 *  Header file for gui_helpers.cpp
 *
 *  This file contains declarations wich are platform-specific, in
 *  this case specific to OS/2 Presentation Manager (PM).
 *
 *  Copyright (C) 1998-1999 Teemu Ahola.
 *
 */


#ifndef _HELPERS_H
#define _HELPERS_H

#define INCL_PM
#define INCL_WIN
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define ID_MSG_OK                       2000
#define ID_MSG_MEMALLOCERROR            2005
#define ID_MSG_DLGCREATINGERROR         2006
#define ID_MSG_INTERNALERROR            2007
#define ID_MSG_NOUSEFULLDATA            2008
#define ID_MSG_CANCEL                   2009
#define ID_MSG_FILEOPENERROR            2010
#define ID_MSG_FILEINFOQUERYERROR       2011
#define ID_MSG_MEMFREEERROR             2012
#define ID_MSG_FILEEXISTS               2013
#define ID_MSG_FILENOTEXISTS            2014
#define ID_MSG_NULLPOINTERERROR         2015

// File dialog types.
#define FILEDLG_TYPE_SAVE               1
#define FILEDLG_TYPE_OPEN               2
#define FILEDLG_TYPE_SELECT             3
// File dialog return values.
#define RET_FD_OK                       0
#define RET_FD_CANCEL                   1
#define RET_FD_PARAM_ERROR              2


USHORT guiShowErrorInformation (HWND hwndOwner, USHORT usErrorCode, USHORT usCaption,
                                PSZ pszDetails);
USHORT guiShowMessageBox (HWND hwndOwner, PSZ pszCaption, PSZ pszMessage);
USHORT ShowYesNoMessageBox (HWND hwndOwner, PSZ pszCaption, PSZ pszMessage);
INT guiSetMLEText (HWND hwndParent, ULONG ulMLEId, PSZ pszText);
INT InsertMLEText (HWND hwndParent, ULONG ulMLEId, PSZ pszText, IPT *iOffset);
INT guiClearMLE (HWND hwndParent, ULONG ulMLEId);
INT guiGetMLEText (HWND hwndParent, ULONG ulMLEId, PSZ *pszText);
USHORT ShowYesNoCancelMessageBox (HWND hwndOwner, PSZ pszCaption, PSZ pszMessage);
USHORT guiSetEntryFieldTextLimit(HWND hwndParent, ULONG ulEFId, SHORT sTextLimit);
USHORT guiShowFileDialog (HWND, USHORT, PSZ, PAPSZ, PSZ, PSZ *, PAPSZ *, ULONG *);
USHORT guiLoadString(HAB, ULONG, PSZ *);





#endif

