/******************************************************************************
 *@@sourcefile WIP_HTTP_Response.hpp:
 *      Header file for WIP_HTTP_Response.cpp.
 *
 *@@include #include "net\WIP_HTTP_Response.hpp"
 */

#ifndef WIP_HTTP_RESPONSE_INCLUDED
#define WIP_HTTP_RESPONSE_INCLUDED

#include <vector>

#include "net\WISocket.hpp"
#include "net\WIP_HTTP_Header.hpp"

/*
#include <os2.h>
#include "base/bs_string.h"
*/

/******************************************************************************
 *@@ enumTE:
 *      <P>Possible transfer encodings.
 */

typedef enum
{
  TE_UNKNOWN = 0,
  TE_IDENTITY,
  TE_CHUNKED
} enumTE;

/******************************************************************************
 *@@ WIP_HTTP_Response:
 *      <P>Class to store a HTTP response.
 */

class WIP_HTTP_Response
{
  private:
    PSZ    _pszVersionString;
    USHORT _usStatusCode;
    PSZ    _pszReasonPhrase;

    vector<WIP_HTTP_Header*>
           _vHeaders;

    BOOL   _fContentLengthGiven;
    ULONG  _ulContentLength;
    enumTE _enTransferEncoding;
  public:
    WIP_HTTP_Response(Socket& socket);
   ~WIP_HTTP_Response();

    USHORT GetStatusCode()       const { return _usStatusCode;        }
    PCSZ   GetReasonPhrase()     const { return _pszReasonPhrase;     }
    enumTE GetTransferEncoding() const { return _enTransferEncoding;  }
    BOOL   ContentLengthGiven()  const { return _fContentLengthGiven; }
    ULONG  GetContentLength()    const { return _ulContentLength;     }
  private:
    VOID   ParseHeaders();
};

#endif // not WIP_HTTP_RESPONSE_INCLUDED
