/******************************************************************************
 *@@sourcefile WINet.hpp:
 *      Header file for WINet.cpp. See remarks there.
 *
 *@@include #include "net\WINet.hpp"
 */

#ifndef WINET_HPP_INCLUDED
#define WINET_HPP_INCLUDED

#include "net\WIURL.hpp"

/*@@ PrintDebug:
 *      <P>Debugging interface. I use this to make debug output independent
 *      of the actual interface used.
 */

#ifdef DEBUG
    void PrintDebug(const char* format, ...);
#endif // DEBUG

/******************************************************************************
 *@@ PFNWINETCALLBACK:
 *      <P>Pointer to external callback function that should be provided
 *      by the WINet owner to get informed about events.
 */

typedef BOOL (FNWINETCALLBACK)(USHORT, ULONG, const WIURL&);
typedef FNWINETCALLBACK* PFNWINETCALLBACK;

const USHORT CBM_NET_DNSLOOKUP         =  1;
const USHORT CBM_NET_DNSLOOKUP_FAILED  =  2;
const USHORT CBM_NET_CONNECT           =  3;
const USHORT CBM_NET_CONNECT_FAILED    =  4;
const USHORT CBM_NET_REQUEST           =  5;
const USHORT CBM_NET_REQUEST_FAILED    =  6;
const USHORT CBM_NET_FILESIZE          =  7;
const USHORT CBM_NET_BYTES_TRANSFERRED =  8;
const USHORT CBM_NET_TRANSFER_COMPLETE =  9;
const USHORT CBM_NET_TRANSFER_BROKEN   = 10;

/******************************************************************************
 *@@ WINet:
 *      <P>The base class for WarpIN networking stuff.
 */

class WINet
{
  friend class WIProtocol;

  private:
    PFNWINETCALLBACK _pfnExternalCallback;
  public:
    WINet(PFNWINETCALLBACK pfnExternalCallback = NULL);
    WINet(const WINet& wiNet);

    BOOL FetchURL(WIURL& wiURL, PCSZ pcszFileName, BOOL fResume);
  private:
    BOOL LookupHost(WIURL& wiURL);
  protected:
    BOOL Callback(USHORT usMsgType, ULONG ulMsgValue, const WIURL& wiURL);
};

#endif // not WINET_HPP_INCLUDED
