
/*
 * warpin.h:
 *      header file for both warpin.cpp and gui.cpp.
 *
 *      This contains only declarations which are independent of the
 *      implemented GUI, i.e. for the platform-independent frontend
 *      stuff (warpin.cpp).
 *
 *      See warpin.cpp for more about this concept.
 */

/*
 *      Copyright (C) 1998-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_HEADER_INCLUDED
    #define WARPIN_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Declarations
     *
     ********************************************************************/

    /*
     *@@ GUIVisited:
     *      a stack item containing a page index
     *      so we can remember which pages the
     *      user has visited already.
     *
     *      WPIGLOBALS contains a list<GUIVisited>
     *      which is really a stack of the visited
     *      pages. When the user presses "Next",
     *      a new GUIVisited is pushed on the stack.
     *      If the stack is not empty, the "Back"
     *      button is enabled. When the user presses
     *      "Back", the top GUIVisited is popped from
     *      the stack and the respective page is
     *      switched to.
     *
     *      Really, this is just a long int. But
     *      to use the new 0.9.14 list template,
     *      it must be derived from BSRoot.
     *
     *@@added V0.9.14 (2001-07-12) [umoeller]
     */

    struct GUIVisited : public BSRoot
    {
        public:
            DECLARE_CLASS(GUIVisited);

        public:
            long lPageNo;

            /*
             *@@ GUIVisited:
             *      the constructor, which needs
             *      the visited page index as input.
             */

            GUIVisited(long l) : BSRoot(tGUIVisited)
            {
                lPageNo = l;
            }
    };

    /*
     *@@ WPIGLOBALS:
     *      global structure in warpin.cpp which gets
     *      passed to guiBeginInstallMode. This has
     *      all the info you'll ever need.
     *
     *@@changed V0.9.14 (2001-08-09) [umoeller]: major cleanup for engine and stub support
     */

    struct WPIGLOBALS
    {
        /*
         * Global data (always set by main()):
         *
         */

        // path extracted from that (without trailing "\")
        // CHAR                szWarpINPath[CCHMAXPATH];   // (99-10-24) [umoeller]

        // profile handle of WARPIN.INI (opened by main())
        // HINI                hiniWarpIN;

        // WarpIN self-setup mode;
        enum SETUPMODE
             {
                UNSPECIFIED,                // no option given on command line:
                                            // check if WarpIN is installed
                UPGRADEEXISTING,            // "-U" option given: force self-install,
                                            // overwrite existing installation
                DISABLEEXISTING,            // "-F" option given: force self-install,
                                            // use WarpIN in existing directory
                IGNORE                      // "-G" option given: ignore self-install
             }              SetupMode;
                    // added V0.9.14 (2001-07-22) [umoeller]

        /*
         * Data for "Install" mode:
         *
         */

        list<GUIVisited*>    lPagesList;
                    // list of indices to the pages that were visited;
                    // initially empty. This gets updated by the GUI.

        BOOL                fInstallComplete,
                    // in install mode: TRUE after all files have been
                    //      successfully unpacked
                            fDeinstallComplete;
                    // in database mode: TRUE if the database thread
                    //      has de-installed anything

        // BOOL                fDisplayPages;
                    // whether to display pages; defaults to TRUE unless
                    // the user has set WARPIN_DISPLAYPAGES=NO
                    // V0.9.6 (2000-11-23) [umoeller]
                    // removed V0.9.20 (2002-07-03) [umoeller]

        // this flag is set by the "Drive info" window and
        // set to FALSE if there's not enough space on a
        // drive to hold the installation
        BOOL                fPlentyOfSpace;

        ULONG               fSuppressREXXConfirm;
                // V0.9.12 (2001-05-31) [umoeller]

        // install thread
        THREADINFO          tiInstallThread;

        // two buffers for specifiying the default apps and tools
        // directories; these must be global, or putenv won't work
        // V0.9.4 (2000-07-26) [umoeller]
        /* CHAR                szDefaultAppsPath[400],
                                        // WARPIN_DEFAULTAPPSPATH=[path]
                            szDefaultToolsPath[400];
                                        // WARPIN_DEFAULTTOOLSPATH=[path]
        */
                // moved these to FELocals
                // V0.9.19 (2002-04-14) [umoeller]

        /*
         *@@ WPIGLOBALS:
         *      constructor.
         */

        WPIGLOBALS()
            : lPagesList(STORE)
        {
            // szWarpINPath[0] = '\0';            // V0.9.14 (2001-08-09) [umoeller]
            // hiniWarpIN = NULLHANDLE;

            SetupMode = UNSPECIFIED;

            // fDisplayPages = TRUE;   // V0.9.6 (2000-11-23) [umoeller]

            // fAnyAlreadyInstalled = FALSE;
            // pPageInfoList = 0;

            fInstallComplete = FALSE;
            fDeinstallComplete = FALSE;

            // ulAllowConfig = 0;

            fPlentyOfSpace = TRUE;

            fSuppressREXXConfirm = FALSE;

            memset(&tiInstallThread, 0, sizeof(tiInstallThread));
        }

    };

    #ifdef THREADS_HEADER_INCLUDED
        void _Optlink wpiInstallThread(PTHREADINFO pti);
    #endif

#endif
