
/*
 * dlgids.h:
 *      all dialog ID's used by the frontend. This is included
 *      from almost all frontend files as well as the resource
 *      compiler when compiling the NLS resources.
 *
 *      This has been separated from gui.h (99-10-24) [umoeller].
 */

/*
 *      Copyright (C) 1999-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

// icon IDs in resources
#define ID_ICON                           1
#define IDP_SELECTED                    101
#define IDP_DESELECTED                  102
#define IDP_SOMESELECTED                103
#define IDP_DEINSTALL                   104

#define IDP_DB_QMARK                    151
#define IDP_DB_ERROR                    152
#define IDP_DB_OK                       153
#define IDP_DB_NEWER                    154
#define IDP_DB_APP                      155

// bitmap IDs in resources
#define IDB_WARPINLOGO                  170

// standard buttons
#define ID_WIDI_NOBUTTON                 96         // V0.9.9 (2001-04-06) [umoeller]
#define ID_WIDI_BACKBUTTON               97
#define ID_WIDI_NEXTBUTTON               98
#define ID_WIDI_CANCELBUTTON             99

/*  dialogs  */
// #define ID_WID_MAIN                     200
#define ID_WIDI_INFOTEXT                201
#define ID_WIDI_PACKAGESCNR             202         // V0.9.18 (2002-03-03) [umoeller]
#define ID_WIDI_READMEMLE               203
#define ID_WIDI_CONFIGCNR               204         // V0.9.18 (2002-03-03) [umoeller]

#define ID_WIDI_PATHTEXT                205
#define ID_WIDI_PATHENTRY               206

#define ID_WIDI_UPDATECONFIGSYS         210
#define ID_WIDI_INSTALLWPSCLASSES       211
#define ID_WIDI_CREATEWPSOBJECTS        212
#define ID_WIDI_CREATECIDCMD            213

#define ID_WIDI_CURPCKTXT               220
#define ID_WIDI_CURPCKTITLE             221
#define ID_WIDI_CURPCKCOUNT             222
#define ID_WIDI_CURFILETXT              223
#define ID_WIDI_CURFILENAME             224
#define ID_WIDI_CURFILECOUNT            225
#define ID_WIDI_TARGETPATHTXT           230
#define ID_WIDI_TARGETPATHDIR           231
#define ID_WIDI_TARGETPATHFREE          232
#define ID_WIDI_HEADING                 233

#define ID_WIDI_TIMETXT                 240
#define ID_WIDI_TIMEELAPSED             241
#define ID_WIDI_TIMELEFT                242

#define ID_WIDI_PROGRESSBAR             250

#define ID_WIDI_PCKINSTALLED_TXT        270
#define ID_WIDI_PCKINSTALLED            271

// subdialogs for pages
// #define ID_WID_PAGE_TEXT                290
// #define ID_WID_PAGE_README              291
// #define ID_WID_PAGE_CONTAINER           292
// #define ID_WID_PAGE_CONFIGURE           293
#define ID_WID_INSTALLING_STATUS        294

#define ID_WIDI_ICON                    299

// drive info
#define ID_WID_DRIVEINFO                300
#define ID_WIDI_DRIVECNR                301

// file exists; updated (99-10-26) [umoeller]
#define ID_WID_FILEEXISTS               400
#define ID_WID_FILELOCKED               401
#define ID_WIDI_EXISTS_TXT1             402
#define ID_WIDI_EXISTS_SKIP             403
#define ID_WIDI_EXISTS_RENAME           404
#define ID_WIDI_LOCKED_RETRY            405
#define ID_WIDI_LOCKED_UNLOCK           406
#define ID_WIDI_LOCKED_DEFER            407
#define ID_WIDI_EXISTS_DATEOLD          408
#define ID_WIDI_EXISTS_TIMEOLD          409
#define ID_WIDI_EXISTS_SIZEOLD          410
#define ID_WIDI_EXISTS_DATENEW          411
#define ID_WIDI_EXISTS_TIMENEW          412
#define ID_WIDI_EXISTS_SIZENEW          413
#define ID_WIDI_EXISTS_INFOTEXT         414

#define ID_WID_DELETE_FILENEWER         420

// confirmation settings
#define ID_WID_PREFERENCES            450
#define ID_WID_EXISTOLDER_PROMPT        451
#define ID_WID_EXISTOLDER_OVERWRITE     452
#define ID_WID_EXISTOLDER_SKIP          453
#define ID_WID_EXISTSAME_PROMPT         454
#define ID_WID_EXISTSAME_OVERWRITE      455
#define ID_WID_EXISTSAME_SKIP           456
#define ID_WID_EXISTNEWER_PROMPT        457
#define ID_WID_EXISTNEWER_OVERWRITE     458
#define ID_WID_EXISTNEWER_SKIP          459
#define ID_WID_LOGFILE_ENTRY            460
#define ID_WID_SHOWREXXCONFIRM          461
#define ID_WID_CODEPAGE_DROPLIST        462

// default paths settings
#define ID_WID_DEFAULTPATHS             470
#define ID_WIDI_DEFAULTAPPSPATH         471
#define ID_WIDI_DEFAULTTOOLSPATH        472

// product info
#define ID_WID_PRODUCTINFO              500
#define ID_WIDI_VERSION                 501

// upgrade V0.9.7 (2001-01-06) [umoeller]
#define ID_WID_UPGRADE                  502

#define ID_WID_CONFIGURINGSTATUS            600

// global status (99-11-01) [umoeller]
#define ID_WID_GLOBALSTATUS             650
#define ID_WIDI_COLLECTING              651
#define ID_WIDI_REMOVING                652
#define ID_WIDI_UNPACKING               653
#define ID_WIDI_CONFIGSYS               654
#define ID_WIDI_REGISTERING             655
#define ID_WIDI_CREATINGOBJECTS         656
#define ID_WIDI_ARROW                   657
#define ID_WIDI_UPDATINGDATABASE        658     // V0.9.20 (2002-07-03) [umoeller]
#define ID_WIDI_LOADINGARCHIVE          659     // V0.9.20 (2002-07-03) [umoeller]

// global database
#define ID_WID_DB_LEFT_PACKAGES                 700
#define ID_WIDI_DB_AUTHOR               701
#define ID_WIDI_DB_AUTHOR_TXT           702
#define ID_WIDI_DB_VERSION              703
#define ID_WIDI_DB_VERSION_TXT          704
#define ID_WIDI_DB_INSTALLDATE          705
#define ID_WIDI_DB_INSTALLDATE_TXT      706
#define ID_WIDI_DB_TARGETDIR            707
#define ID_WIDI_DB_TARGETDIR_TXT        708
#define ID_WIDI_DB_FILES                709
#define ID_WIDI_DB_FILES_TXT            710

// file list window
#define ID_WID_DB_RIGHT_LIST                 800

// confirm deinstall window
#define ID_WID_CONFIRMDEINSTALL         850
#define ID_WIDI_CFD_PACKAGESLIST        851
#define ID_WIDI_CFD_DELETEFILES         852
#define ID_WIDI_CFD_FILESLIST           853
#define ID_WIDI_CFD_UNDOCONFIG          854
#define ID_WIDI_CFD_CONFIGCNR           855
// #define ID_WIDI_CFD_CONFIGSYS           854
// #define ID_WIDI_CFD_CONFIGSYSLIST       855
// #define ID_WIDI_CFD_WPSCLASSES          856
// #define ID_WIDI_CFD_WPSCLASSESLIST      857
// #define ID_WIDI_CFD_WPSOBJECTS          858
// #define ID_WIDI_CFD_WPSOBJECTSLIST      859

// database thread status
#define ID_WID_DATABASETHREAD           900
#define ID_WIDI_DBT_APPLICATION         901
#define ID_WIDI_DBT_PACKAGE             902
#define ID_WIDI_DBT_FILE                903
#define ID_WIDI_DBT_FILEDATE_DATABASE   904
#define ID_WIDI_DBT_FILEDATE_EXISTING   905
#define ID_WIDI_DBT_PROGRESSBAR         906
#define ID_WIDI_DBT_REPORTMLE           907
#define ID_WIDI_DBT_SAVEREPORTAS        920

// "package already installed" dlg
/* #define ID_WID_ARCHIVEINSTALLED         950
#define ID_WIDI_AI_REPAIR               951
#define ID_WIDI_AI_ADDREMOVE            952
#define ID_WIDI_AI_DEINSTALL            953 */

// "enter variable" dlg
#define ID_WID_ENTERVARIABLE            970
#define ID_WIDI_EV_INFOTEXT             971     // added V0.9.2 (2000-03-11) [umoeller]
#define ID_WIDI_EV_SETTEXT              972
#define ID_WIDI_EV_ENTRYFIELD           973

// "Add/Remove" dlg
// #define ID_WIDI_PCKINARCHIVE            982
// #define ID_WIDI_TOADD                   987
// #define ID_WIDI_TOREMOVE                989

/* #define ID_WID_ADDREMOVE                980
#define ID_WIDI_PCKINARCHIVE_TXT        981
#define ID_WIDI_UGLYLINE                985
#define ID_WIDI_TOADD_TXT               986
#define ID_WIDI_TOREMOVE_TXT            988
    */

// dependency violation dialog V0.9.12 (2001-05-17) [umoeller]
#define ID_WID_DEPENDENCIES             990

/*
 * Menus:
 *
 */

// main window menu bar
#define ID_WIM_MAINMENU                 1000

#define ID_WIM_WARPIN                   1001
#define ID_WIMI_PREFERENCES           1002
#define ID_WIMI_DEFAULTPATHS            1003
#define ID_WIMI_EXIT                    1004

#define ID_WIM_HELP                     1100
#define ID_WIMI_HELPINDEX               1101
#define ID_WIMI_HELPGENERAL             1102
#define ID_WIMI_HELPUSINGHELP           1103
#define ID_WIMI_HELPPRODUCTINFO         1104

// additional menu items for "add/remove" mode
#define ID_WIM_ARCHIVE                  1140
#define ID_WIMI_ARCHIVE_VIEW            1141
#define ID_WIMI_ARCHIVE_CREATE_CID      1142

#define ID_WIM_SELECTADDREMOVE          1150
#define ID_WIM_SELECT                   1151
#define ID_WIMI_SELECT_DEFAULT          1152
#define ID_WIMI_SELECT_REPAIR           1153
#define ID_WIMI_SELECT_UPDATE           1154
#define ID_WIMI_SELECT_FULL             1155
#define ID_WIMI_SELECT_DEINSTALL        1156

// additional menu items for "database" mode
#define ID_WIM_VIEW                     1170
#define ID_WIMI_VIEW_FILES              1171
#define ID_WIMI_VIEW_CONFIG             1172

// context menus for database
#define ID_WIM_DATABASE_APP             1200
#define ID_WIMI_DATABASE_DEINSTALLAPP   1201
#define ID_WIMI_DATABASE_VERIFYAPP      1202
#define ID_WIMI_DATABASE_REMOVEAPP      1203

#define ID_WIM_DATABASE_PACKAGE         1220
#define ID_WIMI_DATABASE_DEINSTALLPCK   1221
#define ID_WIMI_DATABASE_VERIFYPCK      1222
// #define ID_WIMI_DATABASE_SHOWPCK        1223 removed V0.9.1 (2000-01-05) [umoeller]:
#define ID_WIMI_DATABASE_REMOVEPCK      1224

#define ID_WIM_DATABASE_LEFT_WHTSPACE   1240
#define ID_WIM_DATABASE_RIGHT_WHTSPACE  1241
#define ID_WIM_DATABASE_VIEW            1242
#define ID_WIMI_DATABASE_TREEVIEW       1243
#define ID_WIMI_DATABASE_DETAILSVIEW    1244

// string IDs

// database thread report strings
#define WPSI_FILEERROR                          3000
#define WPSI_EXISTINGFILENEWER                  3001
#define WPSI_EXISTINGFILEOLDER                  3002
#define WPSI_DELETEERROR                        3003
#define WPSI_DELETEDIRERROR                     3004
#define WPSI_PACKAGEREMOVED                     3005
#define WPSI_CLASSDEREGISTERED                  3006
#define WPSI_ERRORDEREGISTERINGCLASS            3007
#define WPSI_CLASSUNREPLACED                    3008
#define WPSI_ERRORUNREPLACINGCLASS              3009
#define WPSI_OBJECTDELETED                      3010
#define WPSI_ERRORDELETINGOBJECT                3011
#define WPSI_CFGSYSUNDONE                       3012
#define WPSI_ERRORUNDOINGCFGSYS                 3013
#define WPSI_PROFILECLEARED                     3014    // V0.9.5 (2000-08-26) [umoeller]
#define WPSI_ERRORCLEARINGPROFILE               3015    // V0.9.5 (2000-08-26) [umoeller]

#define WPSI_DEEXECUTING                        3016    // V0.9.9 (2001-03-30) [umoeller]
#define WPSI_DEEXECUTEDONE                      3017    // V0.9.9 (2001-03-30) [umoeller]
#define WPSI_DEEXECUTEERROR                     3018    // V0.9.9 (2001-03-30) [umoeller]

#define WPSI_WARNINGEXISTINGNEWER               3025

#define WPSI_UPDATINGCONFIGSYS                  3026
#define WPSI_REGISTERINGCLASSES                 3027
#define WPSI_CREATINGOBJECTS                    3028

#define WPSI_DRIVEXFREE                         3029
#define WPSI_ELAPSED                            3030
#define WPSI_TOGO                               3031
#define WPSI_PACKAGEX                           3032
#define WPSI_FILEX                              3033

#define WPSI_DRIVE                              3034
#define WPSI_FREEKB                             3035
#define WPSI_REQUIREDKB                         3036

#define WPSI_DB_MAINWINDOWTITLE                 3037
#define WPSI_DB_DEINSTALLINGARCHIVE             3038
#define WPSI_DB_DEINSTALLINGPACKAGE             3039
#define WPSI_DB_DEINSTALLINGAPPLICATION         3040
#define WPSI_DB_VERIFYINGPACKAGE                3041
#define WPSI_DB_VERIFYINGAPPLICATION            3042

#define WPSI_FILENAME                           3043
#define WPSI_SIZE                               3044
#define WPSI_CREATIONDATE                       3045
#define WPSI_LASTWRITEDATE                      3046

#define WPSI_APPLICATION                        3047
#define WPSI_PACKAGENAME                        3048
#define WPSI_VERSION                            3049
#define WPSI_AUTHOR                             3050
#define WPSI_TARGETPATH                         3051
#define WPSI_FILES                              3052
#define WPSI_INSTALLDATE                        3053
#define WPSI_INSTALLTIME                        3054

#define WPSI_VERIFYING                          3055
#define WPSI_DELETING                           3056
#define WPSI_DONE                               3057

#define WPSI_NEXTBUTTON                         3058    // V0.9.2 (2000-03-11) [umoeller]

// new items with V0.9.14 (2001-07-14) [umoeller]
#define WPSI_YES                                3059
#define WPSI_NO                                 3060
#define WPSI_OK                                 3061
#define WPSI_CANCEL                             3062
#define WPSI_ABORT                              3063
#define WPSI_RETRY                              3064
#define WPSI_IGNORE                             3065
#define WPSI_ENTER                              3066
#define WPSI_YESTOALL                           3067

#define WPSI_CLOSE                              3068

#define WPSI_VIEWSCRIPT                         3069
#define WPSI_SHOWMSGAGAIN                       3070

#define WPSI_SCRIPT                             3071

#define WPH_FULLINSTALL                         4000
#define WPHS_MAIN                               4001
#define WPHS_PAGE_TEXT                          4002
#define WPHS_PAGE_README                        4003
#define WPHS_PAGE_CONTAINER                     4004
#define WPHS_PAGE_CONFIGURE                     4005
#define WPHS_DRIVEINFO                          4006


