
/*
 * fe_script_old.h:
 *      header file for fe_script_old.cpp. See remarks there.
 *
 *@@include #include "base\bs_string.h"
 *@@include #include "engine\fe_script.h"
 *@@include #include "engine\fe_script_old.h"
 */

/*
 *      This file Copyright (C) 1999-2001 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_SCRIPT_OLD_HEADER_INCLUDED
    #define WARPIN_SCRIPT_OLD_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Forward declarations
     *
     ********************************************************************/

    class FEOldScript;
    class FERexx;

    /* ******************************************************************
     *
     *  Script classes for old-style scripts
     *
     ********************************************************************/

    /*
     *@@ FEOldPckDecl:
     *      implementation for old-style package declarations,
     *      which are created from an old-style script.
     *
     *@@added V0.9.9 (2001-02-28) [umoeller]
     */

    class FEOldPckDecl : public FEPckDeclBase
    {
        public:
            DECLARE_CLASS(FEOldPckDecl);

        public:
            FEOldScript             *_pScript;
                    // the script instance (old style)
                    // this package decl belongs to; always != NULL,
                    // unless this is from a database, where we don't
                    // know the script any more

            FEOldPckDecl(FEOldScript *pScript,
                         FEGroupDecl *pGroup_,
                         const ustring &ustrInfo,
                         const ustring &ustrPckAttribs,
                         ULONG ulPckOfs);

        private:
            VOID ParsePckAttribsMain(const ustring &ustrPckAttribs,
                                     ULONG ulAttrOfs);

            LONG ParsePckAttribsRequiresStrings(const ustring &ustrPckAttribs,
                                                ULONG ulAttrOfs);

            LONG ParsePckAttribsConfigSys(const ustring &ustrPckAttribs,
                                          ULONG ulAttrOfs);

            LONG ParsePckAttribsWPSClasses(const ustring &ustrPckAttribs,
                                           ULONG ulAttrOfs);

            LONG ParsePckAttribsWPSObjects(const ustring &ustrPckAttribs,
                                           ULONG ulAttrOfs);

            LONG ParsePckAttribsProfiles(const ustring &ustrPckAttribs,
                                         ULONG ulAttrOfs);

            LONG ParsePckAttribsExecutes(const ustring &ustrPckAttribs,
                                         ULONG ulAttrOfs);

            LONG ParsePckAttribsKillProcesses(const ustring &ustrPckAttribs,
                                              ULONG ulAttrOfs);
    };

    /*
     *@@ FEOldScript:
     *      implementation of FEScriptBase for old-style scripts
     *      (i.e. "compatibility", non-XML scripts).
     *
     *@@added V0.9.9 (2001-02-19) [umoeller]
     */

    class FEOldScript : public FEScriptBase
    {
        public:
            DECLARE_CLASS(FEOldScript);

        public:
            string              _strScript;
                            // temporary copy while in Parse()

            BSUniCodec          *_pCodec;

            FERexx              &_Rexx;

            FEOldScript(FELocals &Locals,
                        FERexx &Rexx)
                : FEScriptBase(Locals,
                               Rexx,
                               tFEOldScript),
                  _Rexx(Rexx)
            {
                _pCodec = NULL;
            }

            ~FEOldScript()
            {
                if (_pCodec)
                {
                    delete _pCodec;
                    _pCodec = NULL;
                }
            }

            virtual VOID Parse(const char *pcszScript);

            VOID ParseError(ULONG ulOfs,
                            int iMessage,
                            ustring *paStrings = NULL,
                            int iCount = 0);

            VOID ParseErrorMissingAttrib(ULONG ulOfs,
                                         const char *pcszAttribute,
                                         const char *pcszTag);

        private:
            #define GBLREXX_ATTRIBS     0x01
            #define GBLREXX_BLOCK       0x02

            BOOL GetBlock(const string &strSearchIn,
                          PULONG pulSearchOfs,
                          const string &strTag,
                          ULONG flREXX,
                          string *pstrBlock,
                          string *pstrAttribs,
                          PULONG pulOfsBeginTag,
                          PULONG pulOfsBeginBlock);

            VOID ParseWARPINTag();

            ULONG ParseRexxTags(const char* pcszHeaderString);

            ULONG ParseHeader();

            ULONG ParseVarPrompts(string strBlock,
                                  ULONG ulTotalBlockOfs);

            ULONG ParsePackages(string strBlock,
                                FEGroupDecl *pGroup,
                                ULONG ulTotalBlockOfs);

            ULONG ParsePages();
    };

#endif

