
/*
 *@@sourcefile fe_rexx.h:
 *      header for fe_rexx.c. See remarks there.
 *
 *@@include #define INCL_REXXSAA
 *@@include #include <os2.h>
 *@@include #include <rexxsaa.h>    // if using Toolkit headers; with EMX, this is in os2.h
 *@@include #include "engine\fe_rexx.h"
 */

/*
 *      Copyright (C) 2000 Cornelis Bockemhl.
 *      Copyright (C) 2000-2001 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef FEREXX_INCLUDED_
    #define FEREXX_INCLUDED_

    class FELocals;

    /* ******************************************************************
     *
     *  FERexx
     *
     ********************************************************************/

    /*
     *@@ FNREXX:
     *      function prototype for REXX function handlers.
     *      Even though this is defined in the OS/2 headers
     *      as "RexxFunctionHandler",
     *      we cannot use that definition, because EMX defines
     *      it differently.
     *
     *@@added V0.9.2 (2000-03-11) [umoeller]
     */

    typedef ULONG APIENTRY FNREXX(PCSZ,
                                  ULONG,
                                  PRXSTRING,
                                  PCSZ,
                                  PRXSTRING);

    /*
     *@@ WIREXXFUNCTION:
     *      representation of a WarpIN REXX function which
     *      is implemented in this file and can be called
     *      from script REXX code.
     *      A static global array of these exists in
     *      G_aFERexxFunctions.
     *
     *@@added V0.9.2 (2000-03-10) [umoeller]
     */

    typedef struct _WIREXXFUNCTION
    {
        const char  *pcszFunctionName;  // function name
        FNREXX      *pfn;               // function address
    } WIREXXFUNCTION, *PWIREXXFUNCTION;

    /*
     *@@ FERexx:
     *      encapsulation of the WarpIN REXX support.
     *
     *      This class is supposed to be instantiated
     *      as one global object in order to enable
     *      storing and calling REXX scripts.
     *
     *      See @class_rels for an overview of how the front-end
     *      classes interact.
     *
     *@@added V0.9.2 (2000-03-10) [cbo]
     *@@changed V0.9.14 (2001-07-12) [umoeller]: renamed from FERexx
     */

    class FERexx : public BSRoot
    {
        public:
            DECLARE_CLASS(FERexx);

            FERexx(FELocals &Locals);

            virtual ~FERexx();

            // Exported REXX related functions
            void StoreRexxCode(const char* pcszFuncName,
                               const char* pcszCode,
                               BSUniCodec *pCodec);

            // return codes:
            #define WIREXX_NOERROR          0
            #define WIREXX_INVALIDNAME      1
            #define WIREXX_NOCODE           2
            #define WIREXX_REXXFAILED       3

            int ExecuteRexxCode(const char *pcszFuncName,
                                const char *pcszArgs,
                                char **ppszRet);

            BOOL ExecuteRexxMacros(char **ppszStr,
                                   PULONG pulErrorOffset,
                                   char **ppszErrorCall);

            BOOL ExecuteRexxMacros(BSString& str,
                                   PULONG pulErrorOffset,
                                   BSString& strErrorCall);
    };

#endif

