
/*
 * fe_package_db.h:
 *      header file for fe_package_db.cpp.
 *
 *@@include #define INCL_WINSHELLDATA
 *@@include #define INCL_WINWORKPLACE
 *@@include #include <os2.h>
 *@@include #include <string.h>
 *@@include #include "base\bs_errors.h"
 *@@include #include "base\bs_logger.h"
 *@@include #include "base\bs_config.h"
 *@@include #include "frontend\fe_package_arc.h"
 *@@include #include "frontend\warpin.h"
 */

/*
 *      Copyright (C) 1998-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_FEPACKAGEDB_HEADER_INCLUDED
    #define WARPIN_FEPACKAGEDB_HEADER_INCLUDED

    // class FEDatabaseExcpt;
    class BSConfigBase;

    /*
     *@@ FEDBPackage:
     *      FEPackageBase subclass for packages from the database.
     *      Instances of this class can ONLY be created from a
     *      given database, that is, you'll only get instances
     *      of this if a package has been previously installed.
     *
     *      The constructor reads the package information in
     *      exactly the same format which has been used by
     *      FEInstallJob::Store.
     *
     *@@added V0.9.0 (99-11-03) [umoeller]
     *@@changed V0.9.18 (2002-03-03) [umoeller]: added _PckID member for speed
     *@@changed V0.9.18 (2002-03-08) [umoeller]: added _strAppLoadedFrom
     */

    class FEDBPackage : public FEPackageBase
    {
        public:
            DECLARE_CLASS(FEDBPackage);

        public:
            // FEPckDeclBase       *_pDecl;
                    // package declaration from the script
                    // moved this here from FEPackageBase
                    // V0.9.12 (2001-05-17) [umoeller]

            string          _strAppLoadedFrom;
                    // V0.9.18 (2002-03-08) [umoeller]
                    // exact INI app that we were loaded from
                    // (set by constructor);
                    // this can be a legacy ASCII string or
                    // Unicode, depending on _usCodepage

            FEPackageID     _PckID;
                    // added V0.9.18 (2002-03-03) [umoeller]

            // the following is for the Database thread (Database mode only)
            ULONG           _ulStatus;      // 0: status unknown
                                            // 1: errors found
                                            // 2: no errors found
            PVOID           _pvGuiData;

            // this holds all configuration items to be undone,
            // which can be of a whole lotta subclasses actually.
            // I have taken one single list which takes all config
            // objects of all subclasses. This replaces the several
            // lists for each of the subclasses, which lead to an
            // incredible code bloat due to template expansion.
            list<BSConfigBase*>         _listUndoConfig;

            DATETIME        _InstallDateTime;

            // USHORT          _usCodepage;
                        // codepage which was used in the original archive
                        // when this package was stored in the database;
                        // if 0, the package was stored in new style and
                        // _strAppLoadedFrom is in utf-8 format

            FEDBPackage(FEDatabase &Database,
                        const string &strIniKey,
                        BSUniCodec *pCodec,
                        const ustring ustrID);

            list<WIFileHeaderLI*>* GetFileHeaders(PULONG pulHeaderCount);

        private:
            void Load(FEDatabase &Database,
                      BSUniCodec *pCodec);
    };

#endif
