/* $Id: fe_package.h,v 1.9 2002/08/11 20:24:33 umoeller Exp $ */


/*
 * fe_package.h:
 *      header file for fe_package.cpp.
 *
 *@@include #define INCL_WINSHELLDATA
 *@@include #define INCL_WINWORKPLACE
 *@@include #include <os2.h>
 *@@include #include <string.h>
 *@@include #include "base\bs_errors.h"
 *@@include #include "base\bs_logger.h"
 *@@include #include "base\bs_config.h"
 *@@include #include "frontend\fe_base.h"
 *@@include #include "frontend\fe_package.h"
 */

/*
 *      Copyright (C) 1998-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_FEPACKAGE_HEADER_INCLUDED
    #define WARPIN_FEPACKAGE_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Forward declarations
     *
     ********************************************************************/

    class FEArchive;
    class FEDatabase;
    class FEPackageBase;
    class FEArcPackagePck;
    class FEArcPackageGroup;
    class FEDBPackage;
    class FEPckDeclBase;

    /* ******************************************************************
     *
     *  FEPackageID declaration
     *
     ********************************************************************/

    #define IDCOMP_SAMEPCK      0x10000
    /*      // moved these to wiarchive.h
    #define IDCOMP_SAMEVERSION  0x00001
    #define IDCOMP_THISNEWER    0x00002
    #define IDCOMP_THISOLDER    0x00004
    */

    #define IDCOMP_VERSIONMASK  0x0000F

    /*
     *@@ FEPackageID:
     *      helper class for splitting a six-part package ID
     *      into more meaningful information, which is done
     *      by the constructor.
     *
     *@@added V0.9.0 (99-10-26) [umoeller]
     */

    class FEPackageID : public BSRoot
    {
        public:
            DECLARE_CLASS(FEPackageID);

        private:
            ULONG Init(FELocals &Locals,
                       const ustring &ustrPackageID,
                       BOOL fAllowShort);

        public:
            // Utf8-encoded package info
            ustring     _ustrAuthor,
                        _ustrApplication,
                        _ustrPackageName;

            // same stuff, but encoded with FELocals::QueryGuiCodec()
            string      _strAuthorGui,
                        _strApplicationGui,
                        _strPackageNameGui;

            WIVersion   _version;

            string      _strVersion;
                            // ready-made version string, encoded
                            // with FELocals::QueryGuiCodec()

            FEPackageID(FELocals &Locals,
                        const ustring &ustrPackageID,
                        const char *pszParentSource,
                        int iParentLine,
                        BOOL fAllowShort);

            /*
             *@@ FEPackageID:
             *      copy constructor.
             *
             *@@added V0.9.18 (2002-03-03) [umoeller]
             */

            FEPackageID(const FEPackageID &id)
                : BSRoot(tFEPackageID)
            {
                _ustrAuthor = id._ustrAuthor;
                _ustrApplication = id._ustrApplication;
                _ustrPackageName = id._ustrPackageName;

                _strAuthorGui = id._strAuthorGui;
                _strApplicationGui = id._strApplicationGui;
                _strPackageNameGui = id._strPackageNameGui;

                _version = id._version;

                _strVersion = id._strVersion;
            }

            ~FEPackageID()
            {
            }

            // VOID CreateStringVersion(ustring &strVersion, char cSeparator) const;

            VOID CreateStringSix(ustring &str) const;

            ULONG Compare(const FEPackageID &id) const;
    };

    /* ******************************************************************
     *
     *  FEPackageBase definition
     *
     ********************************************************************/

    // flags for FEPackage.ulType
    // #define PCK_PCK     1               // package is FEArcPackagePck
    // #define PCK_GROUP   2               // package is FEArcPackageGroup
    // #define PCK_DBPCK   3               // package is FEDBPackage

    /*
     *@@ FEPackageBase:
     *      FEPackageBase is the base class used by the front end for
     *      package maintenance in both "install" and "database"
     *      mode.
     *
     +          FEPackageBase (abstract base class)
     +                |
     +                +-- FEArcPackageBase (abstract base class for
     +                |     |               packages in archive)
     +                |     |
     +                |     +-- FEArcPackagePck (package in archive)
     +                |     |
     +                |     +-- FEArcPackageGroup (group def'd in script;
     +                |                            no real package)
     +                |
     +                +-- FEDBPackage (package retrieved from database)
     +
     *      The packages represent the read-only data from the script
     *      and are pretty much constant after they have been created.
     *
     *      In "install" mode, the packages contain data as specified
     *      in the install script; in addition, for each package,
     *      instances of FEJobBase are created to store additional
     *      configuration data (according to user selections).
     *      "Install" mode uses FEArcPackageBase and subclasses, which
     *      are constructed from an FEArchive.
     *
     *      In "database" mode, instances of FEDBPackage are created
     *      from the database directly, without jobs.
     *      "Database" mode uses FEDBPackage and requires an FEDatabase
     *      for the constructor. The database information was previously
     *      stored by FEInstallJob::Store after installation of a
     *      package was complete.
     *
     *      Note that if packages are de-installed
     *      in "Install" mode, FEDBPackage instances are used as well.
     *
     *      See @class_rels for an overview of how the front-end
     *      classes interact.
     *
     *@@changed V0.9.0 (99-10-31) [umoeller]: renamed from "PackageInfo".
     *@@changed V0.9.0 (99-11-06) [umoeller]: moved lotsa stuff to the subclasses
     *@@changed V0.9.12 (2001-05-17) [umoeller]: moved _pDecl to subclasses to prevent crashes with group packages
     */

    class FEPackageBase : public BSRoot
    {
        public:
            DECLARE_CLASS(FEPackageBase);

        // All the following fields are set by the constructors:

        public:
            FEPckDeclBase        *_pDecl;
                    // package declaration, as in script...
                    // -- for FEArcPackagePck, this points to the
                    //    package declaration from the script;
                    // -- for FEArcPackageGroup, this points to
                    //    the FEGroupDecl;
                    // -- for FEDBPackage, this points to a pseudo
                    //    declaration which is created to hold package
                    //    data.
                    // V0.9.18 (2002-03-08) [umoeller]:
                    // this _must_ be a pointer and cannot be a
                    // reference, unfortunately, because otherwise
                    // the dummy package declaration for db packages
                    // won't work.

            WIPackHeader    _PackHeader;
                    // copy of package header in WIArchive

        protected:
            BSRequiresIDsLogger _logRequiresIDs;
                    // list of five- or six-part package IDs which
                    // specify the packages required by this package.
                    // This is either resolved from the REQUIRES
                    // attributes in the script or retrieved directly
                    // from the database.
                    // added V0.9.1 (2000-01-07) [umoeller]

        public:
            list<FEPackageID*>  _RequiresIDs;
                    // resolved list of package IDs

            // All the following fields are updated while this
            // package is being installed:

            PSZ                 _pszFilesList;
                    // list of files that were installed,
                    // each of which is null-terminated;
                    // added to during install or loaded from database
            ULONG               _cbFilesList;
                    // sizeof(*pszFilesList)

            // actual configuration done;
            // added to during wpiConfigure (after install)
            // or loaded from database (in db mode)
            BSCfgSysDoneLogger          _logCfgSysDone;
            BSRegisterDoneLogger        _logRegisterClassesDone;
            BSReplaceDoneLogger         _logReplaceClassDone;
            BSWPSObjectsDoneLogger      _logWPSObjectsDone;
            BSExecuteDoneLogger         _logExecutesDone; // added V0.9.1 (2000-02-03) [umoeller]
            BSDeExecuteResolvedLogger   _logDeExecutesResolved; // V0.9.9 (2001-03-27) [umoeller]
            BSClearPrfAttrsLogger       _logWritePrfsDone; // added V0.9.1 (2000-02-07) [umoeller]
                        // note that there's no BSWritePrfsDoneLogger;
                        // this uses a "clear profiles" logger for undoing

            BSCreatedDirsLogger         _logDirsCreated;
                    // list of directories that were created during
                    // install. This includes the target path, if
                    // it didn't exist yet.
                    // V0.9.20 (2002-07-22) [umoeller]

            const ustring& QueryTargetPath() const;
            const ustring& QueryPackageID() const;
            const ustring& QueryTitle() const;

            VOID AppendRequiresID(FELocals &Locals,
                                  const ustring &ustrID);

        protected:
            FEPackageBase(FEPckDeclBase *pDecl,
                          BSClassID &Class);
            virtual ~FEPackageBase();
    };

#endif
