
/*
 * fe_engine.h:
 *      header file for fe_engine.cpp.
 *
 *@@include #define INCL_WINSHELLDATA
 *@@include #define INCL_WINWORKPLACE
 *@@include #include <os2.h>
 *@@include #include <string.h>
 *@@include #include "base\bs_errors.h"
 *@@include #include "base\bs_logger.h"
 *@@include #include "base\bs_config.h"
 *@@include #include "wiarchive\wiarchive.h"
 *@@include #include "engine\fe_engine.h"
 */

/*
 *      Copyright (C) 1998-2001 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_WEENGINE_HEADER_INCLUDED
    #define WARPIN_WEENGINE_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Forward declarations
     *
     ********************************************************************/

    class FEDatabase;
    class FELocals;
    class FEArchive;
    class FEJobBase;
    class FEInstallJob;
    class FEGroupJob;
    class FEPageInfo;
    class FEArcPackagePck;
    class FEArcPackageGroup;
    class FEDBPackage;
    class FEPackageID;
    class FEInstallVar;
    class FEVarPrompt;
    class FEFileError;
    class FERexx;

    /* ******************************************************************
     *
     *  FEInstallEngine
     *
     ********************************************************************/

    /*
     *@@ FEInstallEngine:
     *      the actual WarpIN installer engine. This
     *      is new with V0.9.14 and encapsulates all
     *      the messy code that used to be all over
     *      the place in src\frontend.
     *
     *      Together with FEDatabase, FELocals, and FERexx,
     *      FEInstallEngine implements all an  installer
     *      application would need to actually install WPI
     *      files and register them with the global database.
     *      WARPIN.EXE is now simply a "client" of the install
     *      engine and adds GUI code only to all these classes.
     *
     *      This is an abstract virtual class, and the GUI
     *      must derive a subclass of this and implement
     *      the abstract virtual methds, which serve as
     *      callbacks.
     *
     *      Create _one_ instance of FEInstallEngine, call a
     *      few methods and give it quite a number of callbacks
     *      for your GUI, and WarpIN will install the packages
     *      in an archive.
     *
     *      Note that FEInstallEngine is used only in install
     *      mode. By contrast, FELocals is created in both
     *      install and deinstall mode.
     *
     *      See @class_rels for an overview of how the front-end
     *      classes interact.
     *
     *      Basically, to build an installer, the following
     *      sequence must be used:
     *
     *      1)  Create an instance of FELocals, which encapsulates
     *          a bunch of install settings.
     *
     *      2)  Create an instance of FEInstallEngine and give it
     *          the WPI file name. (See FEInstallEngine::FEInstallEngine.)
     *          This will create an instance of FEArchive
     *          internally, which in turn creates a WIArchive
     *          (from the back end).
     *
     *      3)  Call FEInstallEngine::AppendArchive. This will now
     *          parse the script and create lots of instances
     *          of FEPackageBase (and subclasses) and FEPageInfo.
     *          From the packages, this will also create
     *          the instances of FEJobBase (and subclasses)
     *          which hold the variable installation data,
     *          such as target paths.
     *
     *      4)  Here comes the job of your GUI. Go display
     *          the pages from the script and set target paths
     *          on the jobs etc.
     *
     *      5)  After all this, call FEInstallEngine::Install. This
     *          will not return until all files have been
     *          unpacked.
     *
     *      6)  If that went well, call FEInstallEngine::Configure to
     *          hack the user's system configuration.
     *
     *      7)  If all that succeeded, call FEInstallEngine::Store
     *          to dump the packages into the database.
     *
     *      That's all, basically. The worst job for the
     *      GUI is still to set up the display for all the
     *      pages in the script and handle the callbacks
     *      correctly.
     *
     *@@added V0.9.14 (2001-07-26) [umoeller]
     *@@changed V0.9.20 (2002-07-03) [umoeller]: turned this into an abstract base class
     */

    class FEInstallEngine : public BSRoot
    {
        public:
            DECLARE_CLASS(FEInstallEngine);

            FEDatabase          &_Database;     // ref to database
                                                // (passed to constructor)
            FELocals            &_Locals;       // as passed to constructor

            FERexx              *_pRexx;        // global REXX instance
                                                // moved here V0.9.20 (2002-07-03) [umoeller]

            list<FEArchive*>    *_pArchivesList;
                        // list of all archives opened by WarpIN
                        // made this a pointer to avoid header inclusion mess
                        // V0.9.20 (2002-07-03) [umoeller]
            FEArchive*          _pCurrentArchive;
                        // first archive on that list

            // application title; copied from <TITLE> tag in archive
            ustring             _ustrAppTitle;

            // list of jobs
            list<FEJobBase*>    *_pAllJobsList;
                        // install jobs and group jobs
                        // made this a pointer to avoid header inclusion mess
                        // V0.9.20 (2002-07-03) [umoeller]

            BOOL                _fAnyAlreadyInstalled;
                        // TRUE if any packages from the archive are already
                        // installed (checked against database)

            // list<FEPageInfo*>   *_pPageInfoList;
                        // pointer to the list in a FEArchive instance
                        // (which will be used for displaying the pages)
                        // removed V0.9.20 (2002-07-06) [umoeller]

            // ULONG               _ulAllowConfig;
                        // a combination of the following (fe_package.h):
                        // -- PCK_CONFIGSYS: CONFIG.SYS can be updated;
                        // -- PCK_WPSCLASSES: WPS classes can be installed;
                        // -- PCK_WPSOBJECTS: WPS objects can be created.
                        // This gets set initially to the sum of the
                        // package information.
                        // The GUI is responsible for updating this
                        // when leaving the CONFIGURE page so that
                        // warpin.cpp knows whether to do config.
                        // removed V0.9.18 (2002-03-08) [umoeller],
                        // we now use install variables

            // callbacks for Install()
            /* PFNUPDATEFILE       _pfnUpdateFile;
            PFNUPDATEBYTES      _pfnUpdateBytes;
            PFNFILEEXISTS       _pfnFileExists;
            PFNFILEERROR        _pfnFileError;
            PFNFILELOCKEDERROR  _pfnFileLockedError;
               all removed V0.9.20 (2002-07-03) [umoeller]
               */

            // data while install is running
            ULONG               _ulPackagesTotal;
            ULONG               _ulFilesTotal;
            double              _dTotalBytesToDo;

            ULONG               _ulCurrentPackage;
            double              _dBytesThisPackage;
            FEInstallJob        *_pCurrentInstallJob;

            string              _strLastFile;
            ULONG               _ulCurrentFile;
            double              _dBytesOfLastFile;
            double              _dBytesDone;

            /*
             * public methods
             *
             */

            FEInstallEngine(FEDatabase &Database,
                            FELocals &Locals);

            virtual ~FEInstallEngine();

            VOID AppendArchive(const ustring &ustrArchiveName);

            ULONG CreateDeinstallPackagesList(list<FEDBPackage*> &DeinstallPackagesList);

            VOID Install(PFNWICALLBACK pWICallback);

            BOOL Configure(HAB hab);

            ULONG Store(FEInstallJob **ppSelfWarpINJob);

            ULONG ResolveMacros(ustring &str);

            ULONG ResolveMacros(char **ppsz);

            FEArcPackagePck* FindPackageInArchives(const FEPackageID &PckID,
                                                   PULONG pulComp)
                             const;

            FEInstallJob* FindInstallJob(const FEArcPackagePck *pArcPackage)
                          const;

            FEInstallJob* FindInstallJob(const FEPackageID &PckID)
                          const;

            FEGroupJob* FindGroupJob(const FEArcPackageGroup *pGroupPackage)
                        const;

            FEInstallJob* Is2BeRemoved(const FEPackageID &PckID)
                          const;

            VOID CheckJobs(PULONG pulToAdd,
                           PULONG pulToRemove);

            FEInstallVar* FindInstallVar(PCSZ pcszKeyNameA);

            ULONG GetInstallVars(list<FEInstallVar*> &listVariables,
                                 BOOL fPublicsOnly);

            BOOL QueryInstallVar(FEInstallVar &var);

            BOOL CheckDependencies();

            BOOL VerifySelections(BOOL fPromptCreateDirs);

            APIRET ExtractTempFile(ULONG ulPckIndex,
                                   const char *pcszFileInPck,
                                   BSString *pstrTempFileName);

            ULONG ConfigKillProcesses();

            BOOL ConfigConfigSys();

            BOOL ConfigWPSClasses();

            BOOL ConfigCreateObjects();

            BOOL ConfigWriteProfiles(HAB hab);

            BOOL ConfigExecutes();

            BOOL ConfigDeExecutes();

            /*
             *  pure virtual methods to be implemented
             *  by GUI subclass
             *  all added V0.9.20 (2002-07-03) [umoeller]
             */

            #define GSTAT_LOADINGARCHIVE        1       // V0.9.20 (2002-07-03) [umoeller]
            #define GSTAT_COLLECTING            2
            #define GSTAT_REMOVING              3
            #define GSTAT_UNPACKING             4
            #define GSTAT_CONFIGSYS             5
            #define GSTAT_WPSCLASSES            6
            #define GSTAT_WPSOBJECTS            7
            #define GSTAT_UPDATINGDATABASE      8       // V0.9.20 (2002-07-03) [umoeller]
            #define GSTAT_DONEWITHALL           9

            /*
             *@@ UpdateGlobalStatus:
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual VOID UpdateGlobalStatus(BYTE bStatus) = 0;

            /*
             *@@ VarPrompt:
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual PSZ VarPrompt(FEVarPrompt &VarPrompt) = 0;

            /*
             *@@ UpdatePackage:
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual VOID UpdatePackage(FEInstallJob *pJob,
                                       ULONG ulPckThis,
                                       ULONG ulPcksTotal) = 0;

            /*
             *@@ UpdateFile:
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual VOID UpdateFile(WIFileHeader *pwifh,
                                    ULONG ulFileThis,
                                    ULONG ulFilesTotal) = 0;

            /*
             *@@ UpdateBytes:
             *      optional callback so that the GUI
             *      can display a progress bar, if so
             *      desired.
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual VOID UpdateBytes(double dBytesDone,
                                     double dBytesTotal)
            {
            }

            /*
             *@@ OnFileExists:
             *      callback from FEInstallEngine::Install to confirm
             *      whether a file should be replaced.
             *
             *      This only gets called if EngineWICallback has
             *      determined that the user should be prompted
             *      for what to do, depending on the overwrite
             *      settings in FELocals.
             *
             *      This must return one of the following:
             *
             *      --  CBRC_PROCEED:   replace this file
             *
             *      --  CBRC_SKIP:      skip this file
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual int OnFileExists(FEFileError *pfi) = 0;

            /*
             *@@ OnFileError:
             *      callback from FEInstallEngine::Install when
             *      some major error occurs.
             *
             *      FEInstallEngine now composes a meaningful
             *      error message for us, which we only need to
             *      display.
             *
             *      iErrorRsp signals if the error is recoverable:
             *
             *      --  CBREC_RETRYCANCEL
             *
             *      --  CBREC_ABORTRETRYIGNORE
             *
             *      --  CBREC_CANCEL
             *
             *      This must return one of the following:
             *
             *      --  CBRC_RETRY     retry the failing operation
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual int OnFileError(FEInstallJob *pJob,
                                    const ustring &ustrErrorMsg,
                                    int iErrorRsp) = 0;

            /*
             *@@ OnFileError:
             *      callback from FEInstallEngine::Install when
             *      the disk is full. This is fatal, and we
             *      cannot recover. This should display a
             *      message to the user; the engine will
             *      exit afterwards.
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual VOID OnDiskFull(char cDriveLetter) = 0;

            /*
             *@@ OnFileLockedError:
             *      this is a special case of file error when
             *      the FEInstallEngine::Install has detected
             *      that a file should be overwritten which is
             *      currently in use by another process.
             *
             *      This must return one of these:
             *
             *      --  CBRC_SKIP:    ignore the error, go on (skip the file).
             *
             *      --  CBRC_RETRY:   have the install thread retry.
             *
             *      --  CBRC_UNLOCK:  have the install thread unlock the file (DosReplaceModule).
             *
             *      --  CBRC_DEFER:   have the install thread defer processing thru CONFIG.SYS.
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual int OnFileLockedError(FEFileError *pfi,
                                          int iErrorCode) = 0;


            /*
             *@@ DoneWithInstall:
             *
             *@@added V0.9.20 (2002-07-03) [umoeller]
             */

            virtual void DoneWithInstall(void) = 0;
    };


#endif
